package com.ejianc.business.promaterial.electronicFence.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.enums.FenceConfigChangeStatusEnum;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.business.promaterial.electronicFence.vo.ElectronicFenceConfigChangeDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigChangeEntity;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigChangeService;
import com.ejianc.business.promaterial.electronicFence.vo.ElectronicFenceConfigChangeVO;

/**
 * 电子围栏变更
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("electronicFenceConfigChange")
public class ElectronicFenceConfigChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IElectronicFenceConfigChangeService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IElectronicFenceConfigService electronicFenceConfigService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ElectronicFenceConfigChangeVO> saveOrUpdate(@RequestBody ElectronicFenceConfigChangeVO saveOrUpdateVO) {
        ElectronicFenceConfigChangeVO resp = service.insertOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！", resp);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ElectronicFenceConfigChangeVO> queryDetail(Long id) {
    	ElectronicFenceConfigChangeEntity entity = service.selectById(id);
    	ElectronicFenceConfigChangeVO vo = BeanMapper.map(entity, ElectronicFenceConfigChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ElectronicFenceConfigChangeVO> vos) {
        service.removeConfigByIds(vos.stream().map(ElectronicFenceConfigChangeVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ElectronicFenceConfigChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ElectronicFenceConfigChangeEntity> page = service.queryPage(param,false);
        IPage<ElectronicFenceConfigChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ElectronicFenceConfigChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @GetMapping(value = "newChange")
    public CommonResponse<ElectronicFenceConfigChangeVO> newChange(@RequestParam Long sourceConfigId) {
        ElectronicFenceConfigChangeVO resp = null;

        ElectronicFenceConfigEntity sourceEntity = electronicFenceConfigService.selectById(sourceConfigId);
        resp = BeanMapper.map(sourceEntity, ElectronicFenceConfigChangeVO.class);

        resp.setSourceConfigId(sourceConfigId);
        //清理基础信息
        clearBaseField(resp);

        //单据状态
        resp.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        //单据编码
        resp.setBillCode(null);
        resp.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        resp.setChangeDate(new Date());
        resp.setId(null);
        resp.setChangeVersion(sourceEntity.getChangeVersion() + 1);

        UserContext user = sessionManager.getUserContext();
        resp.setEmployeeName(user.getEmployeeName());

        if(CollectionUtils.isNotEmpty(resp.getDetailList())) {
            resp.getDetailList().forEach(item -> {
                item.setSourcePid(sourceConfigId);
                item.setSourceSubId(item.getId());
                clearBaseField(item);
            });
        }

        return CommonResponse.success("查询成功", resp);
    }

    private void clearBaseField(BaseVO baseVO) {
        baseVO.setId(IdWorker.getId());
        baseVO.setCreateTime(null);
        baseVO.setCreateUserCode(null);
        baseVO.setUpdateTime(null);
        baseVO.setUpdateUserCode(null);
        baseVO.setVersion(0);
        baseVO.setRowState("add");
    }


}
