package com.ejianc.business.promaterial.electronicFence.service.impl;

import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.enums.FenceConfigChangeStatusEnum;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;

@Service("electronicFenceConfig") 
public class ElectronicFenceConfigBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IElectronicFenceConfigService service;

	@Autowired
	private SessionManager sessionManager;


	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		ElectronicFenceConfigEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		service.saveOrUpdate(e, false);

		return CommonResponse.success("回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		ElectronicFenceConfigEntity e = service.selectById(billId);

		//TODO 撤回前校验
		if(!FenceConfigChangeStatusEnum.未变更.getCode().equals(e.getChangeStatus())) {
			return CommonResponse.error("操作失败，当前围栏设置已做变更!");
		}

		e.setCommitDate(null);
		e.setCommitUserCode(null);
		e.setCommitUserName(null);
		e.setEffectiveDate(null);
		service.saveOrUpdate(e, false);

		return CommonResponse.success("操作成功！");
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ElectronicFenceConfigEntity e = service.selectById(billId);
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			//直审时添加单据提交人等信息
			e.setCommitDate(new Date());
			e.setCommitUserCode(sessionManager.getUserContext().getUserCode());
			e.setCommitUserName(sessionManager.getUserContext().getUserName());
		}
		e.setEffectiveDate(new Date());
		service.saveOrUpdate(e, false);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

}
