package com.ejianc.business.promaterial.plan.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.promaterial.plan.vo.BatPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.BatPlanVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.promaterial.plan.bean.BatPlanEntity;

import java.util.List;

/**
 * 材料批次采购计划主表
 *
 * @author generator
 */
public interface IBatPlanService extends IBaseService<BatPlanEntity> {

    /**
     * 保存
     *
     * @param batPlanVO 保存数据
     * @return 保存结果
     */
    BatPlanVO saveOrUpdateByVo(BatPlanVO batPlanVO);

    Boolean delete(List<BatPlanVO> vos);

    /**
     * 根据id查询详情
     * @param id 单据id
     * @return 详情
     */
    BatPlanVO queryBatPlanDetailById(Long id);

    /**
     * 查询采购计划列表
     * @param param 查询条件
     * @return 查询结果
     */
    IPage<BatPlanVO> queryBatPlanPage(QueryParam param);

    /**
     * 导出
     * @param param 查询参数
     * @return 查询结果
     */
    List<BatPlanVO> excelExportBatPlan(QueryParam param);

    /**
     * 参照查询
     *
     * @param param        查询参数
     * @param condition    参数
     * @param searchObject 模糊查询匹配字段
     * @return 查询结果
     */
    IPage<BatPlanVO> refBatPlanData(QueryParam param, String condition, String searchObject);

    /**
     * 修改采购计划状态
     *
     * @param idList    id列表
     * @param planState 计划状态
     */
    void updateBatPlanByQuoteType(List<String> idList, Integer planState);

    /**
     * 查询采购类别
     *
     * @return 采购类别自定义档案
     */
    List<DefdocDetailVO> refPurchaseDate();

    List<ParamsCheckVO> planNumCtrl(BatPlanVO vo);
}
