package com.ejianc.business.promaterial.plan.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.bean.PlanEntity;
import com.ejianc.business.promaterial.plan.vo.PlanDetailRefVO;
import com.ejianc.business.promaterial.plan.vo.PlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.PlanVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 消耗材-需用计划
 * 
 * @author generator
 * 
 */
public interface IPlanService extends IBaseService<PlanEntity> {
    CommonResponse<PlanVO> saveOrUpdate(PlanVO saveOrUpdateVO);
    List<PlanDetailRefVO> getPlanByMaterialId(List<Long> materialListId, QueryWrapper queryWrapper);

    List<ParamsCheckVO> masterPlanNumCtrl(PlanVO planVO);

    List<ParamsCheckVO> masterPlanPriceCtrl(PlanVO planVO);

    List<ParamsCheckVO> monthPlanNumCtrl(PlanVO planVO);

    Map<Long, BigDecimal> getSumPlanNumByMaterialIds(List<Long> materialIds, Long contractId);
}
