package com.ejianc.business.promaterial.plan.service.impl;

import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.plan.mapper.MonthPlanDetailMapper;
import com.ejianc.business.promaterial.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.promaterial.plan.service.IMonthPlanDetailService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资月计划子表
 * 
 * @author generator
 * 
 */
@Service("monthPlanDetailService")
public class MonthPlanDetailServiceImpl extends BaseServiceImpl<MonthPlanDetailMapper, MonthPlanDetailEntity> implements IMonthPlanDetailService{

    @Autowired
    private MonthPlanDetailMapper mapper;

    @Override
    public List<Map<String, Object>> countDetailTotalNum(Long monthPlanId, List<Long> detailIds, Long projectId) {
        return mapper.countDetailTotalNum(monthPlanId, detailIds, projectId);
    }

    @Override
    public Map<Long, BigDecimal> writeBackOccupyNum(Map<Long, BigDecimal> numMap) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, new ArrayList<>(numMap.keySet())));
        List<MonthPlanDetailEntity> list = super.queryList(param);
        for(MonthPlanDetailEntity detail : list){
            detail.setOccupyNums(ComputeUtil.safeAdd(detail.getOccupyNums(), numMap.get(detail.getId())));
            detail.setSurplusNums(ComputeUtil.safeSub(detail.getMonthPlanNum(), detail.getOccupyNums()));
        }
        if(CollectionUtils.isNotEmpty(list)){
            super.saveOrUpdateBatch(list);
        }
        Map<Long, BigDecimal> result = list.stream().collect(Collectors.toMap(x->x.getId(), x->x.getOccupyNums()));
        return result;
    }
}
