/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.plan.bean.BatPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.BatPlanEntity;
import com.ejianc.business.promaterial.plan.mapper.BatPlanMapper;
import com.ejianc.business.promaterial.plan.service.IBatPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IBatPlanService;
import com.ejianc.business.promaterial.plan.service.IMonthPlanDetailService;
import com.ejianc.business.promaterial.plan.vo.BatPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.promaterial.plan.vo.BatPlanVO;
import com.ejianc.business.promaterial.utils.OrgUtil;
import com.ejianc.business.promaterial.utils.PageUtil;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="batPlanService")
public class BatPlanServiceImpl
extends BaseServiceImpl<BatPlanMapper, BatPlanEntity>
implements IBatPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CONDITION_TRUSTEES_ID = "employeeId";
    private static final String CONDITION_PROJECT_ID = "projectId";
    private static final String CONDITION_ORG_ID = "orgId";
    private static final String BILL_CODE = "PARCEL_PLAN_CODE";
    private static final String PLAN_NUM_CTRL_PARAM_CODE = "P-K412970003";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IBatPlanDetailService detailService;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IMonthPlanDetailService planDetailService;

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public BatPlanVO saveOrUpdateByVo(BatPlanVO batPlanVO) {
        BatPlanEntity entity;
        CommonResponse orgResponse;
        if (StringUtils.isEmpty((CharSequence)batPlanVO.getParentOrgCode()) && batPlanVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(batPlanVO.getParentOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            batPlanVO.setParentOrgCode(orgVO.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)(entity = (BatPlanEntity)((Object)BeanMapper.map((Object)batPlanVO, BatPlanEntity.class))).getBillCode())) {
            BatPlanVO voByCode = this.queryByCode(entity.getBillCode());
            if (!(null == voByCode || null != entity.getId() && voByCode.getId().equals(entity.getId()))) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)batPlanVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            String code = this.orgUtil.getBillCodeByCorp(entity.getOrgId(), entity.getProjectId(), (String)billCode.getData());
            entity.setBillCode(code);
        }
        if (entity.getPlanState() == null) {
            entity.setPlanState(BatPlanEnum.PLAN_STATE_WAIT.getPlanState());
        }
        entity.setUrgentState(null != entity.getUrgentState() ? entity.getUrgentState() : 0);
        entity.setSporadicState(null != entity.getSporadicState() ? entity.getSporadicState() : 0);
        entity.setSignState(null != entity.getSignState() ? entity.getSignState() : 1);
        this.writeBackOccupyNum(entity);
        super.saveOrUpdate((Object)entity, false);
        return this.copyVoByEntity(entity);
    }

    @Override
    public Boolean delete(List<BatPlanVO> vos) {
        List ids = vos.stream().map(x -> x.getId()).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("planId", new Parameter("in", ids));
        List detailList = this.detailService.queryList(param);
        HashMap<Long, BigDecimal> numMap = new HashMap<Long, BigDecimal>();
        for (BatPlanDetailEntity detail : detailList) {
            if (StringUtils.isEmpty((CharSequence)detail.getSourceId())) continue;
            Long sourceId = Long.valueOf(detail.getSourceId());
            numMap.put(sourceId, ComputeUtil.safeSub((BigDecimal)((BigDecimal)numMap.get(sourceId)), (BigDecimal)detail.getNum()));
        }
        super.removeByIds(ids, true);
        if (MapUtils.isNotEmpty(numMap)) {
            this.planDetailService.writeBackOccupyNum(numMap);
        }
        return true;
    }

    private void writeBackOccupyNum(BatPlanEntity entity) {
        BatPlanEntity data = new BatPlanEntity();
        if (null != entity.getId()) {
            data = (BatPlanEntity)((Object)super.selectById((Serializable)entity.getId()));
        }
        Map<Long, BatPlanDetailEntity> dataMap = data.getBatPlanDetailList().stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        HashMap<Long, BigDecimal> numMap = new HashMap<Long, BigDecimal>();
        for (BatPlanDetailEntity detail : entity.getBatPlanDetailList()) {
            if (StringUtils.isEmpty((CharSequence)detail.getSourceId())) continue;
            Long sourceId = Long.valueOf(detail.getSourceId());
            detail.setSurplusNums(ComputeUtil.safeSub((BigDecimal)detail.getNum(), (BigDecimal)detail.getOccupyNums()));
            if ("del".equals(detail.getRowState())) {
                numMap.put(sourceId, ComputeUtil.safeSub((BigDecimal)((BigDecimal)numMap.get(sourceId)), (BigDecimal)detail.getNum()));
                continue;
            }
            BigDecimal num = detail.getNum();
            if (dataMap.containsKey(detail.getId())) {
                num = ComputeUtil.safeSub((BigDecimal)detail.getNum(), (BigDecimal)dataMap.get(detail.getId()).getNum());
            }
            numMap.put(sourceId, ComputeUtil.safeAdd((BigDecimal)((BigDecimal)numMap.get(sourceId)), (BigDecimal)num));
        }
        if (MapUtils.isNotEmpty(numMap)) {
            this.planDetailService.writeBackOccupyNum(numMap);
        }
    }

    private BatPlanVO queryByCode(String planCode) {
        BatPlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)planCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        BatPlanEntity entity = (BatPlanEntity)((Object)super.getOne((Wrapper)query));
        if (null != entity) {
            resp = (BatPlanVO)BeanMapper.map((Object)((Object)entity), BatPlanVO.class);
        }
        return resp;
    }

    @Override
    public BatPlanVO queryBatPlanDetailById(Long id) {
        BatPlanEntity entity = (BatPlanEntity)((Object)super.selectById((Serializable)id));
        return this.copyVoByEntity(entity);
    }

    @Override
    public IPage<BatPlanVO> queryBatPlanPage(QueryParam param) {
        this.setDefaultParam(param);
        return this.queryBatPlanVO(param);
    }

    @Override
    public List<BatPlanVO> excelExportBatPlan(QueryParam param) {
        this.setDefaultParam(param);
        param.setPageIndex(1);
        param.setPageSize(10000);
        List entityList = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            List list = BeanMapper.mapList((Iterable)entityList, BatPlanVO.class);
            for (BatPlanVO vo : list) {
                vo.setBillStateName(this.getBillStateName(vo.getBillState()));
                vo.setPlanStateName(BatPlanEnum.getDescriptionByStateCode((Integer)vo.getPlanState()));
            }
            return list;
        }
        return new ArrayList<BatPlanVO>();
    }

    @Override
    public IPage<BatPlanVO> refBatPlanData(QueryParam param, String condition, String searchObject) {
        this.setDefaultParam(param);
        param.getParams().put("planState", new Parameter("eq", (Object)BatPlanEnum.PLAN_STATE_WAIT.getPlanState()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty((CharSequence)searchObject)) {
            param.setSearchObject(null);
            JSONObject searchJson = JSONObject.parseObject((String)searchObject);
            this.logger.info("\u53c2\u7167\u67e5\u8be2searchObject\uff1a\u3010{}\u3011", (Object)searchJson);
            if (searchJson != null && !searchJson.isEmpty()) {
                for (Map.Entry entry : searchJson.entrySet()) {
                    param.getParams().put(entry.getKey(), new Parameter("like", entry.getValue()));
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            this.logger.info("\u53c2\u7167\u67e5\u8be2condition\uff1a\u3010{}\u3011", (Object)_con);
            if (_con.containsKey((Object)CONDITION_TRUSTEES_ID)) {
                param.getParams().put("trusteesId", new Parameter("eq", _con.get((Object)CONDITION_TRUSTEES_ID)));
            }
            if (_con.containsKey((Object)CONDITION_PROJECT_ID)) {
                Long projectId = Long.parseLong(_con.get((Object)CONDITION_PROJECT_ID).toString());
                CommonResponse projectResponse = this.projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                if (!projectResponse.isSuccess()) {
                    throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put(CONDITION_PROJECT_ID, new Parameter("in", projectResponse.getData()));
            }
            if (_con.containsKey((Object)CONDITION_ORG_ID)) {
                Long orgId = Long.valueOf(_con.get((Object)CONDITION_ORG_ID).toString());
                CommonResponse orgResp = this.iOrgApi.getOneById(orgId);
                OrgVO orgVO = (OrgVO)orgResp.getData();
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                    param.getParams().put(CONDITION_ORG_ID, new Parameter("eq", (Object)orgId));
                } else {
                    param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                }
            }
        }
        Integer current = param.getPageIndex();
        Integer size = param.getPageSize();
        param.setPageSize(-1);
        IPage<BatPlanVO> pageData = this.queryBatPlanVO(param);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List batPlanVOList = pageData.getRecords();
            List idList = batPlanVOList.stream().map(BaseVO::getId).map(String::valueOf).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("planId", new Parameter("in", idList));
            detailParam.getParams().put("surplusNums", new Parameter("sql", (Object)"IFNULL(surplus_nums,0)>0"));
            List detailEntityList = this.detailService.queryList(detailParam);
            List detailVOList = BeanMapper.mapList((Iterable)detailEntityList, BatPlanDetailVO.class);
            HashMap detailMap = new HashMap();
            for (BatPlanDetailVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getPlanId())) {
                    ((List)detailMap.get(vo.getPlanId())).add(vo);
                    continue;
                }
                ArrayList<BatPlanDetailVO> mapList = new ArrayList<BatPlanDetailVO>();
                mapList.add(vo);
                detailMap.put(vo.getPlanId(), mapList);
            }
            batPlanVOList.forEach(batPlanVO -> batPlanVO.setBatPlanDetailList((List)detailMap.get(batPlanVO.getId())));
        }
        List records = pageData.getRecords();
        records = records.stream().filter(x -> CollectionUtils.isNotEmpty((Collection)x.getBatPlanDetailList())).collect(Collectors.toList());
        records = PageUtil.listToPage(records, (int)current, (int)size);
        pageData.setRecords(records);
        return pageData;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        List entityList;
        if (StringUtils.isEmpty((CharSequence)BatPlanEnum.getDescriptionByStateCode((Integer)planState))) {
            throw new BusinessException("\u8ba1\u5212\u72b6\u6001\u9519\u8bef");
        }
        if (CollectionUtils.isNotEmpty(idList) && CollectionUtils.isNotEmpty((Collection)(entityList = (List)super.listByIds(idList)))) {
            for (BatPlanEntity entity : entityList) {
                if (BatPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getPlanState())) {
                    this.logger.info("\u91c7\u8d2d\u8ba1\u5212\u7f16\u7801\u3010{}\u3011\u8ba1\u5212\u540d\u79f0\u3010{}\u3011\u5df2\u91c7\u8d2d\u5b8c\u6210\uff01", (Object)entity.getBillCode(), (Object)entity.getPlanName());
                    throw new BusinessException("\u91c7\u8d2d\u8ba1\u5212\u7f16\u7801\u3010" + entity.getBillCode() + "\u3011\u8ba1\u5212\u540d\u79f0\u3010" + entity.getPlanName() + "\u3011\u5df2\u91c7\u8d2d\u5b8c\u6210\uff01");
                }
                entity.setPlanState(planState);
            }
            super.saveOrUpdateBatch((Collection)entityList);
        }
    }

    @Override
    public List<DefdocDetailVO> refPurchaseDate() {
        CommonResponse zzcRes;
        String wzDefCode = "pro-supply-material-supply-content";
        String zzcDefCode = "pro-supply-revolving-materials-supply-content";
        ArrayList<DefdocDetailVO> list = new ArrayList<DefdocDetailVO>();
        CommonResponse wzRes = this.defdocApi.getDefDocByDefCode(wzDefCode);
        if (wzRes.isSuccess()) {
            list.addAll((Collection)wzRes.getData());
        }
        if ((zzcRes = this.defdocApi.getDefDocByDefCode(zzcDefCode)).isSuccess()) {
            list.addAll((Collection)zzcRes.getData());
        }
        return list;
    }

    @Override
    public List<ParamsCheckVO> planNumCtrl(BatPlanVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PLAN_NUM_CTRL_PARAM_CODE, vo.getOrgId());
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)billParamByCode));
        List checkParamData = (List)billParamByCode.getData();
        List detailList = vo.getBatPlanDetailList().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());
        List<Long> detailIds = detailList.stream().map(BatPlanDetailVO::getMaterialId).collect(Collectors.toList());
        Map<Long, BatPlanDetailVO> detailVONumMap = detailList.stream().collect(Collectors.toMap(BatPlanDetailVO::getMaterialId, item -> item));
        List<Map<String, Object>> detailTotalNumInfo = this.detailService.countDetailTotalNum(vo.getId(), detailIds, vo.getProjectId());
        HashMap detailNumMap = new HashMap();
        Map detailCountMap = null;
        for (Map<String, Object> item2 : detailTotalNumInfo) {
            if (!detailVONumMap.containsKey(Long.valueOf(item2.get("materialId").toString()))) continue;
            detailCountMap = new HashMap<String, BigDecimal>();
            detailCountMap.put("totalPlanNum", ComputeUtil.safeAdd((BigDecimal)detailVONumMap.get(Long.valueOf(item2.get("materialId").toString())).getNum(), (BigDecimal)(null != item2.get("totalPlanNum") ? new BigDecimal(item2.get("totalPlanNum").toString()) : BigDecimal.ZERO)));
            detailCountMap.put("masterPlanNum", new BigDecimal(item2.get("masterPlanNum").toString()));
            detailNumMap.put(Long.valueOf(item2.get("materialId").toString()), detailCountMap);
        }
        StringBuilder sp = new StringBuilder();
        BigDecimal roleValue = null;
        ArrayList<ParamsCheckDsVO> dataSource = null;
        ParamsCheckVO paramsCheckVO = null;
        ParamsCheckDsVO paramsCheckDsVO = null;
        BatPlanDetailVO tempDetail = null;
        for (BillParamVO billParamVO : checkParamData) {
            dataSource = new ArrayList<ParamsCheckDsVO>();
            paramsCheckVO = new ParamsCheckVO();
            roleValue = ComputeUtil.safeDiv((BigDecimal)billParamVO.getRoleValue(), (BigDecimal)new BigDecimal("100"));
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                for (Long materialId : detailNumMap.keySet()) {
                    detailCountMap = (Map)detailNumMap.get(materialId);
                    tempDetail = detailVONumMap.get(materialId);
                    if (((BigDecimal)detailCountMap.get("masterPlanNum")).compareTo(new BigDecimal("-1")) == 0) {
                        this.logger.info("\u660e\u7ec6\uff1a\u540d\u79f0-{},\u578b\u53f7-{},id-{}\u5728\u6708\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u4e0d\u8fdb\u884c\u4ef7\u63a7\uff01", new Object[]{tempDetail.getMaterialName(), tempDetail.getSpec(), tempDetail.getMaterialId()});
                    }
                    BigDecimal value = ComputeUtil.safeMultiply((BigDecimal)((BigDecimal)detailCountMap.get("masterPlanNum")), (BigDecimal)roleValue);
                    if (((BigDecimal)detailCountMap.get("totalPlanNum")).compareTo(value) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem(tempDetail.getMaterialName() + tempDetail.getSpec());
                    paramsCheckDsVO.setWarnName("\u91c7\u8d2d\u8ba1\u5212\u91cf\u8d85\u8fc7\u603b\u9700\u7528\u8ba1\u5212\u91cf");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u91c7\u8d2d\u8ba1\u5212\u91cf\uff1a").append(tempDetail.getNum().setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u91c7\u8d2d\u8ba1\u5212\u91cf\uff1a").append(((BigDecimal)detailCountMap.get("totalPlanNum")).setScale(2, RoundingMode.DOWN)).append("\uff0c\u603b\u9700\u7528\u8ba1\u5212\u91cf*").append(billParamVO.getRoleValue().setScale(2, RoundingMode.DOWN)).append("%\uff1a").append(value.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)((BigDecimal)detailCountMap.get("totalPlanNum")), (BigDecimal)value).setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    private IPage<BatPlanVO> queryBatPlanVO(QueryParam param) {
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List batPlanVOList = BeanMapper.mapList((Iterable)page.getRecords(), BatPlanVO.class);
        for (BatPlanVO vo : batPlanVOList) {
            vo.setPlanStateName(BatPlanEnum.getDescriptionByStateCode((Integer)vo.getPlanState()));
        }
        pageData.setRecords(batPlanVOList);
        return pageData;
    }

    private void setDefaultParam(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("planName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("deptName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse orgResponse = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgVOList = (List)orgResponse.getData();
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put(CONDITION_ORG_ID, new Parameter("in", departmentIds));
        }
    }

    private BatPlanVO copyVoByEntity(BatPlanEntity entity) {
        BatPlanVO vo = (BatPlanVO)BeanMapper.map((Object)((Object)entity), BatPlanVO.class);
        vo.setPlanStateName(BatPlanEnum.getDescriptionByStateCode((Integer)vo.getPlanState()));
        return vo;
    }

    private String getBillStateName(Integer billState) {
        String billStateName = null;
        if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u81ea\u7531\u6001";
        } else if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u5df2\u63d0\u4ea4";
        } else if (BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u5ba1\u6838\u4e2d";
        } else if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u5ba1\u6279\u901a\u8fc7";
        } else if (BillStateEnum.UNAPPROVED.getBillStateCode().equals(billState)) {
            billStateName = "\u5ba1\u6279\u9a73\u56de";
        } else if (BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u5ba1\u6838\u4e2d";
        }
        return billStateName;
    }
}

