/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.order.service.impl;

import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.mapper.OrderDetailMapper;
import com.ejianc.business.promaterial.order.service.IOrderDetailService;
import com.ejianc.business.promaterial.plan.service.ISinglePlanDetailService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderDetailService")
public class OrderDetailServiceImpl
extends BaseServiceImpl<OrderDetailMapper, OrderDetailEntity>
implements IOrderDetailService {
    @Autowired
    private ISinglePlanDetailService planDetailService;

    @Override
    public Map<Long, BigDecimal> writeBackOccupyNum(Map<Long, BigDecimal> numMap) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", new ArrayList<Long>(numMap.keySet())));
        List list = super.queryList(param);
        for (OrderDetailEntity detail : list) {
            BigDecimal surplusNums = detail.getSurplusNumsSum();
            detail.setOccupyNumsSum(ComputeUtil.safeAdd((BigDecimal)detail.getOccupyNumsSum(), (BigDecimal)numMap.get(detail.getId())));
            detail.setSurplusNumsSum(ComputeUtil.safeSub((BigDecimal)detail.getActualNumsSum(), (BigDecimal)detail.getOccupyNumsSum()));
            if (!ComputeUtil.isLessThan((BigDecimal)detail.getSurplusNumsSum(), (BigDecimal)BigDecimal.ZERO)) continue;
            throw new BusinessException("\u7269\u8d44[\u540d\u79f0\uff1a" + detail.getMaterialName() + "\uff0c\u89c4\u683c\uff1a" + detail.getSpec() + "]\uff0c\u5269\u4f59\u91cf\uff1a" + ComputeUtil.scaleStripTrailingZeros((BigDecimal)surplusNums, (int)4) + "\uff0c\u6570\u91cf\u4e0d\u8db3!");
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            super.saveOrUpdateBatch((Collection)list);
        }
        Map<Long, BigDecimal> result = list.stream().collect(Collectors.toMap(x -> x.getId(), x -> x.getOccupyNumsSum()));
        return result;
    }

    @Override
    public Map<Long, BigDecimal> writeBackActualNum(Map<Long, BigDecimal> numMap) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", new ArrayList<Long>(numMap.keySet())));
        List list = super.queryList(param);
        HashMap<Long, BigDecimal> planMap = new HashMap<Long, BigDecimal>();
        for (OrderDetailEntity detail : list) {
            BigDecimal surplusNums = detail.getSurplusNumsSum();
            detail.setOccupyNumsSum(ComputeUtil.safeAdd((BigDecimal)detail.getOccupyNumsSum(), (BigDecimal)numMap.get(detail.getId())));
            detail.setActualNumsSum(ComputeUtil.safeAdd((BigDecimal)detail.getActualNumsSum(), (BigDecimal)numMap.get(detail.getId())));
            detail.setSurplusNumsSum(ComputeUtil.safeSub((BigDecimal)detail.getActualNumsSum(), (BigDecimal)detail.getOccupyNumsSum()));
            if (ComputeUtil.isLessThan((BigDecimal)detail.getSurplusNumsSum(), (BigDecimal)BigDecimal.ZERO)) {
                throw new BusinessException("\u7269\u8d44[\u540d\u79f0\uff1a" + detail.getMaterialName() + "\uff0c\u89c4\u683c\uff1a" + detail.getSpec() + "]\uff0c\u5269\u4f59\u91cf\uff1a" + ComputeUtil.scaleStripTrailingZeros((BigDecimal)surplusNums, (int)4) + "\uff0c\u6570\u91cf\u4e0d\u8db3!");
            }
            planMap.put(detail.getSourceDetailId(), numMap.get(detail.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            super.saveOrUpdateBatch((Collection)list);
        }
        if (MapUtils.isNotEmpty(planMap)) {
            this.planDetailService.writeBackOccupyNum(planMap);
        }
        Map<Long, BigDecimal> result = list.stream().collect(Collectors.toMap(x -> x.getId(), x -> x.getOccupyNumsSum()));
        return result;
    }

    @Override
    public List<Map<String, Object>> countDetailTotalNum(Long orderId, List<Long> materialIds, Long projectId) {
        if (CollectionUtils.isEmpty(materialIds)) {
            return new ArrayList<Map<String, Object>>();
        }
        return ((OrderDetailMapper)this.baseMapper).countDetailTotalNum(orderId, materialIds, projectId);
    }
}

