/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.plan.bean.BatPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.BatPlanEntity;
import com.ejianc.business.promaterial.plan.service.IBatPlanService;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.promaterial.sync.bean.SyncRecordsEntity;
import com.ejianc.business.promaterial.sync.consts.HTConstants;
import com.ejianc.business.promaterial.sync.vo.FileDto;
import com.ejianc.business.promaterial.sync.vo.PlanDetailDto;
import com.ejianc.business.promaterial.sync.vo.PlanDto;
import com.ejianc.business.promaterial.utils.DateUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="batPlan")
public class BatPlanBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SIGN = "plan";
    public static final String SYNC_RECORD_QUEUE = "sync_record_queue";
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IBatPlanService batPlanService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("------------\u64a4\u56de\u524d\u56de\u8c03------------");
        this.logger.info("billId:{},state:{},billTypeCode:{}", new Object[]{billId, state, billTypeCode});
        BatPlanEntity batPlanEntity = (BatPlanEntity)((Object)this.batPlanService.selectById(billId));
        if (BatPlanEnum.PLAN_STATE_WAIT.getPlanState().equals(batPlanEntity.getPlanState())) {
            return CommonResponse.success();
        }
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u68c0\u67e5\u7ed3\u679c\uff1a{}", (Object)resp);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)"\u5355\u636e\u88ab\u5f15\u7528\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        BatPlanEntity batPlanEntity;
        this.logger.info("-------------------\u5ba1\u6279\u524d\u56de\u8c03------------------------");
        this.logger.info("sign-->>{}", (Object)sign);
        if (SIGN.equals(sign) && ((batPlanEntity = (BatPlanEntity)((Object)this.batPlanService.selectById(billId))) == null || batPlanEntity.getTrusteesId() == null)) {
            return CommonResponse.error((String)"\u8bf7\u5148\u9009\u62e9\u62db\u6807\u7ecf\u529e\u4eba\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("-------------------\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03------------------------");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BatPlanEntity entity = (BatPlanEntity)((Object)this.batPlanService.selectById(billId));
        if (new Integer(1).equals(entity.getSignState())) {
            this.sendMq(entity);
        }
        return CommonResponse.success();
    }

    public String sendMq(BatPlanEntity entity) {
        SyncRecordsEntity record = new SyncRecordsEntity();
        record.setOperatorId(InvocationInfoProxy.getUserid());
        record.setOperatorName(this.sessionManager.getUserContext().getUserName());
        record.setPushDate(new Date());
        record.setTenantId(InvocationInfoProxy.getTenantid());
        record.setCreateUserCode(InvocationInfoProxy.getUsercode());
        record.setCreateTime(new Date());
        record.setHandleType("syncPlan");
        String url = HTConstants.PLAN_REQ_HOST + "/hjjc/v1/addPurchaseDemandPlan";
        record.setUrl(url);
        PlanDto vo = this.transferDto(entity);
        record.setData(JSONObject.toJSONString((Object)vo));
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody((Object)record);
        this.rabbitTemplate.convertAndSend("sync_record_queue_" + this.profile, (Object)mqMessage);
        return "\u6d88\u606f\u53d1\u9001MQ\u961f\u5217\u6210\u529f\uff01";
    }

    private PlanDto transferDto(BatPlanEntity entity) {
        PlanDto vo = new PlanDto();
        vo.setOutPlanNo(HTConstants.HT_UNIT_CODE + "_" + entity.getId());
        vo.setTitle(entity.getPlanName());
        BigDecimal planAtm = entity.getBatPlanDetailList().stream().map(x -> x.getMoney()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        vo.setPlanAtm(planAtm);
        vo.setStatus("40");
        vo.setRemark(entity.getMemo());
        vo.setAttachment(null);
        vo.setCreateDate(DateUtils.transformationDate(entity.getCreateDate(), "YYYYMMDDHH24MSS"));
        vo.setCreateUser(HTConstants.HT_INVENTED_ACCOUNT);
        vo.setCreateUserId(HTConstants.HT_INVENTED_EMP_ID);
        vo.setCreateUserName(HTConstants.HT_INVENTED_EMP_NAME);
        vo.setCreateDeptCode(HTConstants.HT_INVENTED_DEPT_CODE);
        vo.setCreateDeptName(HTConstants.HT_INVENTED_DEPT_NAME);
        vo.setCreateOrgCode(HTConstants.HT_INVENTED_ORG_CODE);
        vo.setCreateOrgName(HTConstants.HT_INVENTED_ORG_NAME);
        vo.setSysCode("HJJC");
        vo.setCreatePlateCode(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_CODE);
        vo.setCreatePlateName(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_NAME);
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
        if (fileResp.isSuccess()) {
            ArrayList<FileDto> attachment = new ArrayList<FileDto>();
            for (AttachmentVO file : (List)fileResp.getData()) {
                FileDto dto = new FileDto();
                dto.setFileName(file.getFileName());
                dto.setFileType(FileUtils.getFileExt((String)file.getFileName(), (Boolean)false));
                dto.setFileSize(String.valueOf(file.getFileSize()));
                dto.setDownloadUrl(this.baseHost + "ejc-file-web/attachment/filePreview?fileId=" + file.getId());
                attachment.add(dto);
            }
            vo.setAttachment(attachment);
        }
        List typeIds = entity.getBatPlanDetailList().stream().map(x -> x.getMaterialTypeId()).distinct().collect(Collectors.toList());
        Map<Object, Object> typeMap = new HashMap();
        if (CollectionUtils.isNotEmpty(typeIds)) {
            CommonResponse resp = this.materialApi.queryCategoryListByIds(typeIds);
            if (!resp.isSuccess()) {
                throw new BusinessException(resp.getMsg());
            }
            typeMap = ((List)resp.getData()).stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        }
        List materialIds = entity.getBatPlanDetailList().stream().map(x -> x.getMaterialId()).distinct().collect(Collectors.toList());
        Map<Object, Object> materialMap = new HashMap();
        if (CollectionUtils.isNotEmpty(materialIds)) {
            CommonResponse resp = this.materialApi.queryMaterialItemByIds(materialIds);
            if (!resp.isSuccess()) {
                throw new BusinessException(resp.getMsg());
            }
            materialMap = ((List)resp.getData()).stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        }
        List<String> userIds = entity.getBatPlanDetailList().stream().filter(x -> null != x.getBuyerId()).map(x -> String.valueOf(x.getBuyerId())).distinct().collect(Collectors.toList());
        Map<Object, Object> userMap = new HashMap();
        if (CollectionUtils.isNotEmpty(userIds)) {
            CommonResponse resp = this.userApi.queryListByIds(userIds.toArray(new String[0]));
            if (!resp.isSuccess()) {
                throw new BusinessException(resp.getMsg());
            }
            userMap = ((List)resp.getData()).stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        }
        ArrayList<PlanDetailDto> detailList = new ArrayList<PlanDetailDto>();
        for (BatPlanDetailEntity data : entity.getBatPlanDetailList()) {
            PlanDetailDto detail = new PlanDetailDto();
            detail.setOutPlanLineNo(HTConstants.HT_UNIT_CODE + "_" + data.getId());
            detail.setOutPlanNo(vo.getOutPlanNo());
            detail.setTitle(vo.getTitle());
            detail.setPlanType("3".equals(data.getPlanType()) ? "3" : null);
            if (typeMap.containsKey(data.getMaterialTypeId())) {
                detail.setCategory(((MaterialCategoryVO)typeMap.get(data.getMaterialTypeId())).getCode());
            }
            detail.setCategoryName(data.getMaterialTypeName());
            detail.setItemId(data.getMaterialCode());
            detail.setItemName(data.getMaterialName());
            if (materialMap.containsKey(data.getMaterialId())) {
                MaterialVO material = (MaterialVO)materialMap.get(data.getMaterialId());
                detail.setItemDesc(material.getDef8());
                detail.setItemDescMore(material.getDef7());
                detail.setItemUom(material.getDef9());
            }
            detail.setQty(ComputeUtil.scale((BigDecimal)data.getNum(), (int)4));
            detail.setCurrencyCode("CNY");
            detail.setBudgetAtm(ComputeUtil.scale((BigDecimal)data.getMoney(), (int)4));
            detail.setBudgetPrice(ComputeUtil.scale((BigDecimal)data.getPrice(), (int)8));
            detail.setPurcType(data.getPurcType());
            detail.setPurcSubtype(data.getPurcSubtype());
            detail.setRequireDate(DateUtils.transformationDate(data.getRequiredDate(), "YYYYMMDD"));
            detail.setEndDate(DateUtils.transformationDate(data.getEndDate(), "YYYYMMDD"));
            detail.setStartDate(DateUtils.transformationDate(data.getStartDate(), "YYYYMMDD"));
            detail.setIsConstructionProject(data.getIsConstructionProject());
            detail.setProjectNo(entity.getProjectCode());
            detail.setProjectName(entity.getProjectName());
            detail.setTaxMark(data.getTaxMark());
            detail.setPartUsed(data.getConstruction());
            detail.setUrgencyType(String.valueOf(entity.getUrgentState()));
            detail.setUrgentReason(data.getUrgentReason());
            detail.setIsPiecemeal(String.valueOf(entity.getSporadicState()));
            detail.setTprnd01Status("40");
            detail.setRemark(data.getMemo());
            if (userMap.containsKey(data.getBuyerId())) {
                UserVO user = (UserVO)userMap.get(data.getBuyerId());
                detail.setReqUser(user.getUserCode());
                detail.setReqName(user.getUserName());
            }
            detail.setApplyDeptId(HTConstants.HT_INVENTED_DEPT_CODE);
            detail.setApplyDeptName(HTConstants.HT_INVENTED_DEPT_NAME);
            detail.setApplyOrgId(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_CODE);
            detail.setApplyOrgName(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_NAME);
            detail.setCreateUser(HTConstants.HT_INVENTED_ACCOUNT);
            detail.setCreateUserName(HTConstants.HT_INVENTED_EMP_NAME);
            detail.setCreateOrgCode(HTConstants.HT_INVENTED_ORG_CODE);
            detail.setCreateOrgName(HTConstants.HT_INVENTED_ORG_NAME);
            detail.setCreateDate(DateUtils.transformationDate(data.getCreateTime(), "YYYYMMDDHH24MSS"));
            detail.setCreateDeptCode(HTConstants.HT_INVENTED_DEPT_CODE);
            detail.setCreateDeptName(HTConstants.HT_INVENTED_DEPT_NAME);
            detail.setActualDemandPlanOrgCode(entity.getOrgCode());
            detail.setActualDemandPlanOrgName(entity.getOrgName());
            detail.setActualDemandPlanDeptCode(entity.getProjectCode());
            detail.setActualDemandPlanDeptName(entity.getProjectName());
            detail.setActualDemandPlanPlannerCode(String.valueOf(entity.getEmployeeId()));
            detail.setActualDemandPlanPlanner(entity.getEmployeeName());
            detail.setSysCode("HJJC");
            detail.setCreatePlateCode(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_CODE);
            detail.setCreatePlateName(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_NAME);
            detailList.add(detail);
        }
        vo.setPlanDetailList(detailList);
        return vo;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("------------\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03------------");
        this.logger.info("\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03===billId:{},state:{},billTypeCode:{}", new Object[]{billId, state, billTypeCode});
        BatPlanEntity batPlanEntity = (BatPlanEntity)((Object)this.batPlanService.selectById(billId));
        if (BatPlanEnum.PLAN_STATE_WAIT.getPlanState().equals(batPlanEntity.getPlanState())) {
            return CommonResponse.success();
        }
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u68c0\u67e5\u7ed3\u679c\uff1a{}", (Object)resp);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)"\u5355\u636e\u88ab\u5f15\u7528\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

