/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.sync.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.service.IOrderDetailService;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.business.promaterial.plan.bean.BatPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.BatPlanEntity;
import com.ejianc.business.promaterial.plan.service.IBatPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IBatPlanService;
import com.ejianc.business.promaterial.sync.bean.SyncContractDetailEntity;
import com.ejianc.business.promaterial.sync.bean.SyncContractEntity;
import com.ejianc.business.promaterial.sync.consts.HTConstants;
import com.ejianc.business.promaterial.sync.service.ISyncContractDetailService;
import com.ejianc.business.promaterial.sync.service.ISyncContractService;
import com.ejianc.business.promaterial.sync.vo.FileDto;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.business.promaterial.utils.DateUtils;
import com.ejianc.business.promaterial.utils.JSONUtils;
import com.ejianc.business.promaterial.utils.OrgUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IShareCustomerApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

@Component(value="materialListener")
public class ZhHtCommonListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISyncContractService contractService;
    @Autowired
    private ISyncContractDetailService contractDetailService;
    @Autowired
    private IBatPlanService batPlanService;
    @Autowired
    private IBatPlanDetailService batPlanDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private IShareCustomerApi customerApi;
    @Autowired
    private IShareSupplierApi supplierApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    @JmsListener(destination="${zhht.contractCallback}")
    public void receive_cnecht_zh_contractCallback(String message) {
        this.logger.info("cnecht.zh.contractCallback message: " + message);
        JSONObject json = JSONObject.parseObject((String)message);
        JSONObject data = json.getJSONObject("data");
        JSONArray messageBody = data.getJSONArray("messageBody");
        this.orgUtil.initContext(HTConstants.SYSTEM_USER_ID);
        List<String> bpoIds = messageBody.stream().map(x -> ((JSONObject)x).getString("bpoId")).collect(Collectors.toList());
        Map<String, SyncContractEntity> map = this.getContractMap(bpoIds);
        List itemIds = messageBody.stream().map(x -> ((JSONObject)x).getJSONArray("contractDetailList")).flatMap(Collection::stream).map(x -> (JSONObject)x).map(x -> x.getString("itemId")).distinct().collect(Collectors.toList());
        HashMap<String, MaterialVO> materialMap = new HashMap();
        if (CollectionUtils.isNotEmpty(itemIds)) {
            CommonResponse materialResp = this.materialApi.queryMaterialListByCodes(itemIds);
            if (materialResp.isSuccess()) {
                materialMap = ((List)materialResp.getData()).stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
            } else {
                this.logger.error("materialResp ==== ", (Object)materialResp.getMsg());
            }
        }
        ArrayList<SyncContractEntity> saveList = new ArrayList<SyncContractEntity>();
        for (Object o : messageBody) {
            BatPlanEntity plan;
            JSONObject obj = (JSONObject)o;
            SyncContractEntity vo = this.transferContractVO(map, obj);
            Map<String, SyncContractDetailEntity> detailMap = vo.getDetailList().stream().collect(Collectors.toMap(x -> x.getBpoLineId(), x -> x));
            List<SyncContractDetailEntity> detailList = this.transferContractDetail(obj.getJSONArray("contractDetailList"), detailMap, materialMap);
            String sourceId = null;
            if (CollectionUtils.isNotEmpty(detailList)) {
                vo.setDetailList(detailList);
                sourceId = detailList.get(0).getSourceId();
            }
            if (null == (plan = this.setProjectInfo(vo, sourceId))) {
                this.logger.error("sourceId-{}\u67e5\u8be2\u91c7\u8d2d\u8ba1\u5212-{} ==== ", (Object)sourceId, (Object)plan);
            }
            if (obj.containsKey((Object)"signedDirList") && obj.getJSONArray("signedDirList").size() > 0) {
                List<FileDto> signedDirList = JSONUtils.json2List(obj.getString("signedDirList"), FileDto.class);
                vo.setContractFilePath(signedDirList.get(0).getDownloadUrl());
            }
            vo.setSyncResult(obj.toJSONString());
            saveList.add(vo);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            for (SyncContractEntity entity : saveList) {
                this.contractService.saveOrUpdate((Object)entity, false);
            }
        }
        this.logger.info("\u76d1\u542c\u91c7\u8d2d\u5408\u540c\u540c\u6b65\u6267\u884c\u6210\u529f-\u65b0\u589e{}\u6761\uff01", (Object)saveList.size());
    }

    @JmsListener(destination="${zhht.orderCallback}")
    public void receive_cnecht_zh_orderCallback(String message) {
        this.logger.info("cnecht.zh.orderCallback message: " + message);
        JSONObject json = JSONObject.parseObject((String)message);
        JSONObject data = json.getJSONObject("data");
        JSONArray messageBody = data.getJSONArray("messageBody");
        this.orgUtil.initContext(HTConstants.SYSTEM_USER_ID);
        List bpoIds = messageBody.stream().map(x -> ((JSONObject)x).getString("bpoId")).collect(Collectors.toList());
        Map<Object, Object> contractMap = new HashMap();
        if (CollectionUtils.isNotEmpty(bpoIds)) {
            QueryParam param = new QueryParam();
            param.getParams().put("bpoId", new Parameter("in", bpoIds));
            List list = this.contractService.queryList(param);
            contractMap = list.stream().collect(Collectors.toMap(x -> x.getBpoId(), x -> x, (v1, v2) -> v2));
        }
        ArrayList<SyncContractEntity> saveList = new ArrayList<SyncContractEntity>();
        for (Object o : messageBody) {
            JSONObject obj = (JSONObject)o;
            if (!contractMap.containsKey(obj.getString("bpoId"))) continue;
            SyncContractEntity entity = (SyncContractEntity)((Object)contractMap.get(obj.getString("bpoId")));
            entity.setOrderId(obj.getString("orderId"));
            saveList.add(entity);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.contractService.saveOrUpdateBatch(saveList, saveList.size());
        }
        this.logger.info("\u76d1\u542c\u8ba2\u5355\u540c\u6b65\u6267\u884c\u6210\u529f-\u4fee\u6539{}\u6761-{}\uff01", (Object)saveList.size(), (Object)JSON.toJSONString(bpoIds));
    }

    private BatPlanEntity setProjectInfo(SyncContractEntity vo, String sourceId) {
        if (StringUtils.isEmpty((CharSequence)sourceId)) {
            return null;
        }
        BatPlanDetailEntity planDetail = (BatPlanDetailEntity)((Object)this.batPlanDetailService.selectById((Serializable)((Object)sourceId)));
        if (null == planDetail) {
            return null;
        }
        BatPlanEntity plan = (BatPlanEntity)((Object)this.batPlanService.selectById(planDetail.getPlanId()));
        if (null == plan) {
            return null;
        }
        vo.setProjectId(plan.getProjectId());
        vo.setProjectName(plan.getProjectName());
        vo.setOrgId(plan.getOrgId());
        vo.setOrgCode(plan.getOrgCode());
        vo.setOrgName(plan.getOrgName());
        vo.setParentOrgId(plan.getParentOrgId());
        vo.setParentOrgCode(plan.getParentOrgCode());
        vo.setParentOrgName(plan.getParentOrgName());
        return plan;
    }

    private SyncContractEntity transferContractVO(Map<String, SyncContractEntity> map, JSONObject obj) {
        String code = obj.getString("bpoId");
        SyncContractEntity vo = new SyncContractEntity();
        vo.setId(IdWorker.getId());
        vo.setContractType(0);
        vo.setSignatureStatus("1");
        vo.setFilingStatus(0);
        vo.setPurchaseType("1");
        vo.setPurchaseTypeName("\u81ea\u91c7");
        vo.setFilingRef(0);
        vo.setChangeVersion(0);
        vo.setChangeStatus(1);
        vo.setContractCategoryId(1871172853848608769L);
        vo.setContractCategoryName("\u901a\u7528\u7269\u8d44");
        vo.setContractPropertyCode("proMaterial-1");
        vo.setContractPropertyName("\u5927\u5b97\u6750");
        vo.setEffectiveDate(new Date());
        vo.setMainContractCreateDate(new Date());
        vo.setBillState(BillStateEnum.PASSED_STATE.getBillStateCode());
        if (map.containsKey(code)) {
            vo = map.get(code);
        }
        vo.setBillCode(code);
        vo.setBpoId(obj.getString("bpoId"));
        vo.setContractName(obj.getString("bpoName"));
        vo.setSignDate(DateUtils.createDate(obj.getString("bpoSignedDate"), "YYYYMMDD"));
        vo.setSignPlace(obj.getString("bpoSignedAddress"));
        vo.setProjectPlace(obj.getString("deliveryLocation"));
        vo.setCustomerName(obj.getString("signOrgName"));
        CommonResponse customerResp = this.supplierApi.findOneByName(vo.getCustomerName(), InvocationInfoProxy.getTenantid());
        if (customerResp.isSuccess() && null != customerResp.getData()) {
            vo.setCustomerId(((SupplierVO)customerResp.getData()).getId());
        } else {
            this.logger.error("customerResp ==== ", (Object)customerResp.getMsg());
        }
        vo.setCustomerEmployeeName(obj.getString("bpoEditPerson"));
        vo.setCustomerEmployeeMobile(obj.getString("bpoEditPersonTel"));
        CommonResponse userResp = this.userApi.findByUserMobile(vo.getCustomerEmployeeMobile());
        if (userResp.isSuccess() && null != userResp.getData()) {
            vo.setCustomerEmployeeId(((UserVO)userResp.getData()).getId());
        } else {
            this.logger.error("userResp ==== ", (Object)userResp.getMsg());
        }
        vo.setSupplierName(obj.getString("supplierName"));
        CommonResponse supplierResp = this.supplierApi.findOneByName(vo.getSupplierName(), InvocationInfoProxy.getTenantid());
        if (supplierResp.isSuccess() && null != supplierResp.getData()) {
            vo.setSupplierId(((SupplierVO)supplierResp.getData()).getId());
        } else {
            this.logger.error("supplierResp ==== ", (Object)supplierResp.getMsg());
        }
        vo.setContractTaxMny(obj.getBigDecimal("bpoTaxAmt"));
        vo.setContractMny(obj.getBigDecimal("bpoNotaxAmt"));
        vo.setContractTax(ComputeUtil.safeSub((BigDecimal)vo.getContractTaxMny(), (BigDecimal)vo.getContractMny()));
        vo.setTaxRate(CommonUtils.getTaxRate(vo.getContractTaxMny(), vo.getContractMny()));
        vo.setBaseMoneyWithTax(vo.getContractTaxMny());
        vo.setBaseMoney(vo.getContractMny());
        vo.setBeforeChangeMnyWithTax(vo.getContractTaxMny());
        vo.setBeforeChangeMny(vo.getContractMny());
        vo.setDetailTaxMny(vo.getContractTaxMny());
        vo.setDetailMny(vo.getContractMny());
        vo.setDetailTax(vo.getContractTax());
        vo.setPerformanceStatus(ZhHtCommonListener.tranferStatus(obj.getString("apprState")));
        vo.setDraftType("2-2".equals(obj.getString("signFunc")) ? "2" : "3");
        vo.setPricingType("10".equals(obj.getString("bpoType")) ? "3" : ("11".equals(obj.getString("bpoType")) ? "1" : "2"));
        vo.setSupplementFlag("2".equals(obj.getString("bpoRelation")) ? 1 : 0);
        return vo;
    }

    private List<SyncContractDetailEntity> transferContractDetail(JSONArray detailArray, Map<String, SyncContractDetailEntity> detailMap, Map<String, MaterialVO> materialMap) {
        List bpoLineIds = detailArray.stream().map(x -> (JSONObject)x).map(x -> x.getString("bpoLineId")).collect(Collectors.toList());
        ArrayList<SyncContractDetailEntity> detailList = new ArrayList<SyncContractDetailEntity>();
        for (Object dd : detailArray) {
            JSONObject dObj = (JSONObject)dd;
            SyncContractDetailEntity detail = new SyncContractDetailEntity();
            String bpoLineId = dObj.getString("bpoLineId");
            detail.setSourceType("5");
            detail.setChangeType("0");
            if (detailMap.containsKey(bpoLineId)) {
                detail = detailMap.get(bpoLineId);
            }
            detail.setBpoLineId(bpoLineId);
            detail.setSourceId(CommonUtils.split(dObj.getString("outPlanLineNo"), "_", 1));
            detail.setNum(dObj.getBigDecimal("bpoQty"));
            detail.setPrice(dObj.getBigDecimal("bpoNotaxPrice"));
            detail.setDetailTaxPrice(dObj.getBigDecimal("bpoPrice"));
            detail.setDetailTaxRate(dObj.getBigDecimal("taxRate"));
            detail.setMoney(dObj.getBigDecimal("bpoNotaxAmt"));
            detail.setDetailTaxMny(dObj.getBigDecimal("bpoAmt"));
            detail.setDetailTax(dObj.getBigDecimal("bpoTaxAmt"));
            detail.setMaterialName(dObj.getString("itemName"));
            detail.setMaterialCode(dObj.getString("itemId"));
            detail.setUnitName(dObj.getString("itemUom"));
            if (materialMap.containsKey(detail.getMaterialCode())) {
                MaterialVO material = materialMap.get(detail.getMaterialCode());
                detail.setMaterialId(material.getId());
                detail.setMaterialTypeId(material.getCategoryId());
                detail.setMaterialTypeName(material.getCategoryName());
                detail.setSpec(material.getSpec());
                detail.setUnitId(material.getUnitId());
                detail.setUnitName(material.getUnitName());
                detail.setTexture(material.getDef1());
            }
            detailList.add(detail);
        }
        for (SyncContractDetailEntity detail : detailMap.values()) {
            if (!StringUtils.isNotEmpty((CharSequence)detail.getBpoLineId()) || bpoLineIds.contains(detail.getBpoLineId())) continue;
            detail.setRowState("del");
            detailList.add(detail);
        }
        return detailList;
    }

    private static String tranferStatus(String apprState) {
        String status = null;
        switch (apprState) {
            case "REJECT": {
                status = "4";
                break;
            }
            case "ECONSIGNED": {
                status = "2";
                break;
            }
            case "ACTIVE": {
                status = "2";
                break;
            }
            case "REVISION": {
                status = "2";
                break;
            }
            case "LOCK": {
                status = "5";
                break;
            }
            case "STOP": {
                status = "3";
                break;
            }
            default: {
                status = "1";
            }
        }
        return status;
    }

    private Map<String, SyncContractEntity> getContractMap(List<String> bpoIds) {
        if (CollectionUtils.isEmpty(bpoIds)) {
            return new HashMap<String, SyncContractEntity>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("bpoId", new Parameter("in", bpoIds));
        List list = this.contractService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new HashMap<String, SyncContractEntity>();
        }
        List ids = list.stream().map(x -> x.getId()).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("in", ids));
        List detailList = this.contractDetailService.queryList(queryParam);
        Map<Long, List<SyncContractDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(x -> x.getContractId()));
        for (SyncContractEntity entity : list) {
            if (!detailMap.containsKey(entity.getId())) continue;
            entity.setDetailList(detailMap.get(entity.getId()));
        }
        Map<String, SyncContractEntity> map = list.stream().collect(Collectors.toMap(x -> x.getBpoId(), x -> x, (v1, v2) -> v2));
        return map;
    }

    private Map<String, OrderEntity> getOrderMap(List<String> orderIds) {
        if (CollectionUtils.isEmpty(orderIds)) {
            return new HashMap<String, OrderEntity>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("orderId", new Parameter("in", orderIds));
        List list = this.orderService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new HashMap<String, OrderEntity>();
        }
        List ids = list.stream().map(x -> x.getId()).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orderId", new Parameter("in", ids));
        List detailList = this.orderDetailService.queryList(queryParam);
        Map<Long, List<OrderDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(x -> x.getOrderId()));
        for (OrderEntity entity : list) {
            if (!detailMap.containsKey(entity.getId())) continue;
            entity.setOrderDetailList(detailMap.get(entity.getId()));
        }
        Map<String, OrderEntity> map = list.stream().collect(Collectors.toMap(x -> x.getOrderId(), x -> x, (v1, v2) -> v2));
        return map;
    }
}

