/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.utils;

import com.ejianc.framework.core.exception.BusinessException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static Logger logger = LoggerFactory.getLogger(DateUtils.class);
    public static final String YYYY_MM_DD = "yyyy-MM-dd";

    private DateUtils() {
    }

    public static int[] dayCompare(Date fromDate, Date toDate) {
        Instant instant = fromDate.toInstant();
        Instant instant1 = toDate.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate one = instant.atZone(zoneId).toLocalDate();
        LocalDate two = instant1.atZone(zoneId).toLocalDate();
        int year = Period.between(one, two).getYears();
        int month = Period.between(one, two).getMonths();
        int day = Period.between(one, two).getDays();
        month = year * 12 + month;
        return new int[]{month, day};
    }

    public static Integer daysBetween(Date smdate, Date bdate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
            Calendar cal = Calendar.getInstance();
            cal.setTime(smdate);
            long time1 = cal.getTimeInMillis();
            cal.setTime(bdate);
            long time2 = cal.getTimeInMillis();
            long between_days = (time2 - time1) / 86400000L;
            return Integer.parseInt(String.valueOf(between_days));
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u65e5\u671f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException("\u8ba1\u7b97\u65e5\u671f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    public static Date calculationMonth(Date date, Integer month) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(2, month);
        return calendar.getTime();
    }

    public static Date calculationDay(Date date, Integer days) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, days);
        return calendar.getTime();
    }

    public static Date createDate(String date) {
        return DateUtils.createDate(date, YYYY_MM_DD);
    }

    public static Date createDate(String date, String pattern) {
        try {
            return new SimpleDateFormat(pattern).parse(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String transformationDate(Date date, String pattern) {
        if (null == date) {
            return null;
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String transformationDefaultDate(Date date) {
        if (null == date) {
            return null;
        }
        return DateUtils.transformationDate(date, YYYY_MM_DD);
    }

    public static Date formatDate(Date date, String pattern) {
        return DateUtils.createDate(DateUtils.transformationDate(date, pattern), pattern);
    }

    public static String formatExcelDate(String str) throws ParseException {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        Date date = new Date();
        try {
            Double par = Double.parseDouble(str);
            date = DateUtils.DoubleToDate(par);
        }
        catch (NumberFormatException e) {
            SimpleDateFormat bsdf = new SimpleDateFormat(DateUtils.getDateFormat(str));
            date = bsdf.parse(str);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        return sdf.format(date);
    }

    public static Date DoubleToDate(Double dVal) {
        Date tDate = new Date();
        long localOffset = tDate.getTimezoneOffset() * 60000;
        tDate.setTime((long)((dVal - 25569.0) * 24.0 * 3600.0 * 1000.0 + (double)localOffset));
        return tDate;
    }

    public static String formatDateString(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        SimpleDateFormat bsdf = new SimpleDateFormat(DateUtils.getDateFormat(str));
        String dateStr = null;
        try {
            dateStr = sdf.format(bsdf.parse(str));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public static String getDateFormat(String str) {
        boolean year = false;
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        if (pattern.matcher(str.substring(0, 4)).matches()) {
            year = true;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        if (!year) {
            if (str.contains("\u6708") || str.contains("-") || str.contains("/")) {
                if (Character.isDigit(str.charAt(0))) {
                    index = 1;
                }
            } else {
                index = 3;
            }
        }
        for (int i = 0; i < str.length(); ++i) {
            char lastChar;
            char chr = str.charAt(i);
            if (Character.isDigit(chr)) {
                if (index == 0) {
                    sb.append("y");
                }
                if (index == 1) {
                    sb.append("M");
                }
                if (index == 2) {
                    sb.append("d");
                }
                if (index == 3) {
                    sb.append("H");
                }
                if (index == 4) {
                    sb.append("m");
                }
                if (index == 5) {
                    sb.append("s");
                }
                if (index != 6) continue;
                sb.append("S");
                continue;
            }
            if (i > 0 && Character.isDigit(lastChar = str.charAt(i - 1))) {
                ++index;
            }
            sb.append(chr);
        }
        return sb.toString();
    }
}

