package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.order.vo.OrderDetailVO;
import com.ejianc.business.promaterial.plan.vo.PlanDetailVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.plan.mapper.PlanDetailMapper;
import com.ejianc.business.promaterial.plan.bean.PlanDetailEntity;
import com.ejianc.business.promaterial.plan.service.IPlanDetailService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 消耗材-需用计划子表
 * 
 * @author generator
 * 
 */
@Service("planDetailService")
public class PlanDetailServiceImpl extends BaseServiceImpl<PlanDetailMapper, PlanDetailEntity> implements IPlanDetailService{

    @Override
    public List<PlanDetailVO> geMaterialDetail(Page<PlanDetailVO> page, QueryWrapper queryWrapper) {
        List<PlanDetailVO> list = baseMapper.geMaterialDetail(page,queryWrapper);
        return list;
    }

    @Override
    public List<OrderDetailVO> queryMaterialDetail(Long projectId, Long materialId) {
        List<OrderDetailVO> orderDetailVOS = baseMapper.queryMaterialDetail(projectId, materialId);
        return orderDetailVOS;
    }

    @Override
    public BigDecimal getSurplusNumsSum(Long projectId, Long materialId) {
        BigDecimal surplusNumsSum = baseMapper.getSurplusNumsSum(projectId, materialId);
        return surplusNumsSum;
    }

    @Override
    public List<Map<String, Object>> countDetailTotalNum(Long planId, List<Long> detailIds, Long projectId) {
        if(CollectionUtils.isEmpty(detailIds)){
            return new ArrayList<>();
        }
        return baseMapper.countDetailTotalNum(planId, detailIds, projectId);
    }

    @Override
    public List<Map<String, Object>> countDetailTotalNumByMonth(Long planId, List<Long> detailIds, Long projectId) {
        if(CollectionUtils.isEmpty(detailIds)){
            return new ArrayList<>();
        }
        return baseMapper.countDetailTotalNumByMonth(planId, detailIds, projectId);
    }

    @Override
    public List<Map<String, Object>> contractNumCtrl(Long planId, List<Long> detailIds, Long contractId) {
        if(CollectionUtils.isEmpty(detailIds)){
            return new ArrayList<>();
        }
        return baseMapper.contractNumCtrl(planId, detailIds, contractId);
    }

    @Override
    public Map<Long, BigDecimal> writeBackOccupyNum(Map<Long, BigDecimal> numMap) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, new ArrayList<>(numMap.keySet())));
        List<PlanDetailEntity> list = super.queryList(param);
        for(PlanDetailEntity detail : list){
            detail.setOccupyNums(ComputeUtil.safeAdd(detail.getOccupyNums(), numMap.get(detail.getId())));
            detail.setSurplusNums(ComputeUtil.safeSub(detail.getActualNums(), detail.getOccupyNums()));
        }
        if(CollectionUtils.isNotEmpty(list)){
            super.saveOrUpdateBatch(list);
        }
        Map<Long, BigDecimal> result = list.stream().collect(Collectors.toMap(x->x.getId(), x->x.getOccupyNums()));
        return result;
    }
}
