package com.ejianc.business.promaterial.order.api;

import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.service.IOrderDetailService;
import com.ejianc.business.promaterial.order.vo.WriteBackVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/order/")
public class OrderApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICheckDetailService checkDetailService;

    @Autowired
    private IOrderDetailService orderDetailService;

    /**
     * 回写占用量
     * @param vo
     * @return
     */
    @RequestMapping(value = {"/writeBackOccupyNum"}, method = {RequestMethod.POST})
    CommonResponse<String> writeBackOccupyNum(@RequestBody WriteBackVO vo){
        String reduceType = vo.getReduceType();
        Long checkId = vo.getCheckId();
        Long orderId = vo.getOrderId();
        Map<Long, BigDecimal> numMap = vo.getNumMap();
        if(MapUtils.isEmpty(numMap)){
            return CommonResponse.success("数据为空！");
        }
        Map<Long, BigDecimal> orderMap = vo.getNumMap();
        if("1".equals(reduceType)){// 冲减验收
            QueryParam param = new QueryParam();
            param.getParams().put("checkId", new Parameter(QueryParam.EQ, checkId));
            param.getParams().put("materialId", new Parameter(QueryParam.IN, new ArrayList<>(numMap.keySet())));
            List<CheckDetailEntity> list = checkDetailService.queryList(param);
            for(CheckDetailEntity detail : list){
                if(!numMap.containsKey(detail.getMaterialId())){
                    continue;
                }
                orderMap.put(detail.getSourceId(), numMap.get(detail.getMaterialId()));
            }
        } else if("2".equals(reduceType)){// 冲减配送
            QueryParam param = new QueryParam();
            param.getParams().put("orderId", new Parameter(QueryParam.EQ, orderId));
            param.getParams().put("materialId", new Parameter(QueryParam.IN, new ArrayList<>(numMap.keySet())));
            List<OrderDetailEntity> list = orderDetailService.queryList(param);
            for(OrderDetailEntity detail : list){
                if(!numMap.containsKey(detail.getMaterialId())){
                    continue;
                }
                orderMap.put(detail.getId(), numMap.get(detail.getMaterialId()));
            }
        }
        if(MapUtils.isNotEmpty(orderMap)){
            // 冲减验收：减对应配送计划占用数量
            // 冲减配送：1.减对应配送计划实际数量和占用数量；2.减对应单项采购占用数量
            if("2".equals(reduceType)){
                orderDetailService.writeBackActualNum(orderMap);
            } else {
                orderDetailService.writeBackOccupyNum(orderMap);
            }
        }
        return CommonResponse.success("回写占用量成功！");
    }

}
