package com.ejianc.business.promaterial.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.plan.bean.PlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.PlanEntity;
import com.ejianc.business.promaterial.plan.service.IPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IPlanService;
import com.ejianc.business.promaterial.plan.vo.MonthPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.PlanDetailRefVO;
import com.ejianc.business.promaterial.plan.vo.PlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.PlanVO;
import com.ejianc.business.promaterial.utils.DateUtils;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 消耗材-需用计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("plan")
@Api(value = "消耗材-需用计划", tags = {"消耗材-需用计划"})
public class PlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "XYPLAN_CODE";//此处需要根据实际修改

    @Autowired
    private IPlanService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IPlanDetailService planDetailService;

    @Autowired
    private IShareMaterialApi materialApi;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody PlanVO saveOrUpdateVO) {
        return  service.saveOrUpdate(saveOrUpdateVO);
    }
    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanVO> queryDetail(@RequestParam Long id) {
    	PlanEntity entity = service.selectById(id);
    	PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("deptName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(!param.getParams().containsKey("orgId")){
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
//            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<PlanEntity> page = service.queryPage(param,false);
        IPage<PlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("construction");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                .findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId)
                .collect(Collectors.toList())));
        List<PlanEntity> list = service.queryList(param);
        List<PlanVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, PlanVO.class);
            for (PlanVO vo : voList) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Plan-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> refPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PlanEntity> page = service.queryPage(param,false);
        IPage<PlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 计划参照-列表二级树
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/planRef")
    @ResponseBody
    public CommonResponse<IPage<PlanDetailVO>> planRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                  @RequestParam(defaultValue = "10") Integer pageSize,
                  @RequestParam(value = "condition", required = false) String condition,
                  @RequestParam(value = "searchText", required = false) String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 查询主表 */
        QueryParam param = new QueryParam();
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if(null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            }
        }
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        List<PlanEntity> list = service.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return CommonResponse.success("查询列表数据成功！", new Page<>());
        }
        Map<Long, PlanEntity> map = list.stream().collect(Collectors.toMap(x->x.getId(), x->x));
        /** 查询子表 */
        List<Long> ids = list.stream().map(x->x.getId()).collect(Collectors.toList());
        queryParam.getParams().put("planId", new Parameter(QueryParam.IN, ids));
        queryParam.getParams().put("surplusNums", new Parameter(QueryParam.SQL,"IFNULL(surplus_nums,0)>0"));
        IPage<PlanDetailEntity> page = planDetailService.queryPage(queryParam, false);
        IPage<PlanDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PlanDetailVO> records = BeanMapper.mapList(page.getRecords(), PlanDetailVO.class);
        records.forEach(vo->{
            vo.setPlanCode(map.get(vo.getPlanId()).getBillCode());
        });
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("需用计划参数控制")
    @RequestMapping(value = "/paramCheck", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> paramCheck(@RequestBody PlanVO planVO) {
        List<ParamsCheckVO> allCheck = new ArrayList<>();
        ParamsCheckVO resp = new ParamsCheckVO();

//        logger.info("【消耗材总计划量】控制【消耗材需用计划量】 start");
//        allCheck.addAll(service.masterPlanNumCtrl(planVO));
//        logger.info("【消耗材总计划量】控制【消耗材需用计划量】 end");
//
//        logger.info("【消耗材总计划单价】控制【消耗材需用计划单价 start");
//        allCheck.addAll(service.masterPlanPriceCtrl(planVO));
//        logger.info("【消耗材总计划单价】控制【消耗材需用计划单价 end");

        logger.info("【总需用计划量】控制【分项需用计划量 start");
        allCheck.addAll(service.monthPlanNumCtrl(planVO));
        logger.info("【总需用计划量】控制【分项需用计划量 end");

        logger.info("【合同量】控制【分项需用计划量 start");
        allCheck.addAll(service.contractNumCtrl(planVO));
        logger.info("【合同量】控制【分项需用计划量 end");

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = allCheck.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            resp.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            resp.setWarnType("warn");
        } else {
            resp.setWarnType("none");
        }
        for(ParamsCheckVO p : result) {
            resp.getDataSource().addAll(p.getDataSource());
        }
        return CommonResponse.success("参数校验成功！", resp);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "plan-import.xlsx", "物料导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<PlanDetailVO> successList = new ArrayList<>();
            List<PlanDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 10) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                //获取物资档案数据
                List<String> materialCodeList = new ArrayList<>();
                Map<String, MaterialVO> map = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    materialCodeList.add(datas.get(1));//取材料编码  用来校验
                }
                CommonResponse<List<MaterialVO>> materialRes =  materialApi.queryMaterialListByCodes(materialCodeList);
                if(!materialRes.isSuccess()){
                    return CommonResponse.error("获取档案异常!");
                }
                map = materialRes.getData().stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PlanDetailVO vo = new PlanDetailVO();
                    vo.setId(IdWorker.getId());
                    vo.setMaterialCategoryName(datas.get(0));

                    if (StringUtils.isBlank(datas.get(1))) {
                        vo.setErrorMessage("物料编码为必填项");
                    } else {
                        vo.setMaterialCode(datas.get(1).trim());
                    }

                    vo.setMaterialName(datas.get(2));
                    vo.setSpec(datas.get(3));
                    vo.setUnit(datas.get(4));
                    String materialCode = datas.get(1);
                    if(map.containsKey(materialCode)){
                        MaterialVO material = map.get(materialCode);
                        vo.setMaterialCategoryId(material.getCategoryId());
                        vo.setMaterialCategoryName(material.getCategoryName());
                        vo.setMaterialId(material.getId());
                        vo.setMaterialCode(material.getCode());
                        vo.setMaterialName(material.getName());
                        vo.setSpec(material.getSpec());
                        vo.setTexture(material.getDef1());
                        vo.setUnitId(material.getUnitId());
                        vo.setUnit(material.getUnitName());
                        vo.setSourceId(material.getId());
                        vo.setSourceType(2L);// 来源于物资档案
                    }else{
                        vo.setErrorMessage("物资编码不匹配");
                    }

                    if (StringUtils.isNotBlank(datas.get(5))) {
                        try {
                            vo.setNums(new BigDecimal(datas.get(5)));
                            if (vo.getNums().longValue() < 0) {
                                vo.setErrorMessage("数量必须大于0");
                            }
                        } catch (Exception e) {
                            vo.setErrorMessage("数量必须为数字");
                        }
                    } else {
                        vo.setErrorMessage("数量为必填项");
                    }
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            String date = DateUtils.formatExcelDate(datas.get(6));
                            vo.setPlanDate(DateUtils.createDate(date));
                        } catch (Exception e) {
                            vo.setErrorMessage("需用日期非日期格式");
                        }
                    }

                    if (StringUtils.isNotBlank(datas.get(7))){
                        vo.setConstruction(datas.get(7).trim());
                    }

                    if (StringUtils.isNotBlank(datas.get(8))){
                        Integer firstState = "是".equals(datas.get(8)) ? 1 : 0;
                        vo.setFirstState(firstState);
                    }

                    if (StringUtils.isNotBlank(datas.get(9)) && datas.get(9).length() > 50) {
                        vo.setErrorMessage("备注填写长度为0~50字");
                    } else {
                        vo.setMemo(datas.get(9));
                    }

                    vo.setSourceType(2L);// 来源于物资档案
                    if (StringUtils.isBlank(vo.getErrorMessage())) {
                        successList.add(vo);
                    } else {
                        errorList.add(vo);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }
}
