package com.ejianc.business.promaterial.check.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.CheckStoreEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.ICheckStoreService;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("checkStore")
public class CheckStoreBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
    private ICheckStoreService service;

	@Autowired
	private IStoreManageApi storeManageApi;

	@Autowired
	private ICheckService checkService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		CheckStoreEntity entity = service.selectById(billId);
		// 更新验收是否入库
		LambdaUpdateWrapper<CheckEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.in(CheckEntity::getId, entity.getId());
		wrapper.set(CheckEntity::getStoreFlag, 1);// 是否入库 0 -否 1- 是
		checkService.update(wrapper);

		// 更新是否入库
		LambdaUpdateWrapper<CheckStoreEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(CheckStoreEntity::getId, entity.getId());
		updateWrapper.set(CheckStoreEntity::getStoreFlag, 1);// 是否入库 0 -否 1- 是
		service.update(updateWrapper);

		// 收料入库
		service.inStore(entity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error(res.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		CheckStoreEntity entity = service.selectById(billId);

		// 更新验收是否入库
		LambdaUpdateWrapper<CheckEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.in(CheckEntity::getId, entity.getId());
		wrapper.set(CheckEntity::getStoreFlag, 0);// 是否入库 0 -否 1- 是
		checkService.update(wrapper);

		// 更新是否入库
		LambdaUpdateWrapper<CheckStoreEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(CheckStoreEntity::getId, entity.getId());
		updateWrapper.set(CheckStoreEntity::getStoreFlag, 0);// 是否入库 0 -否 1- 是
		service.update(updateWrapper);

		//入库方式，0-收料入库，1-直入直出
		if (entity.getStoreType() == 0 && entity.getStoreFlag() == 1){
			List<Long> ids = new ArrayList<>();
			ids.add(billId);
			StoreManageVO storeManageVO = new StoreManageVO();
			storeManageVO.setSourceId(entity.getId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.收料入库);
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setOutEffectiveON(true);

			String stringInfo = JSONObject.toJSONString(storeManageVO);
			logger.info("消耗材撤回参数：" +stringInfo);
			CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
			if(!response.isSuccess()) {
				return CommonResponse.error(response.getMsg());
			}else{
				logger.info("xhc推送仓库成功:"+response.getMsg());
			}
		}
		return CommonResponse.success();
	}

}
