/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.check.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.CheckStoreDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckStoreEntity;
import com.ejianc.business.promaterial.check.mapper.CheckStoreMapper;
import com.ejianc.business.promaterial.check.service.ICheckStoreService;
import com.ejianc.business.promaterial.check.vo.CheckStoreVO;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkStoreService")
public class CheckStoreServiceImpl
extends BaseServiceImpl<CheckStoreMapper, CheckStoreEntity>
implements ICheckStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "XHC-CHECK-CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public CheckStoreVO saveOrUpdate(CheckStoreVO saveOrUpdateVO) {
        CheckStoreEntity entity = (CheckStoreEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CheckStoreEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(saveOrUpdateVO.getProjectShortName() + (String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        CheckStoreVO vo = (CheckStoreVO)BeanMapper.map((Object)((Object)entity), CheckStoreVO.class);
        return vo;
    }

    @Override
    public CheckStoreVO pushToCheckStore(CheckEntity check) {
        CheckStoreEntity entity = (CheckStoreEntity)((Object)BeanMapper.map((Object)((Object)check), CheckStoreEntity.class));
        entity.setBillCode(check.getBillCode() + "-\u5165\u5e93");
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        super.saveOrUpdate((Object)entity, false);
        return (CheckStoreVO)BeanMapper.map((Object)((Object)entity), CheckStoreVO.class);
    }

    @Override
    public Boolean delete(List<CheckStoreVO> vos) {
        List<Long> ids = vos.stream().map(x -> x.getId()).collect(Collectors.toList());
        ((CheckStoreMapper)this.baseMapper).deleteByIds(ids);
        ((CheckStoreMapper)this.baseMapper).deleteDetailList(ids);
        return true;
    }

    @Override
    public void inStore(CheckStoreEntity checkEntity) {
        ContractEntity contractEntity = null;
        if (checkEntity.getContractId() != null) {
            contractEntity = (ContractEntity)((Object)this.contractService.selectById(checkEntity.getContractId()));
        }
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6536\u6599\u5165\u5e93);
        storeManageVO.setStoreId(checkEntity.getStoreId());
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        storeManageVO.setSourceId(checkEntity.getId());
        ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
        for (int i = 0; i < checkEntity.getCheckDetailList().size(); ++i) {
            FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u6536\u6599\u5165\u5e93, (Integer)0);
            this.getFlow(checkEntity, checkEntity.getCheckDetailList().get(i), flowVO, contractEntity);
            flowVOS.add(flowVO);
        }
        storeManageVO.setFlowVOList(flowVOS);
        String stringInfo = JSONObject.toJSONString((Object)storeManageVO);
        this.logger.info("\u6d88\u8017\u6750\u9a8c\u6536\u5165\u5e93\u53c2\u6570\uff1a" + stringInfo);
        CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
        if (!response.isSuccess()) {
            this.logger.info("\u6d4b\u8bd5\u62a5\u951901");
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f" + response.getMsg());
        }
    }

    private void getFlow(CheckStoreEntity checkEntity, CheckStoreDetailEntity t, FlowVO flowVO, ContractEntity contractEntity) {
        flowVO.setConsumableFlag(t.getConsumableFlag());
        flowVO.setProjectId(checkEntity.getProjectId());
        flowVO.setTaxRate(t.getTaxRate());
        flowVO.setProjectName(checkEntity.getProjectName());
        flowVO.setParentOrgId(checkEntity.getParentOrgId());
        flowVO.setParentOrgName(checkEntity.getParentOrgName());
        flowVO.setOrgId(checkEntity.getOrgId());
        flowVO.setOrgName(checkEntity.getOrgName());
        flowVO.setStoreId(checkEntity.getStoreId());
        flowVO.setStoreName(checkEntity.getStoreName());
        flowVO.setEmployeeId(checkEntity.getEmployeeId());
        flowVO.setEmployeeName(checkEntity.getEmployeeName());
        flowVO.setMaterialType(checkEntity.getCheckType());
        flowVO.setMaterialTypeName(checkEntity.getCheckTypeName());
        flowVO.setSupplierId(checkEntity.getSupplierId());
        flowVO.setSupplierName(checkEntity.getSupplierName());
        flowVO.setPurchaseContractId(checkEntity.getContractId());
        flowVO.setPurchaseContractName(checkEntity.getContractName());
        flowVO.setMaterialCategoryId(t.getMaterialTypeId());
        flowVO.setMaterialCategoryName(t.getMaterialTypeName());
        flowVO.setMaterialId(t.getMaterialId());
        flowVO.setMaterialName(t.getMaterialName());
        flowVO.setMaterialCode(t.getMaterialCode());
        flowVO.setMaterialSpec(t.getSpec());
        flowVO.setMaterialUnitId(t.getUnitId());
        flowVO.setMaterialUnitName(t.getUnit());
        flowVO.setCusDef8(null != t.getDeliveryDate() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)t.getDeliveryDate()) : null);
        flowVO.setTaxPrice(t.getCheckTaxPrice());
        flowVO.setPrice(t.getCheckPrice());
        flowVO.setNum(t.getCheckNum());
        flowVO.setTaxMny(t.getCheckTaxMny());
        flowVO.setMny(t.getCheckMny());
        flowVO.setTax(t.getTaxMny());
        flowVO.setPickUnitId(checkEntity.getSubSupplierId());
        flowVO.setPickUnitName(checkEntity.getSubSupplierName());
        flowVO.setPickContractId(checkEntity.getSubContractId());
        flowVO.setPickContractName(checkEntity.getSubContractName());
        flowVO.setSourceId(checkEntity.getId());
        flowVO.setSourceDetailId(t.getId());
        flowVO.setSourceBillCode(checkEntity.getBillCode());
        flowVO.setSourceBillDate(checkEntity.getCheckDate());
        flowVO.setSourceBillRemark(checkEntity.getMemo());
        flowVO.setSourceBillDetailRemark(t.getMemo());
        flowVO.setSourceBillTypeName("\u6750\u6599\u9a8c\u6536");
        flowVO.setSourceBillTypeCode("BT220215000000006");
        flowVO.setSourceType(checkEntity.getSourceType());
        flowVO.setPickType(checkEntity.getSubOutType());
        flowVO.setLicensePlate(checkEntity.getLicensePlate());
        flowVO.setFinanceId(t.getFinanceId());
        flowVO.setFinanceName(t.getFinanceName());
        flowVO.setNetPrice(t.getNetPrice());
        flowVO.setUseType(t.getUseType());
        if (null != checkEntity.getContractId() && null != contractEntity) {
            List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
            Map sourceIdMap = contractDetailList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            Map DetailMaterialIdMap = contractDetailList.stream().filter(e -> e.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity()));
            Map DetailMaterialIdTypeMap = contractDetailList.stream().filter(e -> e.getMaterialId() == null).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, Function.identity()));
            ContractDetailEntity contractDetailEntity = (ContractDetailEntity)((Object)sourceIdMap.get(t.getSourceId()));
            if (null != contractDetailEntity) {
                flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                flowVO.setContractPrice(contractDetailEntity.getPrice());
            } else {
                contractDetailEntity = (ContractDetailEntity)((Object)DetailMaterialIdMap.get(t.getMaterialId()));
                if (null != contractDetailEntity) {
                    flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                    flowVO.setContractPrice(contractDetailEntity.getPrice());
                } else {
                    contractDetailEntity = (ContractDetailEntity)((Object)DetailMaterialIdTypeMap.get(t.getMaterialTypeId()));
                    if (null != contractDetailEntity) {
                        flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                        flowVO.setContractPrice(contractDetailEntity.getPrice());
                    } else {
                        flowVO.setContractTaxPrice(BigDecimal.ZERO);
                        flowVO.setContractPrice(BigDecimal.ZERO);
                    }
                }
            }
        }
        flowVO.setRowState(t.getRowState());
    }
}

