/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.different.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.different.bean.DifferentDetailEntity;
import com.ejianc.business.promaterial.different.bean.DifferentEntity;
import com.ejianc.business.promaterial.different.mapper.DifferentMapper;
import com.ejianc.business.promaterial.different.service.IDifferentService;
import com.ejianc.business.promaterial.different.vo.DifferentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="differentService")
public class DifferentServiceImpl
extends BaseServiceImpl<DifferentMapper, DifferentEntity>
implements IDifferentService {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    private static final String BILL_CODE = "DC_CODE";
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<DifferentVO> saveOrUpdate(DifferentVO saveOrUpdateVO) {
        DifferentEntity entity = (DifferentEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DifferentEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        DifferentVO vo = (DifferentVO)BeanMapper.map((Object)((Object)entity), DifferentVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<DifferentVO> pushCost(DifferentVO differentVO) {
        DifferentEntity differentEntity = (DifferentEntity)((Object)((DifferentMapper)this.baseMapper).selectById(differentVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)differentVO.getDifferentDetailList())) {
            List differentDetailEntityList = BeanMapper.mapList((Iterable)differentVO.getDifferentDetailList(), DifferentDetailEntity.class);
            differentEntity.setDifferentDetailList(differentDetailEntityList);
        }
        super.saveOrUpdate((Object)differentEntity, false);
        this.costPush(differentEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)differentEntity), DifferentVO.class));
    }

    private void costPush(DifferentEntity differentEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<DifferentDetailEntity> differentDetailEntityList = differentEntity.getDifferentDetailList();
        String newRelationFlag = "1";
        if (CollectionUtils.isNotEmpty(differentDetailEntityList)) {
            for (DifferentDetailEntity differentDetailEntity : differentDetailEntityList) {
                if (BigDecimal.ZERO.equals(differentDetailEntity.getDetailCostMny()) || BigDecimal.ZERO.equals(differentDetailEntity.getDetailCostTaxMny()) || null != differentDetailEntity.getSubjectId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(differentDetailEntityList)) {
            newRelationFlag = "0";
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{differentEntity.getId()});
        updateWrapper.set(DifferentEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = differentEntity.getRelationFlag();
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(differentEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                this.costDetailApi.deleteSubject(differentEntity.getId());
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag)) {
            this.saveCost(differentEntity);
        }
    }

    private void saveCost(DifferentEntity differentEntity) {
        CommonResponse stringCommonResponse;
        Integer settlementType = differentEntity.getSettlementType();
        String sourceType = settlementType == 0 ? "PROMATERIAL_DIFFERENT" : "CONCRETE_PROMATERIAL_DIFFERENT";
        String sourceTabType = settlementType == 0 ? "PROMATERIAL_DIFFERENT_DETAIL" : "CONCRETE_PROMATERIAL_DIFFERENT_DETAIL";
        String billName = settlementType == 0 ? SourceTypeEnum.\u6d88\u8017\u6750\u8c03\u5dee\u5355.getTypeName() : SourceTypeEnum.\u6df7\u51dd\u571f\u8c03\u5dee\u5355.getTypeName();
        String url = settlementType == 0 ? "/ejc-promaterial-frontend/#/different/card?id=" : "/ejc-promaterial-frontend/#/differentConcrete/card?id=";
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<DifferentDetailEntity> differentDetailEntityList = differentEntity.getDifferentDetailList();
        if (CollectionUtils.isNotEmpty(differentDetailEntityList)) {
            for (DifferentDetailEntity differentDetailEntity : differentDetailEntityList) {
                if (BigDecimal.ZERO.equals(differentDetailEntity.getDetailCostMny()) || BigDecimal.ZERO.equals(differentDetailEntity.getDetailCostTaxMny())) continue;
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSourceBillCode(differentEntity.getBillCode());
                costDetailVO.setSourceBillName(billName);
                costDetailVO.setSourceBillUrl(url + differentEntity.getId());
                costDetailVO.setSubjectId(differentDetailEntity.getSubjectId());
                costDetailVO.setSubjectCode(differentDetailEntity.getSubjectCode());
                costDetailVO.setSubjectName(differentDetailEntity.getSubjectName());
                costDetailVO.setWbsId(differentDetailEntity.getWbsId());
                costDetailVO.setWbsCode(differentDetailEntity.getWbsCode());
                costDetailVO.setWbsName(differentDetailEntity.getWbsName());
                costDetailVO.setSourceId(differentDetailEntity.getDifferentId());
                costDetailVO.setSourceDetailId(differentDetailEntity.getId());
                costDetailVO.setHappenTaxMny(differentDetailEntity.getDetailCostTaxMny());
                costDetailVO.setHappenMny(differentDetailEntity.getDetailCostMny());
                costDetailVO.setHappenDate(differentEntity.getDifferentDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(sourceType);
                costDetailVO.setSourceTabType(sourceTabType);
                costDetailVO.setProjectId(differentEntity.getProjectId());
                costDetailVO.setMaterialId(differentDetailEntity.getMaterialId());
                costDetailVO.setMaterialName(differentDetailEntity.getMaterialName());
                costDetailVO.setMaterialCode(differentDetailEntity.getMaterialCode());
                costDetailVO.setMaterialTypeId(differentDetailEntity.getMaterialTypeId());
                costDetailVO.setMaterialTypeName(differentDetailEntity.getMaterialTypeName());
                costDetailVO.setSpec(differentDetailEntity.getSpec());
                costDetailVO.setUnit(differentDetailEntity.getUnit());
                costDetailVO.setUnitId(differentDetailEntity.getUnitId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList) && !(stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList)).isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
    }
}

