/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.out.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.out.bean.OutStoreEntity;
import com.ejianc.business.promaterial.out.bean.OutStoreSubEntity;
import com.ejianc.business.promaterial.out.mapper.OutStoreMapper;
import com.ejianc.business.promaterial.out.service.IOutStoreService;
import com.ejianc.business.promaterial.out.vo.ClaimTypeEnum;
import com.ejianc.business.promaterial.out.vo.OutStoreSubVO;
import com.ejianc.business.promaterial.out.vo.OutStoreVO;
import com.ejianc.business.promaterial.out.vo.SupOutStoreSubVO;
import com.ejianc.business.promaterial.out.vo.SupOutStoreVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="outStoreService")
public class OutStoreServiceImpl
extends BaseServiceImpl<OutStoreMapper, OutStoreEntity>
implements IOutStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private JedisPool jedisPool;
    private final String OPERATE = "PROMATERIAL_OUT";
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    private static final String BILL_TYPE = "BT220215000000004";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/outStore/saveOutStore";
    private final String DELPUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/outStore/deleteOutStore";
    private static final String BILL_CODE = "PROMATERIAL_OUT";
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public CommonResponse<OutStoreVO> saveOrUpdate(OutStoreVO outStoreVO) {
        OutStoreEntity entity;
        OrgVO orgVO;
        CommonResponse orgResponse;
        if (CollectionUtils.isEmpty((Collection)outStoreVO.getOutStoreSubList())) {
            throw new BusinessException("\u5b50\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList list = new ArrayList();
        outStoreVO.getOutStoreSubList().forEach(e -> {
            if (!"del".equals(e.getRowState())) {
                list.add(e);
            }
        });
        if (CollectionUtils.isEmpty(list)) {
            throw new BusinessException("\u5b50\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)outStoreVO.getParentOrgCode()) && outStoreVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(outStoreVO.getParentOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            outStoreVO.setParentOrgCode(orgVO.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)outStoreVO.getOrgCode()) && outStoreVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(outStoreVO.getOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            outStoreVO.setOrgCode(orgVO.getCode());
        }
        if ((entity = (OutStoreEntity)((Object)BeanMapper.map((Object)outStoreVO, OutStoreEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)outStoreVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setSignStatus(0);
        entity.setRelationFlag("0");
        entity.setProportionFlag("0");
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        super.saveOrUpdate((Object)entity, false);
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(outStoreVO.getStoreId());
        storeManageVO.setSourceId(entity.getId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u9886\u6599\u51fa\u5e93);
        storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
        ArrayList flowVOS = new ArrayList();
        outStoreVO.getOutStoreSubList().forEach(t -> {
            if ("del".equals(t.getRowState())) {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u9886\u6599\u51fa\u5e93, (Integer)0);
                flowVO.setStoreId(outStoreVO.getStoreId());
                flowVO.setStoreName(outStoreVO.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(outStoreVO.getEmployeeId());
                flowVO.setEmployeeName(outStoreVO.getEmployeeName());
                flowVO.setSupplierId(entity.getSubSupplierId());
                flowVO.setSupplierName(entity.getSubSupplierName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialCode(t.getMaterialCode());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getSpec());
                flowVO.setMaterialUnitId(t.getUnitId());
                flowVO.setMaterialUnitName(t.getUnit());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setTaxPrice(t.getTaxPrice());
                flowVO.setPrice(t.getPrice());
                flowVO.setNum(t.getNum());
                flowVO.setTaxMny(t.getTaxMoney());
                flowVO.setMny(t.getMoney());
                flowVO.setTax(t.getOutTax());
                flowVO.setUseFor(outStoreVO.getUseFor());
                flowVO.setSubEmployeeName(outStoreVO.getSubEmployeeName());
                flowVO.setPickUnitId(entity.getSubSupplierId());
                flowVO.setPickUnitName(entity.getSubSupplierName());
                flowVO.setPickContractId(entity.getSubContractId());
                flowVO.setPickContractName(entity.getSubContractName());
                flowVO.setMaterialUseId(entity.getMaterialUseId());
                flowVO.setMaterialUseName(entity.getMaterialUseName());
                flowVO.setSubjectId(t.getSubjectId());
                flowVO.setSubjectName(t.getSubjectName());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getOutDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillTypeCode(BILL_TYPE);
                flowVO.setSourceBillTypeName("\u9886\u6599\u51fa\u5e93");
                flowVO.setSourceType(Integer.valueOf(1));
                flowVO.setSourceBillRemark(entity.getMemo());
                flowVO.setPickType(entity.getClaimType());
                flowVO.setPickTypeName(ClaimTypeEnum.getEnumByStateCode((Integer)entity.getClaimType()).getDescription());
                flowVOS.add(flowVO);
            }
        });
        entity.getOutStoreSubList().forEach(t -> {
            FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u9886\u6599\u51fa\u5e93, (Integer)0);
            flowVO.setStoreId(outStoreVO.getStoreId());
            flowVO.setStoreName(outStoreVO.getStoreName());
            flowVO.setProjectId(entity.getProjectId());
            flowVO.setProjectName(entity.getProjectName());
            flowVO.setOrgId(entity.getOrgId());
            flowVO.setOrgName(entity.getOrgName());
            flowVO.setParentOrgId(entity.getParentOrgId());
            flowVO.setParentOrgName(entity.getParentOrgName());
            flowVO.setEmployeeId(outStoreVO.getEmployeeId());
            flowVO.setEmployeeName(outStoreVO.getEmployeeName());
            flowVO.setSupplierId(entity.getSubSupplierId());
            flowVO.setSupplierName(entity.getSubSupplierName());
            flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
            flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
            flowVO.setMaterialId(t.getMaterialId());
            flowVO.setMaterialCode(t.getMaterialCode());
            flowVO.setMaterialName(t.getMaterialName());
            flowVO.setMaterialSpec(t.getSpec());
            flowVO.setMaterialUnitId(t.getUnitId());
            flowVO.setMaterialUnitName(t.getUnit());
            flowVO.setSourceBillDetailRemark(t.getMemo());
            flowVO.setTaxPrice(t.getTaxPrice());
            flowVO.setPrice(t.getPrice());
            flowVO.setNum(t.getNum());
            flowVO.setTaxMny(t.getTaxMoney());
            flowVO.setMny(t.getMoney());
            flowVO.setTax(t.getOutTax());
            flowVO.setUseFor(entity.getUseFor());
            flowVO.setSubEmployeeName(entity.getSubEmployeeName());
            flowVO.setPickUnitId(entity.getSubSupplierId());
            flowVO.setPickUnitName(entity.getSubSupplierName());
            flowVO.setPickContractId(entity.getSubContractId());
            flowVO.setPickContractName(entity.getSubContractName());
            flowVO.setMaterialUseId(entity.getMaterialUseId());
            flowVO.setMaterialUseName(entity.getMaterialUseName());
            flowVO.setSubjectId(t.getSubjectId());
            flowVO.setSubjectName(t.getSubjectName());
            flowVO.setSourceId(entity.getId());
            flowVO.setSourceDetailId(t.getId());
            flowVO.setSourceBillCode(entity.getBillCode());
            flowVO.setSourceBillTypeCode(BILL_TYPE);
            flowVO.setSourceBillTypeName("\u9886\u6599\u51fa\u5e93");
            flowVO.setSourceType(Integer.valueOf(1));
            flowVO.setSourceBillDate(entity.getOutDate());
            flowVO.setRowState(t.getRowState());
            flowVO.setSourceBillRemark(entity.getMemo());
            flowVO.setPickType(entity.getClaimType());
            flowVO.setPickTypeName(ClaimTypeEnum.getEnumByStateCode((Integer)entity.getClaimType()).getDescription());
            flowVOS.add(flowVO);
        });
        storeManageVO.setFlowVOList(flowVOS);
        this.logger.debug("\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString((Object)storeManageVO));
        CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
        }
        OutStoreVO vo = (OutStoreVO)BeanMapper.map((Object)((Object)entity), OutStoreVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<String> del(List<OutStoreVO> vos) {
        Collection list = super.listByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        HashMap<Long, List> map = new HashMap<Long, List>();
        list.forEach(e -> {
            if (map.containsKey(e.getStoreId())) {
                ((List)map.get(e.getStoreId())).add(e.getId());
            } else {
                ArrayList<Long> idList = new ArrayList<Long>();
                idList.add(e.getId());
                map.put(e.getStoreId(), idList);
            }
            if (e.getAttrFlag() != null && e.getAttrFlag() != 2) {
                CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(e.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
                if (!stringCommonResponse.isSuccess()) {
                    throw new BusinessException(stringCommonResponse.getMsg());
                }
            }
        });
        map.forEach((key, value) -> {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(key);
            storeManageVO.setSourceIdsForRollBack(value);
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u9886\u6599\u51fa\u5e93);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
            CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
        });
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        OutStoreEntity outStoreEntity = (OutStoreEntity)((Object)super.selectById((Serializable)((Object)billId)));
        outStoreEntity.setSupOperateTime(supOperateTime);
        outStoreEntity.setSupOperatorName(supOperatorName);
        outStoreEntity.setSupOperatorPhone(supOperatorPhone);
        outStoreEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = "BT220215000000004::" + outStoreEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)BILL_CODE, (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)outStoreEntity.getId());
                this.releaseLock(jedis, false, key, BILL_CODE);
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, outStoreEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            outStoreEntity.setAttachIds(attchIdsList);
            outStoreEntity.setSignStatus(1);
            super.saveOrUpdate((Object)outStoreEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)outStoreEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, BILL_CODE);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(OutStoreEntity entity) {
        if (null != entity.getClaimType() && 2 == entity.getClaimType()) {
            return false;
        }
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = "BT220215000000004::" + entity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u8ba1\u91cf\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)BILL_CODE, (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, BILL_CODE);
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            SupOutStoreVO supOutStoreVO = (SupOutStoreVO)BeanMapper.map((Object)((Object)entity), SupOutStoreVO.class);
            List subVOS = BeanMapper.mapList(entity.getOutStoreSubList(), SupOutStoreSubVO.class);
            supOutStoreVO.setOutStoreSubList(subVOS);
            paramMap.put("transData", JSONObject.toJSONString((Object)supOutStoreVO));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, null, null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)entity.getSubSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/outStore/saveOutStore", paramMap, entity.getSubSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{entity.getSubSupplierId(), entity.getId(), billPushResp.getMsg()});
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{entity.getId(), entity.getSubSupplierId(), syncReqResp.getMsg()});
                }
            } else {
                this.logger.error("\u83b7\u53d6\u51fa\u5e93\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)entity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u51fa\u5e93\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{entity.getId(), entity.getSubSupplierId(), e});
        }
        finally {
            this.releaseLock(jedis, locked, key, BILL_CODE);
        }
        return syncFlag;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CommonResponse<String> updatePushBill(OutStoreEntity entity) {
        locked = false;
        jedis = this.jedisPool.getResource();
        key = "BT220215000000004::" + entity.getId().toString();
        ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        ((OutStoreMapper)this.baseMapper).updateById((Object)entity);
        this.logger.info("\u4fee\u6539\u7b7e\u5b57\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)entity));
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"PROMATERIAL_OUT", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "PROMATERIAL_OUT");
                var6_6 = CommonResponse.error((String)"\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25!");
                return var6_6;
            }
            paramMap = new HashMap<String, String>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            this.logger.info("\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)entity.getSubSupplierId(), (Object)entity.getId());
            syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem("/ejc-supbusiness-web/openapi/outStore/deleteOutStore", RequestMethod.POST, JSONObject.toJSONString(paramMap), entity.getSubSupplierId().toString());
            if (!syncReqResp.isSuccess()) ** GOTO lbl36
            supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                var9_11 = supHandleResp;
                return var9_11;
            }
            try {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSubSupplierId(), entity.getId(), supHandleResp.getMsg()});
                throw new BusinessException(supHandleResp.getMsg());
lbl36:
                // 1 sources

                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSubSupplierId(), entity.getId(), syncReqResp.getMsg()});
                throw new BusinessException(syncReqResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
                throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
            }
        }
        finally {
            this.releaseLock(jedis, locked, key, "PROMATERIAL_OUT");
        }
    }

    @Override
    public CommonResponse<OutStoreVO> pushCost(OutStoreVO outStoreVO) {
        OutStoreEntity entity = (OutStoreEntity)((Object)((OutStoreMapper)this.baseMapper).selectById(outStoreVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)outStoreVO.getOutStoreSubList())) {
            List storeSubEntityList = BeanMapper.mapList((Iterable)outStoreVO.getOutStoreSubList(), OutStoreSubEntity.class);
            entity.setOutStoreSubList(storeSubEntityList);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), OutStoreVO.class));
    }

    @Override
    public ParamsCheckVO checkParams(OutStoreVO otStoreVO) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        CostCtrlVO costCtrlVO = this.sjCost(otStoreVO);
        if (null != costCtrlVO) {
            CommonResponse costResponse = this.executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("\u6210\u672c\u79d1\u76ee\u63a7\u5236\u5931\u8d25," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = (ParamsCheckVO)costResponse.getData();
            if (null != costRes) {
                paramsCheckVOS.add(costRes);
            }
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public void costPush(OutStoreEntity outStoreEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<OutStoreSubEntity> outStoreSubList = outStoreEntity.getOutStoreSubList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(outStoreSubList)) {
            for (OutStoreSubEntity storeSubEntity : outStoreSubList) {
                if (null != storeSubEntity.getSubjectId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(outStoreSubList)) {
            newRelationFlag = "0";
        }
        if ("1".equals(newRelationFlag)) {
            this.saveCost(outStoreEntity, 1);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{outStoreEntity.getId()});
        updateWrapper.set(OutStoreEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        outStoreEntity.setRelationFlag(newRelationFlag);
    }

    public CostCtrlVO sjCost(OutStoreVO vo) {
        List outStoreSubList = vo.getOutStoreSubList();
        if (CollectionUtils.isNotEmpty((Collection)outStoreSubList)) {
            HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
            for (OutStoreSubVO outStoreSubVO : outStoreSubList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal taxMoney;
                if (null == outStoreSubVO.getSubjectId() || "del".equals(outStoreSubVO.getRowState())) continue;
                BigDecimal money = outStoreSubVO.getMoney() == null ? BigDecimal.ZERO : outStoreSubVO.getMoney();
                BigDecimal bigDecimal = taxMoney = outStoreSubVO.getTaxMoney() == null ? BigDecimal.ZERO : outStoreSubVO.getTaxMoney();
                if (map.containsKey(outStoreSubVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(outStoreSubVO.getSubjectId());
                    BigDecimal mny = costCtrlDetailVO.getMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getMny();
                    BigDecimal taxMny = costCtrlDetailVO.getTaxMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getTaxMny();
                    costCtrlDetailVO.setMny(mny.add(money));
                    costCtrlDetailVO.setTaxMny(taxMny.add(taxMoney));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(outStoreSubVO.getSubjectId());
                costCtrlDetailVO.setMny(money);
                costCtrlDetailVO.setTaxMny(taxMoney);
                map.put(outStoreSubVO.getSubjectId(), costCtrlDetailVO);
            }
            if (null != map && map.size() > 0) {
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if (null != vo.getId()) {
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList(map.values()));
                return ctrlVO;
            }
            return null;
        }
        return null;
    }

    private void saveCost(OutStoreEntity outStoreEntity, Integer effectiveStatus) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<OutStoreSubEntity> outStoreSubList = outStoreEntity.getOutStoreSubList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(outStoreSubList)) {
            for (OutStoreSubEntity outStoreSubEntity : outStoreSubList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setMaterialId(outStoreSubEntity.getMaterialId());
                costDetailVO.setMaterialName(outStoreSubEntity.getMaterialName());
                costDetailVO.setMaterialCode(outStoreSubEntity.getMaterialCode());
                costDetailVO.setMaterialTypeId(outStoreSubEntity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(outStoreSubEntity.getMaterialCategoryName());
                costDetailVO.setSpec(outStoreSubEntity.getSpec());
                costDetailVO.setUnit(outStoreSubEntity.getUnit());
                costDetailVO.setUnitId(outStoreSubEntity.getUnitId());
                costDetailVO.setSourceBillCode(outStoreEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u9886\u6599\u51fa\u5e93.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-promaterial-frontend/#/outStore/card?id=" + outStoreEntity.getId());
                costDetailVO.setSubjectId(outStoreSubEntity.getSubjectId());
                costDetailVO.setSubjectId(outStoreSubEntity.getSubjectId());
                costDetailVO.setSubjectCode(outStoreSubEntity.getSubjectCode());
                costDetailVO.setSubjectName(outStoreSubEntity.getSubjectName());
                costDetailVO.setNum(outStoreSubEntity.getNum());
                costDetailVO.setWbsId(outStoreSubEntity.getWbsId());
                costDetailVO.setWbsCode(outStoreSubEntity.getWbsCode());
                costDetailVO.setWbsName(outStoreSubEntity.getWbsName());
                costDetailVO.setSourceId(outStoreSubEntity.getOutStoreId());
                costDetailVO.setSourceDetailId(outStoreSubEntity.getId());
                costDetailVO.setHappenTaxMny(outStoreSubEntity.getTaxMoney());
                costDetailVO.setHappenMny(outStoreSubEntity.getMoney());
                costDetailVO.setHappenDate(outStoreEntity.getOutDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("OUT_STORE");
                costDetailVO.setSourceTabType("OUT_STORE_SUB");
                costDetailVO.setProjectId(outStoreEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}

