/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.plan.bean.MonthPlanEntity;
import com.ejianc.business.promaterial.plan.service.IMonthPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMonthPlanService;
import com.ejianc.business.promaterial.plan.vo.MonthPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.MonthPlanVO;
import com.ejianc.business.promaterial.plan.vo.PlanTypeEnum;
import com.ejianc.business.promaterial.utils.ArchivesUtil;
import com.ejianc.business.promaterial.utils.DateUtils;
import com.ejianc.business.promaterial.utils.JSONUtils;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"monthPlan"})
public class MonthPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "MONTH_PLAN_CODE";
    @Autowired
    private IMonthPlanService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private ArchivesUtil archivesUtil;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IShareProjectWbsApi wbsApi;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MonthPlanVO> saveOrUpdate(@RequestBody MonthPlanVO saveorUpdateVO) {
        return this.service.saveOrUpdate(saveorUpdateVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MonthPlanVO> queryDetail(Long id) {
        MonthPlanEntity entity = (MonthPlanEntity)((Object)this.service.selectById(id));
        MonthPlanVO vo = (MonthPlanVO)BeanMapper.map((Object)((Object)entity), MonthPlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthPlanVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MonthPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("operatorName");
        fuzzyFields.add("deptName");
        param.getParams().put("planType", new Parameter("eq", (Object)PlanTypeEnum.\u6d88\u8017\u6750.getCode()));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MonthPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u6df7\u6ce5\u571f\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryConcreteList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MonthPlanVO>> queryConcreteList(@RequestBody QueryParam param) {
        IPage<MonthPlanVO> pageData = this.service.queryConcreteList(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("planType", new Parameter("eq", (Object)PlanTypeEnum.\u6d88\u8017\u6750.getCode()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, MonthPlanVO.class);
            voList.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("MonthPlan-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u6708\u8ba1\u5212\u53c2\u6570\u63a7\u5236")
    @RequestMapping(value={"/paramCheck"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> paramCheck(@RequestBody MonthPlanVO monthPlanVO) {
        ArrayList<ParamsCheckVO> allCheck = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO resp = new ParamsCheckVO();
        this.logger.info("\u3010\u6d88\u8017\u6750\u603b\u8ba1\u5212\u91cf\u3011\u63a7\u5236\u3010\u6d88\u8017\u6750\u6708\u8ba1\u5212\u91cf\u3011 start");
        allCheck.addAll(this.service.masterPlanNumCtrl(monthPlanVO));
        this.logger.info("\u3010\u6d88\u8017\u6750\u603b\u8ba1\u5212\u91cf\u3011\u63a7\u5236\u3010\u6d88\u8017\u6750\u6708\u8ba1\u5212\u91cf\u3011 end");
        this.logger.info("\u3010\u6d88\u8017\u6750\u603b\u8ba1\u5212\u5355\u4ef7\u3011\u63a7\u5236\u3010\u6d88\u8017\u6750\u6708\u8ba1\u5212\u5355\u4ef7 start");
        allCheck.addAll(this.service.masterPlanPriceCtrl(monthPlanVO));
        this.logger.info("\u3010\u6d88\u8017\u6750\u603b\u8ba1\u5212\u5355\u4ef7\u3011\u63a7\u5236\u3010\u6d88\u8017\u6750\u6708\u8ba1\u5212\u5355\u4ef7 end");
        Map<String, List<ParamsCheckVO>> checkListMap = allCheck.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            resp.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            resp.setWarnType("warn");
        } else {
            resp.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            resp.getDataSource().addAll(p.getDataSource());
        }
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)resp);
    }

    @ApiOperation(value="\u6df7\u6ce5\u571f\u5bfc\u51fa")
    @RequestMapping(value={"/excelConcreteExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelConcreteExport(@RequestBody QueryParam param, HttpServletResponse response) {
        this.service.excelConcreteExport(param, response);
    }

    @ApiOperation(value="pc\u53c2\u7167")
    @RequestMapping(value={"/refMonthPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<MonthPlanVO> refMonthPlanData(String condition, @RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            param.getParams().put("name", new Parameter("like", (Object)searchText));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isBlank((CharSequence)condition)) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("projectId")) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        if (null == conditionMap.get("planType")) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879planType\uff01");
        }
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("billState", new Parameter("in", billStates));
        param.getParams().put("projectId", new Parameter("eq", conditionMap.get("projectId")));
        param.getParams().put("planType", new Parameter("eq", conditionMap.get("planType")));
        List monthPlanEntities = this.service.queryList(param, false);
        List monthPlanVOS = BeanMapper.mapList((Iterable)monthPlanEntities, MonthPlanVO.class);
        return monthPlanVOS;
    }

    @ApiOperation(value="app\u53c2\u7167")
    @RequestMapping(value={"/refMonthPlanAppData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MonthPlanDetailVO>> refMonthPlanAppData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("material_category_name");
        param.getFuzzyFields().add("material_name");
        param.getFuzzyFields().add("spec");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("projectId")) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        if (null == conditionMap.get("planType")) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879planType\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("project_id", new Parameter("eq", conditionMap.get("projectId")));
        queryParam.getParams().put("plan_type", new Parameter("eq", conditionMap.get("planType")));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List list = this.service.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)new Page());
        }
        Map<Long, MonthPlanEntity> map = list.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        List ids = list.stream().map(x -> x.getId()).collect(Collectors.toList());
        param.getParams().put("materialMonthPlanId", new Parameter("in", ids));
        param.getParams().put("surplusNums", new Parameter("sql", (Object)"IFNULL(surplus_nums,0)>0"));
        IPage page = this.monthPlanDetailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), MonthPlanDetailVO.class);
        records.forEach(vo -> vo.setPlanCode(((MonthPlanEntity)((Object)((Object)map.get(vo.getMaterialMonthPlanId())))).getBillCode()));
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadMatch"})
    @ResponseBody
    public void downloadMatch(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"material-import.xlsx", (String)"\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportMatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportMatch(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        List<Object> successList = new ArrayList();
        ArrayList<MonthPlanDetailVO> errorList = new ArrayList<MonthPlanDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 10) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MonthPlanDetailVO vo = new MonthPlanDetailVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    vo.setErrorMessage("\u7269\u6599\u5206\u7c7b\u4e3a\u5fc5\u586b\u9879");
                } else {
                    vo.setMaterialCategoryName(((String)datas.get(0)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) && ((String)datas.get(1)).length() > 64) {
                    vo.setErrorMessage("\u7269\u8d44\u7f16\u7801\u586b\u5199\u957f\u5ea6\u4e3a0~64\u5b57");
                } else {
                    vo.setMaterialCode(((String)datas.get(1)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setErrorMessage("\u6750\u6599\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(2)).length() > 30) {
                    vo.setErrorMessage("\u6750\u6599\u540d\u79f0\u586b\u5199\u957f\u5ea6\u4e3a0~30\u5b57");
                } else {
                    vo.setMaterialName(((String)datas.get(2)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    vo.setSpec(((String)datas.get(3)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setUnit(((String)datas.get(4)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    try {
                        vo.setMonthPlanNum(new BigDecimal((String)datas.get(5)));
                        if (vo.getMonthPlanNum().longValue() < 0L) {
                            vo.setErrorMessage("\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        vo.setErrorMessage("\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    vo.setErrorMessage("\u6570\u91cf\u4e3a\u5fc5\u586b\u9879");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        String date = DateUtils.formatExcelDate((String)datas.get(6));
                        vo.setPlanDate(DateUtils.createDate(date));
                    }
                    catch (Exception e) {
                        vo.setErrorMessage("\u9700\u7528\u65e5\u671f\u975e\u65e5\u671f\u683c\u5f0f");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    vo.setConstruction(((String)datas.get(7)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    Integer firstState = "\u662f".equals(datas.get(8)) ? 1 : 0;
                    vo.setFirstState(firstState);
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) && ((String)datas.get(9)).length() > 50) {
                    vo.setErrorMessage("\u5907\u6ce8\u586b\u5199\u957f\u5ea6\u4e3a0~50\u5b57");
                } else {
                    vo.setRemark((String)datas.get(9));
                }
                vo.setSourceType(Integer.valueOf(2));
                if (StringUtils.isBlank((CharSequence)vo.getErrorMessage())) {
                    String onlykey = vo.getMaterialCategoryName() + vo.getMaterialName() + vo.getUnit() + vo.getSpec();
                    vo.setOnlyKey(onlykey);
                    successList.add(vo);
                    vo.setId(Long.valueOf(IdWorker.getId()));
                    continue;
                }
                errorList.add(vo);
            }
        }
        if (CollectionUtils.isNotEmpty(successList)) {
            JSONObject match = this.archivesUtil.findMatch(successList, "materialCategoryId", "materialId", "materialCategoryName", "materialName", "materialCode", "unitId", "unit", "spec", "errorMessage");
            successList = JSONUtils.json2List(match.getString("sourceList"), MonthPlanDetailVO.class);
            List<MonthPlanDetailVO> errorList1 = JSONUtils.json2List(match.getString("errorList"), MonthPlanDetailVO.class);
            errorList.addAll(errorList1);
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"month-plan-import.xlsx", (String)"\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<MonthPlanDetailVO> successList = new ArrayList<MonthPlanDetailVO>();
        ArrayList<MonthPlanDetailVO> errorList = new ArrayList<MonthPlanDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 10) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            ArrayList materialCodeList = new ArrayList();
            Map<Object, Object> map = new HashMap();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                materialCodeList.add(datas.get(1));
            }
            CommonResponse materialRes = this.materialApi.queryMaterialListByCodes(materialCodeList);
            if (!materialRes.isSuccess()) {
                return CommonResponse.error((String)"\u83b7\u53d6\u6863\u6848\u5f02\u5e38!");
            }
            map = ((List)materialRes.getData()).stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MonthPlanDetailVO vo = new MonthPlanDetailVO();
                vo.setId(Long.valueOf(IdWorker.getId()));
                vo.setMaterialCategoryName((String)datas.get(0));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setErrorMessage("\u7269\u6599\u7f16\u7801\u4e3a\u5fc5\u586b\u9879");
                } else {
                    vo.setMaterialCode(((String)datas.get(1)).trim());
                }
                vo.setMaterialName((String)datas.get(2));
                vo.setSpec((String)datas.get(3));
                vo.setUnit((String)datas.get(4));
                String materialCode = (String)datas.get(1);
                if (map.containsKey(materialCode)) {
                    MaterialVO material = (MaterialVO)map.get(materialCode);
                    vo.setMaterialCategoryId(material.getCategoryId());
                    vo.setMaterialCategoryName(material.getCategoryName());
                    vo.setMaterialId(material.getId());
                    vo.setMaterialCode(material.getCode());
                    vo.setMaterialName(material.getName());
                    vo.setSpec(material.getSpec());
                    vo.setUnitId(material.getUnitId());
                    vo.setUnit(material.getUnitName());
                    vo.setTexture(material.getDef1());
                    vo.setSourceId(material.getId());
                    vo.setSourceType(Integer.valueOf(2));
                } else {
                    vo.setErrorMessage("\u7269\u8d44\u7f16\u7801\u4e0d\u5339\u914d");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    try {
                        vo.setMonthPlanNum(new BigDecimal((String)datas.get(5)));
                        if (vo.getMonthPlanNum().longValue() < 0L) {
                            vo.setErrorMessage("\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        vo.setErrorMessage("\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    vo.setErrorMessage("\u6570\u91cf\u4e3a\u5fc5\u586b\u9879");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        String date = DateUtils.formatExcelDate((String)datas.get(6));
                        vo.setPlanDate(DateUtils.createDate(date));
                    }
                    catch (Exception e) {
                        vo.setErrorMessage("\u9700\u7528\u65e5\u671f\u975e\u65e5\u671f\u683c\u5f0f");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    vo.setConstruction(((String)datas.get(7)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    Integer firstState = "\u662f".equals(datas.get(8)) ? 1 : 0;
                    vo.setFirstState(firstState);
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) && ((String)datas.get(9)).length() > 50) {
                    vo.setErrorMessage("\u5907\u6ce8\u586b\u5199\u957f\u5ea6\u4e3a0~50\u5b57");
                } else {
                    vo.setRemark((String)datas.get(9));
                }
                vo.setSourceType(Integer.valueOf(2));
                if (StringUtils.isBlank((CharSequence)vo.getErrorMessage())) {
                    successList.add(vo);
                    continue;
                }
                errorList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

