/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.settlement.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckService;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceApiVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceCheckTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceCheckTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationDetailService;
import com.ejianc.business.promaterial.settlement.bean.SettlementCollectEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementFeeEntity;
import com.ejianc.business.promaterial.settlement.mapper.SettlementMapper;
import com.ejianc.business.promaterial.settlement.service.ISettlementCollectService;
import com.ejianc.business.promaterial.settlement.service.ISettlementDetailService;
import com.ejianc.business.promaterial.settlement.service.ISettlementFeeService;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.settlement.vo.ContractFlagEnum;
import com.ejianc.business.promaterial.settlement.vo.ContractSettlementRecordVO;
import com.ejianc.business.promaterial.settlement.vo.PrintSettlementDetailVO;
import com.ejianc.business.promaterial.settlement.vo.PrintSettlementFeeVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementDetailVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementFeeVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementRecordVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.business.store.api.IAccountSettleApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.temporary.settlement.api.ITemporarySettlementApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;

@Service(value="settlementService")
public class SettlementServiceImpl
extends BaseServiceImpl<SettlementMapper, SettlementEntity>
implements ISettlementService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String JS_BILL_CODE = "JS_CODE";
    private static final String HNT_BILL_CODE = "HNT_JS_CODE";
    private static final String GC_BILL_CODE = "GC_JS_CODE";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettlementCollectService settlementCollectService;
    @Autowired
    private IAccountSettleApi accountSettleApi;
    @Autowired
    private IReconciliationDetailService reconciliationDetailService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private ISettlementDetailService settlementDetailService;
    @Autowired
    private ISettlementFeeService settlementFeeService;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private final String OPERATE = "SETTLMENT_JS";
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    private IProincomeContractApi proincomeContrantApi;
    @Autowired
    private ITemporarySettlementApi temporarySettlementApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IConcreteCheckService concreteCheckService;
    private static final String MBILL_TYPE = "BT220309000000003";
    private static final String CBILL_TYPE = "BT220316000000005";

    @Override
    public SettlementRecordVO querySettleRecord(Long contractId) {
        SettlementRecordVO vo = new SettlementRecordVO();
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        vo.setContractId(contractId);
        vo.setContractTaxMny(contractEntity.getContractTaxMny());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettlementEntity::getContractId, (Object)contractId);
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.in(SettlementEntity::getBillState, new Object[]{1, 3});
        wrapper.orderByAsc(BaseEntity::getCreateTime);
        List list = super.list((Wrapper)wrapper);
        List vos = BeanMapper.mapList((Iterable)list, SettlementVO.class);
        if (CollectionUtils.isNotEmpty((Collection)vos)) {
            BigDecimal totalSettlementTaxMny = vos.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementVO::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setTotalSettlementTaxMny(totalSettlementTaxMny);
        } else {
            vo.setTotalSettlementTaxMny(BigDecimal.ZERO);
        }
        if (vo.getContractTaxMny() == null || BigDecimal.ZERO.compareTo(vo.getContractTaxMny()) == 0) {
            vo.setSettleRatio(BigDecimal.ZERO);
        } else {
            vo.setSettleRatio(vo.getTotalSettlementTaxMny().divide(vo.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        vo.setSettlementList(vos);
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(SettlementEntity::getContractId, (Object)contractId);
        wrapper2.eq(BaseEntity::getDr, (Object)0);
        wrapper2.eq(SettlementEntity::getSignatureType, (Object)1);
        List list2 = super.list((Wrapper)wrapper2);
        vo.setFlag(Boolean.valueOf(!CollectionUtils.isNotEmpty((Collection)list2)));
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(SettlementEntity::getContractId, (Object)contractId);
        wrapper3.eq(BaseEntity::getDr, (Object)0);
        wrapper3.notIn(SettlementEntity::getBillState, new Object[]{1, 3});
        wrapper3.eq(SettlementEntity::getSignatureType, (Object)0);
        List list3 = super.list((Wrapper)wrapper3);
        vo.setFlagTwo(Boolean.valueOf(!CollectionUtils.isNotEmpty((Collection)list3)));
        return vo;
    }

    @Override
    public CommonResponse<SettlementVO> saveOrUpdate(SettlementVO saveOrUpdateVO) {
        if (CollectionUtils.isEmpty((Collection)saveOrUpdateVO.getSettlementDetailList())) {
            throw new BusinessException("\u68c0\u6d4b\u5230\u5f53\u524d\u7ed3\u7b97\u5355\u7684\u6750\u6599\u660e\u7ec6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01");
        }
        SettlementEntity entity = (SettlementEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettlementEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String BILL_CODE = "";
            switch (entity.getSettlementType()) {
                case 0: {
                    BILL_CODE = JS_BILL_CODE;
                    break;
                }
                case 1: {
                    BILL_CODE = HNT_BILL_CODE;
                    break;
                }
                case 2: {
                    BILL_CODE = GC_BILL_CODE;
                }
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (null != entity.getContractId() && this.queryExist(entity.getContractId(), entity.getSettlementType())) {
                throw new BusinessException("\u8be5\u5408\u540c\u4e0b\u6709\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355\uff01");
            }
        } else {
            ArrayList<SettlementDetailEntity> detailDel = new ArrayList<SettlementDetailEntity>();
            if (CollectionUtils.isNotEmpty(entity.getSettlementDetailList())) {
                for (SettlementDetailEntity detail : entity.getSettlementDetailList()) {
                    if (!"del".equals(detail.getRowState())) continue;
                    detailDel.add(detail);
                }
            }
            this.deleteAccount(entity, detailDel, entity.getContractId());
        }
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        super.saveOrUpdate((Object)entity, false);
        this.updateAccount(entity);
        SettlementVO vo = (SettlementVO)BeanMapper.map((Object)((Object)entity), SettlementVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    public boolean queryExist(Long contractId, Integer settlementType) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettlementEntity::getContractId, (Object)contractId);
        wrapper.eq(SettlementEntity::getSettlementType, (Object)settlementType);
        wrapper.notIn(SettlementEntity::getBillState, new Object[]{1, 3});
        List list = super.list((Wrapper)wrapper);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    public void delCollect(Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettlementCollectEntity::getSettlementId, (Object)id);
        List list = this.settlementCollectService.list((Wrapper)wrapper);
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            this.settlementCollectService.removeByIds(ids);
        }
    }

    private void uapdeRD(List ids, Integer flag) {
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            this.logger.info("\u5b50\u8868\u952e\u503c:" + JSONObject.toJSONString((Object)ids));
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(BaseEntity::getId, (Collection)ids);
            List list = this.reconciliationDetailService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.logger.info("\u5bf9\u8d26\u5b50\u8868\u6570\u636e:" + JSONObject.toJSONString((Object)list));
                list.forEach(item -> item.setReconciliationState(flag));
                this.reconciliationDetailService.saveOrUpdateBatch(list, list.size(), false);
                this.logger.info("\u4fee\u6539\u72b6\u6001\u6210\u529f--" + JSONObject.toJSONString((Object)list));
            }
        }
    }

    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal currentTaxMny = BigDecimal.ZERO;
        BigDecimal currentMny = BigDecimal.ZERO;
        BigDecimal lastNum = BigDecimal.ZERO;
        String sTDate = null;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        wrapper.in(SettlementEntity::getBillState, new Object[]{1, 3});
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(SettlementEntity::getContractId, (Object)contractId);
        List list = super.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            SettlementEntity settlementEntity = (SettlementEntity)((Object)list.get(0));
            currentTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny = list.stream().filter(e -> e.getSettlementMny() != null).map(SettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            lastNum = list.stream().filter(e -> e.getNum() != null).map(SettlementEntity::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            sTDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settlementEntity.getSettlementDate());
        }
        map.put("currentTaxMny", currentTaxMny);
        map.put("currentMny", currentMny);
        map.put("lastNum", lastNum);
        map.put("sTDate", sTDate);
        map.put("settlementNum", list.size());
        return CommonResponse.success((String)"\u83b7\u53d6\u91d1\u989d\u548c\u65f6\u95f4\u3001\u7ed3\u7b97\u6b21\u6570\u6210\u529f,\uff01", map);
    }

    public void updateAccount(SettlementEntity entity) {
        boolean flag = true;
        StoreApiVO storeApiVO = new StoreApiVO();
        ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
        HashSet<Long> checkId = new HashSet<Long>();
        storeApiVO.setSettleFlag(Integer.valueOf(1));
        storeApiVO.setSettleId(entity.getId());
        storeApiVO.setSettleDate(entity.getSettlementDate());
        storeApiVO.setSettleCode(entity.getBillCode());
        storeApiVO.setPurchaseContractId(entity.getContractId());
        storeApiVO.setPurchaseContractName(entity.getContractName());
        ArrayList<Long> idsAdd = new ArrayList<Long>();
        for (SettlementDetailEntity detailEntity : entity.getSettlementDetailList()) {
            if ("del".equals(detailEntity.getRowState())) continue;
            if (entity.getSettlementType() != 1 || detailEntity.getSourceType() != 3) {
                FlowVO flowVO = new FlowVO();
                if (null != entity.getContractId() && ContractFlagEnum.\u65e0\u5408\u540c.getCode().equals(detailEntity.getContractFlag())) {
                    checkId.add(detailEntity.getSourceId());
                    flowVO.setCusDef1("NoContract");
                }
                flowVO.setSettleDetailId(detailEntity.getId());
                flowVO.setSourceId(detailEntity.getSourceId());
                flowVO.setSourceDetailId(detailEntity.getSourceDetailId());
                flowVOS.add(flowVO);
            }
            if (detailEntity.getReconciliationDetailId() == null) continue;
            idsAdd.add(detailEntity.getReconciliationDetailId());
        }
        if (CollectionUtils.isNotEmpty(flowVOS)) {
            storeApiVO.setDetail(flowVOS);
            this.logger.info("\u4fdd\u5b58\u7ed3\u7b97\u66f4\u65b0\u4fe1\u606f--" + JSONObject.toJSONString((Object)storeApiVO));
            CommonResponse response2 = this.accountSettleApi.changeAccountSettleByType(storeApiVO);
            if (!response2.isSuccess()) {
                this.logger.info("\u5e93\u5b58\u8fd4\u56de\u4fe1\u606f--" + JSONObject.toJSONString((Object)response2));
                throw new BusinessException("\u4fdd\u5b58\u7ed3\u7b97\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
            this.logger.info("\u4fdd\u5b58\u7ed3\u7b97\u66f4\u65b0\u4fe1\u606f\u5b8c\u6210--" + JSONObject.toJSONString((Object)response2));
        } else {
            this.logger.info("flowVOS \u4e3a\u7a7a\u3002\u3002\u3002\u3002");
        }
        this.uapdeRD(idsAdd, 1);
        this.updateContractId(new ArrayList<Long>(checkId), entity.getContractId(), entity.getContractName());
    }

    public void updateContractId(List<Long> ids, Long contractId, String contractName) {
        List concreteCheckEntities;
        this.logger.info("\u5408\u540cid\u66f4\u65b0\u4fe1\u606f\uff0c\u66f4\u65b0ids:{}--\u5408\u540cid:{}", (Object)JSONObject.toJSONString(ids), (Object)contractId);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List checkEntities = this.checkService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)checkEntities)) {
            List collect = checkEntities.stream().map(item -> {
                item.setContractId(contractId);
                item.setCheckerName(contractName);
                return item;
            }).collect(Collectors.toList());
            this.checkService.updateBatchById(collect);
            this.logger.info("\u5408\u540cid\u66f4\u65b0\u4fe1\u606f\uff0c\u6750\u6599\u66f4\u65b0\u4fe1\u606f:{}", (Object)JSONObject.toJSONString(collect));
        }
        if (CollectionUtils.isNotEmpty((Collection)(concreteCheckEntities = this.concreteCheckService.queryList(queryParam)))) {
            List collect2 = concreteCheckEntities.stream().map(item -> {
                item.setContractId(contractId);
                item.setCheckerName(contractName);
                return item;
            }).collect(Collectors.toList());
            this.concreteCheckService.updateBatchById(collect2);
            this.logger.info("\u5408\u540cid\u66f4\u65b0\u4fe1\u606f\uff0c\u6df7\u51dd\u571f\u66f4\u65b0\u4fe1\u606f:{}", (Object)JSONObject.toJSONString(collect2));
        }
    }

    @Override
    public CommonResponse<String> delete(List<SettlementVO> vos) {
        for (SettlementVO vo : vos) {
            SettlementEntity settlementEntity = (SettlementEntity)((Object)super.selectById((Serializable)vo.getId()));
            this.deleteAccount(settlementEntity, settlementEntity.getSettlementDetailList(), settlementEntity.getContractId());
            CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(vo.getId());
            this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (stringCommonResponse.isSuccess()) continue;
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public void deleteAccount(SettlementEntity entity, List<SettlementDetailEntity> detailList, Long contractId) {
        StoreApiVO storeApiVO = new StoreApiVO();
        ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
        storeApiVO.setSettleFlag(Integer.valueOf(0));
        HashSet<Long> checkId = new HashSet<Long>();
        ArrayList<Long> idsDel = new ArrayList<Long>();
        for (SettlementDetailEntity detailEntity : detailList) {
            if (entity.getSettlementType() != 1 || detailEntity.getSourceType() != 3) {
                FlowVO flowVO = new FlowVO();
                if (null != contractId && ContractFlagEnum.\u65e0\u5408\u540c.getCode().equals(detailEntity.getContractFlag())) {
                    checkId.add(detailEntity.getSourceId());
                    flowVO.setCusDef1("NoContract");
                }
                flowVO.setSourceId(detailEntity.getSourceId());
                flowVO.setSourceDetailId(detailEntity.getSourceDetailId());
                flowVOS.add(flowVO);
            }
            if (detailEntity.getReconciliationDetailId() == null) continue;
            idsDel.add(detailEntity.getReconciliationDetailId());
        }
        if (CollectionUtils.isNotEmpty(flowVOS)) {
            storeApiVO.setDetail(flowVOS);
            this.logger.info("\u5220\u9664\u7ed3\u7b97\u66f4\u65b0\u4fe1\u606f--" + JSONObject.toJSONString((Object)storeApiVO));
            CommonResponse response = this.accountSettleApi.changeAccountSettleByType(storeApiVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u5220\u9664\u7ed3\u7b97\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
        } else {
            this.logger.info("\u7ed3\u7b97\u5355\u5220\u9664\uff1aflowVOS  \u4e3a\u7a7a\u3002\u3002\u3002\u3002");
        }
        this.uapdeRD(idsDel, 0);
        this.updateContractId(new ArrayList<Long>(checkId), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public boolean pushSettleToPool(SettlementVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb-----" + JSONObject.toJSONString((Object)vo));
            BeanConvertorUtil.convert((Object)vo, (Object)spv);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(vo, spv);
            if (vo.getContractId() == null) {
                if (vo.getSettlementType() == 1) {
                    spv.setBillCodeUrl("/ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + vo.getId());
                } else {
                    spv.setBillCodeUrl("/ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + vo.getId());
                }
            } else if (vo.getSettlementType() == 1) {
                spv.setBillCodeUrl("/ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + vo.getId());
            } else {
                spv.setBillCodeUrl("/ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + vo.getId());
            }
            this.logger.info("\u63a8\u9001\u53c2\u6570----" + JSONObject.toJSONString((Object)spv));
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f00\u59cb,\u7ed3\u7b97\u5355id-{}", (Object)id);
            CommonResponse res = this.settlePoolApi.deleteSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)id, (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    private void convertSettleVOToSettlePoolVO(SettlementVO vo, SettlePoolVO spv) {
        if (null == vo || null == spv) {
            this.logger.error("\u5c06\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u539f\u56e0\uff1a\u7ed3\u7b97\u5355\u5bf9\u8c61\u4e3a\u7a7a\u6216\u7ed3\u7b97\u6c60\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u65e0\u6cd5\u8f6c\u6362\uff01");
            return;
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5f00\u59cb");
        switch (vo.getSettlementType()) {
            case 0: {
                if (vo.getContractId() != null) {
                    spv.setSourceType(SettleSourceTypeEnum.\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97.getCode());
                    break;
                }
                spv.setSourceType(SettleSourceTypeEnum.\u96f6\u661f\u6750\u6599\u7ed3\u7b97.getCode());
                break;
            }
            case 1: {
                spv.setSourceType(SettleSourceTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u7ed3\u7b97.getCode());
            }
        }
        spv.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        spv.setId(vo.getId());
        spv.setSettlePropertyName("\u652f\u51fa");
        spv.setSettleProperty(Integer.valueOf(0));
        spv.setSourceId(vo.getId());
        spv.setCreateUserCode(vo.getCreateUserCode());
        spv.setCreateTime(vo.getCreateTime());
        spv.setUpdateUserCode(vo.getUpdateUserCode());
        spv.setUpdateTime(vo.getUpdateTime());
        spv.setContractFlag(Integer.valueOf(0));
        spv.setHandleType(Integer.valueOf(0));
        if (vo.getContractId() != null) {
            spv.setContractFlag(Integer.valueOf(1));
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
            switch (contractEntity.getContractType()) {
                case 0: {
                    spv.setContractType(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
                    break;
                }
                case 1: {
                    spv.setContractType(ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
                }
            }
            spv.setSupplementFlag(contractEntity.getSupplementFlag());
            spv.setMaiContractId(contractEntity.getMainContractId());
            spv.setMaiContractName(contractEntity.getMainContractName());
            spv.setMaiContractCode(contractEntity.getMainContractCode());
            spv.setContractCode(contractEntity.getBillCode());
            spv.setPartyaId(contractEntity.getCustomerId());
            spv.setPartyaName(contractEntity.getCustomerName());
            spv.setSignDate(contractEntity.getSignDate());
            spv.setLastTaxMny(ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementTaxMny(), (BigDecimal)vo.getSettlementTaxMny()));
            spv.setLastMny(ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementMny(), (BigDecimal)vo.getSettlementMny()));
            spv.setLastTax(ComputeUtil.safeSub((BigDecimal)spv.getLastTaxMny(), (BigDecimal)spv.getLastMny()));
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60");
    }

    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ExecutionVO targetCost(SettlementVO settlementVO, String linkUrl, Integer settlementType) {
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettlementEntity::getContractId, (Object)settlementVO.getContractId());
        wrapper.in(SettlementEntity::getBillState, Arrays.asList(1, 3));
        wrapper.eq(BaseEntity::getDr, (Object)0);
        List list = this.settlementService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u7ed3\u7b97\u6570\u636e\u4e0d\u5b58\u5728");
        }
        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(SettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        ContractVO contractVO = this.contractService.queryDetail(settlementVO.getContractId());
        List contractDetailList = contractVO.getContractDetailList();
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(settlementVO.getId());
        totalVO.setTenantId(settlementVO.getTenantId());
        totalVO.setBillCode(settlementVO.getBillCode());
        totalVO.setBillDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settlementVO.getSettlementDate()));
        if (settlementType == 0) {
            totalVO.setBillType(MBILL_TYPE);
        } else {
            totalVO.setBillType(CBILL_TYPE);
        }
        switch (contractVO.getContractPropertyCode()) {
            case "proMaterial-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5927\u5b97\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-2": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-3": {
                totalVO.setBussinessType(BussinessTypeEnum.\u96f6\u661f\u6750\u6599\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "contractConcrete-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c.getCode());
            }
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(settlementVO.getProjectId());
        totalVO.setOrgId(settlementVO.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalSettleMny, (BigDecimal)contractVO.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)contractVO.getContractTaxMny()));
        totalVO.setLinkUrl(linkUrl);
        List settleIdList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.in(SettlementDetailEntity::getSettlementId, settleIdList);
        List settleDetailList = this.settlementDetailService.list((Wrapper)detailWrapper);
        if (CollectionUtils.isNotEmpty((Collection)settleDetailList)) {
            Map<Long, List<SettlementDetailEntity>> detailMaterialMap = settleDetailList.stream().collect(Collectors.groupingBy(SettlementDetailEntity::getMaterialId));
            Map<Long, List<ContractDetailVO>> contractDetailMap = contractDetailList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.groupingBy(ContractDetailVO::getMaterialId));
            if (!contractDetailMap.isEmpty()) {
                for (Long materialId : detailMaterialMap.keySet()) {
                    List<SettlementDetailEntity> detailMaterialList = detailMaterialMap.get(materialId);
                    List<ContractDetailVO> contractDetailList1 = contractDetailMap.get(materialId);
                    BigDecimal contractSumNum = contractDetailList1.stream().filter(e -> e.getNum() != null).map(ContractDetailVO::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumMny = contractDetailList1.stream().filter(e -> e.getMoney() != null).map(ContractDetailVO::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumTaxMny = contractDetailList1.stream().filter(e -> e.getDetailTaxMny() != null).map(ContractDetailVO::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sumNum = detailMaterialList.stream().filter(e -> e.getNum() != null).map(SettlementDetailEntity::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sumMny = detailMaterialList.stream().filter(e -> e.getMny() != null).map(SettlementDetailEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sumTaxMny = detailMaterialList.stream().filter(e -> e.getTaxMny() != null).map(SettlementDetailEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    SettlementDetailEntity planDetailVO = detailMaterialList.get(0);
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(Long.valueOf(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId()));
                    detailExecutionVO.setSourceBillId(planDetailVO.getSettlementId());
                    detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                    detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                    if (planDetailVO.getMaterialId() == null) {
                        detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                        detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
                    } else {
                        detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                        detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                    }
                    detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                    detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                    MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCode());
                    }
                    detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                    detailExecutionVO.setName(planDetailVO.getMaterialName());
                    detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                    detailExecutionVO.setUnitName(planDetailVO.getUnit());
                    detailExecutionVO.setPrice(planDetailVO.getPrice());
                    detailExecutionVO.setTaxPrice(planDetailVO.getTaxPrice());
                    detailExecutionVO.setNum(ComputeUtil.safeSub((BigDecimal)sumNum, (BigDecimal)contractSumNum));
                    detailExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)sumMny, (BigDecimal)contractSumMny));
                    detailExecutionVO.setSpec(planDetailVO.getSpec());
                    detailExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)sumTaxMny, (BigDecimal)contractSumTaxMny));
                    detailList.add(detailExecutionVO);
                }
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public ExecutionVO targetCost2(SettlementVO settlementVO, String linkUrl, Integer settlementType) {
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        BigDecimal totalSettleTaxMny = settlementVO.getSettlementTaxMny();
        BigDecimal totalSettleMny = settlementVO.getSettlementMny();
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setContractId(settlementVO.getContractId());
        totalVO.setSourceId(settlementVO.getId());
        totalVO.setTenantId(settlementVO.getTenantId());
        totalVO.setBillDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settlementVO.getSettlementDate()));
        totalVO.setBillCode(settlementVO.getBillCode());
        if (settlementType == 0) {
            totalVO.setBillType(MBILL_TYPE);
        } else {
            totalVO.setBillType(CBILL_TYPE);
        }
        switch (settlementVO.getContractPropertyCode()) {
            case "proMaterial-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5927\u5b97\u6750\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355.getCode());
                break;
            }
            case "proMaterial-2": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355.getCode());
                break;
            }
            case "proMaterial-3": {
                totalVO.setBussinessType(BussinessTypeEnum.\u96f6\u661f\u6750\u6599\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355.getCode());
                break;
            }
            case "contractConcrete-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u6df7\u51dd\u571f\u7ed3\u7b97\u5355.getCode());
            }
        }
        totalVO.setBillCategory(BillCategoryEnum.\u7ed3\u7b97.getCode());
        totalVO.setProjectId(settlementVO.getProjectId());
        totalVO.setOrgId(settlementVO.getOrgId());
        totalVO.setMoney(totalSettleMny);
        totalVO.setTaxMoney(totalSettleTaxMny);
        totalVO.setLinkUrl(linkUrl);
        List settleDetailList = settlementVO.getSettlementDetailList();
        if (CollectionUtils.isNotEmpty((Collection)settleDetailList)) {
            for (SettlementDetailVO planDetailVO : settleDetailList) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId()));
                detailExecutionVO.setSourceBillId(settlementVO.getId());
                detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                detailExecutionVO.setName(planDetailVO.getMaterialName());
                detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setUnitName(planDetailVO.getUnit());
                detailExecutionVO.setPrice(planDetailVO.getPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getTaxPrice());
                detailExecutionVO.setNum(planDetailVO.getNum());
                detailExecutionVO.setMoney(planDetailVO.getMny());
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(planDetailVO.getTaxMny());
                detailExecutionVO.setContractId(settlementVO.getContractId());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    public CostCtrlVO sjCost(SettlementVO vo) {
        List feeList = vo.getSettlementFeeList();
        if (CollectionUtils.isNotEmpty((Collection)feeList)) {
            HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
            for (SettlementFeeVO settlementFeeVO : feeList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal feeTaxMny;
                if (null == settlementFeeVO.getSubjectIdFee() || "del".equals(settlementFeeVO.getRowState())) continue;
                BigDecimal feeMny = settlementFeeVO.getFeeMny() == null ? BigDecimal.ZERO : settlementFeeVO.getFeeMny();
                BigDecimal bigDecimal = feeTaxMny = settlementFeeVO.getFeeTaxMny() == null ? BigDecimal.ZERO : settlementFeeVO.getFeeTaxMny();
                if (map.containsKey(settlementFeeVO.getSubjectIdFee())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(settlementFeeVO.getSubjectIdFee());
                    BigDecimal mny = costCtrlDetailVO.getMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getMny();
                    BigDecimal taxMny = costCtrlDetailVO.getTaxMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getTaxMny();
                    costCtrlDetailVO.setMny(mny.add(feeMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(feeTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectIdFee());
                costCtrlDetailVO.setMny(feeMny);
                costCtrlDetailVO.setTaxMny(feeTaxMny);
                map.put(settlementFeeVO.getSubjectIdFee(), costCtrlDetailVO);
            }
            if (null != map && map.size() > 0) {
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if (null != vo.getId()) {
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList(map.values()));
                return ctrlVO;
            }
            return null;
        }
        return null;
    }

    @Override
    public ParamsCheckVO checkParams(SettlementVO vo) {
        ArrayList paramsCheckVOS = new ArrayList();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public List<ParamsCheckVO> costProjectCheckParams(SettlementVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse booleanCommonResponse = this.dutyApi.queryDutyByProjectId(vo.getProjectId());
        if (!booleanCommonResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (!((Boolean)booleanCommonResponse.getData()).booleanValue()) {
            CommonResponse billParamByCodeAndOrgId = this.paramConfigApi.getBillParamByCodeAndOrgId("P-ilUA850193", vo.getOrgId());
            if (billParamByCodeAndOrgId.isSuccess() && null != billParamByCodeAndOrgId.getData()) {
                List data = (List)billParamByCodeAndOrgId.getData();
                if (CollectionUtils.isNotEmpty((Collection)data)) {
                    for (BillParamVO billParamByCode : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        String orgName = billParamByCode.getOrgName();
                        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                        paramsCheckVO.setWarnType(paramsArray[billParamByCode.getControlType()]);
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("\u65e0\u76ee\u6807\u6210\u672c\u63a7\u7ed3\u7b97");
                        paramsCheckDsVO.setOrgName(orgName);
                        paramsCheckDsVO.setWarnName("\u8be5\u9879\u76ee\u6ca1\u6709\u7f16\u5236\u76ee\u6807\u8d23\u4efb\u6210\u672c");
                        paramsCheckDsVO.setContent("\u8be5\u9879\u76ee\u6ca1\u6709\u7f16\u5236\u76ee\u6807\u8d23\u4efb\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u7ed3\u7b97\u5355");
                        checkDsVOS.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            } else {
                this.logger.info(billParamByCodeAndOrgId.getMsg());
                throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
            }
        }
        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO priceCheckParams(SettlementVO vo) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        switch (vo.getSettlementType()) {
            case 0: {
                materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.\u6d88\u8017\u6750\u7ed3\u7b97.getCode());
                break;
            }
            case 1: {
                materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.\u6df7\u51dd\u571f\u7ed3\u7b97.getCode());
            }
        }
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialPriceHistoryApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)vo.getSettlementDetailList())) {
            for (SettlementDetailVO detailVO : vo.getSettlementDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getTaxPrice());
                priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        ParamsCheckVO paramsCheckVO = this.priceHistoryService.priceCheckParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    public ParamsCheckVO costPriceCheckParams(SettlementVO vo) {
        MaterialCostPriceApiVO materialPriceHistoryApiVO = new MaterialCostPriceApiVO();
        if (vo.getSettlementType() == 0) {
            materialPriceHistoryApiVO.setPriceCheckType(MaterialCostPriceCheckTypeEnum.\u6d88\u8017\u6750\u7ed3\u7b97.getCode());
        } else {
            materialPriceHistoryApiVO.setPriceCheckType(MaterialCostPriceCheckTypeEnum.\u6df7\u51dd\u571f\u7ed3\u7b97.getCode());
        }
        ArrayList<MaterialCostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialCostPriceApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)vo.getSettlementDetailList())) {
            for (SettlementDetailVO detailVO : vo.getSettlementDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getTaxPrice());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setMaterialCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = this.contractService.costPriceParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyList(ContractEntity contractEntity, SettlementVO vo) {
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        String purchaseType = contractEntity.getPurchaseType();
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsNum(ContractEntity contractEntity, SettlementVO vo) {
        String purchaseType = contractEntity.getPurchaseType();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        return paramsCheckVOS;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(SettlementVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        return paramsCheckVOList;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        SettlementEntity entity = (SettlementEntity)((Object)super.selectById((Serializable)id));
        if (entity.getSignatureType() != null && entity.getSignatureType() == 1) {
            String linkUrl = entity.getSettlementType() == 0 ? (null == entity.getContractId() || 0L == entity.getContractId() ? this.BaseHost + "ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + entity.getId() : this.BaseHost + "ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + entity.getId()) : (null == entity.getContractId() || 0L == entity.getContractId() ? this.BaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + entity.getId() : this.BaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + entity.getId());
            ExecutionVO executionVO = this.targetCost((SettlementVO)BeanMapper.map((Object)((Object)entity), SettlementVO.class), linkUrl, entity.getSettlementType());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public CommonResponse<String> pushTargetCost2(Long id) {
        SettlementEntity entity = (SettlementEntity)((Object)super.selectById((Serializable)id));
        String linkUrl = entity.getSettlementType() == 0 ? (null == entity.getContractId() || 0L == entity.getContractId() ? this.BaseHost + "ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + entity.getId() : this.BaseHost + "ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + entity.getId()) : (null == entity.getContractId() || 0L == entity.getContractId() ? this.BaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + entity.getId() : this.BaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + entity.getId());
        ExecutionVO executionVO = this.targetCost2((SettlementVO)BeanMapper.map((Object)((Object)entity), SettlementVO.class), linkUrl, entity.getSettlementType());
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public ContractSettlementRecordVO queryDetailRecord(Long contractId) {
        ContractSettlementRecordVO settleRecordVO = new ContractSettlementRecordVO();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(contractId));
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQuery.orderByDesc((Object)"settlement_date");
        List list = super.list((Wrapper)listQuery);
        List rentSettlementVOS = BeanMapper.mapList((Iterable)list, SettlementVO.class);
        settleRecordVO.setSettleList(rentSettlementVOS);
        BigDecimal contractSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            contractSettleMny = list.stream().map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        settleRecordVO.setContractSettleMny(contractSettleMny);
        if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
            settleRecordVO.setSettleRate(BigDecimal.ZERO);
        } else {
            settleRecordVO.setSettleRate(settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100L)).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        return settleRecordVO;
    }

    @Override
    public void updateContractPoolSettle(SettlementVO vo, Boolean type) {
        if (null != vo.getContractId()) {
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + (type != false ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0csettleEntity={}, \u8fc7\u7a0b\uff080\uff09/\u6700\u7ec8\uff081\uff09={}, type={}", new Object[]{vo, vo.getSignatureType(), type});
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;
            BigDecimal totalSettleMny = BigDecimal.ZERO;
            BigDecimal totalSettleTax = BigDecimal.ZERO;
            if (type.booleanValue()) {
                totalSettleTaxMny = vo.getCurrentSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementTaxMny();
                totalSettleMny = vo.getCurrentSettlementMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementMny();
                totalSettleTax = ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)totalSettleMny);
            } else {
                totalSettleTaxMny = ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementTaxMny(), (BigDecimal)vo.getSettlementTaxMny());
                totalSettleMny = ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementMny(), (BigDecimal)vo.getSettlementMny());
                totalSettleTax = ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)totalSettleMny);
            }
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(vo.getContractId());
            contractPoolVO.setTotalSettleTaxMny(totalSettleTaxMny);
            contractPoolVO.setTotalSettleMny(totalSettleMny);
            contractPoolVO.setTotalSettleTax(totalSettleTax);
            if (1 == vo.getSignatureType()) {
                if (type.booleanValue()) {
                    contractPoolVO.setFinishSettleDate(new Date());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u5c01\u8d26.getCode());
                } else {
                    contractPoolVO.setFinishSettleDate(null);
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                }
            }
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractPoolVO));
            CommonResponse updateConPoolRes = this.contractPoolApi.saveOrUpdateContract(contractPoolVO);
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)updateConPoolRes));
        }
    }

    @Override
    public CommonResponse<SettlementVO> pushCost(SettlementVO vo) {
        SettlementEntity entity = (SettlementEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (CollectionUtils.isNotEmpty(entity.getSettlementDetailList())) {
            List detailEntityList = BeanMapper.mapList((Iterable)vo.getSettlementDetailList(), SettlementDetailEntity.class);
            entity.setSettlementDetailList(detailEntityList);
        }
        if (CollectionUtils.isNotEmpty(entity.getSettlementFeeList())) {
            List feeEntityList = BeanMapper.mapList((Iterable)vo.getSettlementFeeList(), SettlementFeeEntity.class);
            entity.setSettlementFeeList(feeEntityList);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), SettlementVO.class));
    }

    @Override
    public void costPush(SettlementEntity entity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<SettlementDetailEntity> detailList = entity.getSettlementDetailList();
        String newRelationFlag = "1";
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (SettlementDetailEntity detailEntity : detailList) {
                if (null != detailEntity.getSubjectId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(detailList)) {
            newRelationFlag = "0";
        }
        if ("1".equals(newRelationFlag)) {
            this.saveCost(entity, 1);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(SettlementEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        entity.setRelationFlag(newRelationFlag);
    }

    private void saveCost(SettlementEntity entity, Integer effectiveStatus) {
        CostDetailVO costDetailVO;
        String linkUrl = "";
        String billName = "";
        String sourceType = "";
        if (entity.getSettlementType() == 0) {
            linkUrl = null == entity.getContractId() ? "/ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + entity.getId() : "/ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + entity.getId();
            billName = SourceTypeEnum.\u6750\u6599\u91c7\u8d2d\u7ed3\u7b97.getTypeName();
            sourceType = "MATERIAL";
        } else {
            linkUrl = null == entity.getContractId() ? "/ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + entity.getId() : "/ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + entity.getId();
            billName = SourceTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u7ed3\u7b97.getTypeName();
            sourceType = "CONCRETE";
        }
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<SettlementDetailEntity> detailList = entity.getSettlementDetailList();
        List<SettlementFeeEntity> feeList = entity.getSettlementFeeList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (SettlementDetailEntity detailEntity : detailList) {
                if (entity.getSettlementType() == 1 && detailEntity.getSourceType() == 3) {
                    this.logger.info("\u6df7\u51dd\u571f\u7ed3\u7b97\u5355\u63a8\u9001\u5b9e\u9645\u6210\u672c---" + detailEntity.getId());
                    costDetailVO = new CostDetailVO();
                    costDetailVO.setSourceBillCode(entity.getBillCode());
                    costDetailVO.setSourceBillName(billName);
                    costDetailVO.setSourceBillUrl(linkUrl);
                    costDetailVO.setSubjectId(detailEntity.getSubjectId());
                    costDetailVO.setSubjectId(detailEntity.getSubjectId());
                    costDetailVO.setSubjectCode(detailEntity.getSubjectCode());
                    costDetailVO.setSubjectName(detailEntity.getSubjectName());
                    costDetailVO.setNum(detailEntity.getNum());
                    costDetailVO.setWbsId(detailEntity.getWbsId());
                    costDetailVO.setWbsCode(detailEntity.getWbsCode());
                    costDetailVO.setWbsName(detailEntity.getWbsName());
                    costDetailVO.setSourceId(entity.getId());
                    costDetailVO.setSourceDetailId(detailEntity.getId());
                    costDetailVO.setHappenTaxMny(detailEntity.getTaxMny());
                    costDetailVO.setHappenMny(detailEntity.getMny());
                    costDetailVO.setHappenDate(entity.getSettlementDate());
                    costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                    costDetailVO.setSourceType(sourceType + "_SETTLE");
                    costDetailVO.setSourceTabType(sourceType + "_SETTLE_DETAIL");
                    costDetailVO.setProjectId(entity.getProjectId());
                    costDetailVOList.add(costDetailVO);
                }
                if (entity.getSettlementType() != 0) continue;
                this.logger.info("\u6750\u6599\u91c7\u8d2d\u7ed3\u7b97\u5355\u63a8\u9001\u5b9e\u9645\u6210\u672c---" + detailEntity.getId());
                costDetailVO = new CostDetailVO();
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(billName);
                costDetailVO.setSourceBillUrl(linkUrl);
                costDetailVO.setSubjectId(detailEntity.getSubjectId());
                costDetailVO.setSubjectId(detailEntity.getSubjectId());
                costDetailVO.setSubjectCode(detailEntity.getSubjectCode());
                costDetailVO.setSubjectName(detailEntity.getSubjectName());
                costDetailVO.setNum(detailEntity.getNum());
                costDetailVO.setWbsId(detailEntity.getWbsId());
                costDetailVO.setWbsCode(detailEntity.getWbsCode());
                costDetailVO.setWbsName(detailEntity.getWbsName());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getTaxMny());
                costDetailVO.setHappenMny(detailEntity.getMny());
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(sourceType + "_SETTLE");
                costDetailVO.setSourceTabType(sourceType + "_SETTLE_DETAIL");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(feeList)) {
            for (SettlementFeeEntity feeEntity : feeList) {
                costDetailVO = new CostDetailVO();
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(billName);
                costDetailVO.setSourceBillUrl(linkUrl);
                costDetailVO.setSubjectId(feeEntity.getSubjectIdFee());
                costDetailVO.setSubjectId(feeEntity.getSubjectIdFee());
                costDetailVO.setSubjectCode(feeEntity.getSubjectCodeFee());
                costDetailVO.setSubjectName(feeEntity.getSubjectNameFee());
                costDetailVO.setNum(feeEntity.getFeeNum());
                costDetailVO.setWbsId(feeEntity.getWbsIdFee());
                costDetailVO.setWbsCode(feeEntity.getWbsCodeFee());
                costDetailVO.setWbsName(feeEntity.getWbsNameFee());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setSourceDetailId(feeEntity.getId());
                costDetailVO.setHappenTaxMny(feeEntity.getFeeTaxMny());
                costDetailVO.setHappenMny(feeEntity.getFeeMny());
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(sourceType + "_SETTLE");
                costDetailVO.setSourceTabType(sourceType + "_SETTLE_FEE");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public List<SettlementVO> querySettlementByContractId(SettlementVO settlementVO) {
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        List<Object> rtnList = new ArrayList<SettlementVO>();
        if (CollectionUtils.isNotEmpty(list)) {
            rtnList = BeanMapper.mapList(list, SettlementVO.class);
            for (SettlementVO settlementVO2 : rtnList) {
                settlementVO2.setSettlementDateStr(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settlementVO2.getSettlementDate()));
                settlementVO2.setBillCodeLink(settlementVO2.getBillCode());
                settlementVO2.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)settlementVO2.getBillState()).getDescription());
            }
        }
        return rtnList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMny(SettlementVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyBySupplier(SettlementVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        return paramsCheckVOList;
    }

    private BigDecimal getNoContractSupplierMny(SettlementVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("supplierId", new Parameter("eq", (Object)vo.getSupplierId()));
        queryParam.getParams().put("contractId", new Parameter("eq", null));
        if (vo.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        List entityList = super.queryList(queryParam, false);
        BigDecimal sum = CommonUtils.setBigDecimalDefaultValue(vo.getSettlementTaxMny());
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return sum;
        }
        for (SettlementEntity entity : entityList) {
            sum = sum.add(CommonUtils.setBigDecimalDefaultValue(entity.getSettlementTaxMny()));
        }
        return sum;
    }

    @Override
    public List<PrintSettlementDetailVO> queryPrintSettlementDetail(SettlementVO settlementVO) {
        ArrayList<Object> rtnList = new ArrayList<PrintSettlementDetailVO>();
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        if (CollectionUtils.isEmpty(list)) {
            return rtnList;
        }
        List idList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settlementId", new Parameter("in", idList));
        List detailEntityList = this.settlementDetailService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)detailEntityList)) {
            return rtnList;
        }
        Map<Object, Object> thisMap = new HashMap();
        if (settlementVO.getId() != null) {
            List thisDetailList = detailEntityList.stream().filter(t -> t.getSettlementId().equals(settlementVO.getId())).collect(Collectors.toList());
            thisMap = thisDetailList.stream().collect(Collectors.groupingBy(SettlementDetailEntity::getMaterialId));
        }
        HashMap<String, PrintSettlementDetailVO> map = new HashMap<String, PrintSettlementDetailVO>();
        for (SettlementDetailEntity detailEntity : detailEntityList) {
            PrintSettlementDetailVO printVo;
            String key = "" + detailEntity.getMaterialId() + detailEntity.getStoreTaxPrice() + detailEntity.getTaxPrice();
            if (map.containsKey(key)) {
                printVo = (PrintSettlementDetailVO)map.get(key);
                BigDecimal storeSum = CommonUtils.addBigDecimal(printVo.getStoreNum(), detailEntity.getStoreNum());
                BigDecimal sum = CommonUtils.addBigDecimal(printVo.getNum(), detailEntity.getNum());
                BigDecimal storeTaxMny = CommonUtils.addBigDecimal(printVo.getStoreTaxMny(), detailEntity.getStoreTaxMny());
                BigDecimal taxMny = CommonUtils.addBigDecimal(printVo.getTaxMny(), detailEntity.getTaxMny());
                printVo.setStoreNum(storeSum);
                printVo.setNum(sum);
                printVo.setStoreTaxMny(storeTaxMny);
                printVo.setTaxMny(taxMny);
                printVo.setSettleDiff(CommonUtils.subtractBigDecimal(printVo.getTaxMny(), printVo.getStoreTaxMny()));
                continue;
            }
            printVo = (PrintSettlementDetailVO)BeanMapper.map((Object)((Object)detailEntity), PrintSettlementDetailVO.class);
            List thisMaterialList = (List)thisMap.get(detailEntity.getMaterialId());
            BigDecimal thisSettleNum = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)thisMaterialList)) {
                for (SettlementDetailEntity settlementDetailEntity : thisMaterialList) {
                    thisSettleNum = thisSettleNum.add(CommonUtils.setBigDecimalDefaultValue(settlementDetailEntity.getNum()));
                }
            }
            printVo.setThisSettleNum(thisSettleNum);
            printVo.setSettleDiff(CommonUtils.subtractBigDecimal(printVo.getTaxMny(), printVo.getStoreTaxMny()));
            map.put(key, printVo);
        }
        rtnList = new ArrayList(map.values());
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator.comparing(PrintSettlementDetailVO::getThisSettleNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed().thenComparing(PrintSettlementDetailVO::getNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed());
        }
        return rtnList;
    }

    @Override
    public List<PrintSettlementFeeVO> queryPrintSettlementFee(SettlementVO settlementVO) {
        ArrayList<PrintSettlementFeeVO> rtnList = new ArrayList<PrintSettlementFeeVO>();
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        if (CollectionUtils.isEmpty(list)) {
            return rtnList;
        }
        List idList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settlementId", new Parameter("in", idList));
        List feeEntityList = this.settlementFeeService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)feeEntityList)) {
            return rtnList;
        }
        Map<Object, Object> thisMap = new HashMap();
        Map<Object, Object> thisNoContractMap = new HashMap();
        if (settlementVO.getId() != null) {
            List thisDetailList = feeEntityList.stream().filter(t -> t.getSettlementId().equals(settlementVO.getId())).collect(Collectors.toList());
            thisMap = thisDetailList.stream().filter(t -> t.getSourceId() != null).collect(Collectors.groupingBy(SettlementFeeEntity::getSourceDetailId));
            thisNoContractMap = thisDetailList.stream().filter(t -> t.getSourceId() == null).collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key2));
        }
        HashMap<String, PrintSettlementFeeVO> map = new HashMap<String, PrintSettlementFeeVO>();
        for (SettlementFeeEntity feeEntity : feeEntityList) {
            PrintSettlementFeeVO printFeeVo;
            if (feeEntity.getSourceId() == null) {
                printFeeVo = (PrintSettlementFeeVO)BeanMapper.map((Object)((Object)feeEntity), PrintSettlementFeeVO.class);
                SettlementFeeEntity thisFeeEntity = (SettlementFeeEntity)((Object)thisNoContractMap.get(feeEntity.getId()));
                if (thisFeeEntity != null) {
                    printFeeVo.setThisFeeNum(CommonUtils.setBigDecimalDefaultValue(thisFeeEntity.getFeeNum()));
                }
                rtnList.add(printFeeVo);
                continue;
            }
            String key = "" + feeEntity.getSourceId() + feeEntity.getSourceDetailId();
            if (map.containsKey(key)) {
                printFeeVo = (PrintSettlementFeeVO)map.get(key);
                BigDecimal feeNum = CommonUtils.addBigDecimal(printFeeVo.getFeeNum(), feeEntity.getFeeNum());
                BigDecimal feeTaxMny = CommonUtils.addBigDecimal(printFeeVo.getFeeTaxMny(), feeEntity.getFeeTaxMny());
                printFeeVo.setFeeNum(feeNum);
                printFeeVo.setFeeTaxMny(feeTaxMny);
                continue;
            }
            printFeeVo = (PrintSettlementFeeVO)BeanMapper.map((Object)((Object)feeEntity), PrintSettlementFeeVO.class);
            List thisFeeList = (List)thisMap.get(feeEntity.getSourceDetailId());
            BigDecimal thisNum = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)thisFeeList)) {
                for (SettlementFeeEntity feeEntity1 : thisFeeList) {
                    thisNum = thisNum.add(CommonUtils.setBigDecimalDefaultValue(feeEntity1.getFeeNum()));
                }
            }
            printFeeVo.setThisFeeNum(thisNum);
            map.put(key, printFeeVo);
        }
        rtnList.addAll(new ArrayList(map.values()));
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator.comparing(PrintSettlementFeeVO::getThisFeeNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed().thenComparing(PrintSettlementFeeVO::getFeeNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed());
        }
        return rtnList;
    }

    private List<SettlementEntity> queryListByContractId(SettlementVO settlementVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)settlementVO.getContractId()));
        queryParam.getParams().put("settlementType", new Parameter("eq", (Object)settlementVO.getSettlementType()));
        queryParam.getOrderMap().put("settlementDate", "desc");
        return super.queryList(queryParam, false);
    }
}

