/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.sync.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.sync.bean.SyncRecordsEntity;
import com.ejianc.business.promaterial.sync.handler.HTSyncHandler;
import com.ejianc.business.promaterial.sync.service.ISyncRecordService;
import com.ejianc.business.promaterial.sync.vo.PlanDto;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DataSyncListener
extends BaseConsumer {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String SYNC_RECORD_QUEUE = "sync_record_queue";
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    @Autowired
    private HTSyncHandler handler;
    @Autowired
    private ISyncRecordService service;

    protected void doConsumeMsg(MqMessage mqMessage) {
        this.logger.info("\u63a5\u6536\u5230\u5f85\u540c\u6b65\u6570\u636e\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)mqMessage.getBody()));
        try {
            Stopwatch start = Stopwatch.createStarted();
            SyncRecordsEntity record = (SyncRecordsEntity)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)mqMessage.getBody()), SyncRecordsEntity.class));
            boolean flag = false;
            String result = null;
            if ("syncPlan".equals(record.getHandleType())) {
                PlanDto vo = (PlanDto)JSONObject.parseObject((String)record.getData(), PlanDto.class);
                result = this.handler.syncPlan(vo);
                flag = !"\u5931\u8d25".equals(result);
                record.setPushResult("\u91c7\u8d2d\u8ba1\u5212\u3010" + vo.getOutPlanNo() + "\u3011\u63a8\u9001" + (flag ? "\u6210\u529f" : "\u5931\u8d25") + "\uff01");
            }
            Stopwatch stop = start.stop();
            record.setSyncHandleSeconds(stop.elapsed(TimeUnit.SECONDS));
            record.setSucFlag(String.valueOf(flag));
            record.setSyncResult(result);
            this.service.saveOrUpdate((Object)record, false);
        }
        catch (Exception e) {
            this.logger.error("\u6570\u636e\u540c\u6b65\u5f02\u5e38: ", (Throwable)e);
        }
    }

    protected String[] getQueueNames() {
        return new String[]{"sync_record_queue_" + this.profile};
    }
}

