/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.reconciliation.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.promaterial.contract.vo.ReferenceDetailVO;
import com.ejianc.business.promaterial.contract.vo.ReferenceMapVO;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationDetailEntity;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationCollectService;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationDetailService;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationService;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationDetailVO;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationVO;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"reconciliation"})
@Api(value="\u5bf9\u8d26\u5355\u4e3b\u8868", tags={"\u5bf9\u8d26\u5355\u4e3b\u8868"})
public class ReconciliationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "DZ_CODE";
    @Autowired
    private IReconciliationService service;
    @Autowired
    private IReconciliationDetailService detailService;
    @Autowired
    private IReconciliationCollectService collectService;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private IUserApi userApi;
    private static final String XHC_BILL_TYPE = "BT220310000000001";
    private static final String HNT_BILL_TYPE = "BT220316000000003";
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/reconciliation/card";
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ReconciliationVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ReconciliationVO saveOrUpdateVO) {
        List list;
        ReconciliationEntity entity = (ReconciliationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ReconciliationEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.checkContract(entity);
        ArrayList<ReconciliationDetailVO> detailList = new ArrayList<ReconciliationDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getDetailList())) {
            for (ReconciliationDetailVO detailVO : saveOrUpdateVO.getDetailList()) {
                if (detailVO.getId() == null || !"del".equals(detailVO.getRowState())) continue;
                detailList.add(detailVO);
            }
        }
        if ((list = null == saveOrUpdateVO.getId() || saveOrUpdateVO.getId() == 0L ? this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)saveOrUpdateVO.getContractId())).in((Object)"bill_state", new Object[]{0, 2, 4, 5})).eq((Object)"dr", (Object)0)) : this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)saveOrUpdateVO.getContractId())).in((Object)"bill_state", new Object[]{0, 2, 4, 5})).eq((Object)"dr", (Object)0)).ne((Object)"id", (Object)saveOrUpdateVO.getId()))).size() > 0) {
            throw new BusinessException(" \u4e00\u4e2a\u5408\u540c\u4e0b\u53ea\u80fd\u6709\u4e00\u5f20\u672a\u751f\u6548\u7684\u5bf9\u8d26\u5355");
        }
        this.service.updateAccount(0, (ReconciliationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ReconciliationEntity.class)), BeanMapper.mapList(detailList, ReconciliationDetailEntity.class));
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("reconciliation_id", entity.getId());
        this.collectService.removeByMap(hashMap);
        entity.setMaterialName(entity.getDetailList().stream().map(ReconciliationDetailEntity::getMaterialName).collect(Collectors.joining(",")));
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.service.saveOrUpdate((Object)entity, false);
        this.service.updateAccount(1, entity, entity.getDetailList());
        ReconciliationVO vo = (ReconciliationVO)BeanMapper.map((Object)((Object)entity), ReconciliationVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReconciliationVO> queryDetail(@RequestParam Long id) {
        ReconciliationEntity entity = (ReconciliationEntity)((Object)this.service.selectById(id));
        ReconciliationVO vo = (ReconciliationVO)BeanMapper.map((Object)((Object)entity), ReconciliationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u534f\u540c\u94fe\u63a5")
    @RequestMapping(value={"/getBillShareLink"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        ReconciliationEntity entity = (ReconciliationEntity)((Object)this.service.selectById(id));
        String billTypeCode = entity.getReconciliationType() == 0 ? XHC_BILL_TYPE : HNT_BILL_TYPE;
        CommonResponse supplierResp = this.proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546\u4e3b\u952e-{}\u67e5\u8be2\u5931\u8d25\uff0c{}", (Object)entity.getSupplierId(), (Object)supplierResp.getMsg());
            return CommonResponse.error((String)"\u5355\u636e\u83b7\u53d6\u4f9b\u65b9\u4fe1\u606f\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
        }
        Boolean flag = (Boolean)supplierResp.getData();
        if (!flag.booleanValue()) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u672a\u5f00\u901a\u534f\u540c\u6743\u9650\uff0c\u65e0\u6cd5\u534f\u540c\u5206\u4eab\u3002");
        }
        if (BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)billTypeCode, (Object)cooperateResp.getMsg());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            boolean pushResult = this.service.pushBillToSupCenter(entity, billTypeCode);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushResult);
            if (!pushResult) {
                this.logger.error("\u5355\u636e-{}\u63a8\u9001\u7ed9\u4f9b\u5e94\u5546supplierId-{}\u5931\u8d25\uff01", (Object)id, (Object)entity.getSupplierId());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, billTypeCode, entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/proMaterial/reconciliation/card", null);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReconciliationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ReconciliationVO vo : vos) {
                ReconciliationEntity entity = (ReconciliationEntity)((Object)this.service.selectById(vo.getId()));
                this.service.updateAccount(0, entity, entity.getDetailList());
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/supSignSync"})
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("reconciliationType", new Parameter("eq", (Object)0));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReconciliationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u6d88\u8017\u6750\u5217\u8868")
    @RequestMapping(value={"/queryConcreteList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> queryConcreteList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("reconciliationType", new Parameter("eq", (Object)1));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReconciliationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("reconciliationType", new Parameter("eq", (Object)0));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, ReconciliationVO.class);
        vos.forEach(t -> t.setSignStatusName(t.getSignStatus() == 0 ? "\u672a\u7b7e\u5b57" : "\u5df2\u7b7e\u5b57"));
        vos.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("Reconciliation-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u6df7\u51dd\u571f\u5bfc\u51fa")
    @RequestMapping(value={"/excelConcreteExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelConcreteExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("reconciliationType", new Parameter("eq", (Object)1));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, ReconciliationVO.class);
        vos.forEach(t -> t.setSignatureStatus(SignatureStatusEnum.getEnumByCode(t.getSignatureStatus()).getDescription()));
        vos.forEach(t -> t.setSignStatusName(t.getSignStatus() == 0 ? "\u672a\u7b7e\u5b57" : "\u5df2\u7b7e\u5b57"));
        vos.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("Reconciliation-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refReconciliationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> refReconciliationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
            }
            if (null != conditionMap.get("reconciliationType")) {
                Integer reconciliationType = Integer.valueOf(conditionMap.get("reconciliationType").toString());
                param.getParams().put("reconciliationType", new Parameter("eq", (Object)reconciliationType));
            }
        }
        IPage<ReconciliationVO> page = this.service.queryData(param);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List reconciliationVOS = BeanMapper.mapList((Iterable)page.getRecords(), ReconciliationVO.class);
        for (ReconciliationVO vo : reconciliationVOS) {
            LambdaQueryWrapper lambd = new LambdaQueryWrapper();
            lambd.eq(BaseEntity::getDr, (Object)0);
            lambd.eq(ReconciliationDetailEntity::getReconciliationId, (Object)vo.getId());
            List list = this.detailService.list((Wrapper)lambd);
            List batchPlanDetailVOS = BeanMapper.mapList((Iterable)list, ReconciliationDetailVO.class);
            vo.setDetailList(batchPlanDetailVOS);
        }
        pageData.setRecords(reconciliationVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u5408\u540c\u7d2f\u8ba1\u5bf9\u8d26\u6570\u91cf")
    @RequestMapping(value={"/queryReconciliationNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReconciliationVO> queryReconciliationNum(@RequestParam Long id) {
        ReconciliationVO reconciliationVO = new ReconciliationVO();
        Integer size = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)id)).in((Object)"bill_state", Arrays.asList(1, 3))).eq((Object)"dr", (Object)0)).size();
        reconciliationVO.setTotalReconciliationNum(size);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)reconciliationVO);
    }

    @GetMapping(value={"/getReferenceMap"})
    @ResponseBody
    public CommonResponse<List<ReferenceMapVO>> getReferenceMap(@RequestParam String type, @RequestParam Long id) {
        Map<String, String> queryParam = this.getQueryDataParam(id.toString());
        CommonResponse dataResp = this.mdApi.queryDataList(queryParam);
        if (!dataResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5408\u540cid-{}\u83b7\u53d6\u5f15\u7528\u5355\u636e\u4fe1\u606f\u5217\u8868\u5931\u8d25{}", (Object)id, (Object)dataResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5f15\u7528\u7ed3\u7b97\u5355\u7684\u5355\u636e\u4fe1\u606f\u5217\u8868\u5931\u8d25\uff01");
        }
        List<ReferenceMapVO> resp = this.getReferenceMapData((Map)dataResp.getData());
        return CommonResponse.success(resp);
    }

    private Map<String, String> getQueryDataParam(String id) {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        StringBuilder sp = new StringBuilder();
        sp = new StringBuilder();
        sp.append("SELECT  id, create_user_code, create_time, bill_code, org_name,bill_state,reconciliation_tax_mny as mny  FROM `ejc_promaterial_reconciliation`\nwhere id in (select DISTINCT reconciliation_id from ejc_promaterial_reconciliation_detail where source_id =").append(id).append("  and dr = 0) and dr = 0 ");
        queryParam.put(XHC_BILL_TYPE, sp.toString());
        sp = new StringBuilder();
        sp.append("SELECT  id, create_user_code, create_time, bill_code, org_name,bill_state,settlement_tax_mny as mny  FROM `ejc_promaterial_settlement`\nwhere id in (select DISTINCT settlement_id from ejc_promaterial_settlement_detail where source_id = ").append(id).append("  and dr = 0) and dr = 0 ");
        queryParam.put("BT220309000000003", sp.toString());
        sp = new StringBuilder();
        sp.append("select id, create_user_code, create_time, project_name AS bill_code, parent_org_name,bill_state,cost_mny as mny  from ejc_procost_share ").append(" where id in (select DISTINCT share_id from ejc_procost_share_detail where source_id = ").append(id).append(" and dr = 0) and dr = 0");
        queryParam.put("BT220316000000002", sp.toString());
        sp = new StringBuilder();
        sp.append("SELECT id, create_user_code, create_time, bill_code, org_name,bill_state,apply_mny as mny FROM `ejc_payment_apply` where dr = 0 and contract_id = ").append(id);
        queryParam.put("BT220223000000003", sp.toString());
        return queryParam;
    }

    private List<ReferenceMapVO> getReferenceMapData(Map<String, List<JSONObject>> data) {
        ArrayList<ReferenceMapVO> resp = new ArrayList<ReferenceMapVO>();
        ReferenceMapVO tmp = null;
        ReferenceDetailVO tmpDetail = null;
        List<JSONObject> dataList = null;
        HashSet<String> userCodes = new HashSet<String>();
        for (String billType : data.keySet()) {
            dataList = data.get(billType);
            if (!CollectionUtils.isNotEmpty(dataList)) continue;
            String billName = "";
            String billUrl = "";
            switch (billType) {
                case "BT220215000000006": {
                    billName = "\u9a8c\u6536\u5355";
                    billUrl = "ejc-promaterial-frontend/#/check/card?id=";
                    break;
                }
                case "BT220310000000001": {
                    billName = "\u5bf9\u8d26\u5355";
                    billUrl = "ejc-promaterial-frontend/#/reconciliation/card?id=";
                    break;
                }
                case "BT220309000000003": {
                    billName = "\u91c7\u8d2d\u7ed3\u7b97\u5355";
                    billUrl = "ejc-promaterial-frontend/#/settlementList/settlementCard?id=";
                    break;
                }
                case "BT220316000000002": {
                    billName = "\u6210\u672c\u5f52\u96c6\u5355";
                    billUrl = "ejc-share-frontend/#/costShare/card?id=";
                    break;
                }
                case "BT220223000000003": {
                    billName = "\u6709\u5408\u540c\u4ed8\u6b3e\u7533\u8bf7";
                    billUrl = "ejc-profinance-frontend/#/paymentList/contractCard?id=";
                }
            }
            tmp = new ReferenceMapVO();
            tmp.setId(billType);
            tmp.setModuleName(billName);
            tmp.setReferenceNum(Integer.valueOf(dataList.size()));
            BigDecimal sumMny = new BigDecimal(0);
            for (JSONObject dataRow : dataList) {
                tmpDetail = new ReferenceDetailVO();
                tmpDetail.setId(dataRow.getString("id"));
                tmpDetail.setBillCode(dataRow.getString("bill_code"));
                tmpDetail.setBillState(BillStateEnum.getEnumByStateCode((Integer)dataRow.getInteger("bill_state")).getDescription());
                tmpDetail.setCreateTime(dataRow.getDate("create_time"));
                tmpDetail.setEmployeeName(dataRow.getString("create_user_code"));
                tmpDetail.setModuleName(tmp.getModuleName());
                tmpDetail.setOrgName(dataRow.getString("org_name"));
                tmpDetail.setMny(dataRow.getBigDecimal("mny"));
                tmpDetail.setDetailPcUrl(this.BaseHost + billUrl + tmpDetail.getId());
                tmp.getDetailList().add(tmpDetail);
                if (StringUtils.isNotBlank((CharSequence)tmpDetail.getEmployeeName())) {
                    userCodes.add(tmpDetail.getEmployeeName());
                }
                if (tmpDetail.getMny() == null) continue;
                sumMny = sumMny.add(dataRow.getBigDecimal("mny"));
            }
            tmp.setSumMny(sumMny);
            resp.add(tmp);
        }
        if (CollectionUtils.isNotEmpty(userCodes)) {
            CommonResponse userResp = this.userApi.queryUserByUserCodes(userCodes.toArray(new String[userCodes.size()]));
            if (!userResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7528\u6237\u7f16\u7801\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)userResp.getMsg());
            } else {
                Map<String, UserVO> userMap = ((List)userResp.getData()).stream().collect(Collectors.toMap(item -> item.getUserCode(), item -> item));
                resp.stream().forEach(item -> item.getDetailList().stream().forEach(detail -> {
                    if (userMap.containsKey(detail.getEmployeeName())) {
                        detail.setEmployeeName(((UserVO)userMap.get(detail.getEmployeeName())).getUserName());
                    }
                }));
            }
        }
        return resp;
    }
}

