package com.ejianc.business.promaterial.settlement.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckService;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.*;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.out.bean.OutStoreEntity;
import com.ejianc.business.promaterial.out.bean.OutStoreSubEntity;
import com.ejianc.business.promaterial.out.vo.OutStoreVO;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceCheckTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.promaterial.pricelib.vo.PriceLibVO;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationDetailEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationDetailService;
import com.ejianc.business.promaterial.settlement.bean.SettlementCollectEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementFeeEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementCollectService;
import com.ejianc.business.promaterial.settlement.service.ISettlementDetailService;
import com.ejianc.business.promaterial.settlement.service.ISettlementFeeService;
import com.ejianc.business.promaterial.settlement.vo.*;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.business.store.api.IAccountSettleApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.temporary.settlement.api.ITemporarySettlementApi;
import com.ejianc.business.temporary.settlement.vo.TemporarySettlementVO;
import com.ejianc.business.temporary.userecord.vo.TemporaryUseRecordVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.support.idworker.util.IdWorker;
import io.micrometer.shaded.org.pcollections.Empty;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.hash.HashService;
import org.aspectj.weaver.ast.Var;
import org.owasp.esapi.ValidationRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.settlement.mapper.SettlementMapper;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 结算单主表
 *
 * @author generator
 *
 */
@Service("settlementService")
public class SettlementServiceImpl extends BaseServiceImpl<SettlementMapper, SettlementEntity> implements ISettlementService{
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE_C = "JS_CODE";//此处需要根据实际修改
    private static final String BILL_CODE_H = "SHAHUN";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractService contractService;//合同
    @Autowired
    private ISettlementCollectService settlementCollectService;//结算汇总
    @Autowired
    private IAccountSettleApi accountSettleApi;//结算状态更新api
    @Autowired
    private IReconciliationDetailService reconciliationDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private ISettlementFeeService settlementFeeService; // 结算其他费用

    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private ISettlementDetailService settlementDetailService;

    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IParamConfigApi paramConfigApi;

    private final String  OPERATE= "SETTLMENT_JS";
    @Value("${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IProincomeContractApi proincomeContrantApi;
    @Autowired
    private ITemporarySettlementApi temporarySettlementApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IConcreteCheckService concreteCheckService;

    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/settlement/saveSettlement";
    private static final String MBILL_TYPE = "BT220309000000003";//消耗
    private static final String CBILL_TYPE = "BT220316000000005";//混凝
    //参数控制编码
    private static final String M_PARAM_CODE_GC = "P-261sG051";//消耗金额控制-过程
    private static final String M_PARAM_CODE_ZZ = "P-g9oJ340151";//消耗金额控制-最终

    private static final String C_PARAM_CODE_GC = "P-p52jnO52";//混凝金额控制-过程
    private static final String C_PARAM_CODE_ZZ = "P-4472DH0153";//混凝金额控制-最终

    private static final String MN_PARAM_CODE_GC = "P-o0ydgH53";//消耗数量控制-过程
    private static final String MN_PARAM_CODE_ZZ = "P-Zvb6nF0152";//消耗数量控制-最终

    private static final String CN_PARAM_CODE_GC = "P-6lY70054";//混凝数量控制-过程
    private static final String CN_PARAM_CODE_ZZ = "P-7Fq3830154";//混凝数量控制-最终

    private static final String NO_CONTRACT_PARAM_CODE = "P-0w8vi00147";// 单次无合同结算金额控制
    private static final String NO_CONTRACT_SUPPLIER_PARAM_CODE = "P-r958420148";// 单次无合同结算金额控制
    private static final String CHECK_MNY_CON_CODE = "P-5E2vV80145";//【施工合同金额】控【无合同结算、零星机械金额】


    /*根据合同id查询*/
    @Override
    public SettlementRecordVO querySettleRecord(Long contractId) {
        SettlementRecordVO vo = new SettlementRecordVO();
        ContractEntity contractEntity = contractService.selectById(contractId);
        vo.setContractId(contractId);
        vo.setContractTaxMny(contractEntity.getContractTaxMny());
        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettlementEntity::getContractId, contractId);
        wrapper.eq(SettlementEntity::getDr, 0);
        wrapper.in(SettlementEntity::getBillState,1,3);
        wrapper.orderByAsc(SettlementEntity::getCreateTime);
        List<SettlementEntity> list = super.list(wrapper);
        List<SettlementVO> vos = BeanMapper.mapList(list, SettlementVO.class);
        SettlementVO settlementVO = CollectionUtils.isNotEmpty(vos) ? vos.get(0) : null;
        vo.setTotalSettlementTaxMny(null != settlementVO && null != settlementVO.getCurrentSettlementTaxMny() ? settlementVO.getCurrentSettlementTaxMny() : BigDecimal.ZERO);
        if(vo.getContractTaxMny()==null || BigDecimal.ZERO.compareTo(vo.getContractTaxMny()) == 0) {
            vo.setSettleRatio(BigDecimal.ZERO);
        } else {
            vo.setSettleRatio(vo.getTotalSettlementTaxMny().divide(vo.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        vo.setSettlementList(vos);
        //查询是否有最终结算单
        LambdaQueryWrapper<SettlementEntity> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(SettlementEntity::getContractId, contractId);
        wrapper2.eq(SettlementEntity::getDr, 0);
        wrapper2.eq(SettlementEntity::getSignatureType, 1);//最终
        List<SettlementEntity> list2 = super.list(wrapper2);
        vo.setFlag(!CollectionUtils.isNotEmpty(list2));
        //查询是否有未生效的过程结算单
        LambdaQueryWrapper<SettlementEntity> wrapper3 = new LambdaQueryWrapper<>();
        wrapper3.eq(SettlementEntity::getContractId, contractId);
        wrapper3.eq(SettlementEntity::getDr, 0);
        wrapper3.notIn(SettlementEntity::getBillState, 1,3);
        wrapper3.eq(SettlementEntity::getSignatureType, 0);//过程
        List<SettlementEntity> list3 = super.list(wrapper3);
        vo.setFlagTwo(!CollectionUtils.isNotEmpty(list3));
        return vo;
    }

    @Override
    public CommonResponse<SettlementVO> saveOrUpdate(SettlementVO saveOrUpdateVO) {
        // 校验结算明细
        //最终结算不需要填明细信息
        if(saveOrUpdateVO.getSignatureType() == 0 && CollectionUtils.isEmpty(saveOrUpdateVO.getSettlementDetailList())){
            throw new BusinessException("检测到当前结算单的材料明细为空，无法保存！");
        }
        SettlementEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            String BILL_CODE = "";
            switch (entity.getSettlementType()){
                case 0:BILL_CODE = BILL_CODE_C;break;
                case 1:BILL_CODE = BILL_CODE_H;break;
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            if (null!=entity.getContractId() && this.queryExist(entity.getContractId())){
                throw new BusinessException("该合同下有未生效的结算单！");
            }
        }else {
            this.delCollect(entity.getId());
            List<SettlementDetailEntity> detailDel = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(entity.getSettlementDetailList())){
                for (SettlementDetailEntity detail : entity.getSettlementDetailList()) {
                    if("del".equals(detail.getRowState())){
                        detailDel.add(detail);
                    }
                }
            }
            //删除结算状态
            this.deleteAccount(detailDel,entity.getContractId());
        }
        //初始化签章，签字状态
        entity.setSignStatus(0);
        entity.setSignatureStatus(0);
        entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        entity.setProportionFlag("0");// 分摊状态(1:是，0：否)
        entity.setRelationFlag("0");// 关联状态(1:是，0：否)
        if(entity.getContractId()!=null){//有合同同保存
            if(CollectionUtils.isNotEmpty(entity.getSettlementDetailList())){
                ContractEntity contractEntity = contractService.selectById(entity.getContractId());
                List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
                if(CollectionUtils.isEmpty(contractDetailList)){
                    throw new BusinessException("结算明细在合同【"+entity.getContractName()+"】中不存在，请变更合同后再结算");
                }
                List<String> materialIds = contractDetailList.stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).map(item->item.getMaterialId().toString()).collect(Collectors.toList());
                List<String> materialTypeIds = contractDetailList.stream().filter(t -> t.getMaterialId() == null && t.getMaterialTypeId()!=null &&!ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).map(item->item.getMaterialTypeId().toString()).collect(Collectors.toList());
                for (SettlementDetailEntity detail : entity.getSettlementDetailList()) {
                    if(!"del".equals(detail.getRowState())){
                        boolean flag = true;
                        String materialTypeId = detail.getMaterialTypeId()==null?"":detail.getMaterialTypeId().toString();
                        String materialId = detail.getMaterialId()==null?"":detail.getMaterialId().toString();
                        if(materialTypeIds.contains(materialTypeId)){//结算明细有合同分类
                            flag = false;
                        }
                        if(materialIds.contains(materialId)){//结算明细有合同明细
                            flag = false;
                        }
                        if(flag){
                            throw new BusinessException("材料【"+detail.getMaterialName()+"】在合同【"+entity.getContractName()+"】中不存在，请变更合同后再结算");
                        }
                    }
                }
            }
        }
        super.saveOrUpdate(entity, false);
        //保存结算信息
        this.updateAccount(entity);
        SettlementVO vo = BeanMapper.map(entity, SettlementVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /*是否有为生效的结算单*/
    public boolean queryExist(Long contractId){
        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettlementEntity::getContractId, contractId);
        wrapper.notIn(SettlementEntity::getBillState, 1, 3);//未生效条件
        List<SettlementEntity> list = super.list(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {//有数据表示有未生效的结算单
            return true;
        }
        return false;
    }

    /*删除汇总*/
    public void delCollect(Long id) {
        LambdaQueryWrapper<SettlementCollectEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettlementCollectEntity::getSettlementId, id);
        List<SettlementCollectEntity> list = settlementCollectService.list(wrapper);
        List<Long> ids = list.stream().map(SettlementCollectEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            settlementCollectService.removeByIds(ids);
        }
    }

    /*修对账子表结算状态
       @param: ids 要修改对账子表id集合
       @param: flag 0-未引用 1-引用
       */
    private void uapdeRD(List ids,Integer flag){
        if(CollectionUtils.isNotEmpty(ids)){
            logger.info("子表键值:"+JSONObject.toJSONString(ids));
            LambdaQueryWrapper<ReconciliationDetailEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(ReconciliationDetailEntity::getId, ids);
            List<ReconciliationDetailEntity> list = reconciliationDetailService.list(wrapper);
            if(CollectionUtils.isNotEmpty(list)){
                logger.info("对账子表数据:"+JSONObject.toJSONString(list));
                list.forEach(item->{
                    item.setReconciliationState(flag);
                });
                reconciliationDetailService.saveOrUpdateBatch(list, list.size(), false);
                logger.info("修改状态成功--"+JSONObject.toJSONString(list));
            }
        }
    }

    /*获取最近一次含本期结算金额和结算日期 ，结算次数*/
    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        Map<String, Object> map = new HashMap<>();
        BigDecimal currentTaxMny = BigDecimal.ZERO; // 结算金额
        BigDecimal currentMny = BigDecimal.ZERO; // 结算金额(无税)
        String sTDate  = null;
        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.orderByDesc(SettlementEntity::getCreateTime);
        wrapper.in(SettlementEntity::getBillState, 1,3);//防止修改时获取本单据的数据
        wrapper.eq(SettlementEntity::getDr, 0);
        wrapper.eq(SettlementEntity::getContractId, contractId);
        List<SettlementEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            SettlementEntity settlementEntity = list.get(0);
            currentTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny  = list.stream().filter(e -> e.getSettlementMny() != null).map(SettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            sTDate = DateFormatUtil.formatDate("yyyy-MM-dd", settlementEntity.getSettlementDate());
        }
        map.put("currentTaxMny",currentTaxMny);
        map.put("currentMny",currentMny);
        map.put("sTDate",sTDate);
        map.put("settlementNum",list.size());
        return CommonResponse.success("获取金额和时间、结算次数成功,！",map);
    }

    /*保存/修改更新结算状态    修改对账状态*/
    public void updateAccount(SettlementEntity entity) {
        boolean flag =true;
        StoreApiVO storeApiVO = new StoreApiVO();
        List<FlowVO> flowVOS = new ArrayList<>();
        Set<Long> checkId = new HashSet<Long>();//要回显合同id的验收明细ids
        //入库保存
        storeApiVO.setSettleFlag(1);
        storeApiVO.setSettleId(entity.getId());
        storeApiVO.setSettleDate(entity.getSettlementDate());
        storeApiVO.setSettleCode(entity.getBillCode());
        storeApiVO.setPurchaseContractId(entity.getContractId());
        storeApiVO.setPurchaseContractName(entity.getContractName());
        //对账保存修改
        List<Long> idsAdd = new ArrayList<>();
        //遍历子表
        for (SettlementDetailEntity detailEntity :entity.getSettlementDetailList() ) {
            if(!"del".equals(detailEntity.getRowState())){//新增/修改
                FlowVO flowVO = new FlowVO();
                if(null!=entity.getContractId() && ContractFlagEnum.无合同.getCode().equals(detailEntity.getContractFlag())){
                    checkId.add(detailEntity.getSourceId());
                    flowVO.setCusDef1("NoContract");
                }
                flowVO.setSettleDetailId(detailEntity.getId());
                flowVO.setSourceId(detailEntity.getSourceId());
                flowVO.setSourceDetailId(detailEntity.getSourceDetailId());
                flowVOS.add(flowVO);
                if(detailEntity.getReconciliationDetailId()!=null){//对账修改
                    idsAdd.add(detailEntity.getReconciliationDetailId());
                }
            }
        }
        storeApiVO.setDetail(flowVOS);
        logger.info("保存结算更新信息--" + JSONObject.toJSONString(storeApiVO));
        CommonResponse<String> response2 = accountSettleApi.changeAccountSettleByType(storeApiVO);
        if (!response2.isSuccess()) {
            throw new BusinessException("保存结算状态更新失败");
        }
        logger.info("保存结算更新信息完成--" + JSONObject.toJSONString(response2));
        this.uapdeRD(idsAdd, 1);
        updateContractId(new ArrayList<>(checkId),entity.getContractId(),entity.getContractName());
    }

    /*更新无合同合同id态*/
    public void updateContractId(List<Long> ids,Long contractId,String contractName) {
        logger.info("合同id更新信息，更新ids:{}--合同id:{}",JSONObject.toJSONString(ids),contractId);
        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id",new Parameter(QueryParam.IN,ids));
        List<CheckEntity> checkEntities = checkService.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(checkEntities)){
            List<CheckEntity> collect = checkEntities.stream().map(item -> {
                item.setContractId(contractId);
                item.setCheckerName(contractName);
                return item;
            }).collect(Collectors.toList());
            checkService.updateBatchById(collect);
            logger.info("合同id更新信息，材料更新信息:{}",JSONObject.toJSONString(collect));
        }
        List<ConcreteCheckEntity> concreteCheckEntities = concreteCheckService.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(concreteCheckEntities)){
            List<ConcreteCheckEntity> collect2 = concreteCheckEntities.stream().map(item -> {
                item.setContractId(contractId);
                item.setCheckerName(contractName);
                return item;
            }).collect(Collectors.toList());
            concreteCheckService.updateBatchById(collect2);
            logger.info("合同id更新信息，混凝土更新信息:{}",JSONObject.toJSONString(collect2));
        }
    }

    /*删除*/
    @Override
    public CommonResponse<String> delete(List<SettlementVO> vos) {
        //修改 入库 结算状态
        SettlementEntity settlementEntity = super.selectById(vos.get(0).getId());
        this.deleteAccount(settlementEntity.getSettlementDetailList(),settlementEntity.getContractId());
        super.removeByIds(vos.stream().map(SettlementVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /*删除更新结算状态*/
    public void deleteAccount(List<SettlementDetailEntity> settlementDetail,Long contractId) {
        StoreApiVO storeApiVO = new StoreApiVO();
        List<FlowVO> flowVOS = new ArrayList<>();
        storeApiVO.setSettleFlag(0);
        Set<Long> checkId = new HashSet<Long>();//要回显合同id的验收明细ids
        //对账删除
        List<Long> idsDel = new ArrayList<>();
        for (SettlementDetailEntity detailEntity : settlementDetail) {
            FlowVO flowVO = new FlowVO();
            if(null!=contractId && ContractFlagEnum.无合同.getCode().equals(detailEntity.getContractFlag())){
                checkId.add(detailEntity.getSourceId());
                flowVO.setCusDef1("NoContract");
            }
            if (detailEntity.getReconciliationDetailId() != null) {//对账修改
                idsDel.add(detailEntity.getReconciliationDetailId());
            }
            flowVO.setSourceId(detailEntity.getSourceId());
            flowVO.setSourceDetailId(detailEntity.getSourceDetailId());
            flowVOS.add(flowVO);
        }
        storeApiVO.setDetail(flowVOS);
        logger.info("删除结算更新信息--" + JSONObject.toJSONString(storeApiVO));
        CommonResponse<String> response = accountSettleApi.changeAccountSettleByType(storeApiVO);
        if (!response.isSuccess()) {
            throw new BusinessException("删除结算状态更新失败");
        }
        this.uapdeRD(idsDel, 0);
        updateContractId(new ArrayList<>(checkId),null,null);
    }


    /*推送供方*/
    @Override
    public boolean pushBillToSupCenter(SettlementEntity entity, String billTypeCode) {
        String BILL_TYPE;
        if(entity.getSettlementType()==1){
            BILL_TYPE = CBILL_TYPE;
        }else {
            BILL_TYPE = MBILL_TYPE;
        }
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送计量单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            SupSettlementVO supSettlementVO = BeanMapper.map(entity, SupSettlementVO.class);
            List<SupSettlementDetailVO> supSettlementDetailVOS = BeanMapper.mapList(entity.getSettlementDetailList(), SupSettlementDetailVO.class);
            List<SupSettlementFeeVO> supSettlementFeeVOS = BeanMapper.mapList(entity.getSettlementFeeList(), SupSettlementFeeVO.class);
            List<SupSettlementCollectVO> supSettlementCollectVOS = BeanMapper.mapList(entity.getSettlementCollectList(), SupSettlementCollectVO.class);
            supSettlementVO.setSettlementDetailList(supSettlementDetailVOS);
            supSettlementVO.setSettlementFeeList(supSettlementFeeVOS);
            supSettlementVO.setSettlementCollectList(supSettlementCollectVOS);
            paramMap.put("transData", JSONObject.toJSONString(supSettlementVO));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), billTypeCode, "settlementProjectFile", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                //当前单据携带有附件信息
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送附件参数-{}", entity.getSupplierId(), JSONObject.toJSONString(files));
                logger.info("向供应商-{}推送计量单据参数-{}", entity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        entity.getSupplierId().toString(),
                        files);
//                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        logger.error("供方id-{}处理推送订单单据id-{}失败, {}", entity.getSupplierId(), entity.getId(), billPushResp.getMsg());
                    }
                } else {
                    logger.error("发送请求推送订单单据id-{}给供方id-{}失败, {}", entity.getId(), entity.getSupplierId(), syncReqResp.getMsg());
                }
            } else {
                logger.error("获取订单单据id-{}对应附件信息失败, {}", entity.getId(), fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送订单单据id-{}给供方id-{} 异常，", entity.getId(), entity.getSupplierId(), e);
//            throw e;
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    /*
     * 撤回推送供方
     *  */
    @Override
    public CommonResponse<String> updatePushBill(SettlementEntity entity, String billTypeCode, String url) {
        String BILL_TYPE;
        if(entity.getSettlementType()==1){
            BILL_TYPE = CBILL_TYPE;
        }else {
            BILL_TYPE = MBILL_TYPE;
        }
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return CommonResponse.error("推送供方异常!");
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        baseMapper.updateById(entity);
        logger.info("修改签字信息：{}", JSONObject.toJSONString(entity));
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return CommonResponse.error("单据作废失败，单据锁获取失败!");
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            logger.info("单据id-{}弃审，通知供方-{}单据作废!", entity.getSupplierId(), entity.getId());
            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(url,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    entity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    return supHandleResp;
                } else {
                    logger.error("供方-{}处理作废单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), supHandleResp.getMsg());
                    throw new BusinessException(supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(),
                        syncReqResp.getMsg());
                throw new BusinessException(syncReqResp.getMsg());
            }

        }
        catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", entity.getId(), e);
            throw new BusinessException("推送供方异常!");
        }
        finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }

    /*供方签字确认*/
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        SettlementEntity settlementEntity = super.selectById(billId);
        String BILL_TYPE;
        if (settlementEntity.getSettlementType() == 0) {
            BILL_TYPE = MBILL_TYPE;
        }
        else {
            BILL_TYPE = CBILL_TYPE;
        }
        //设置供方签字信息
        settlementEntity.setSupOperateTime(supOperateTime);
        settlementEntity.setSupOperatorName(supOperatorName);
        settlementEntity.setSupOperatorPhone(supOperatorPhone);
        settlementEntity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE + "::" + settlementEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", settlementEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance()
                    .handleReqFile((MultipartHttpServletRequest) request,
                            mp, BILL_TYPE, authority, settlementEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            settlementEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：0-未签字 1-已签字
            // 乙方已签字状态即待甲方签字
            settlementEntity.setSignStatus(1);
            //更新单据
            super.saveOrUpdate(settlementEntity, false);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(checkEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(),
//                settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        }
        catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", settlementEntity.getId(), e);
            msg = "单据签字信息回写失败！";
            throw e;
        }
        finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*提交推送结算池*/
    @Override
    public boolean pushSettleToPool(SettlementVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始-----"+JSONObject.toJSONString(vo));
            // 对象自动转换
            BeanConvertorUtil.convert(vo, spv);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");

            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(vo, spv);
            if(vo.getContractId()==null){
                if(vo.getSettlementType()==1){//结算类型  0 -物资 1-混凝土   结算类型/合同类型转换
                    spv.setBillCodeUrl("/ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + vo.getId());
                }else {
                    spv.setBillCodeUrl("/ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + vo.getId());
                }

            }else {
                if(vo.getSettlementType()==1){//结算类型  0 -物资 1-混凝土   结算类型/合同类型转换
                    spv.setBillCodeUrl("/ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + vo.getId());
                }else {
                    spv.setBillCodeUrl("/ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + vo.getId());
                }

            }
            logger.info("推送参数----"+JSONObject.toJSONString(spv));
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            logger.info("结算单推送结算池结束---"+JSONObject.toJSONString(res));
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单推送结算池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}",vo.getId(), res.getMsg());
                throw new BusinessException("结算单弃审推送结算池失败!");
            }
        } catch (Exception e) {
            logger.error("结算单推送结算池失败！结算单id-{}", vo.getId(), e);
            throw new BusinessException("结算单推送结算池异常!");
        }
        return flag;
    }

    /*弃审删除结算池*/
// 从结算池中删除数据
    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            logger.info("结算单弃审推送结算池开始,结算单id-{}",id);
            CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
            logger.info("结算单推送结算池结束---"+JSONObject.toJSONString(res));
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单弃审推送结算池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}",id, res.getMsg());
                throw new BusinessException("结算单弃审推送结算池失败!");
            }
        }catch (Exception e){
            logger.error("结算单弃审推送结算池失败！结算单id-{}", id, e);
            throw new BusinessException("结算单弃审推送结算池异常!");
        }
        return flag;
    }


    // 将SettlementVO转换成settlePoolVO
    private void convertSettleVOToSettlePoolVO(SettlementVO vo, SettlePoolVO spv) {
        if (null == vo || null == spv) {
            logger.error("将结算单推送至结算池失败！原因：结算单对象为空或结算池对象为空，结算单对象 -> 结算池对象无法转换！");
            return;
        }
        logger.info("结算单对象 -> 结算池对象手动转换开始");
        switch (vo.getSettlementType()){//结算类型  0 -物资 1-混凝土   结算类型/合同类型转换
            case 0:
                if(vo.getContractId()!=null){
                    spv.setSourceType(SettleSourceTypeEnum.物资采购结算.getCode());
                }else {
                    spv.setSourceType(SettleSourceTypeEnum.零星材料结算.getCode());
                };break;
            case 1:spv.setSourceType(SettleSourceTypeEnum.混凝土采购结算.getCode());break;
        }
        //单据类似  单据状态 ：
        spv.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        spv.setId(vo.getId());
        spv.setSettlePropertyName("支出");
        spv.setSettleProperty(0);//属性类别，0支出，1收入
        spv.setSourceId(vo.getId());//结算单id
        spv.setCreateUserCode(vo.getCreateUserCode());//结算创建者账号
        spv.setCreateTime(vo.getCreateTime());//结算创建时间
        spv.setUpdateUserCode(vo.getUpdateUserCode());//结算修改者账号
        spv.setUpdateTime(vo.getUpdateTime());//结算修改时间
        spv.setContractFlag(0);// 是否有合同：1-是，0-否
        spv.setHandleType(0);
        if(vo.getContractId()!=null){//有合同需要推送的字段
            spv.setContractFlag(1);// 是否有合同：1-是，0-否
            //查询合同
            ContractEntity contractEntity = contractService.selectById(vo.getContractId());
            switch (contractEntity.getContractType()){//合同类型  0 - 物资 1- 混凝土
                case 0:spv.setContractType(ContractTypeEnum.物资采购合同.getTypeCode());break;
                case 1:spv.setContractType(ContractTypeEnum.混凝土合同.getTypeCode());break;
            }
            spv.setSupplementFlag(contractEntity.getSupplementFlag());//是否补充写协议
            spv.setMaiContractId(contractEntity.getMainContractId());//原合同id
            spv.setMaiContractName(contractEntity.getMainContractName());//原合同name
            spv.setMaiContractCode(contractEntity.getMainContractCode());//原合同code
            spv.setContractCode(contractEntity.getBillCode());//合同编码
            spv.setPartyaId(contractEntity.getCustomerId());//甲方id
            spv.setPartyaName(contractEntity.getCustomerName());//甲方name
            spv.setSignDate(contractEntity.getSignDate());//签订日期
            spv.setLastTaxMny(ComputeUtil.safeSub(vo.getCurrentSettlementTaxMny(),vo.getSettlementTaxMny()));//截止本期已结算金额（含税，不含本期）
            spv.setLastMny(ComputeUtil.safeSub(vo.getCurrentSettlementMny(),vo.getSettlementMny()));//截止本期已结算金额(无税，不含本期)
            spv.setLastTax(ComputeUtil.safeSub(spv.getLastTaxMny(),spv.getLastMny()));//截止本期税额（不含本期）
        }
        logger.info("结算单对象 -> 结算池对象手动转换完成，下面开始推送至结算池");
    }

    /**
     * 计算差值
     * @param a 变量a
     * @param b 变量b
     * @return 差值的绝对值，当其中一个变量为null时 或 计算出来的差值为null时 返回null
     */
    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ExecutionVO targetCost(SettlementVO settlementVO, String linkUrl, Integer settlementType) {
        List<DetailExecutionVO> detailList = new ArrayList<>();
        // 计算所有过程结算累计结算金额
        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettlementEntity::getContractId, settlementVO.getContractId());
        wrapper.in(SettlementEntity::getBillState, Arrays.asList(1, 3));
        wrapper.eq(SettlementEntity::getDr,0);
        List<SettlementEntity> list = settlementService.list(wrapper);
        if (CollectionUtils.isEmpty(list)){
            throw new BusinessException("结算数据不存在");
        }
//        list.add(settlementService.selectById(settlementVO.getId()));
        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(SettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 查询合同
        ContractVO contractVO = contractService.queryDetail(settlementVO.getContractId());
        List<ContractDetailVO> contractDetailList = contractVO.getContractDetailList();

        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(settlementVO.getId());
        totalVO.setTenantId(settlementVO.getTenantId());
        totalVO.setBillCode(settlementVO.getBillCode());
        if (settlementType == 0) {
            totalVO.setBillType(MBILL_TYPE);
        }
        else {
            totalVO.setBillType(CBILL_TYPE);
        }
        switch (contractVO.getContractPropertyCode()){
            case "proMaterial-1": totalVO.setBussinessType(BussinessTypeEnum.大宗材物资采购合同.getCode());break;
            case "proMaterial-2": totalVO.setBussinessType(BussinessTypeEnum.周转材物资采购合同.getCode());break;
            case "proMaterial-3": totalVO.setBussinessType(BussinessTypeEnum.零星材料物资采购合同.getCode());break;
            case "contractConcrete-1": totalVO.setBussinessType(BussinessTypeEnum.混凝土采购合同.getCode());break;
        }
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setProjectId(settlementVO.getProjectId());
        totalVO.setOrgId(settlementVO.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub(totalSettleMny, contractVO.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub(totalSettleTaxMny, contractVO.getContractTaxMny()));
        totalVO.setLinkUrl(linkUrl);
        //获取结算子表进行汇总
        List<Long> settleIdList = list.stream().map(SettlementEntity::getId).collect(Collectors.toList());
        //根据结算单查询子表
        LambdaQueryWrapper<SettlementDetailEntity> detailWrapper = new LambdaQueryWrapper<>();
        detailWrapper.in(SettlementDetailEntity::getSettlementId, settleIdList);
        List<SettlementDetailEntity> settleDetailList = settlementDetailService.list(detailWrapper);
        if(CollectionUtils.isNotEmpty(settleDetailList)){
            //根据物资Id进行分组
            Map<Long, List<SettlementDetailEntity>> detailMaterialMap = settleDetailList.stream().collect(Collectors.groupingBy(SettlementDetailEntity::getMaterialId));
            Map<Long, List<ContractDetailVO>> contractDetailMap = contractDetailList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.groupingBy(ContractDetailVO::getMaterialId));
            if (!contractDetailMap.isEmpty()){
                for (Long materialId : detailMaterialMap.keySet()) {
                    List<SettlementDetailEntity> detailMaterialList = detailMaterialMap.get(materialId);
                    List<ContractDetailVO> contractDetailList1 = contractDetailMap.get(materialId);
                    //进行数量，金额汇总
                    BigDecimal contractSumNum = contractDetailList1.stream().filter(e -> e.getNum() != null).map(ContractDetailVO::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumMny = contractDetailList1.stream().filter(e -> e.getMoney() != null).map(ContractDetailVO::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumTaxMny = contractDetailList1.stream().filter(e -> e.getDetailTaxMny() != null).map(ContractDetailVO::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

                    BigDecimal sumNum = detailMaterialList.stream().filter(e -> e.getNum() != null).map(SettlementDetailEntity::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sumMny = detailMaterialList.stream().filter(e -> e.getMny() != null).map(SettlementDetailEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sumTaxMny = detailMaterialList.stream().filter(e -> e.getTaxMny() != null).map(SettlementDetailEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    SettlementDetailEntity planDetailVO = detailMaterialList.get(0);
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId());
                    detailExecutionVO.setSourceBillId(settlementVO.getId());
                    detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                    detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                    //判断是否是分类
                    if (planDetailVO.getMaterialId()==null){
                        detailExecutionVO.setCategoryFlag(true);
                        detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
                    }else {
                        detailExecutionVO.setCategoryFlag(false);
                        detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                    }
                    detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                    detailExecutionVO.setCategoryContainFlag(false);
                    //根据分类ID查询物料分类信息
                    MaterialCategoryVO categoryVO = materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    }
                    else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCode());
                    }
                    detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());
                    detailExecutionVO.setName(planDetailVO.getMaterialName());
                    detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                    detailExecutionVO.setUnitName(planDetailVO.getUnit());
                    detailExecutionVO.setPrice(planDetailVO.getPrice());
                    detailExecutionVO.setTaxPrice(planDetailVO.getTaxPrice());
                    detailExecutionVO.setNum(ComputeUtil.safeSub(sumNum, contractSumNum));
                    detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, contractSumMny));
                    detailExecutionVO.setSpec(planDetailVO.getSpec());
                    detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny,contractSumTaxMny));
                    detailList.add(detailExecutionVO);
                }
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(SettlementVO vo){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*参数控制区域*/
        //----start有合同预警域
        if(null!=vo.getContractId()) {
            ContractEntity contractEntity = contractService.selectById(vo.getContractId());
            paramsCheckVOS.addAll(this.checkParamsMnyList(contractEntity, vo));//金额 --组织分别控制
            //数量  proMaterial-1 - 大宗(主要)   proMaterial-2-周转  proMaterial-3-零星   混凝土不走
            logger.info("该结算单状态---{}", vo.getSettlementType());
            Boolean flag = true;
            if (vo.getSettlementType() == 0) {//是否消耗材结算
                if (!("proMaterial-1".equals(vo.getContractPropertyCode()))) {
                    flag = false;
                }
            }
            if (flag) {
                paramsCheckVOS.addAll(this.checkParamsNum(contractEntity, vo));//数量
            }
        }//------end有合同预警域------start无合同预警域
        else {
            if(CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))){//【施工合同金额】控【无合同结算、零星机械金额】*/
                paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
            }
            // 单次金额控制
            paramsCheckVOS.addAll(this.checkParamsMny(vo));
            // 单个供应商无合同结算金额控制
            paramsCheckVOS.addAll(this.checkParamsMnyBySupplier(vo));
        }
        //------end有合同预警域
        if(this.priceCheckParams(vo)!=null){//价格库控制
            paramsCheckVOS.add(this.priceCheckParams(vo));
        }
        /*--end---参数控制区域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                }
                else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    //价格库合同参数控制
    @Override
    public ParamsCheckVO priceCheckParams(SettlementVO vo) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        switch (vo.getSettlementType()){
            case 0: materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.消耗材结算.getCode());break;
            case 1: materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.混凝土结算.getCode());break;
        }
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(vo.getSettlementDetailList())){
            for (SettlementDetailVO detailVO : vo.getSettlementDetailList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                    MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getTaxPrice());
                    priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                    priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        ParamsCheckVO paramsCheckVO = priceHistoryService.priceCheckParams(materialPriceHistoryApiVO);
        return  paramsCheckVO;
    }

    /**
     * 单据管控-累计结算金额大于合同金额  --组织分别控制
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMnyList(ContractEntity contractEntity,SettlementVO vo) {
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny()==null?BigDecimal.ZERO:contractEntity.getContractTaxMny();
        String purchaseType = contractEntity.getPurchaseType();//采购类型 1-自采，2-集采
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        String CHECK_PARAM_CODE = "";
        if(vo.getSettlementType()==0){//类型（0-物资采购结算单，1-混凝土结算单）
            switch (vo.getSignatureType()){//("结算类型，0-过程,1-最终")
                case 0:CHECK_PARAM_CODE= M_PARAM_CODE_GC;break;
                case 1:CHECK_PARAM_CODE= M_PARAM_CODE_ZZ;break;
            }
        }else {
            switch (vo.getSignatureType()){//("结算类型，0-过程,1-最终")
                case 0:CHECK_PARAM_CODE= C_PARAM_CODE_GC;break;
                case 1:CHECK_PARAM_CODE= C_PARAM_CODE_ZZ;break;
            }
        }
        CommonResponse<List<BillParamVO>> billParamByCodeAndOrgId = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCodeAndOrgId.isSuccess() && null != billParamByCodeAndOrgId.getData()) {
            List<BillParamVO> data = billParamByCodeAndOrgId.getData();
            logger.info("结算金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO billParamByCode : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    Long orgId = billParamByCode.getOrgId();
                    String orgName = billParamByCode.getOrgName();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BillParamVO billParamVO = billParamByCode;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);

                    if ("2".equals(purchaseType)) {
                        // 集采合同直接赋值为不控制
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        continue;
                    } else {
                        paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    }

                    if (vo.getCurrentSettlementTaxMny().compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("合同超结");
                        paramsCheckDsVO.setOrgName(orgName);
                        paramsCheckDsVO.setWarnName("累计结算金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次结算金额：").append(vo.getSettlementTaxMny().toString())
                                .append("元，含本次累计结算金额：").append(vo.getCurrentSettlementTaxMny())
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny)
                                .append("元。超出金额：").append(ComputeUtil.safeSub(vo.getCurrentSettlementTaxMny(), comMny)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCodeAndOrgId.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }

    /**
     * 单据管控-累计结算数量大于合同数量
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsNum(ContractEntity contractEntity,SettlementVO vo) {
        String purchaseType = contractEntity.getPurchaseType();//采购类型 1-自采，2-集采
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        if (null!=purchaseType && "2".equals(purchaseType)) {
            // 集采合同不控制
            return paramsCheckVOS;
        }
        String CHECK_PARAM_CODE = "";
        if(vo.getSettlementType()==0){//类型（0-物资采购结算单，1-混凝土结算单）
            switch (vo.getSignatureType()){//("结算类型，0-过程,1-最终")
                case 0:CHECK_PARAM_CODE= MN_PARAM_CODE_GC;break;
                case 1:CHECK_PARAM_CODE= MN_PARAM_CODE_ZZ;break;
            }
        }else {
            switch (vo.getSignatureType()){//("结算类型，0-过程,1-最终")
                case 0:CHECK_PARAM_CODE= CN_PARAM_CODE_GC;break;
                case 1:CHECK_PARAM_CODE= CN_PARAM_CODE_ZZ;break;
            }
        }
        //查询结算累计子表
        List<SettlementDetailVO> detail = baseMapper.getDetail(contractEntity.getId(),vo.getId());
        Map<Long, SettlementDetailVO> detailSettleMap = detail.stream().collect(Collectors.toMap(SettlementDetailVO::getMaterialId, item -> item, (v1, v2) -> v2));
        //合同分类
        //Map<Long, ContractDetailEntity> typeMap = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() == null && !ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, item -> item, (v1, v2) -> v2));
        Map<Long, List<ContractDetailEntity>> typeMap = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() == null && !ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).collect(Collectors.groupingBy(ContractDetailEntity::getMaterialTypeId));

        //合同明细
        //Map<Long, ContractDetailEntity> map = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, item -> item, (v1, v2) -> v2));
        Map<Long, List<ContractDetailEntity>> map = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).collect(Collectors.groupingBy(ContractDetailEntity::getMaterialId));

        //当前单据吗明细 去重过累加过的的
        Map<Long, SettlementDetailVO> detailMap = new HashMap<>();
        //结算分类数量 分类数量 = 累计结算+本次 都不在的合同明细的明细数量累加
        Map<Long, BigDecimal> detailTypeMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(detail)){
            for (SettlementDetailVO detailVO : detail) {
                if(!map.containsKey(detailVO.getMaterialId())){//不属于明细
                    BigDecimal num = detailTypeMap.get(detailVO.getMaterialTypeId());
                    if(detailTypeMap.containsKey(detailVO.getMaterialTypeId())){//存在累加更新
                        detailTypeMap.put(detailVO.getMaterialTypeId(),ComputeUtil.safeAdd(num, detailVO.getNum()));
                    }else {//不存在，添加
                        detailTypeMap.put(detailVO.getMaterialTypeId(),detailVO.getNum());
                    }
                }
            }
        }
        //累计分类数量
        //当前明细去重 数量汇总
        if(CollectionUtils.isNotEmpty(vo.getSettlementDetailList())){
            for (SettlementDetailVO detailVO : vo.getSettlementDetailList()) {
                if(!"del".equals(detailVO.getRowState())){//去除删除的
                    SettlementDetailVO mapVO = detailMap.get(detailVO.getMaterialId());
                    if(Objects.nonNull(mapVO)){
                        detailVO.setNum(ComputeUtil.safeAdd(mapVO.getNum(), detailVO.getNum()));
                        detailMap.put(detailVO.getMaterialId(),detailVO);
                    }else{
                        detailMap.put(detailVO.getMaterialId(),detailVO);
                    }
                    if(!map.containsKey(detailVO.getMaterialId())){//不属于明细
                        BigDecimal num = detailTypeMap.get(detailVO.getMaterialTypeId());
                        if(detailTypeMap.containsKey(detailVO.getMaterialTypeId())){//存在累加更新
                            detailTypeMap.put(detailVO.getMaterialTypeId(),ComputeUtil.safeAdd(num, detailVO.getNum()));
                        }else {//不存在，添加
                            detailTypeMap.put(detailVO.getMaterialTypeId(),detailVO.getNum());
                        }
                    }
                }
            }
        }
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("结算数量控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if(CollectionUtils.isNotEmpty(detailMap.values())){
                        //遍历明细
                        for (SettlementDetailVO detailVO : detailMap.values()) {
                            BigDecimal num = detailSettleMap.containsKey(detailVO.getMaterialId())?detailSettleMap.get(detailVO.getMaterialId()).getNum():BigDecimal.ZERO;
                            //含本次结算数量  明细
                            BigDecimal totalNum = ComputeUtil.safeAdd(num, detailVO.getNum()).setScale(4, BigDecimal.ROUND_HALF_UP);
                            //含本次结算分类明细
                            BigDecimal numType = detailTypeMap.containsKey(detailVO.getMaterialTypeId())?detailTypeMap.get(detailVO.getMaterialTypeId()):BigDecimal.ZERO;
                            //合同数量
                            BigDecimal comNum = BigDecimal.ZERO;
                            //是否属于合同明细
                            if(map.containsKey(detailVO.getMaterialId())){
                                //ContractDetailEntity detailEntity = map.get(detailVO.getMaterialId());
                                BigDecimal detailNum = map.get(detailVO.getMaterialId()).stream().map(ContractDetailEntity::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                                //合同数量
                                comNum = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(detailNum, roleValue), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                                //是否属于合同分类
                            }else if(typeMap.containsKey(detailVO.getMaterialTypeId())) {
                                //ContractDetailEntity detailEntity = typeMap.get(detailVO.getMaterialTypeId());
                                BigDecimal detailNum = typeMap.get(detailVO.getMaterialTypeId()).stream().map(ContractDetailEntity::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                                //合同数量
                                comNum = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(detailNum,
                                        roleValue), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                                totalNum = numType;
                                //都不属于
                            }else {
                                //合同数量
                                comNum = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(BigDecimal.ZERO, roleValue), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                            }
                            if (totalNum.compareTo(comNum) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                paramsCheckDsVO.setWarnName("结算数量大于合同数量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append(detailVO.getMaterialName()).append(detailVO.getSpec()==null ? "" : " "+detailVO.getSpec()).append(" ").append("本次结算数量：").append(detailVO.getNum().setScale(4, BigDecimal.ROUND_HALF_UP))
                                        .append("，含本次累计结算数量：").append(totalNum.setScale(4, BigDecimal.ROUND_HALF_UP))
                                        .append("，合同数量*").append(roleValue).append("%:").append(comNum.setScale(4, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出数量：").append(ComputeUtil.safeSub(totalNum, comNum).setScale(4, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        }
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOS;
    }

    /*
     * 【施工合同金额】控【无合同结算、零星机械金额】*/
    @Override
    public List<ParamsCheckVO> checkParamsConstruction(SettlementVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        BigDecimal contractTaxMny = BigDecimal.ZERO;//施工合同金额
        BigDecimal mny = null==vo.getSettlementTaxMny()?BigDecimal.ZERO:vo.getSettlementTaxMny();//本次结算金额
        BigDecimal totalMny = mny;//无合同结算金额+临时设备金额   默认赋值本次结算金额
        //根据项目查询该项目下所有状态的 物资/混凝土结算金额累计
        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettlementEntity::getProjectId, vo.getProjectId());
        wrapper.isNull(SettlementEntity::getContractId);
        if(null!=vo.getId()){
            wrapper.ne(SettlementEntity::getId, vo.getId());
        }
        List<SettlementEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            BigDecimal totalSettleMny = list.stream().filter(e -> null!=e.getSettlementTaxMny()).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd(totalMny,totalSettleMny);//累加结算金额
        }
        //根据项目查询该项目下所有状态的【临时设备结算金额】
        CommonResponse<JSONObject> response = temporarySettlementApi.queryTemporarySettlementMny(vo.getProjectId());
        logger.info("该项目：{}-下所有状态的【临时设备结算金额】金额结果:{}",vo.getProjectId(),JSONObject.toJSONString(response));
        if(response.isSuccess() && null!=response.getData()){
            BigDecimal settleTaxMny = response.getData().getBigDecimal("settleTaxMny");
            totalMny = ComputeUtil.safeAdd(totalMny,settleTaxMny);//累加 临时设备结算金额
        }
        //根据项目查询施工合同金额
        CommonResponse<ContractRegisterVO> commonResponse = proincomeContrantApi.queryContranctMny(vo.getProjectId());
        logger.info("该项目:{}-下生效的最新正式施工合同:{}",vo.getProjectId(),JSONObject.toJSONString(commonResponse));
        if(commonResponse.isSuccess() && null!=commonResponse.getData()){
            contractTaxMny = null==commonResponse.getData().getContractTaxMny() ? BigDecimal.ZERO : commonResponse.getData().getContractTaxMny();
        }
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CON_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【施工合同金额】控【无合同结算、零星机械金额】信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    //施工合同百分比 后的金额
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100"));
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("无合同结算、临机费用超施工合同额");
                        paramsCheckDsVO.setWarnName("无合同结算、临机费用累计金额超施工合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(mny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次零材、零机发生金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        SettlementEntity entity = super.selectById(id);
        // 最终结算推送目标成本
        if (entity.getSignatureType()!=null && entity.getSignatureType()==1) {
            String linkUrl;
            if (entity.getSettlementType() == 0) {
                if (null == entity.getContractId() || 0==entity.getContractId()){
                    linkUrl = BaseHost + "ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + entity.getId();
                }else {
                    linkUrl = BaseHost + "ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + entity.getId();
                }
            }
            else {
                if (null == entity.getContractId() || 0==entity.getContractId()){
                    linkUrl = BaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + entity.getId();
                }else {
                    linkUrl =
                            BaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + entity.getId();
                }
            }
            ExecutionVO executionVO = this.targetCost(BeanMapper.map(entity, SettlementVO.class),linkUrl,
                    entity.getSettlementType());
            logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
        }
//        //目标成本推送
//        ExecutionVO executionVO = this.targetCost(this.queryDetail(id), BILL_TYPE, linkUrl);
//        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
//        CommonResponse<String> response = executionApi.aggPush(executionVO);
//        if (!response.isSuccess()) {
//            throw new BusinessException("目标成本推送失败," + response.getMsg());
//        }
        return CommonResponse.success("目标成本推送成功");
    }

    /**
     * 根据合同id查询当前合同下结算列表
     *
     * @param contractId 合同id
     * @return 查询结果
     */
    @Override
    public ContractSettlementRecordVO queryDetailRecord(Long contractId) {
        ContractSettlementRecordVO settleRecordVO = new ContractSettlementRecordVO();

        ContractEntity contract = contractService.selectById(contractId);
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());

        QueryWrapper<SettlementEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE
                .getBillStateCode());
        listQuery.orderByDesc("settlement_date");
        List<SettlementEntity> list = super.list(listQuery);
        List<SettlementVO> rentSettlementVOS = BeanMapper.mapList(list, SettlementVO.class);
        settleRecordVO.setSettleList(rentSettlementVOS);

        //累计结算金额
        BigDecimal contractSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            contractSettleMny = list.stream().map(SettlementEntity::getSettlementTaxMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        settleRecordVO.setContractSettleMny(contractSettleMny);

        if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
            settleRecordVO.setSettleRate(BigDecimal.ZERO);
        }
        else {
            settleRecordVO.setSettleRate((settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100)))
                    .divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        return settleRecordVO;
    }

    // 结算审批通过后/撤回后更新合同池累计结算金额（含税、无税、税额），type：是审批通过还是撤回标识，"true"审批通过后，"false"撤回后
    @Override
    public void updateContractPoolSettle(SettlementVO vo, Boolean type) {
        if(null!=vo.getContractId()) {//有合同推送
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + (type ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），settleEntity={}, 过程（0）/最终（1）={}, type={}", vo, vo.getSignatureType(), type);
            //计算累计计算金额
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;         // 累计结算金额含税初始化
            BigDecimal totalSettleMny = BigDecimal.ZERO;            // 累计结算金额无税初始化
            BigDecimal totalSettleTax = BigDecimal.ZERO;            // 累计结算税额初始化
            if (type) {
                totalSettleTaxMny = vo.getCurrentSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementTaxMny();
                totalSettleMny = vo.getCurrentSettlementMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementMny();
                totalSettleTax = ComputeUtil.safeSub(totalSettleTaxMny, totalSettleMny);
            } else {//撤回删除本次结算金额
                totalSettleTaxMny = ComputeUtil.safeSub(vo.getCurrentSettlementTaxMny(), vo.getSettlementTaxMny());
                totalSettleMny = ComputeUtil.safeSub(vo.getCurrentSettlementMny(), vo.getSettlementMny());
                totalSettleTax = ComputeUtil.safeSub(totalSettleTaxMny, totalSettleMny);
            }
            // 封装
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(vo.getContractId());
            contractPoolVO.setTotalSettleTaxMny(totalSettleTaxMny);        // 含税
            contractPoolVO.setTotalSettleMny(totalSettleMny);                 // 无税
            contractPoolVO.setTotalSettleTax(totalSettleTax);     // 税额
            if (1 == vo.getSignatureType()) {//signatureType; // 结算类型，0-过程,1-最终
                if (type) {//通过
                    contractPoolVO.setFinishSettleDate(new Date());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.已封账.getCode());//performanceStatus
                } else {
                    contractPoolVO.setFinishSettleDate(null);
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());//performanceStatus
                }
            }
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口入参：{}", JSONObject.toJSONString(contractPoolVO));
            CommonResponse<ContractPoolVO> updateConPoolRes = contractPoolApi.saveOrUpdateContract(contractPoolVO);
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口返回结果：{}", JSONObject.toJSONString(updateConPoolRes));
        }
    }

    @Override
    public CommonResponse<SettlementVO> pushCost(SettlementVO vo) {
        SettlementEntity entity = super.selectById(vo.getId());
        if (CollectionUtils.isNotEmpty(entity.getSettlementDetailList())) {
            List<SettlementDetailEntity> detailEntityList = BeanMapper.mapList(vo.getSettlementDetailList(), SettlementDetailEntity.class);
            entity.setSettlementDetailList(detailEntityList);
        }
        if (CollectionUtils.isNotEmpty(entity.getSettlementFeeList())) {
            List<SettlementFeeEntity> feeEntityList = BeanMapper.mapList(vo.getSettlementFeeList(), SettlementFeeEntity.class);
            entity.setSettlementFeeList(feeEntityList);
        }
        super.saveOrUpdate(entity, false);
        //推送数据
        this.costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, SettlementVO.class));
    }

    @Override
    public void costPush(SettlementEntity entity) {
        logger.info("开始costPush");
//        List<SettlementDetailEntity> detailList = entity.getSettlementDetailList();
        List<SettlementFeeEntity> feeList = entity.getSettlementFeeList();
        String newRelationFlag = "1";
//        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
//            for (SettlementDetailEntity detailEntity : detailList) {
//                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
//                    newRelationFlag = "0";
//                    break;
//                }
//            }
//        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (SettlementFeeEntity feeEntity : feeList) {
                if (null == feeEntity.getSubjectIdFee() || null == feeEntity.getWbsIdFee()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(feeList)) {
            newRelationFlag = "0";
        }
        //判断之前的单据是否关联
        String oldRelationFlag = entity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(entity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-领料出库Id---{}",entity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(entity.getId());
                logger.info("结果"+JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                //税率
                saveCost(entity);
            }
        }
        //更新是否关联
        LambdaUpdateWrapper<SettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(SettlementEntity::getId, entity.getId());
        updateWrapper.set(SettlementEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
        entity.setRelationFlag(newRelationFlag);
    }

    private void saveCost(SettlementEntity entity) {
        String linkUrl = "";
        String billName = "";
        String sourceType = "";
        if (entity.getSettlementType() == 0) {//0-消耗材 1 -混凝土
            if (null == entity.getContractId()){
                linkUrl ="/ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + entity.getId();
            }else {
                linkUrl = "/ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + entity.getId();
            }
            billName = SourceTypeEnum.材料采购结算.getTypeName();
            sourceType = "MATERIAL";
        }else {
            if (null == entity.getContractId()){
                linkUrl = "/ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + entity.getId();
            }else {
                linkUrl = "/ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + entity.getId();
            }
            billName = SourceTypeEnum.混凝土采购结算.getTypeName();
            sourceType = "CONCRETE";
        }
//        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
//        List<SettlementDetailEntity> detailList = entity.getSettlementDetailList();
        List<SettlementFeeEntity> feeList = entity.getSettlementFeeList();
//        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
//            for (SettlementDetailEntity detailEntity : detailList) {
//                CostDetailVO costDetailVO = new CostDetailVO();
//                costDetailVO.setSourceBillCode(entity.getBillCode());
//                costDetailVO.setSourceBillName(billName);
//                costDetailVO.setSourceBillUrl(linkUrl);
//                costDetailVO.setSubjectId(detailEntity.getSubjectId());
//                costDetailVO.setSubjectId(detailEntity.getSubjectId());
//                costDetailVO.setSubjectCode(detailEntity.getSubjectCode());
//                costDetailVO.setSubjectName(detailEntity.getSubjectName());
//                costDetailVO.setNum(detailEntity.getNum());
//                costDetailVO.setWbsId(detailEntity.getWbsId());
//                costDetailVO.setWbsCode(detailEntity.getWbsCode());
//                costDetailVO.setWbsName(detailEntity.getWbsName());
//                costDetailVO.setSourceId(entity.getId());
//                costDetailVO.setSourceDetailId(detailEntity.getId());
//                costDetailVO.setHappenTaxMny(detailEntity.getTaxMny());
//                costDetailVO.setHappenMny(detailEntity.getMny());
//                costDetailVO.setHappenDate(entity.getSettlementDate());
//                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
//                costDetailVO.setSourceType(sourceType+"_SETTLE");
//                costDetailVO.setSourceTabType(sourceType+"_SETTLE_DETAIL");
//                costDetailVO.setProjectId(entity.getProjectId());
//                costDetailVOList.add(costDetailVO);
//            }
//        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (SettlementFeeEntity feeEntity : feeList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(billName);
                costDetailVO.setSourceBillUrl(linkUrl);
                costDetailVO.setSubjectId(feeEntity.getSubjectIdFee());
                costDetailVO.setSubjectId(feeEntity.getSubjectIdFee());
                costDetailVO.setSubjectCode(feeEntity.getSubjectCodeFee());
                costDetailVO.setSubjectName(feeEntity.getSubjectNameFee());
                costDetailVO.setNum(feeEntity.getFeeNum());
                costDetailVO.setWbsId(feeEntity.getWbsIdFee());
                costDetailVO.setWbsCode(feeEntity.getWbsCodeFee());
                costDetailVO.setWbsName(feeEntity.getWbsNameFee());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setSourceDetailId(feeEntity.getId());
                costDetailVO.setHappenTaxMny(feeEntity.getFeeTaxMny());
                costDetailVO.setHappenMny(feeEntity.getFeeMny());
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(sourceType+"_SETTLE");
                costDetailVO.setSourceTabType(sourceType+"_SETTLE_FEE");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    /**
     * 根据合同id查询对应的结算列表
     *
     * @param settlementVO 合同id、结算类型
     * @return 查询结果
     */
    @Override
    public List<SettlementVO> querySettlementByContractId(SettlementVO settlementVO) {
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        List<SettlementVO> rtnList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            rtnList = BeanMapper.mapList(list, SettlementVO.class);
            for (SettlementVO vo : rtnList) {
                vo.setSettlementDateStr(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getSettlementDate()));
                vo.setBillCodeLink(vo.getBillCode());
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        return rtnList;
    }

    /**
     * 单据管控-单次无合同结算金额控制
     *
     * @param vo 结算信息
     * @return 控制结果
     */
    @Override
    public List<ParamsCheckVO> checkParamsMny(SettlementVO vo) {
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCodeAndOrgId = paramConfigApi
                .getBillParamByCodeAndOrgId(NO_CONTRACT_PARAM_CODE, vo.getOrgId());
        if (billParamByCodeAndOrgId.isSuccess() && null != billParamByCodeAndOrgId.getData()) {
            List<BillParamVO> data = billParamByCodeAndOrgId.getData();
            logger.info("单次无合同结算金额控制信息返回：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    BigDecimal mny = null == vo.getSettlementTaxMny() ? BigDecimal.ZERO : vo.getSettlementTaxMny();//本次使用金额
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (mny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("本次结算金额超过限定金额");
                        paramsCheckDsVO.setWarnName("单次无合同结算金额超限定金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(mny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，限定金额：").append(roleValue.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：")
                                .append(ComputeUtil.safeSub(mny, roleValue).setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        }
        else {
            logger.info(billParamByCodeAndOrgId.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    /**
     * 单据管控-单个供应商无合同结算金额控制
     *
     * @param vo 结算信息
     * @return 控制结果
     */
    @Override
    public List<ParamsCheckVO> checkParamsMnyBySupplier(SettlementVO vo) {
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCodeAndOrgId = paramConfigApi
                .getBillParamByCodeAndOrgId(NO_CONTRACT_SUPPLIER_PARAM_CODE, vo.getOrgId());
        if (billParamByCodeAndOrgId.isSuccess() && null != billParamByCodeAndOrgId.getData()) {
            List<BillParamVO> data = billParamByCodeAndOrgId.getData();
            logger.info("供应商无合同结算金额控制信息返回：" + JSONObject.toJSONString(data));
            // 根据项目+供应商查询所有状态的无合同材料结算+无合同混凝土结算金额+本期金额
            BigDecimal mny = this.getNoContractSupplierMny(vo);
            BigDecimal thisMny = CommonUtils.setBigDecimalDefaultValue(vo.getSettlementTaxMny());
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (mny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("供应商无合同结算金额超过限定金额");
                        paramsCheckDsVO.setWarnName("供应商无合同结算金额超过限定金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(thisMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计结算金额").append(mny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，限定金额：").append(roleValue.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：")
                                .append(ComputeUtil.safeSub(mny, roleValue).setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        }
        else {
            logger.info(billParamByCodeAndOrgId.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    /**
     * 根据项目+供应商查询所有状态的无合同材料结算+无合同混凝土结算金额+本期金额
     *
     * @param vo 结算信息
     * @return 查询结果
     */
    private BigDecimal getNoContractSupplierMny(SettlementVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, vo.getProjectId()));
        queryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, vo.getSupplierId()));
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, null));
        if (vo.getId() != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, vo.getId()));
        }
        List<SettlementEntity> entityList = super.queryList(queryParam, false);
        BigDecimal sum = CommonUtils.setBigDecimalDefaultValue(vo.getSettlementTaxMny());
        if (CollectionUtils.isEmpty(entityList)) return sum;
        for (SettlementEntity entity : entityList) {
            sum = sum.add(CommonUtils.setBigDecimalDefaultValue(entity.getSettlementTaxMny()));
        }
        return sum;
    }

    /**
     * 查询打印结算单材料明细，按子表材料+入库单价+结算单价  一致时合并；
     *
     * @param settlementVO 结算单信息
     * @return 查询结果
     */
    @Override
    public List<PrintSettlementDetailVO> queryPrintSettlementDetail(SettlementVO settlementVO) {
        List<PrintSettlementDetailVO> rtnList = new ArrayList<>();
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        if (CollectionUtils.isEmpty(list)) {
            return rtnList;
        }
        List<Long> idList = list.stream().map(SettlementEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settlementId", new Parameter(QueryParam.IN, idList));
        List<SettlementDetailEntity> detailEntityList = settlementDetailService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(detailEntityList)) return rtnList;
        // 查找本期数据
        Map<Long, List<SettlementDetailEntity>> thisMap = new HashMap<>();
        if (settlementVO.getId() != null) {
            List<SettlementDetailEntity> thisDetailList = detailEntityList.stream()
                    .filter(t -> t.getSettlementId().equals(settlementVO.getId())).collect(Collectors.toList());
            thisMap = thisDetailList.stream().collect(Collectors.groupingBy(SettlementDetailEntity::getMaterialId));
        }
        // 组装数据，相同的合同
        Map<String, PrintSettlementDetailVO> map = new HashMap<>();
        String key;
        for (SettlementDetailEntity detailEntity : detailEntityList) {
            key = "" + detailEntity.getMaterialId() + detailEntity.getStoreTaxPrice() + detailEntity.getTaxPrice();
            PrintSettlementDetailVO printVo;
            if (map.containsKey(key)) {
                printVo = map.get(key);
                BigDecimal storeSum = CommonUtils.addBigDecimal(printVo.getStoreNum(), detailEntity.getStoreNum());
                BigDecimal sum = CommonUtils.addBigDecimal(printVo.getNum(), detailEntity.getNum());
                BigDecimal storeTaxMny = CommonUtils.addBigDecimal(printVo.getStoreTaxMny(), detailEntity.getStoreTaxMny());
                BigDecimal taxMny = CommonUtils.addBigDecimal(printVo.getTaxMny(), detailEntity.getTaxMny());

                printVo.setStoreNum(storeSum);
                printVo.setNum(sum);
                printVo.setStoreTaxMny(storeTaxMny);
                printVo.setTaxMny(taxMny);
                printVo.setSettleDiff(CommonUtils.subtractBigDecimal(printVo.getTaxMny(), printVo.getStoreTaxMny()));
            }
            else {
                printVo = BeanMapper.map(detailEntity, PrintSettlementDetailVO.class);
                List<SettlementDetailEntity> thisMaterialList = thisMap.get(detailEntity.getMaterialId());
                BigDecimal thisSettleNum = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(thisMaterialList)) {
                    for (SettlementDetailEntity settlementDetailEntity : thisMaterialList) {
                        thisSettleNum = thisSettleNum.add(CommonUtils.setBigDecimalDefaultValue(settlementDetailEntity.getNum()));
                    }
                }
                printVo.setThisSettleNum(thisSettleNum);
                printVo.setSettleDiff(CommonUtils.subtractBigDecimal(printVo.getTaxMny(), printVo.getStoreTaxMny()));
                map.put(key, printVo);
            }
        }
        rtnList = new ArrayList<>(map.values());
        // 排序
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator
                    .comparing(PrintSettlementDetailVO::getThisSettleNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed()
                    .thenComparing(PrintSettlementDetailVO::getNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed());
        }
        return rtnList;
    }

    /**
     * 查询打印结算单其他费用，当其他费用来源于合同同一清单时，合并
     *
     * @param settlementVO 结算单信息
     * @return 查询结果
     */
    @Override
    public List<PrintSettlementFeeVO> queryPrintSettlementFee(SettlementVO settlementVO) {
        List<PrintSettlementFeeVO> rtnList = new ArrayList<>();
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        if (CollectionUtils.isEmpty(list)) {
            return rtnList;
        }
        List<Long> idList = list.stream().map(SettlementEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settlementId", new Parameter(QueryParam.IN, idList));
        List<SettlementFeeEntity> feeEntityList = settlementFeeService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(feeEntityList)) return rtnList;
        // 查找本期数据
        Map<Long, List<SettlementFeeEntity>> thisMap = new HashMap<>();
        Map<Long, SettlementFeeEntity> thisNoContractMap = new HashMap<>();
        if (settlementVO.getId() != null) {
            List<SettlementFeeEntity> thisDetailList = feeEntityList.stream()
                    .filter(t -> t.getSettlementId().equals(settlementVO.getId())).collect(Collectors.toList());
            // 来源合同的sourceId不为空，sourceId=contractId，sourceDetailId=对应合同其他费用id
            thisMap = thisDetailList.stream().filter(t -> t.getSourceId() != null)
                    .collect(Collectors.groupingBy(SettlementFeeEntity::getSourceDetailId));
            // 无合同处理 不进行合同
            thisNoContractMap = thisDetailList.stream().filter(t -> t.getSourceId() == null)
                    .collect(Collectors.toMap(SettlementFeeEntity::getId, Function.identity(), (key1, key2) -> key2));
        }
        // 组装数据，相同的合同
        Map<String, PrintSettlementFeeVO> map = new HashMap<>();
        for (SettlementFeeEntity feeEntity : feeEntityList) {
            // 来源不是合同的跳过处理
            PrintSettlementFeeVO printFeeVo;
            if (feeEntity.getSourceId() == null) {
                printFeeVo = BeanMapper.map(feeEntity, PrintSettlementFeeVO.class);
                SettlementFeeEntity thisFeeEntity = thisNoContractMap.get(feeEntity.getId());
                if (thisFeeEntity != null) {
                    printFeeVo.setThisFeeNum(CommonUtils.setBigDecimalDefaultValue(thisFeeEntity.getFeeNum()));
                }
                rtnList.add(printFeeVo);
                continue;
            }
            String key = "" + feeEntity.getSourceId() + feeEntity.getSourceDetailId();
            if (map.containsKey(key)) {
                printFeeVo = map.get(key);
                BigDecimal feeNum = CommonUtils.addBigDecimal(printFeeVo.getFeeNum(), feeEntity.getFeeNum());
                BigDecimal feeTaxMny = CommonUtils.addBigDecimal(printFeeVo.getFeeTaxMny(), feeEntity.getFeeTaxMny());

                printFeeVo.setFeeNum(feeNum);
                printFeeVo.setFeeTaxMny(feeTaxMny);
            }
            else {
                printFeeVo = BeanMapper.map(feeEntity,PrintSettlementFeeVO.class);
                List<SettlementFeeEntity> thisFeeList = thisMap.get(feeEntity.getSourceDetailId());
                BigDecimal thisNum = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(thisFeeList)) {
                    for (SettlementFeeEntity feeEntity1 : thisFeeList) {
                        thisNum = thisNum.add(CommonUtils.setBigDecimalDefaultValue(feeEntity1.getFeeNum()));
                    }
                }
                printFeeVo.setThisFeeNum(thisNum);
                map.put(key, printFeeVo);
            }
        }
        rtnList.addAll(new ArrayList<>(map.values()));
        // 排序 默认按其中本期数量 从 大到小排序，当本期数量一致或为空时，按结算数量从大到小排序
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator
                    .comparing(PrintSettlementFeeVO::getThisFeeNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed()
                    .thenComparing(PrintSettlementFeeVO::getFeeNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed());
        }
        return rtnList;
    }

    /**
     * 根据合同id查询结算单列表
     *
     * @param settlementVO 合同id、结算单类型
     * @return 查询结果
     */
    private List<SettlementEntity> queryListByContractId(SettlementVO settlementVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, settlementVO.getContractId()));
        queryParam.getParams().put("settlementType", new Parameter(QueryParam.EQ, settlementVO.getSettlementType()));
//        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
//        if(settlementVO.getId() != null){
//            queryParam.getParams().put("id", new Parameter(QueryParam.NE, settlementVO.getId()));
//        }
        queryParam.getOrderMap().put("settlementDate", QueryParam.DESC);
        return super.queryList(queryParam, false);
    }

}
