package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.plan.bean.*;
import com.ejianc.business.promaterial.plan.service.*;
import com.ejianc.business.promaterial.plan.vo.MasterPlanDetailChangeVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("masterPlanChange") 
public class MasterPlanChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IMasterPlanService masterPlanService;

	@Autowired
	private IMasterPlanDetailService masterPlanDetailService;

	@Autowired
	private IMasterPlanChangeService masterPlanChangeService;

	@Autowired
	private IMasterPlanChangeHisService masterPlanChangeHisService;
	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IMasterPlanDetailChangeHisService masterPlanDetailChangeHisService;
	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		logger.info("总计划变更提交审批回调--billId:{}, state: {}", billId, state);

		//此处billId即为单据Id
		MasterPlanChangeEntity entity =masterPlanChangeService.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		//设置提交人信息
		entity.setCommitDate(new Date());
		entity.setCommitUserCode(userContext.getUserCode());
		entity.setCommitUserName(userContext.getUserName());

		masterPlanChangeService.saveOrUpdate(entity, false);

		return CommonResponse.success("总计划变更提交审批回调成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
	    // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("总计划变更撤回回调处理：billId: {}, state: {}", billId, state);
		MasterPlanChangeEntity planChange = masterPlanChangeService.selectById(billId);

		//清空总计划变更提交人信息
		planChange.setCommitUserName(null);
		planChange.setCommitUserCode(null);
		planChange.setCommitDate(null);

		masterPlanChangeService.saveOrUpdate(planChange, false);

		return CommonResponse.success("总计划变更撤回回调处理成功！");
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
//		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)){
			logger.info("总计划变更审批完成回调处理：billId: {}, state: {}", billId, state);
			//查询变更计划
			MasterPlanChangeEntity planChange = masterPlanChangeService.selectById(billId);
			MasterPlanEntity newPlanEntity = null;
			//查询原计划
			MasterPlanEntity oldPlan = masterPlanService.selectById(planChange.getSourcePlanId());
		//变更计划附件复制到主计划
		if(oldPlan.getPlanType()==0){//消耗材
			CommonResponse<String> stringCommonResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT211224000000004", "materPlan001", String.valueOf(oldPlan.getId()), "BT211224000000003", "materPlan001");
			if(!stringCommonResponse.isSuccess()){
				logger.info("消耗材变更附件复制到主附件------", JSONObject.toJSONString(stringCommonResponse));
			}else {
				logger.info("消耗材更附件复制到主附件------", JSONObject.toJSONString(stringCommonResponse));
			}
		}else if(oldPlan.getPlanType()==1){//混凝土
			CommonResponse<String> stringCommonResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT220211000000003", "materPlan001", String.valueOf(oldPlan.getId()), "BT220211000000002", "materPlan001");
			if(!stringCommonResponse.isSuccess()){
				logger.info("混泥土变更附件复制到主附件失败------", JSONObject.toJSONString(stringCommonResponse));
			}else {
				logger.info("混泥土变更附件复制到主附件成功------", JSONObject.toJSONString(stringCommonResponse));
			}
		}
		/*处理变更计划主表信息*/
			if(state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
				//直审时记录
				UserContext userContext = sessionManager.getUserContext();
				//设置提交人信息
				planChange.setCommitDate(new Date());
				planChange.setCommitUserCode(userContext.getUserCode());
				planChange.setCommitUserName(userContext.getUserName());
			}
			//设置总计划变更单据生效时间
			planChange.setEffectiveDate(new Date());

			//1、复制计划信息到计划记录
			MasterPlanChangeHisEntity recordEntity = BeanMapper.map(oldPlan, MasterPlanChangeHisEntity.class);
			logger.info("总计划变更审批完成回调, 总计划变更信息：【{}】, 变更前总计划信息: 【{}】", JSON.toJSONString(planChange), JSON.toJSONString(oldPlan));

			//设置总计划Id
			recordEntity.setSourcePlanId(oldPlan.getId());
			//Id置为空
			recordEntity.setId(null);
			//子表处理
			if(CollectionUtils.isNotEmpty(recordEntity.getMasterPlanDetailList())) {
				recordEntity.getMasterPlanDetailList().stream().forEach(detail -> {
					detail.setTargetId(detail.getId());
					detail.setId(null);
				});
			}
			/*记录主表信息处理*/
			//设置编制人等信息
			recordEntity.setCreateUserCode(planChange.getCreateUserCode());
			recordEntity.setCreateTime(planChange.getCreateTime());
			recordEntity.setCreateUserName(planChange.getCreateUserName());
			recordEntity.setModifyUserName(planChange.getModifyUserName());
			recordEntity.setUpdateTime(planChange.getUpdateTime());
			recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
			recordEntity.setCommitDate(planChange.getCommitDate());
			recordEntity.setCommitUserCode(planChange.getCommitUserCode());
			recordEntity.setCommitUserName(planChange.getCommitUserName());
			recordEntity.setEffectiveDate(planChange.getEffectiveDate());
			recordEntity.setOriginalPlanAmt(oldPlan.getTotalPlanAmt());
			recordEntity.setTotalPlanAmt(planChange.getTotalPlanAmt());
			recordEntity.setChangePlanId(planChange.getId());
			recordEntity.setChangeUserName(planChange.getChangeUserName());
			recordEntity.setChangeReason(planChange.getChangeReason());
			if(null == recordEntity.getTotalPlanAmt()) {
				recordEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
			}
			if(null == recordEntity.getOriginalPlanAmt()) {
				recordEntity.setOriginalPlanAmt(BigDecimal.ZERO.setScale(8));
			}
			recordEntity.setChangeAmount(recordEntity.getTotalPlanAmt().subtract(recordEntity.getOriginalPlanAmt()));
			if(recordEntity.getOriginalPlanAmt().compareTo(BigDecimal.ZERO) == 0) {
				recordEntity.setChangeRatio(0d);
			} else {
				recordEntity.setChangeRatio(recordEntity.getChangeAmount().divide(recordEntity.getOriginalPlanAmt(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue());
			}

			//总计划变更记录保存
			masterPlanChangeHisService.saveOrUpdate(recordEntity, false);
			//更新变更记录表中末级的的parentId,根据从主表带过来的parentId查询当前父级的主键Id 赋值给当前末级  begin
			recordEntity.getMasterPlanDetailList().forEach((item)->{
				if(item.getLeafFlag()==true && item.getParentId()!=null){
					QueryWrapper<MasterPlanDetailChangeHisEntity> query = new QueryWrapper<>();
					query.eq("target_id", item.getParentId());
					query.eq("material_master_plan_id", item.getMaterialMasterPlanId());
					MasterPlanDetailChangeHisEntity one = masterPlanDetailChangeHisService.getOne(query);
					if(one!=null){
						item.setParentId(one.getId());
					}
				}
			});
			//总计划变更记录再次保存更新
			masterPlanChangeHisService.saveOrUpdate(recordEntity, false);

			//变更计划信息更新
			masterPlanChangeService.saveOrUpdate(planChange, false);

			//修改总计划字段  复制变更计划{回显原计划用}
			newPlanEntity = BeanMapper.map(planChange, MasterPlanEntity.class);
			/*
			 * 更新主表信息
			 * */
			//变更状态-已变更
			newPlanEntity.setChangeState(MasterPlanVO.PLAN_CHANGE_STATE_CHANGED);
			//清空当前变更计划id
			newPlanEntity.setCurChangingPlanId(null);
			//合同初始创建信息
			newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
			newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
			newPlanEntity.setCreateTime(oldPlan.getCreateTime());
			newPlanEntity.setId(oldPlan.getId());
			newPlanEntity.setVersion(oldPlan.getVersion());
			newPlanEntity.setChangeVersion(planChange.getChangeVersion());

			//子表信息设置

			List<Long> delDetailIds = new ArrayList<>();//原计划要删除的子表

			List<MasterPlanDetailEntity> updatePlanDetail = new ArrayList<>();//要更新的子表
		logger.info("回显原计划子表开始！");
//		("变更类型: 1-增补项，2-删除项，3-变更项,0-未变更")
			List<MasterPlanDetailEntity> oldList = oldPlan.getMasterPlanDetailList();//原计划 子表
			Map<Long, MasterPlanDetailEntity> map1 = oldList.stream().filter(t -> t.getId() != null).collect(Collectors.toMap(MasterPlanDetailEntity::getId, item -> item, (v1, v2) -> v2));
			if(CollectionUtils.isNotEmpty(newPlanEntity.getMasterPlanDetailList())) {//遍历变更计划子表
				for (MasterPlanDetailEntity detail : newPlanEntity.getMasterPlanDetailList()) {
					if(detail.getChangeType()==2){//删除
						delDetailIds.add(detail.getTargetId());
					}else {
						if(null!=detail.getTargetId()){//修改
							if(map1.containsKey(detail.getTargetId())){
								MasterPlanDetailEntity masterPlanDetail = map1.get(detail.getTargetId());
								masterPlanDetail.setChangeType(detail.getChangeType());
								masterPlanDetail.setNum(detail.getNum());
								masterPlanDetail.setPrice(detail.getPrice());
								masterPlanDetail.setAmount(detail.getAmount());
								masterPlanDetail.setSurplusNums(detail.getSurplusNums());
								updatePlanDetail.add(masterPlanDetail);
							}

						}else {//新增
							detail.setId(null);
							updatePlanDetail.add(detail);
						}
					}
				}
			}
			if(CollectionUtils.isNotEmpty(updatePlanDetail)){
				masterPlanDetailService.saveOrUpdateBatch(updatePlanDetail);
			}
			newPlanEntity.setMasterPlanDetailList(updatePlanDetail);
			if(CollectionUtils.isNotEmpty(delDetailIds)){
				masterPlanDetailService.removeByIds(delDetailIds);//原计划删除
			}
		logger.info("回显原计划子表结束！");
//			newPlanEntity.setMasterPlanDetailList(planChange.getMasterPlanDetailList());
			masterPlanService.saveOrUpdate(newPlanEntity, false);
//			QueryWrapper<MasterPlanDetailEntity> wrapper = new QueryWrapper<>();
//			wrapper.eq("material_master_plan_id",newPlanEntity.getId());
//			List<MasterPlanDetailEntity> detailList = masterPlanDetailService.list(wrapper);
			Map<Long, Long> map = new HashMap<>();
			QueryWrapper<MasterPlanDetailEntity> wrapper = new QueryWrapper<>();
			wrapper.eq("material_master_plan_id",oldPlan.getId());
			List<MasterPlanDetailEntity> list = masterPlanDetailService.list(wrapper);
			if(CollectionUtils.isNotEmpty(list)){
				logger.info("原计划子表树形构造，序号设置开始！");
				for (MasterPlanDetailEntity masterPlanDetail : list) {
					if(masterPlanDetail.getMaterialId()==null){
						map.put(masterPlanDetail.getMaterialCategoryId(),masterPlanDetail.getId());
					}
				}
				for (MasterPlanDetailEntity masterPlanDetail : list) {
					masterPlanDetail.setTargetId(masterPlanDetail.getId());
					if(masterPlanDetail.getMaterialId()!=null){
						if (map.containsKey(masterPlanDetail.getMaterialCategoryId())){
							masterPlanDetail.setParentId(map.get(masterPlanDetail.getMaterialCategoryId()));
						}else {
							masterPlanDetail.setParentId(null);
						}
					}
				}
				Map<Long, MasterPlanDetailEntity> map2 = new HashMap<>();
				Map<Long, Integer> map3 = new HashMap<>();
				Integer index = 1;
				for (MasterPlanDetailEntity masterPlanDetail : list) {
					if(masterPlanDetail.getParentId()==null){
						masterPlanDetail.setTreeIndex(index.toString());
						map2.put(masterPlanDetail.getId(),masterPlanDetail);
						index++;
						map3.put(masterPlanDetail.getId(),1);
					}
				}
				for (MasterPlanDetailEntity masterPlanDetail : list) {
					if(masterPlanDetail.getParentId()!=null){
						if(map2.containsKey(masterPlanDetail.getParentId())){
							String treeIndex = map2.get(masterPlanDetail.getParentId()).getTreeIndex();
							Integer integer = map3.get(masterPlanDetail.getParentId());
							masterPlanDetail.setTreeIndex(treeIndex+"."+integer);
							integer++;
							map3.put(masterPlanDetail.getParentId(),integer);
						}
					}
				}
				logger.info("原计划子表树形构造，序号设置结束！");
				if(masterPlanDetailService.saveOrUpdateBatch(list)) {
					return CommonResponse.success("回调业务处理成功！");
				}
				return CommonResponse.success("回调业务处理失败！");
			}
		return CommonResponse.success("审批通过后回调完成！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		if(state != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
			CommonResponse.success("有审批流程的变更总计划无法执行该操作！");
		}
		return CommonResponse.success("总计划变更弃审回调处理成功！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("总计划变更弃审回调处理：billId: {}, state: {}", billId, state);
		MasterPlanChangeEntity planChange = masterPlanChangeService.selectById(billId);

		//清空总计划变更提交人信息
		planChange.setCommitUserName(null);
		planChange.setCommitUserCode(null);
		planChange.setCommitDate(null);

		QueryWrapper<MasterPlanChangeHisEntity> hisQuery = new QueryWrapper<>();
		hisQuery.eq("change_plan_id", billId);
		MasterPlanChangeHisEntity hisEntity = masterPlanChangeHisService.getOne(hisQuery);

		if(null != hisEntity) {
			//数据恢复至审批完成前的数据状态
			MasterPlanEntity newPlanEntity = null;
			MasterPlanEntity oldPlan = masterPlanService.selectById(planChange.getSourcePlanId());

			logger.info("总计划执行弃审数据恢复逻辑，当前数据【{}】，待恢复数据【{}】", oldPlan, hisEntity);
			//数据恢复
			newPlanEntity = BeanMapper.map(hisEntity, MasterPlanEntity.class);
			newPlanEntity.setCurChangingPlanId(hisEntity.getChangePlanId());
			//恢复创建人等信息
			newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
			newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
			newPlanEntity.setCreateTime(oldPlan.getCreateTime());
			newPlanEntity.setId(oldPlan.getId());
			newPlanEntity.setVersion(oldPlan.getVersion());
			newPlanEntity.setChangeVersion(planChange.getChangeVersion());

			//变更状态-变更中
			newPlanEntity.setChangeState(MasterPlanVO.PLAN_CHANGE_STATE_CHANGING);
			//总计划金额
			newPlanEntity.setTotalPlanAmt(hisEntity.getOriginalPlanAmt());
			newPlanEntity.setChangeVersion(planChange.getChangeVersion() - 1);

			//子表信息设置
			List<Long> delDetailIds = new ArrayList<>();
			if(CollectionUtils.isNotEmpty(planChange.getMasterPlanDetailList())) {
				List<MasterPlanDetailEntity> list = new ArrayList<>();
				MasterPlanDetailEntity tmp = null;
				Map<Long, Integer> map = oldPlan.getMasterPlanDetailList().stream().collect(Collectors.toMap(MasterPlanDetailEntity::getId, MasterPlanDetailEntity::getVersion));

				for(MasterPlanDetailChangeEntity detail : planChange.getMasterPlanDetailList()) {
					tmp = BeanMapper.map(detail, MasterPlanDetailEntity.class);

					if(null != detail.getTargetId()) {
						tmp.setVersion(map.get(detail.getTargetId()));
						tmp.setId(detail.getTargetId());
						if(detail.getChangeType().equals(MasterPlanDetailChangeVO.CHANGE_TYPE_ADD)) {
							//删除新增项
							delDetailIds.add(detail.getId());
						} else {
							list.add(tmp);
						}
					} else {
						//删除新增项
						delDetailIds.add(detail.getId());
					}
				}

				newPlanEntity.setMasterPlanDetailList(list);
			}

			//删除已有子表
			if(CollectionUtils.isNotEmpty(delDetailIds)) {
				masterPlanDetailService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
			}

			//删除变更记录
			masterPlanChangeHisService.removeById(hisEntity.getId(), false);

			masterPlanService.saveOrUpdate(newPlanEntity, false);
		}

		if(masterPlanChangeService.saveOrUpdate(planChange, false)) {
			return CommonResponse.success("回调业务处理成功！");
		}
		return CommonResponse.success("总计划变更弃审回调处理成功！");
	}

}
