package com.ejianc.business.promaterial.plan.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanMapper;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMonthPlanDetailService;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.business.promaterial.plan.vo.MonthPlanVO;
import com.ejianc.business.promaterial.plan.vo.PlanTypeEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.plan.mapper.MonthPlanMapper;
import com.ejianc.business.promaterial.plan.bean.MonthPlanEntity;
import com.ejianc.business.promaterial.plan.service.IMonthPlanService;

import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;
import java.math.BigDecimal;
import java.sql.Time;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资月计划
 * 
 * @author generator
 * 
 */
@Service("monthPlanService")
public class MonthPlanServiceImpl extends BaseServiceImpl<MonthPlanMapper, MonthPlanEntity> implements IMonthPlanService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE_C = "MONTH_PLAN_CODE";//消耗材
    private static final String BILL_CODE_H = "HNTYJH01";//混凝土

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMonthPlanService service;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private MonthPlanMapper mapper;

    @Override
    public IPage<MonthPlanVO> queryConcreteList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("operatorName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 计划类型隔离 */
        param.getParams().put("planType", new Parameter(QueryParam.EQ, PlanTypeEnum.混泥土.getCode()));
        if(!param.getParams().containsKey("orgId")){
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<MonthPlanEntity> page = service.queryPage(param,false);
        IPage<MonthPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthPlanVO.class));
        return pageData;
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @Override
    public void excelConcreteExport(QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 计划类型隔离 */
        param.getParams().put("planType", new Parameter(QueryParam.EQ, PlanTypeEnum.混泥土.getCode()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MonthPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<MonthPlanVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, MonthPlanVO.class);
            voList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("ConcreteMonthPlan-export.xlsx", beans, response);
    }
//根据项目id,判断该月是否有计划
    @Override
    public boolean monthQueryPlan(Long projectId, Date planMonth,Integer planType,Long id) {
        try {
            String monthDate = DateFormatUtil.formatDate("yyyy-MM", planMonth);
            List<MonthPlanVO> list  = baseMapper.monthQueryPlan(projectId, monthDate,planType,id);
            if(CollectionUtils.isNotEmpty(list)){
                return true;
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("该项目本月已是否存在月计划校验失败！");
        }
        return false;
    }

    @Override
    public CommonResponse<MonthPlanVO> saveOrUpdate(MonthPlanVO saveorUpdateVO) {
        MonthPlanEntity entity = BeanMapper.map(saveorUpdateVO, MonthPlanEntity.class);
        if(StringUtils.isNotBlank(entity.getBillCode())) {
            //编码重复校验
            MonthPlanVO voByCode = service.queryByCode(entity.getBillCode(),entity.getPlanType());
            if(null != voByCode && (null == entity.getId() || !voByCode.getId().equals(entity.getId()))) {
                throw new BusinessException("保存失败，编码重复！");
            }
        } else {
            String BILL_CODE = "";
            switch (entity.getPlanType()){
                case 0:BILL_CODE = BILL_CODE_C;break;
                case 1:BILL_CODE =BILL_CODE_H;break;
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveorUpdateVO);
            CommonResponse<String> codeResp = billCodeApi.generateBillCode(billCodeParam);
            if(!codeResp.isSuccess()) {
                throw new BusinessException("保存失败，获取自动编码失败！");
            }
            entity.setBillCode(codeResp.getData());
        }
        if(entity.getId() == null || entity.getId() == 0){
            //设置编制日期
            String today = DateUtil.today();
            Date date = DateUtil.parse(today);
            entity.setBillDate(date);
        }
        boolean b = service.monthQueryPlan(entity.getProjectId(), entity.getPlanMonth(),entity.getPlanType(),entity.getId());
        if(b){
            String msg = "";
            switch (entity.getPlanType()){
                case 0:msg = "保存失败，该项目本月已存在消耗材月计划，请勿重复添加！";break;
                case 1:msg ="保存失败，该项目本月已存在混凝土月计划，请勿重复添加！";break;
            }
            throw new BusinessException(msg);
        }
        //name拼接
        entity.setName(DateFormatUtil.formatDate("yyyy-MM-dd",entity.getPlanMonth())+" "+entity.getBillCode());
        List<MonthPlanDetailEntity> monthPlanDetailEntities = entity.getMonthPlanDetailEntities();
        List<MasterPlanDetailEntity> masterDetailList = new ArrayList<>();
        for (MonthPlanDetailEntity monthPlanDetailEntitie: monthPlanDetailEntities){
            monthPlanDetailEntitie.setSurplusNums(monthPlanDetailEntitie.getMonthPlanNum());//对剩余量初始化
            monthPlanDetailEntitie.setName(entity.getName());//子表name初始化
        }

        super.saveOrUpdate(entity, false);
        MonthPlanVO vo = BeanMapper.map(entity, MonthPlanVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    //根据编码查询
    @Override
    public MonthPlanVO queryByCode(String planCode,Integer planType) {
        MonthPlanVO resp = null;
        QueryWrapper<MonthPlanEntity> query = new QueryWrapper<>();
        query.eq("bill_code", planCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
//        query.eq("plan_type", planType);
        MonthPlanEntity entity = mapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, MonthPlanVO.class);
        }
        return resp;
    }

}
