/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.contract.bean.ContractChangeEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.promaterial.contract.enums.MaterialContractTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractChangeService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contractFileUpdate/"})
public class ContractFileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISignatureManageApi signatureManageApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IContractChangeService changeService;

    @PostMapping(value={"updateFileInfo"})
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(updateData.getLong("billId")));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));
        contract.setContractFileSyncFlag(true);
        this.contractService.saveOrUpdate((Object)contract, false);
        resp.put("message", (Object)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        resp.put("billData", (Object)contract);
        return CommonResponse.success((String)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"getSignedFileInfo"})
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value="billId") Long billId, @RequestParam(value="billType") String billType) {
        BaseEntity entity;
        JSONObject resp = new JSONObject();
        String contractBillTypeStr = "contract";
        ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
        ContractVO cv = new ContractVO();
        if (contractBillTypeStr.equals(billType)) {
            entity = (ContractEntity)((Object)this.contractService.selectById(billId));
            Assert.notNull((Object)entity, (String)"\u67e5\u8be2\u4e0d\u5230\u4e3b\u5408\u540c\u8be6\u60c5");
            cv.setContractId(entity.getId());
            cv.setContractName(entity.getContractName());
            cv.setSourceType(billType);
            cv.setBillType(BillTypeEnum.\u6d88\u8017\u6750\u5408\u540c.getCode());
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(entity.getContractType())) {
                cv.setBillType(BillTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getCode());
            }
        } else {
            entity = (ContractChangeEntity)((Object)this.changeService.selectById(billId));
            Assert.notNull((Object)entity, (String)"\u67e5\u8be2\u4e0d\u5230\u53d8\u66f4\u5408\u540c\u8be6\u60c5");
            cv.setContractId(entity.getId());
            cv.setContractName(entity.getContractName());
            cv.setSourceType(billType);
            cv.setBillType(BillTypeEnum.\u6d88\u8017\u6750\u5408\u540c\u53d8\u66f4.getCode());
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(entity.getContractType())) {
                cv.setBillType(BillTypeEnum.\u6df7\u51dd\u571f\u53d8\u66f4\u5408\u540c.getCode());
            }
        }
        cvs.add(cv);
        CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
        if (!signResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5355\u636eid-{}\uff0cbillType-{}\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: {}", new Object[]{billId, billType, signResp.getMsg()});
            return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25!");
        }
        List fileList = (List)signResp.getData();
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            return CommonResponse.error((String)"\u672a\u83b7\u53d6\u5230\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\uff01");
        }
        SignMgrPreviewVO signedFileInfo = (SignMgrPreviewVO)((List)signResp.getData()).get(0);
        if (contractBillTypeStr.equals(billType)) {
            ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(billId));
            contract.setSignedFileId(signedFileInfo.getFileId());
            this.contractService.saveOrUpdate((Object)contract, false);
        } else {
            ContractChangeEntity contractChange = (ContractChangeEntity)((Object)this.changeService.selectById(billId));
            contractChange.setSignedFileId(signedFileInfo.getFileId());
            this.changeService.saveOrUpdate((Object)contractChange, false);
        }
        resp.put("fileId", (Object)signedFileInfo.getFileId());
        resp.put("filePath", (Object)signedFileInfo.getFilePath());
        resp.put("fileTruePath", (Object)signedFileInfo.getTruePath());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"getBillDataJson"})
    public CommonResponse<com.ejianc.business.promaterial.contract.vo.ContractVO> getBillDataJson(@RequestParam Long id) {
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(id));
        com.ejianc.business.promaterial.contract.vo.ContractVO vo = (com.ejianc.business.promaterial.contract.vo.ContractVO)BeanMapper.map((Object)((Object)contract), com.ejianc.business.promaterial.contract.vo.ContractVO.class);
        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,##0.00");
        if (CollectionUtils.isNotEmpty((Collection)vo.getContractDetailList())) {
            vo.getContractDetailList().forEach(item -> {
                item.setDetailPriceStr(null != item.getPrice() ? priceFmt.format(item.getPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setDetailTaxPriceStr(null != item.getDetailTaxPrice() ? priceFmt.format(item.getDetailTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setDetailMnyStr(null != item.getMoney() ? mnyFmt.format(item.getMoney()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxMnyStr(null != item.getDetailTaxMny() ? mnyFmt.format(item.getDetailTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxStr(null != item.getDetailTax() ? mnyFmt.format(item.getDetailTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxRateStr(null != item.getDetailTaxRate() ? mnyFmt.format(item.getDetailTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailNumStr(null != item.getNum() ? priceFmt.format(item.getNum()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getContractFeeList())) {
            vo.getContractFeeList().forEach(item -> {
                item.setFreePriceStr(null != item.getFreePrice() ? priceFmt.format(item.getFreePrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setFreeTaxPriceStr(null != item.getFreeTaxPrice() ? priceFmt.format(item.getFreeTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setFreeMnyStr(null != item.getFreeMoney() ? mnyFmt.format(item.getFreeMoney()) : mnyFmt.format(BigDecimal.ZERO));
                item.setFreeTaxMnyStr(null != item.getFreeTaxMny() ? mnyFmt.format(item.getFreeTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setFreeTaxStr(null != item.getFreeTax() ? mnyFmt.format(item.getFreeTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setFreeNumStr(null != item.getFreeNum() ? priceFmt.format(item.getFreeNum()) : priceFmt.format(BigDecimal.ZERO));
                item.setFreeTaxRateStr(null != item.getFreeTaxRate() ? mnyFmt.format(item.getFreeTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getContractStageList())) {
            vo.getContractStageList().forEach(item -> item.setStageScaleStr(null != item.getStageScale() ? mnyFmt.format(item.getStageScale()) : mnyFmt.format(BigDecimal.ZERO)));
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getContractClauseList())) {
            vo.getContractClauseList().forEach(item -> item.setNecessaryStatusStr(null != item.getNecessaryStatus() && item.getNecessaryStatus() == 1 ? "\u662f" : "\u5426"));
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getContractAdmixtureList())) {
            vo.getContractAdmixtureList().forEach(item -> item.setPriceStr(null != item.getPrice() ? priceFmt.format(item.getPrice()) : priceFmt.format(BigDecimal.ZERO)));
        }
        return CommonResponse.success((Object)vo);
    }
}

