/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.contract.service.impl;

import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.mapper.ContractDetailMapper;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="contractDetailService")
public class ContractDetailServiceImpl
extends BaseServiceImpl<ContractDetailMapper, ContractDetailEntity>
implements IContractDetailService {
    @Override
    public String getContractDetailByTree(Long contractId) {
        return this.queryContractDetailToString(contractId, true);
    }

    @Override
    public String getContractDetailByTable(Long contractId) {
        return this.queryContractDetailToString(contractId, false);
    }

    @Override
    public List<ContractDetailVO> getContractDetail(Long contractId) {
        List<ContractDetailEntity> list = this.queryContractDetail(contractId, true);
        return BeanMapper.mapList(list, ContractDetailVO.class);
    }

    private String queryContractDetailToString(Long contractId, boolean flag) {
        List<ContractDetailEntity> list = this.queryContractDetail(contractId, flag);
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty(list)) {
            for (ContractDetailEntity entity : list) {
                sb.append(entity.getMaterialTypeId()).append(",");
            }
            if (sb.length() > 0) {
                sb.delete(sb.length() - 1, sb.length());
            }
        }
        return sb.toString();
    }

    private List<ContractDetailEntity> queryContractDetail(Long contractId, boolean flag) {
        if (contractId == null) {
            throw new BusinessException("\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
        if (flag) {
            queryParam.getParams().put("material_id", new Parameter("eq", null));
        } else {
            queryParam.getParams().put("material_id", new Parameter("ne", null));
        }
        return super.queryList(queryParam);
    }
}

