/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.promaterial.contract.enums.DraftTypeEnum;
import com.ejianc.business.promaterial.contract.enums.MaterialContractTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.enums.PurchaseTypeEnum;
import com.ejianc.business.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractAsyncService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contract")
public class ContractBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    private IContractAsyncService contractAsyncService;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ContractEntity e = (ContractEntity)((Object)this.contractService.selectById(billId));
        this.logger.info("---------------------------------------------------------------------DraftType\uff1a" + e.getDraftType());
        if (DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString().equals(e.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(e.getDraftType())) {
            String billType = "BT211227000000003";
            String sourceType = "mContractFile";
            if (e.getContractType() == 1) {
                billType = "BT220215000000001";
                sourceType = "mContractFile";
            }
            CommonResponse attachListResp = this.attachmentApi.queryListBySourceId(e.getId(), billType, sourceType, null);
            this.logger.info("\u83b7\u53d6\u9644\u4ef6\u5185\u5bb9\uff1a" + JSONObject.toJSONString((Object)attachListResp.getData()));
            if (!attachListResp.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)attachListResp.getData()))) {
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u5931\u8d25, \u8bf7\u68c0\u67e5\u5408\u540c\u6587\u4ef6\u6216\u91cd\u65b0\u4e0a\u4f20\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ContractEntity e = (ContractEntity)((Object)this.contractService.selectById(billId));
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(e.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(e.getDraftType())) {
            if (null == e.getContractFileId()) {
                return CommonResponse.error((String)"\u8bf7\u7f16\u8f91\u5408\u540c\u6587\u4ef6\u5e76\u4fdd\u5b58\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
            }
            if (!e.getContractFileSyncFlag().booleanValue()) {
                return CommonResponse.error((String)"\u8bf7\u91cd\u65b0\u8fdb\u884c\u5408\u540c\u7f16\u8f91\uff0c\u540c\u6b65\u5355\u636e\u4fe1\u606f\u5230\u5408\u540c\u6587\u4ef6\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        ContractEntity e = (ContractEntity)((Object)this.contractService.selectById(billId));
        this.logger.info("\u5ba1\u6279\u8282\u70b9\u5ba1\u6279\u4e2d\u65f6\u8282\u70b9\u5ba1\u6279\u524d\u56de\u8c03:  \u5f53\u524d\u6570\u636e-{}", (Object)JSONObject.toJSONString((Object)((Object)e)));
        if ((DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(e.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(e.getDraftType())) && !e.getContractFileSyncFlag().booleanValue()) {
            return CommonResponse.error((String)"\u8bf7\u91cd\u65b0\u8fdb\u884c\u5408\u540c\u7f16\u8f91\uff0c\u540c\u6b65\u5355\u636e\u4fe1\u606f\u5230\u5408\u540c\u6587\u4ef6\uff01");
        }
        if (DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString().equals(e.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(e.getDraftType())) {
            String billType = "BT211227000000003";
            String sourceType = "mContractFile";
            if (e.getContractType() == 1) {
                billType = "BT220215000000001";
                sourceType = "mContractFile";
            }
            CommonResponse attachListResp = this.attachmentApi.queryListBySourceId(e.getId(), billType, sourceType, null);
            this.logger.info("\u83b7\u53d6\u9644\u4ef6\u5185\u5bb9\uff1a" + JSONObject.toJSONString((Object)attachListResp.getData()));
            if (!attachListResp.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)attachListResp.getData()))) {
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u5931\u8d25, \u8bf7\u68c0\u67e5\u5408\u540c\u6587\u4ef6\u6216\u91cd\u65b0\u4e0a\u4f20\uff01");
            }
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(billId));
        if (contractEntity != null) {
            if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(contractEntity.getDraftType())) {
                this.logger.info("\u5408\u540cid-{}\u4e3a\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u4e3a\u7b7e\u7ae0\u72b6\u6001\u5e76\u8bbe\u7f6e\u4e3a\u5c65\u7ea6\u4e2d", (Object)billId);
                contractEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                contractEntity.setEffectiveDate(new Date());
            } else if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(contractEntity.getDraftType()) && contractEntity.getContractFileId() != null && contractEntity.getContractFileSyncFlag().booleanValue()) {
                this.logger.info("\u5408\u540cid-{}\u4e3a\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0\u76f4\u63a5\u4fee\u6539\u4e3a\u7b7e\u7ae0\u72b6\u6001\u5e76\u8bbe\u7f6e\u4e3a\u5c65\u7ea6\u4e2d", (Object)billId);
                contractEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                contractEntity.setEffectiveDate(new Date());
            }
            if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contractEntity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(contractEntity.getDraftType())) {
                if (null == contractEntity.getContractFileId()) {
                    return CommonResponse.error((String)"\u8bf7\u7f16\u8f91\u5408\u540c\u6587\u4ef6\u5e76\u4fdd\u5b58\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
                }
                if (!contractEntity.getContractFileSyncFlag().booleanValue()) {
                    return CommonResponse.error((String)"\u8bf7\u91cd\u65b0\u8fdb\u884c\u5408\u540c\u7f16\u8f91\uff0c\u540c\u6b65\u5355\u636e\u4fe1\u606f\u5230\u5408\u540c\u6587\u4ef6\uff01");
                }
            }
            this.checkContractFile(contractEntity);
        }
        this.contractService.saveOrUpdate((Object)contractEntity);
        this.contractService.asyncWatermarkById(billId);
        this.contractService.pushContract((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class));
        return CommonResponse.success((String)"\u5408\u540c\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(billId));
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contractEntity.getDraftType()) || DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString().equals(contractEntity.getDraftType())) {
            if (!statusList.contains(contractEntity.getSignatureStatus())) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
            }
        } else if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus())) {
            contractEntity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            boolean delWatermarkflag;
            Long conorgid = contractEntity.getParentOrgId();
            CommonResponse conResp = this.orgApi.getOneById(conorgid);
            if (!conResp.isSuccess() || !conResp.isSuccess()) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            Long currentOrg = InvocationInfoProxy.getOrgId();
            String innerCode = ((OrgVO)conResp.getData()).getInnerCode();
            if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(contractEntity.getPurchaseType()) && !innerCode.contains(String.valueOf(currentOrg))) {
                return CommonResponse.error((String)("\u5f53\u524d\u96c6\u91c7\u5408\u540c\u7f16\u5236\u7ec4\u7ec7\u662f\u3010" + contractEntity.getParentOrgName() + "\u3011\uff0c\u4e0d\u53ef\u64a4\u56de\uff01"));
            }
            this.contractService.pushDelContract((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class));
            if (contractEntity.getWatermarkContractFileId() != null && (delWatermarkflag = this.contractService.delWatermarkContractFile(contractEntity.getWatermarkContractFileId()))) {
                contractEntity.setWatermarkContractFileId(null);
            }
            contractEntity.setSignedFileId(null);
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            contractEntity.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
            this.contractService.saveOrUpdate((Object)contractEntity, false);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private void checkContractFile(ContractEntity contractEntity) {
        CommonResponse attachResp = this.attachmentApi.queryDetail(contractEntity.getContractFileId().toString());
        if (!attachResp.isSuccess() || null == attachResp.getData()) {
            String sourceType = "mContractFile";
            String billType = BillTypeEnum.\u6d88\u8017\u6750\u5408\u540c.getCode();
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractEntity.getContractType())) {
                sourceType = "mContractFile";
                billType = BillTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getCode();
            }
            this.logger.info("\u5408\u540c\u5b58\u50a8\u6587\u4ef6Id-{}\u5728\u6587\u4ef6\u4e2d\u5fc3\u4e0d\u5b58\u5728\uff0c\u6839\u636e\u53c2\u6570sourceId-{}, sourceType-{}, billType-{} \u67e5\u8be2\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f", new Object[]{contractEntity.getContractFileId(), contractEntity.getId(), sourceType, billType});
            CommonResponse attachListResp = this.attachmentApi.queryListBySourceId(contractEntity.getId(), billType, sourceType, "desc");
            this.logger.info("\u6839\u636e\u53c2\u6570sourceId-{}, sourceType-{}, billType-{} \u67e5\u8be2\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u7ed3\u679c\uff1a{}", new Object[]{contractEntity.getId(), sourceType, billType, JSONObject.toJSONString((Object)attachListResp)});
            if (attachListResp.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)attachListResp.getData()))) {
                AttachmentVO attachmentVO = (AttachmentVO)((List)attachListResp.getData()).get(0);
                this.logger.info("\u5c06\u5408\u540cid-{}\u5bf9\u5e94\u5408\u540c\u6587\u4ef6Id-{}\u6539\u4e3a{}", new Object[]{contractEntity.getId(), contractEntity.getContractFileId(), attachmentVO.getId()});
                contractEntity.setContractFileId(attachmentVO.getId());
                contractEntity.setContractFilePath(attachmentVO.getTruePath());
            } else {
                throw new BusinessException("\u5ba1\u6279\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u5931\u8d25, \u8bf7\u68c0\u67e5\u5408\u540c\u6587\u4ef6\uff01");
            }
        }
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray arr = new JSONArray();
        this.logger.info("sign:{}", (Object)sign);
        if ("choseCostUser".equals(sign)) {
            ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(billId));
            Long projectId = entity.getProjectId();
            JSONObject jsonObject = new JSONObject();
            CommonResponse commonResponse = this.projectPoolApi.queryProjectPoolById(projectId);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5931\u8d25!");
            }
            JSONArray array = (JSONArray)commonResponse.getData();
            List vos = JSONObject.parseArray((String)array.toJSONString(), ProjectPoolSetVO.class);
            this.logger.info("vos:{}", (Object)JSONObject.toJSONString((Object)vos));
            ProjectPoolSetVO vo = (ProjectPoolSetVO)vos.get(0);
            Long costAdapter = vo.getCostAdapter();
            String costAdapterName = vo.getCostAdapterName();
            this.logger.info("userId:{}", (Object)costAdapter);
            this.logger.info("userName:{}", (Object)costAdapterName);
            jsonObject.put("userId", (Object)costAdapter);
            jsonObject.put("userName", (Object)costAdapterName);
            arr.add((Object)jsonObject);
        }
        return CommonResponse.success((Object)arr);
    }
}

