/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.check.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.CheckWeighEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckEntity;
import com.ejianc.business.promaterial.check.mapper.CheckMapper;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.ICheckWeighService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckService;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.check.vo.CheckWeighTypeEnum;
import com.ejianc.business.promaterial.check.vo.CheckWeighVO;
import com.ejianc.business.promaterial.check.vo.WeighUnitEnum;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PurchaseTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.MaterialMnyVO;
import com.ejianc.business.promaterial.delivery.bean.DeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.DeliveryTypeEnum;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.order.bean.ConcreteOrderDetailEntity;
import com.ejianc.business.promaterial.order.service.IConcreteOrderDetailService;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceCheckTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.temporary.userecord.api.ITemporaryUseRecordApi;
import com.ejianc.business.weigh.weighbill.api.IWeighbillApi;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IConcreteOrderDetailService concreteOrderDetailService;
    @Autowired
    private IDeliveryService deliveryService;
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialDelivery/saveMaterialDeliveryState";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IWeighbillApi weighbillApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ICheckWeighService checkWeighService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String CHECK_MNY_CODE = "P-2dnh8V0139";
    private static final String CHECK_SUB_MNY_CODE = "P-Tl9Zyr0141";
    private final String[] ALLOW_WEIGH_UNIT = new String[]{"\u5343\u514b", "\u516c\u65a4", "KG", "kg", "Kg", "T", "t", "\u5428"};
    @Autowired
    private IConcreteCheckService concreteCheckService;
    @Autowired
    private IProincomeContractApi proincomeContrantApi;
    @Autowired
    private ITemporaryUseRecordApi temporaryUseRecordApi;
    private static final String BILL_CODE = "XHC-CHECK-CODE";
    private final String OPERATE = "XHC_CHECK_SYNC";
    private static final String BILL_TYPE = "BT220215000000006";
    private static final String CHECK_PARAM_CODE = "P-44841Z56";
    private static final String CHECK_MNY_CON_CODE = "P-n01oAU0146";
    private final String CHECK_SUPPLIER_PARAM = "p-c213331233";

    @Override
    @Transactional
    public CheckVO saveOrUpdates(CheckVO saveOrUpdateVO, Boolean isControl) {
        OrgVO orgVO;
        CommonResponse orgResponse;
        if (!isControl.booleanValue() && saveOrUpdateVO.getId() != null) {
            CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
            Boolean isOldPush = false;
            if (checkEntity.getCheckType().equals("proMaterial-2")) {
                isOldPush = true;
            }
            if (!checkEntity.getCheckType().equals("proMaterial-2") && checkEntity.getAttrFlag().equals(1)) {
                isOldPush = true;
            }
            if (isOldPush.booleanValue()) {
                ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
                ExecutionVO executionVO = this.targetCost(checkEntity);
                totalExecutionVOList.add(executionVO.getTotalVO());
                CommonResponse responses = this.executionApi.aggDel(totalExecutionVOList);
                if (!responses.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u63a8\u9001\u5931\u8d25" + responses.getMsg());
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
        }
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CheckEntity.class));
        if (!(isControl.booleanValue() || entity.getId() != null && entity.getId() != 0L)) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (null == entity.getCheckWeighType()) {
                entity.setCheckWeighType(CheckWeighTypeEnum.\u5426\u78c5\u5355\u9a8c\u6536.getCode());
            }
            if (null == entity.getAutomaticWeigh()) {
                entity.setAutomaticWeigh(1);
            }
        }
        entity.setSignStatus(0);
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        entity.setRelationFlag("0");
        entity.setProportionFlag("0");
        if (!isControl.booleanValue()) {
            if (CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode().equals(entity.getCheckWeighType())) {
                ArrayList<CheckWeighEntity> checkWeighListDel = new ArrayList<CheckWeighEntity>();
                for (CheckWeighEntity checkWeighEntity : entity.getCheckWeighList()) {
                    if (!"del".equals(checkWeighEntity.getRowState())) continue;
                    checkWeighListDel.add(checkWeighEntity);
                }
                this.delWeighBill(checkWeighListDel);
            }
            super.saveOrUpdate((Object)entity, false);
            if (CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode().equals(entity.getCheckWeighType())) {
                this.addOrUpdateWeighBill(entity.getCheckDetailList(), entity.getCheckWeighList());
            }
        } else {
            if (null == entity.getId()) {
                entity.setId(IdWorker.getId());
            }
            List<CheckDetailEntity> detailEntityList = entity.getCheckDetailList();
            ArrayList<CheckDetailEntity> detailEntityListNew = new ArrayList<CheckDetailEntity>();
            if (CollectionUtils.isNotEmpty(detailEntityList)) {
                for (CheckDetailEntity cdEntity : detailEntityList) {
                    if (null == cdEntity.getId()) {
                        cdEntity.setId(IdWorker.getId());
                    }
                    if ("del".equals(cdEntity.getRowState())) continue;
                    detailEntityListNew.add(cdEntity);
                }
                entity.setCheckDetailList(detailEntityListNew);
            }
        }
        if (entity.getSourceType() == 1 && !isControl.booleanValue()) {
            Integer checkStatus = 0;
            DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(entity.getDeliveryId()));
            LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
            lambdaQueryWrapper.eq(CheckDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
            List checkDetailEntityList = this.checkDetailService.list((Wrapper)lambdaQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)checkDetailEntityList)) {
                Map<Long, List<CheckDetailEntity>> checkMap = checkDetailEntityList.stream().collect(Collectors.groupingBy(CheckDetailEntity::getDeliveryDetailId));
                LambdaQueryWrapper lambdaDeliveryDetail = Wrappers.lambdaQuery();
                lambdaDeliveryDetail.eq(DeliveryDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
                List deliveryDetailEntityList = this.deliveryDetailService.list((Wrapper)lambdaDeliveryDetail);
                for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                    List<CheckDetailEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)) {
                        BigDecimal checkNum = checkAllDetailEntityList.stream().map(CheckDetailEntity::getCheckNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        deliveryDetailEntity.setCheckNum(checkNum);
                    }
                    if (null != deliveryDetailEntity.getCheckNum()) continue;
                    deliveryDetailEntity.setCheckNum(BigDecimal.ZERO);
                }
                Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
                Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> e.getCheckNum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNum().compareTo(e.getDeliveryNum()) == -1);
                if (allCheck.booleanValue()) {
                    checkStatus = 2;
                }
                if (anyCheck.booleanValue()) {
                    checkStatus = 1;
                }
                deliveryEntity.setCheckStatus(checkStatus);
                this.deliveryService.updateById((Object)deliveryEntity);
                this.deliveryDetailService.updateBatchById(deliveryDetailEntityList);
            }
            if (!DeliveryTypeEnum.\u81ea\u5236\u9001\u8d27\u5355.getCode().equals(deliveryEntity.getDeliveryType())) {
                CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sourceId", deliveryEntity.getSourceId());
                map.put("checkStatus", checkStatus);
                map.put("systemId", ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(map);
                Boolean updateSupplierStatus = this.deliveryService.updateSupplierStatus(deliveryEntity.getId(), dataInfo, "/ejc-supbusiness-web/openapi/materialDelivery/saveMaterialDeliveryState", RequestMethod.POST, deliveryEntity.getSupplierId().toString(), "XHC_CHECK_SYNC", BILL_TYPE);
                if (!updateSupplierStatus.booleanValue()) {
                    throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
                }
            }
        }
        if (!isControl.booleanValue()) {
            Long contractId = saveOrUpdateVO.getContractId();
            Integer attrFlag = saveOrUpdateVO.getAttrFlag();
            String string = saveOrUpdateVO.getCheckType();
            Boolean isPush = false;
            if (string.equals("proMaterial-2")) {
                isPush = true;
            }
            if (!string.equals("proMaterial-2") && attrFlag.equals(1)) {
                isPush = true;
            }
            if (isPush.booleanValue()) {
                ExecutionVO executionVO = this.targetCost(entity);
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                CommonResponse response = this.executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25:" + response.getMsg());
                }
            }
        }
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return vo;
    }

    private void delWeighBill(List<CheckWeighEntity> checkWeighList) {
        ArrayList<WeighbillVO> upDateWeighBill = new ArrayList<WeighbillVO>();
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            for (CheckWeighEntity checkWeighEntity : checkWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                weighbillVO.setCheckId(checkWeighEntity.getCheckId());
                weighbillVO.setCheckDetailId(checkWeighEntity.getId());
                weighbillVO.setId(checkWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(Integer.valueOf(0));
                upDateWeighBill.add(weighbillVO);
            }
        }
        if (CollectionUtils.isNotEmpty(upDateWeighBill)) {
            this.logger.info("\u4fdd\u5b58\u5220\u9664\u56de\u663e\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(upDateWeighBill));
            this.weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }

    public void updSmartStore(List<Long> usedIds, List<Long> unuseIds) {
        try {
            if (CollectionUtils.isNotEmpty(usedIds) || CollectionUtils.isNotEmpty(unuseIds)) {
                if (CollectionUtils.isNotEmpty(usedIds) && CollectionUtils.isNotEmpty(unuseIds)) {
                    unuseIds.removeAll(usedIds);
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("usedIds", usedIds);
                jsonObject.put("unuseIds", unuseIds);
                String resStr = HttpTookit.postByJson((String)"https://portal.17elian.com/ejc-ai-web/smartBill/updInStoreState", (String)JSONObject.toJSONString((Object)jsonObject));
                this.logger.info("\u90d1\u5dde\u4e00\u5efa \u4fee\u6539\u5165\u5e93\u72b6\u6001 \u8bf7\u6c42\u53c2\u6570 usedIds={}\uff0cunuseIds={} \uff0c\u54cd\u5e94={}", new Object[]{usedIds, unuseIds, resStr});
            }
        }
        catch (Exception e) {
            this.logger.error("\u90d1\u5dde\u4e00\u5efa \u4fee\u6539\u5165\u5e93\u72b6\u6001 \u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private void addOrUpdateWeighBill(List<CheckDetailEntity> checkDetailList, List<CheckWeighEntity> checkWeighList) {
        ArrayList<WeighbillVO> upDateWeighBill = new ArrayList<WeighbillVO>();
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            for (CheckWeighEntity checkWeighEntity : checkWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                if (CollectionUtils.isNotEmpty(checkDetailList)) {
                    for (CheckDetailEntity checkDetailEntity : checkDetailList) {
                        if (null == checkWeighEntity.getDeliveryDetailId() || !checkWeighEntity.getDeliveryDetailId().equals(checkDetailEntity.getDeliveryDetailId())) continue;
                        weighbillVO.setCheckId(checkDetailEntity.getCheckId());
                        weighbillVO.setCheckDetailId(checkDetailEntity.getId());
                        checkWeighEntity.setCheckDetailId(checkDetailEntity.getId());
                        checkWeighEntity.setCheckStatus(1);
                    }
                }
                weighbillVO.setId(checkWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(Integer.valueOf(1));
                upDateWeighBill.add(weighbillVO);
            }
        }
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            this.logger.info("\u65b0\u589e\u4fee\u6539\u66f4\u65b0\u9a8c\u6536\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(checkWeighList));
            this.checkWeighService.updateBatchById(checkWeighList);
        }
        if (CollectionUtils.isNotEmpty(upDateWeighBill)) {
            this.logger.info("\u65b0\u589e\u4fee\u6539\u56de\u663e\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(upDateWeighBill));
            this.weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }

    private ExecutionVO targetCost(CheckEntity checkEntity) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(checkEntity.getId());
        totalVO.setTenantId(checkEntity.getTenantId());
        totalVO.setBillCode(checkEntity.getBillCode());
        totalVO.setBillType(BILL_TYPE);
        if (checkEntity.getCheckType().equals("proMaterial-1")) {
            totalVO.setBussinessType(BussinessTypeEnum.\u5927\u5b97\u6750\u9a8c\u6536\u5355.getCode());
        }
        if (checkEntity.getCheckType().equals("proMaterial-2")) {
            totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u9a8c\u6536\u5355.getCode());
        }
        if (checkEntity.getCheckType().equals("proMaterial-3")) {
            totalVO.setBussinessType(BussinessTypeEnum.\u96f6\u661f\u6750\u6599\u9a8c\u6536\u5355.getCode());
        }
        if (checkEntity.getCheckType().equals("proMaterial-4")) {
            totalVO.setBussinessType(null);
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5165\u5e93.getCode());
        totalVO.setProjectId(checkEntity.getProjectId());
        totalVO.setOrgId(checkEntity.getOrgId());
        String url = null;
        if (checkEntity.getContractId() == null) {
            url = this.baseHost + "ejc-promaterial-frontend/#/check/card?id=" + checkEntity.getId();
        }
        if (checkEntity.getContractId() != null) {
            url = this.baseHost + "ejc-promaterial-frontend/#/check/contractCard?id=" + checkEntity.getId();
        }
        totalVO.setLinkUrl(url);
        totalVO.setBillDate(checkEntity.getCheckDate() == null ? null : checkEntity.getCheckDate().toString());
        BigDecimal checkMoney = BigDecimal.ZERO;
        BigDecimal checkTaxMoney = BigDecimal.ZERO;
        for (CheckDetailEntity checkDetailEntity : checkEntity.getCheckDetailList()) {
            checkMoney = checkMoney.add(checkDetailEntity.getCheckMny());
            checkTaxMoney = checkTaxMoney.add(checkDetailEntity.getCheckTaxMny());
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(Long.valueOf(checkDetailEntity.getId() == null ? IdWorker.getId() : checkDetailEntity.getId()));
            detailExecutionVO.setSourceBillId(checkEntity.getId());
            detailExecutionVO.setCategoryId(checkDetailEntity.getMaterialTypeId());
            detailExecutionVO.setCategoryName(checkDetailEntity.getMaterialTypeName());
            detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
            detailExecutionVO.setCode(checkDetailEntity.getMaterialCode());
            detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
            MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(checkDetailEntity.getMaterialTypeId()).getData();
            if (categoryVO == null) {
                detailExecutionVO.setCategoryInnerCode(null);
                detailExecutionVO.setCategoryCode(null);
            } else {
                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                detailExecutionVO.setCategoryCode(categoryVO.getCode());
            }
            detailExecutionVO.setDocId(checkDetailEntity.getMaterialId());
            detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
            detailExecutionVO.setName(checkDetailEntity.getMaterialName());
            detailExecutionVO.setUnitId(checkDetailEntity.getUnitId());
            detailExecutionVO.setUnitName(checkDetailEntity.getUnit());
            detailExecutionVO.setSpec(checkDetailEntity.getSpec());
            detailExecutionVO.setNum(checkDetailEntity.getCheckNum());
            detailExecutionVO.setMoney(checkDetailEntity.getCheckMny());
            detailExecutionVO.setTaxMoney(checkDetailEntity.getCheckTaxMny());
            detailExecutionVO.setPrice(checkDetailEntity.getCheckPrice());
            detailExecutionVO.setTaxPrice(checkDetailEntity.getCheckTaxPrice());
            detailExecutionVO.setTaxRate(checkDetailEntity.getTaxRate());
            detailList.add(detailExecutionVO);
        }
        totalVO.setMoney(checkMoney);
        totalVO.setTaxMoney(checkTaxMoney);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    @Transactional
    public void deletes(List<CheckVO> vos) {
        if (vos.size() > 1) {
            throw new BusinessException("\u9a8c\u6536\u5355\u4e0d\u5141\u8bb8\u6279\u91cf\u5220\u9664!");
        }
        CheckVO checkVO = vos.get(0);
        CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)checkVO.getId()));
        List<CheckDetailEntity> checkDetailList = checkEntity.getCheckDetailList();
        List<CheckWeighEntity> checkWeighList = checkEntity.getCheckWeighList();
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(checkEntity.getDeliveryId()));
        if (deliveryEntity != null) {
            List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
            Map checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(CheckDetailEntity::getDeliveryDetailId, Function.identity()));
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                if (!checkDetailEntityMap.containsKey(deliveryDetailEntity.getId())) continue;
                CheckDetailEntity checkDetailEntity = (CheckDetailEntity)((Object)checkDetailEntityMap.get(deliveryDetailEntity.getId()));
                deliveryDetailEntity.setCheckNum(deliveryDetailEntity.getCheckNum().subtract(checkDetailEntity.getCheckNum()));
            }
            Boolean allCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
            Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> e.getCheckNum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNum().compareTo(e.getDeliveryNum()) == -1);
            Integer checkStatus = 0;
            if (allCheck.booleanValue()) {
                checkStatus = 2;
            }
            if (anyCheck.booleanValue()) {
                checkStatus = 1;
            }
            deliveryEntity.setCheckStatus(checkStatus);
            this.deliveryService.updateById((Object)deliveryEntity);
            this.deliveryDetailService.updateBatchById(deliveryDetailList);
            if (!DeliveryTypeEnum.\u81ea\u5236\u9001\u8d27\u5355.getCode().equals(deliveryEntity.getDeliveryType())) {
                CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sourceId", deliveryEntity.getSourceId());
                map.put("checkStatus", checkStatus);
                map.put("systemId", ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(map);
                Boolean updateSupplierStatus = this.deliveryService.updateSupplierStatus(deliveryEntity.getId(), dataInfo, "/ejc-supbusiness-web/openapi/materialDelivery/saveMaterialDeliveryState", RequestMethod.POST, deliveryEntity.getSupplierId().toString(), "XHC_CHECK_SYNC", BILL_TYPE);
                if (!updateSupplierStatus.booleanValue()) {
                    throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
                }
            }
        }
        if (CollectionUtils.isNotEmpty(vos)) {
            CommonResponse response;
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (CheckVO checkVO1 : vos) {
                CheckEntity checkEntity1 = (CheckEntity)((Object)super.selectById((Serializable)checkVO1.getId()));
                ExecutionVO executionVO = this.targetCost(checkEntity1);
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            Boolean isOldPush = false;
            if (checkEntity.getCheckType().equals("proMaterial-2")) {
                isOldPush = true;
            }
            if (!checkEntity.getCheckType().equals("proMaterial-2") && checkEntity.getAttrFlag().equals(1)) {
                isOldPush = true;
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            if (isOldPush.booleanValue() && !(response = this.executionApi.aggDel(totalExecutionVOList)).isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25" + response.getMsg());
            }
        }
        if (CollectionUtils.isNotEmpty(checkDetailList)) {
            ArrayList<Long> unuseIds = new ArrayList<Long>();
            checkDetailList.forEach(sub -> {
                if (null != sub.getSourceMainId()) {
                    unuseIds.add(sub.getSourceMainId());
                }
            });
            if (CollectionUtil.isNotEmpty(unuseIds)) {
                this.updSmartStore(null, unuseIds);
            }
        }
        this.delWeighBill(checkWeighList);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(String datInfo, Long supplierId, Long sourceId, String billTypeCode, CooperateVO cooperate, String url) {
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + sourceId.toString();
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"XHC_CHECK_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "XHC_CHECK_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", datInfo);
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(sourceId, null, null, null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)supplierId, (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(url, paramMap, supplierId.toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, sourceId, billPushResp.getMsg()});
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{sourceId, supplierId, syncReqResp.getMsg()});
                }
            } else {
                this.logger.error("\u83b7\u53d6\u9a8c\u6536\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)sourceId, (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{sourceId, supplierId, e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "XHC_CHECK_SYNC");
        }
        return syncFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)((Object)billId)));
        checkEntity.setSupOperateTime(supOperateTime);
        checkEntity.setSupOperatorName(supOperatorName);
        checkEntity.setSupOperatorPhone(supOperatorPhone);
        checkEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = "BT220215000000006::" + checkEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"XHC_CHECK_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)checkEntity.getId());
                this.releaseLock(jedis, false, key, "XHC_CHECK_SYNC");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, checkEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            checkEntity.setAttachIds(attchIdsList);
            checkEntity.setSignStatus(1);
            super.saveOrUpdate((Object)checkEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)checkEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "XHC_CHECK_SYNC");
        }
        return msg;
    }

    @Override
    public CheckVO getRateAndPrice(CheckVO checkVO) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(checkVO.getContractId()));
        LambdaQueryWrapper lambdaContractDetail = Wrappers.lambdaQuery();
        lambdaContractDetail.eq(ContractDetailEntity::getContractId, (Object)checkVO.getContractId());
        lambdaContractDetail.eq(ContractDetailEntity::getMaterialId, (Object)checkVO.getMaterialId());
        ContractDetailEntity contractDetailEntity = (ContractDetailEntity)((Object)this.contractDetailService.getOne((Wrapper)lambdaContractDetail));
        if (contractDetailEntity != null) {
            checkVO.setCheckPrice(contractDetailEntity.getPrice());
            checkVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
            checkVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
            checkVO.setContractNumsSum(contractDetailEntity.getNum());
            checkVO.setMemo(contractDetailEntity.getMemo());
            return checkVO;
        }
        LambdaQueryWrapper lambdaContractType = Wrappers.lambdaQuery();
        lambdaContractType.eq(ContractDetailEntity::getContractId, (Object)checkVO.getContractId());
        lambdaContractType.eq(ContractDetailEntity::getMaterialTypeId, (Object)checkVO.getMaterialTypeId());
        lambdaContractType.isNull(ContractDetailEntity::getMaterialId);
        ContractDetailEntity contractTypeEntity = (ContractDetailEntity)((Object)this.contractDetailService.getOne((Wrapper)lambdaContractType));
        if (contractTypeEntity != null) {
            checkVO.setCheckPrice(contractTypeEntity.getPrice());
            checkVO.setCheckTaxPrice(contractTypeEntity.getDetailTaxPrice());
            checkVO.setTaxRate(contractTypeEntity.getDetailTaxRate());
            checkVO.setContractNumsSum(contractTypeEntity.getNum());
            checkVO.setMemo(contractTypeEntity.getMemo());
            return checkVO;
        }
        checkVO.setTaxRate(contractEntity.getTaxRate());
        return checkVO;
    }

    @Override
    public CheckVO hntgetRateAndPrice(Long sourceDetailId) {
        ContractDetailEntity contractDetailEntity = (ContractDetailEntity)((Object)this.contractDetailService.selectById(sourceDetailId));
        CheckVO checkVO = new CheckVO();
        if (contractDetailEntity != null) {
            checkVO.setCheckPrice(contractDetailEntity.getPrice());
            checkVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
            checkVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
            checkVO.setContractNumsSum(contractDetailEntity.getNum());
        }
        return checkVO;
    }

    @Override
    public CheckVO hntOrderRateAndPrice(Long sourceDetailId) {
        ConcreteOrderDetailEntity concreteOrderDetailEntity = (ConcreteOrderDetailEntity)((Object)this.concreteOrderDetailService.selectById(sourceDetailId));
        ContractDetailEntity contractDetailEntity = (ContractDetailEntity)((Object)this.contractDetailService.selectById(concreteOrderDetailEntity.getSourceDetailId()));
        CheckVO checkVO = new CheckVO();
        if (contractDetailEntity != null) {
            checkVO.setCheckPrice(contractDetailEntity.getPrice());
            checkVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
            checkVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
            checkVO.setContractNumsSum(contractDetailEntity.getNum());
        }
        return checkVO;
    }

    private String sendMsg(CheckEntity checkEntity, String subject, String content) {
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setContent(content);
        msgParameter.setSubject(subject);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(checkEntity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }

    @Override
    public CommonResponse<CheckVO> pushCost(CheckVO checkVO) {
        CheckEntity checkEntity = (CheckEntity)((Object)((CheckMapper)this.baseMapper).selectById(checkVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)checkVO.getCheckDetailList())) {
            List checkDetailEntityList = BeanMapper.mapList((Iterable)checkVO.getCheckDetailList(), CheckDetailEntity.class);
            checkEntity.setCheckDetailList(checkDetailEntityList);
        }
        super.saveOrUpdate((Object)checkEntity, false);
        if (checkEntity.getAttrFlag().equals(1)) {
            this.costPush(checkEntity);
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)checkEntity), CheckVO.class));
    }

    @Override
    public CheckVO getDetailListData(CheckVO checkVO) {
        List materialIdList;
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(checkVO.getContractId()));
        List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
        if (CollectionUtils.isNotEmpty(contractDetailList) && (materialIdList = contractDetailList.stream().map(ContractDetailEntity::getMaterialCode).collect(Collectors.toList())).stream().distinct().count() < (long)materialIdList.size()) {
            throw new BusinessException("\u8bf7\u52ff\u6dfb\u52a0\u91cd\u590d\u6570\u636e\uff01");
        }
        List checkDetailListPC = checkVO.getCheckDetailList();
        Map contractDetailEntityMap = contractDetailList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity()));
        Map contractDetailTypeEntityMap = contractDetailList.stream().filter(t -> t.getMaterialId() == null).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, Function.identity()));
        List materialIds = checkDetailListPC.stream().map(CheckDetailVO::getMaterialId).collect(Collectors.toList());
        for (CheckDetailVO checkDetailVO : checkDetailListPC) {
            ContractDetailEntity contractDetailEntity;
            if (contractDetailEntityMap.containsKey(checkDetailVO.getMaterialId())) {
                contractDetailEntity = (ContractDetailEntity)((Object)contractDetailEntityMap.get(checkDetailVO.getMaterialId()));
                checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
                checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
                checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                checkDetailVO.setContractNumsSum(contractDetailEntity.getNum());
                continue;
            }
            if (contractDetailTypeEntityMap.containsKey(checkDetailVO.getMaterialTypeId())) {
                contractDetailEntity = (ContractDetailEntity)((Object)contractDetailTypeEntityMap.get(checkDetailVO.getMaterialTypeId()));
                checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
                checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
                checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                checkDetailVO.setContractNumsSum(contractDetailEntity.getNum());
                continue;
            }
            checkDetailVO.setTaxRate(contractEntity.getTaxRate());
        }
        CommonResponse commonResponse = this.materialApi.queryMaterialItemByIds(materialIds);
        if (commonResponse.isSuccess()) {
            List materialVOList = (List)commonResponse.getData();
            Map materialVOMap = materialVOList.stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
            for (CheckDetailVO checkDetailVO : checkDetailListPC) {
                if (!materialVOMap.containsKey(checkDetailVO.getMaterialId())) continue;
                MaterialVO materialVO = (MaterialVO)materialVOMap.get(checkDetailVO.getMaterialId());
                checkDetailVO.setSubjectId(materialVO.getSubjectId());
                checkDetailVO.setSubjectName(materialVO.getSubjectName());
            }
        }
        return checkVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)id));
        CheckVO checkVO = (CheckVO)BeanMapper.map((Object)((Object)checkEntity), CheckVO.class);
        Boolean executionFlag = false;
        CommonResponse response = new CommonResponse();
        if ("proMaterial-2".equals(checkVO.getCheckType())) {
            executionFlag = true;
        }
        if (!"proMaterial-2".equals(checkVO.getCheckType()) && checkVO.getAttrFlag() != null && checkVO.getAttrFlag() == 1) {
            executionFlag = true;
        }
        if (executionFlag.booleanValue()) {
            ExecutionVO executionVO = this.targetCost(checkEntity);
            this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
            response = this.executionApi.ctrlCheckVO(executionVO);
        }
        ParamsCheckVO paramsCheckVO = this.checkParams(checkVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(CheckVO checkVO) {
        Boolean executionFlag = false;
        CommonResponse response = new CommonResponse();
        if ("proMaterial-2".equals(checkVO.getCheckType())) {
            executionFlag = true;
        }
        if (!"proMaterial-2".equals(checkVO.getCheckType()) && checkVO.getAttrFlag() != null && checkVO.getAttrFlag() == 1) {
            executionFlag = true;
        }
        if (executionFlag.booleanValue()) {
            CheckVO vo = this.saveOrUpdates(checkVO, true);
            ExecutionVO executionVO = this.targetCost((CheckEntity)((Object)BeanMapper.map((Object)vo, CheckEntity.class)));
            this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
            response = this.executionApi.ctrlCheckVO(executionVO);
        }
        ParamsCheckVO paramsCheckVO = this.checkParams(checkVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public void costPush(CheckEntity checkEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<CheckDetailEntity> checkDetailList = checkEntity.getCheckDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkDetailList)) {
            for (CheckDetailEntity checkDetailEntity : checkDetailList) {
                if (null != checkDetailEntity.getSubjectId() && null != checkDetailEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(checkDetailList)) {
            newRelationFlag = "0";
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{checkEntity.getId()});
        updateWrapper.set(CheckEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = checkEntity.getRelationFlag();
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(checkEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u9886\u6599\u51fa\u5e93Id---{}", (Object)checkEntity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(checkEntity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    this.logger.info("\u6d4b\u8bd5\u62a5\u951902");
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag)) {
            this.saveCost(checkEntity);
        }
    }

    private void saveCost(CheckEntity checkEntity) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<CheckDetailEntity> checkDetailList = checkEntity.getCheckDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkDetailList)) {
            for (CheckDetailEntity checkDetailEntity : checkDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(checkDetailEntity.getSubjectId());
                costDetailVO.setSubjectCode(checkDetailEntity.getSubjectCode());
                costDetailVO.setSubjectName(checkDetailEntity.getSubjectName());
                costDetailVO.setWbsId(checkDetailEntity.getWbsId());
                costDetailVO.setWbsCode(checkDetailEntity.getWbsCode());
                costDetailVO.setWbsName(checkDetailEntity.getWbsName());
                costDetailVO.setSourceId(checkEntity.getId());
                costDetailVO.setSourceDetailId(checkDetailEntity.getId());
                costDetailVO.setHappenTaxMny(checkDetailEntity.getCheckTaxMny());
                costDetailVO.setHappenMny(checkDetailEntity.getCheckMny());
                costDetailVO.setNum(checkDetailEntity.getCheckNum());
                costDetailVO.setHappenDate(checkEntity.getCheckDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("CHECK");
                costDetailVO.setSourceTabType("CHECK_DETAIL");
                costDetailVO.setProjectId(checkEntity.getProjectId());
                costDetailVO.setSourceBillCode(checkEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u6750\u6599\u9a8c\u6536\u5355.getTypeName());
                costDetailVO.setMaterialId(checkDetailEntity.getMaterialId());
                costDetailVO.setMaterialName(checkDetailEntity.getMaterialName());
                costDetailVO.setMaterialCode(checkDetailEntity.getMaterialCode());
                costDetailVO.setMaterialTypeId(checkDetailEntity.getMaterialTypeId());
                costDetailVO.setMaterialTypeName(checkDetailEntity.getMaterialTypeName());
                costDetailVO.setUnit(checkDetailEntity.getUnit());
                costDetailVO.setUnitId(checkDetailEntity.getUnitId());
                costDetailVO.setSpec(checkDetailEntity.getSpec());
                String url = null;
                if (checkEntity.getContractId() == null) {
                    url = "/ejc-promaterial-frontend/#/check/card?id=" + checkEntity.getId();
                }
                if (checkEntity.getContractId() != null) {
                    url = "/ejc-promaterial-frontend/#/check/contractCard?id=" + checkEntity.getId();
                }
                costDetailVO.setSourceBillUrl(url);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public ParamsCheckVO checkParams(CheckVO vo, ParamsCheckVO paramsCheckVO2) {
        CommonResponse response;
        List checkDetailList;
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (null != vo.getContractId()) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
            if ("proMaterial-1".equals(vo.getCheckType())) {
                paramsCheckVOS.addAll(this.checkParamsNum(contractEntity, vo));
            }
        } else if (CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
        }
        if (vo.getContractId() == null && CollectionUtils.isNotEmpty((Collection)(checkDetailList = vo.getCheckDetailList()))) {
            BigDecimal checkTaxMny = checkDetailList.stream().map(CheckDetailVO::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paramsCheckVOS.addAll(this.checkParamsCheckNum(checkTaxMny, vo.getOrgId()));
        }
        if (!(vo.getContractId() != null || (response = this.paramConfigApi.getByCode("p-c213331233")).isSuccess() && null != response.getData() && ((ParamRegisterSetVO)response.getData()).getValueData().indexOf(vo.getSupplierId() + "") != -1)) {
            this.logger.info("\u83b7\u53d6\u65e0\u5408\u540c\u6d88\u8017\u6750\u9a8c\u6536\u4e0d\u63a7\u5236\u7684\u4f9b\u5e94\u5546\u53c2\u6570\u5931\u8d25\u6216\u4e3a\u7a7a\u6216\u8be5\u4f9b\u5e94\u5546\u9700\u6821\u9a8c\uff0c", (Object)JSONObject.toJSONString((Object)response));
            List checkDetailList2 = vo.getCheckDetailList();
            BigDecimal currentMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)checkDetailList2)) {
                currentMny = checkDetailList2.stream().map(CheckDetailVO::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            LambdaQueryWrapper checkLambda = Wrappers.lambdaQuery();
            checkLambda.eq(CheckEntity::getProjectId, (Object)vo.getProjectId());
            checkLambda.isNull(CheckEntity::getContractId);
            checkLambda.eq(CheckEntity::getSupplierId, (Object)vo.getSupplierId());
            List checkEntityList = super.list((Wrapper)checkLambda);
            BigDecimal checkAll = currentMny;
            if (CollectionUtils.isNotEmpty((Collection)checkEntityList)) {
                List checkIds = checkEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper checkDetailLambda = Wrappers.lambdaQuery();
                checkDetailLambda.in(CheckDetailEntity::getCheckId, checkIds);
                List checkDetailEntityList = this.checkDetailService.list((Wrapper)checkDetailLambda);
                if (CollectionUtils.isNotEmpty((Collection)checkDetailEntityList)) {
                    BigDecimal checkTaxMny = checkDetailEntityList.stream().map(CheckDetailEntity::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    checkAll = currentMny.add(checkTaxMny);
                }
            }
            paramsCheckVOS.addAll(this.checkParamsCheckSubNum(currentMny, checkAll, vo.getOrgId()));
        }
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        if (this.priceCheckParams(vo) != null) {
            paramsCheckVOS.add(this.priceCheckParams(vo));
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(CheckVO vo) {
        CommonResponse billParamByCode;
        List list;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        BigDecimal totalMny = mny = null == vo.getCheckAllTaxMny() ? BigDecimal.ZERO : vo.getCheckAllTaxMny();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(CheckEntity::getProjectId, (Object)vo.getProjectId());
        wrapper.isNull(CheckEntity::getContractId);
        if (null != vo.getId()) {
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)wrapper)))) {
            BigDecimal totalTaxMny = list.stream().filter(e -> null != e.getCheckAllTaxMny()).map(CheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)totalTaxMny);
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(ConcreteCheckEntity::getProjectId, (Object)vo.getProjectId());
        wrapper2.isNull(ConcreteCheckEntity::getContractId);
        List list2 = this.concreteCheckService.list((Wrapper)wrapper2);
        if (CollectionUtils.isNotEmpty((Collection)list2)) {
            BigDecimal totalTaxMny = list2.stream().filter(e -> null != e.getCheckAllTaxMny()).map(ConcreteCheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)totalTaxMny);
        }
        CommonResponse response = this.temporaryUseRecordApi.queryProTemporaryUseRecordMny(vo.getProjectId());
        this.logger.info("\u8be5\u9879\u76ee\uff1a{}-\u4e0b\u6240\u6709\u72b6\u6001\u7684\u3010\u4e34\u65f6\u8bbe\u5907\u4f7f\u7528\u8bb0\u5f55\u91d1\u989d\u3011\u91d1\u989d\u7ed3\u679c:{}", (Object)vo.getProjectId(), (Object)JSONObject.toJSONString((Object)response));
        if (response.isSuccess() && null != response.getData()) {
            BigDecimal useMny = ((JSONObject)response.getData()).getBigDecimal("useMny");
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)useMny);
        }
        CommonResponse commonResponse = this.proincomeContrantApi.queryContranctMny(vo.getProjectId());
        this.logger.info("\u8be5\u9879\u76ee:{}-\u4e0b\u751f\u6548\u7684\u6700\u65b0\u6b63\u5f0f\u65bd\u5de5\u5408\u540c:{}", (Object)vo.getProjectId(), (Object)JSONObject.toJSONString((Object)commonResponse));
        if (commonResponse.isSuccess() && null != commonResponse.getData()) {
            BigDecimal bigDecimal = contractTaxMny = null == ((ContractRegisterVO)commonResponse.getData()).getContractTaxMny() ? BigDecimal.ZERO : ((ContractRegisterVO)commonResponse.getData()).getContractTaxMny();
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CON_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u65bd\u5de5\u5408\u540c\u91d1\u989d\u3011\u63a7\u3010\u65e0\u5408\u540c\u9a8c\u6536\u3001\u96f6\u661f\u673a\u68b0\u91d1\u989d\u3011\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100"));
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u65e0\u5408\u540c\u9a8c\u6536\u3001\u4e34\u673a\u8d39\u7528\u8d85\u65bd\u5de5\u5408\u540c\u989d");
                        paramsCheckDsVO.setWarnName("\u65e0\u5408\u540c\u9a8c\u6536\u3001\u4e34\u673a\u8d39\u7528\u7d2f\u8ba1\u91d1\u989d\u8d85\u65bd\u5de5\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(mny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u96f6\u6750\u3001\u96f6\u673a\u53d1\u751f\u91d1\u989d\uff1a").append(totalMny.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO priceCheckParams(CheckVO vo) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.\u6d88\u8017\u6750\u9a8c\u6536.getCode());
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialPriceHistoryApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)vo.getCheckDetailList())) {
            for (CheckDetailVO detailVO : vo.getCheckDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getCheckPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getCheckTaxPrice());
                priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = this.priceHistoryService.priceCheckParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsCheckNum(BigDecimal checkTaxMny, Long orgId) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CODE, orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u6d88\u8017\u6750-\u5355\u6b21\u65e0\u5408\u540c\u9a8c\u6536\u91d1\u989d\u63a7\u5236\u63a7\u5236\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (checkTaxMny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u672c\u6b21\u9a8c\u6536\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u5355\u6b21\u65e0\u5408\u540c\u6750\u6599\u9a8c\u6536\u91d1\u989d\u8d85\u9650\u5b9a\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(checkTaxMny.setScale(2, 4)).append("\u5143\uff0c\u9650\u5b9a\u91d1\u989d\uff1a").append(roleValue.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)checkTaxMny, (BigDecimal)roleValue).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsCheckSubNum(BigDecimal currentMny, BigDecimal checkTaxMnyAll, Long orgId) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_SUB_MNY_CODE, orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u6d88\u8017\u6750-\u5355\u4e2a\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u9a8c\u6536\u91d1\u989d\u63a7\u5236\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (checkTaxMnyAll.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u9a8c\u6536\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u9a8c\u6536\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(currentMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u9a8c\u6536\u91d1\u989d\uff1a").append(checkTaxMnyAll.setScale(2, 4)).append("\u5143\uff0c\u9650\u5b9a\u91d1\u989d\uff1a").append(roleValue.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)checkTaxMnyAll, (BigDecimal)roleValue).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsNum(ContractEntity contractEntity, CheckVO vo) {
        String purchaseType = contractEntity.getPurchaseType();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(purchaseType)) {
            return paramsCheckVOS;
        }
        List<CheckDetailVO> detail = ((CheckMapper)this.baseMapper).getDetail(contractEntity.getId(), vo.getId());
        Map<Long, CheckDetailVO> detailSettleMap = detail.stream().collect(Collectors.toMap(CheckDetailVO::getMaterialId, item -> item, (v1, v2) -> v2));
        Map<Long, ContractDetailEntity> typeMap = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() == null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, item -> item, (v1, v2) -> v2));
        Map<Long, ContractDetailEntity> map = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, item -> item, (v1, v2) -> v2));
        HashMap<Long, BigDecimal> detailTypeMap = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isNotEmpty(detail)) {
            for (CheckDetailVO checkDetailVO : detail) {
                if (map.containsKey(checkDetailVO.getMaterialId())) continue;
                BigDecimal num = (BigDecimal)detailTypeMap.get(checkDetailVO.getMaterialTypeId());
                if (detailTypeMap.containsKey(checkDetailVO.getMaterialTypeId())) {
                    detailTypeMap.put(checkDetailVO.getMaterialTypeId(), ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)checkDetailVO.getCheckNum()));
                    continue;
                }
                detailTypeMap.put(checkDetailVO.getMaterialTypeId(), checkDetailVO.getCheckNum());
            }
        }
        HashMap<Long, CheckDetailVO> detailMap = new HashMap<Long, CheckDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)vo.getCheckDetailList())) {
            for (CheckDetailVO detailVO : vo.getCheckDetailList()) {
                if ("del".equals(detailVO.getRowState())) continue;
                CheckDetailVO mapVO = (CheckDetailVO)detailMap.get(detailVO.getMaterialId());
                if (Objects.nonNull(mapVO)) {
                    detailVO.setCheckNum(ComputeUtil.safeAdd((BigDecimal)mapVO.getCheckNum(), (BigDecimal)detailVO.getCheckNum()));
                    detailMap.put(detailVO.getMaterialId(), detailVO);
                } else {
                    detailMap.put(detailVO.getMaterialId(), detailVO);
                }
                if (map.containsKey(detailVO.getMaterialId())) continue;
                BigDecimal num = (BigDecimal)detailTypeMap.get(detailVO.getMaterialTypeId());
                if (detailTypeMap.containsKey(detailVO.getMaterialTypeId())) {
                    detailTypeMap.put(detailVO.getMaterialTypeId(), ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)detailVO.getCheckNum()));
                    continue;
                }
                detailTypeMap.put(detailVO.getMaterialTypeId(), detailVO.getCheckNum());
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u5165\u5e93\u6570\u91cf\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (CollectionUtils.isNotEmpty(detailMap.values())) {
                        for (CheckDetailVO detailVO : detailMap.values()) {
                            ContractDetailEntity detailEntity;
                            BigDecimal num = detailSettleMap.containsKey(detailVO.getMaterialId()) ? detailSettleMap.get(detailVO.getMaterialId()).getCheckNum() : BigDecimal.ZERO;
                            BigDecimal totalNum = ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)detailVO.getCheckNum()).setScale(4, 4);
                            BigDecimal numType = detailTypeMap.containsKey(detailVO.getMaterialTypeId()) ? (BigDecimal)detailTypeMap.get(detailVO.getMaterialTypeId()) : BigDecimal.ZERO;
                            BigDecimal comNum = BigDecimal.ZERO;
                            if (map.containsKey(detailVO.getMaterialId())) {
                                detailEntity = map.get(detailVO.getMaterialId());
                                comNum = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailEntity.getNum(), (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                            } else {
                                if (!typeMap.containsKey(detailVO.getMaterialTypeId())) continue;
                                detailEntity = typeMap.get(detailVO.getMaterialTypeId());
                                comNum = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailEntity.getNum(), (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                                totalNum = numType;
                            }
                            if (totalNum.compareTo(comNum) <= 0) continue;
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + "+" + detailVO.getSpec());
                            paramsCheckDsVO.setWarnName("\u5165\u5e93\u6570\u91cf\u5927\u4e8e\u5408\u540c\u6570\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u5165\u5e93\u6570\u91cf\uff1a").append(detailVO.getCheckNum().setScale(4, 4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5165\u5e93\u6570\u91cf\uff1a").append(totalNum.setScale(4, 4)).append("\uff0c\u5408\u540c\u6570\u91cf*").append(roleValue).append("%:").append(comNum.setScale(4, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalNum, (BigDecimal)comNum).setScale(4, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public CheckEntity syncCost(Long id) {
        CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)id));
        ExecutionVO executionVO = this.targetCost(checkEntity);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25:" + response.getMsg());
        }
        return checkEntity;
    }

    @Override
    public CheckVO queryDetailWeigh(CheckVO vo) {
        CheckVO checkVO = this.deliveryService.queryDetailToCheck(vo.getDeliveryId());
        this.logger.info("----\u78c5\u5355\u9a8c\u6536\u539f\u6570\u636e \uff1a{}", (Object)JSONObject.toJSONString((Object)checkVO));
        List checkDetailList = checkVO.getCheckDetailList();
        List checkWeighList = vo.getCheckWeighList();
        ArrayList<CheckWeighVO> checkWeighVOS = new ArrayList<CheckWeighVO>();
        if (CollectionUtils.isNotEmpty((Collection)checkWeighList)) {
            List collect = checkWeighList.stream().filter(item -> null != item.getId()).map(item -> item.getId()).collect(Collectors.toList());
            CommonResponse listCommonResponse = this.weighbillApi.queryWeighbills(checkVO.getProjectId(), collect);
            if (!listCommonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u78c5\u5355\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + listCommonResponse.getMsg());
            }
            List data = (List)listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (WeighbillVO weighbillVO : data) {
                    CheckWeighVO checkWeighVO = (CheckWeighVO)BeanMapper.map((Object)weighbillVO, CheckWeighVO.class);
                    BigDecimal netWeight = weighbillVO.getNetWeight();
                    BigDecimal coefficient = weighbillVO.getCoefficient();
                    String weightUnit = weighbillVO.getWeightUnit();
                    Map<String, BigDecimal> checkNumMap = this.getCheckNum(weightUnit, netWeight, coefficient);
                    checkWeighVO.setCheckNum(checkNumMap.get("checkNum"));
                    checkWeighVO.setDetailNetWeightCoefficient(checkNumMap.get("detailNetWeightCoefficient"));
                    checkWeighVO.setWeightId(weighbillVO.getId());
                    checkWeighVO.setCheckId(null);
                    checkWeighVO.setId(null);
                    checkWeighVO.setWeighMemo(weighbillVO.getMemo());
                    checkWeighVO.setRowState("add");
                    checkWeighVOS.add(checkWeighVO);
                }
                Map<Long, List<CheckWeighVO>> weighMap = checkWeighVOS.stream().filter(t -> null != t.getDeliveryDetailId()).collect(Collectors.groupingBy(CheckWeighVO::getDeliveryDetailId));
                if (CollectionUtils.isNotEmpty((Collection)checkDetailList)) {
                    for (CheckDetailVO checkDetailVO : checkDetailList) {
                        List<CheckWeighVO> checkWeighS = weighMap.get(checkDetailVO.getDeliveryDetailId());
                        if (null != checkWeighS && CollectionUtils.isNotEmpty(checkWeighS)) {
                            BigDecimal checkNum = checkWeighS.stream().map(CheckWeighVO::getCheckNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal detailNetWeightCoefficient = checkWeighS.stream().map(CheckWeighVO::getDetailNetWeightCoefficient).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal netWeight = checkWeighS.stream().map(CheckWeighVO::getNetWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                            checkDetailVO.setDetailNetWeight(netWeight);
                            checkDetailVO.setDetailNetWeightCoefficient(detailNetWeightCoefficient);
                            checkDetailVO.setDetailCoefficient(ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)checkNum));
                            checkDetailVO.setCheckNum(checkNum);
                            continue;
                        }
                        checkDetailVO.setDetailNetWeightCoefficient(BigDecimal.ZERO);
                        checkDetailVO.setDetailNetWeight(BigDecimal.ZERO);
                        checkDetailVO.setDetailCoefficient(BigDecimal.ZERO);
                        checkDetailVO.setCheckNum(BigDecimal.ZERO);
                    }
                }
            }
        }
        checkVO.setCheckWeighType(CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode());
        checkVO.setCheckDetailList(checkDetailList);
        checkVO.setCheckWeighList(checkWeighVOS);
        return checkVO;
    }

    public Map<String, BigDecimal> getCheckNum(String weighUnit, BigDecimal netWeight, BigDecimal coefficient) {
        BigDecimal checkNum = BigDecimal.ZERO;
        BigDecimal detailNetWeightCoefficient = BigDecimal.ZERO;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (null == coefficient) {
            coefficient = BigDecimal.ZERO;
        }
        if (null == netWeight) {
            netWeight = BigDecimal.ZERO;
        }
        Integer billStateCode = 0;
        if (StringUtils.isNotEmpty((CharSequence)weighUnit)) {
            billStateCode = WeighUnitEnum.getEnumByStateCode((String)weighUnit).getBillStateCode();
        }
        switch (billStateCode) {
            case 0: {
                detailNetWeightCoefficient = netWeight;
                checkNum = ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)coefficient);
                break;
            }
            case 1: {
                detailNetWeightCoefficient = ComputeUtil.safeMultiply((BigDecimal)netWeight, (BigDecimal)new BigDecimal("1000"));
                checkNum = ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)coefficient);
            }
        }
        map.put("checkNum", checkNum);
        map.put("detailNetWeightCoefficient", detailNetWeightCoefficient);
        return map;
    }

    @Override
    public Map<String, Integer> countBillNum(Long projectId, Date checkDate) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery.eq(CheckEntity::getProjectId, (Object)projectId)).eq(CheckEntity::getCheckDate, (Object)checkDate);
        int checkCount = super.count((Wrapper)lambdaQuery);
        resultMap.put("\u6d88\u8017\u6750", checkCount);
        LambdaQueryWrapper lambdaQuery1 = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery1.eq(ConcreteCheckEntity::getProjectId, (Object)projectId)).eq(ConcreteCheckEntity::getCheckDate, (Object)checkDate);
        int concreteCheckCount = this.concreteCheckService.count((Wrapper)lambdaQuery1);
        resultMap.put("\u6df7\u51dd\u571f", concreteCheckCount);
        return resultMap;
    }

    @Override
    public BigDecimal getSupplierNoContractMny(Long projectId, Long supplierId) {
        List concreteCheckList;
        BigDecimal rtnBig = BigDecimal.ZERO;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        queryParam.getParams().put("contractId", new Parameter("eq", null));
        List checkList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)checkList)) {
            rtnBig = checkList.stream().map(CheckEntity::getCheckAllTaxMny).reduce(rtnBig, BigDecimal::add);
        }
        if (CollectionUtils.isNotEmpty((Collection)(concreteCheckList = this.concreteCheckService.queryList(queryParam, false)))) {
            rtnBig = concreteCheckList.stream().map(ConcreteCheckEntity::getCheckAllTaxMny).reduce(rtnBig, BigDecimal::add);
        }
        return rtnBig;
    }

    @Override
    public CommonResponse<List<MaterialMnyVO>> queryMaterialMnyOfCheck(Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        LocalDate today = LocalDate.now();
        LocalDate beforeMonthDay = today.minusDays(29L);
        String sb = beforeMonthDay.toString() + "," + today.toString();
        this.logger.info("\u65e5\u671f\u67e5\u8be2\uff1a{}", (Object)sb);
        param.getParams().put("checkDate", new Parameter("between", (Object)sb));
        List checkEntityList = super.queryList(param);
        this.logger.info("checkEntityList\uff1a{}", (Object)JSONObject.toJSONString((Object)checkEntityList));
        List concreteCheckEntityList = this.concreteCheckService.queryList(param);
        this.logger.info("concreteCheckEntityList\uff1a{}", (Object)JSONObject.toJSONString((Object)concreteCheckEntityList));
        ArrayList<Long> checkIds = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)checkEntityList)) {
            checkIds = checkEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty((Collection)concreteCheckEntityList)) {
            checkIds.addAll(concreteCheckEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        List materialMnyList = new ArrayList();
        if (CollectionUtils.isNotEmpty(checkIds)) {
            this.logger.info("\u67e5\u51fa\u7b26\u5408\u6761\u4ef6\u9a8c\u6536\u5355id\uff1a{}", (Object)JSONObject.toJSONString(checkIds));
            List<CheckDetailEntity> detailList = ((CheckMapper)this.baseMapper).getCheckMnyGroupByMaterialType(checkIds);
            if (CollectionUtils.isNotEmpty(detailList)) {
                this.logger.info("\u67e5\u51fa\u7b26\u5408\u6761\u4ef6\u9a8c\u6536\u5355\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(detailList));
                materialMnyList = BeanMapper.mapList(detailList, MaterialMnyVO.class);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u6599\u91d1\u989d\u4f7f\u7528\u6570\u636e\u6210\u529f\uff01", materialMnyList);
    }

    @Override
    public List<CheckVO> queryCheckListByContract(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        List checkList = super.queryList(queryParam, false);
        return BeanMapper.mapList((Iterable)checkList, CheckVO.class);
    }
}

