package com.ejianc.business.promaterial.pricelib.service.impl;

import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.pricelib.mapper.PriceGuideDetailMapper;
import com.ejianc.business.promaterial.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.promaterial.pricelib.service.IPriceGuideDetailService;

import java.util.List;

/**
 * 材料指导价子表
 *
 * @author generator
 */
@Service("priceGuideDetailService")
public class PriceGuideDetailServiceImpl extends BaseServiceImpl<PriceGuideDetailMapper, PriceGuideDetailEntity> implements IPriceGuideDetailService {

    /**
     * 根据材料id查询物资指导价
     *
     * @param materialList 材料idList
     * @return 物资指导价
     */
    @Override
    public List<PriceGuideDetailEntity> queryPriceGuideDetailByMaterialIds(List<Long> materialList) {
        return baseMapper.queryPriceGuideDetailByMaterialIds(materialList);
    }
}
