/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.order.bean.ConcreteOrderAdmixtureEntity;
import com.ejianc.business.promaterial.order.bean.ConcreteOrderEntity;
import com.ejianc.business.promaterial.order.mapper.ConcreteOrderMapper;
import com.ejianc.business.promaterial.order.service.IConcreteOrderService;
import com.ejianc.business.promaterial.order.vo.ConcreteOrderAdmixtureVO;
import com.ejianc.business.promaterial.order.vo.ConcreteOrderDetailVO;
import com.ejianc.business.promaterial.order.vo.ConcreteOrderVO;
import com.ejianc.business.promaterial.order.vo.OrderVO;
import com.ejianc.business.promaterial.order.vo.SupConcreteOrderDetailVO;
import com.ejianc.business.promaterial.order.vo.SupConcreteOrderVO;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="concreteOrderService")
public class ConcreteOrderServiceImpl
extends BaseServiceImpl<ConcreteOrderMapper, ConcreteOrderEntity>
implements IConcreteOrderService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private final String OPERATE = "CONCRETE_ORDER_SYNC";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/concreteOrder/saveOrUpdate";
    private final String UPDATE_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/concreteOrder/updateOrderCloseFlag";
    private static final String BILL_CODE = "CONCRETE_ORDER";

    @Override
    public ConcreteOrderVO queryDetail(Long id) {
        ConcreteOrderEntity entity = (ConcreteOrderEntity)((Object)super.selectById((Serializable)id));
        ConcreteOrderVO vo = (ConcreteOrderVO)BeanMapper.map((Object)((Object)entity), ConcreteOrderVO.class);
        List concreteOrderDetailList = vo.getConcreteOrderDetailList();
        List<ConcreteOrderAdmixtureEntity> concreteOrderAdmixtureList = entity.getConcreteOrderAdmixtureList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(concreteOrderAdmixtureList)) {
            List listVO = BeanMapper.mapList(concreteOrderAdmixtureList, ConcreteOrderAdmixtureVO.class);
            Map<Long, List<ConcreteOrderAdmixtureVO>> bidderMap = listVO.stream().collect(Collectors.groupingBy(ConcreteOrderAdmixtureVO::getDetailId));
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)concreteOrderDetailList)) {
                for (ConcreteOrderDetailVO concreteOrderDetailVO : concreteOrderDetailList) {
                    List<ConcreteOrderAdmixtureVO> admixtureVOList = bidderMap.get(concreteOrderDetailVO.getId());
                    if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(admixtureVOList)) continue;
                    concreteOrderDetailVO.setConcreteOrderAdmixtureList(admixtureVOList);
                }
                vo.setConcreteOrderDetailList(concreteOrderDetailList);
            }
        }
        return vo;
    }

    @Override
    public ConcreteOrderVO saveOrUpdates(ConcreteOrderVO saveOrUpdateVO) {
        List concreteOrderDetailList = saveOrUpdateVO.getConcreteOrderDetailList();
        ArrayList<ConcreteOrderAdmixtureEntity> admixtureArrayList = new ArrayList<ConcreteOrderAdmixtureEntity>();
        StringBuffer materialName = new StringBuffer();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)concreteOrderDetailList)) {
            for (ConcreteOrderDetailVO concreteOrderDetailVO : concreteOrderDetailList) {
                List admixtureVOList;
                if (!"del".equals(concreteOrderDetailVO.getRowState())) {
                    materialName.append(concreteOrderDetailVO.getMaterialName() + ",");
                }
                if (concreteOrderDetailVO.getId() == null) {
                    long id = IdWorker.getId();
                    concreteOrderDetailVO.setId(Long.valueOf(id));
                }
                if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(admixtureVOList = concreteOrderDetailVO.getConcreteOrderAdmixtureList()))) continue;
                for (ConcreteOrderAdmixtureVO concreteOrderAdmixtureVO : admixtureVOList) {
                    concreteOrderAdmixtureVO.setDetailId(concreteOrderDetailVO.getId());
                    ConcreteOrderAdmixtureEntity concreteOrderAdmixtureEntity = (ConcreteOrderAdmixtureEntity)((Object)BeanMapper.map((Object)concreteOrderAdmixtureVO, ConcreteOrderAdmixtureEntity.class));
                    admixtureArrayList.add(concreteOrderAdmixtureEntity);
                }
            }
        }
        ConcreteOrderEntity entity = (ConcreteOrderEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ConcreteOrderEntity.class));
        entity.setOrderFlag(0);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(admixtureArrayList)) {
            entity.setConcreteOrderAdmixtureList(admixtureArrayList);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        String materialNames = materialName.substring(0, materialName.length() - 1);
        entity.setMaterialName(materialNames);
        super.saveOrUpdate((Object)entity, false);
        ConcreteOrderVO vo = (ConcreteOrderVO)BeanMapper.map((Object)((Object)entity), ConcreteOrderVO.class);
        return this.queryDetail(entity.getId());
    }

    @Override
    public CommonResponse<String> updateOrderFlag(ConcreteOrderVO orderVO) {
        ConcreteOrderEntity orderEntity = (ConcreteOrderEntity)((Object)super.getById((Serializable)orderVO.getId()));
        CommonResponse<String> res = this.updatePushBill(orderEntity, "BT220223000000001", "/ejc-supbusiness-web/openapi/concreteOrder/updateOrderCloseFlag");
        orderEntity.setOrderFlag(1);
        super.updateById((Object)orderEntity);
        return CommonResponse.success((String)"\u5173\u95ed\u6210\u529f");
    }

    @Override
    public CommonResponse<OrderVO> updateReceived(SupConcreteOrderVO orderVO) {
        ConcreteOrderEntity orderEntity = (ConcreteOrderEntity)((Object)super.getById((Serializable)orderVO.getId()));
        if (null != orderEntity && null != orderEntity.getReceiveState() && orderEntity.getReceiveState() > 0 && 4 != orderVO.getReceiveState()) {
            return CommonResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u88ab\u64cd\u4f5c,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
        String formurl = this.baseHost + "ejc-promaterial-frontend/#/concreteOrder/card?id=" + orderEntity.getId();
        String subject = "";
        String content = "";
        if (1 == orderVO.getReceiveState()) {
            orderEntity.setReceiveState(1);
            orderEntity.setDeliverState(0);
            subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u5168\u90e8\u63a5\u6536\u3002";
            content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u5168\u90e8\u63a5\u6536\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            orderEntity.getConcreteOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(vo.getOrderNumsSum());
                vo.setDeliverNumsSum(BigDecimal.ZERO);
            });
        } else if (2 == orderVO.getReceiveState()) {
            orderEntity.setReceiveState(2);
            orderEntity.setDeliverState(0);
            subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u90e8\u5206\u63a5\u6536\u3002";
            content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u90e8\u5206\u63a5\u6536\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            if (CollectionUtils.isNotEmpty((Collection)orderVO.getConcreteOrderDetailList())) {
                Map<Long, BigDecimal> map = orderVO.getConcreteOrderDetailList().stream().collect(Collectors.toMap(SupConcreteOrderDetailVO::getId, SupConcreteOrderDetailVO::getReceiveNumsSum));
                this.logger.debug("map------" + map);
                orderEntity.getConcreteOrderDetailList().forEach(vo -> {
                    vo.setReceiveNumsSum((BigDecimal)map.get(vo.getId()));
                    this.logger.debug("ReceiveNumsSum------" + vo.getReceiveNumsSum());
                    vo.setDeliverNumsSum(BigDecimal.ZERO);
                });
            }
        } else if (3 == orderVO.getReceiveState()) {
            orderEntity.setReceiveState(3);
            orderEntity.setReceiveReason(orderVO.getReceiveReason());
            subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u62d2\u7edd\u63a5\u6536\u3002";
            content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u62d2\u7edd\u63a5\u6536\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            orderEntity.getConcreteOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(BigDecimal.ZERO);
                vo.setDeliverNumsSum(BigDecimal.ZERO);
            });
        }
        this.sendMsg(messageType, sender, "notice", subject, content, String.valueOf(orderEntity.getTenantId()), orderEntity);
        this.logger.debug("-----\u4e3b\u952e" + orderEntity.getId());
        super.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public CommonResponse<OrderVO> updateDeliverState(SupConcreteOrderVO orderVO) {
        ConcreteOrderEntity orderEntity = (ConcreteOrderEntity)((Object)super.getById((Serializable)orderVO.getId()));
        if (null == orderEntity) {
            return CommonResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u88ab\u64cd\u4f5c,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        orderEntity.setDeliverState(orderVO.getDeliverState());
        super.updateById((Object)orderEntity);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public boolean pushBillToSupCenter(ConcreteOrderEntity concreteOrderEntity, String billTypeCode) {
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + concreteOrderEntity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)concreteOrderEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        concreteOrderEntity.setSystemId((String)ejcCloudSystemCode.getData());
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"CONCRETE_ORDER_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "CONCRETE_ORDER_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", JSONObject.toJSONString((Object)BeanMapper.map((Object)((Object)concreteOrderEntity), SupConcreteOrderVO.class)));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(concreteOrderEntity.getId(), "BT220223000000001", "concrete-order-attaches", null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)concreteOrderEntity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/concreteOrder/saveOrUpdate", paramMap, concreteOrderEntity.getSupplierId().toString(), files);
                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, this.logger);
            } else {
                this.logger.error("\u83b7\u53d6\u8ba2\u5355\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)concreteOrderEntity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{concreteOrderEntity.getId(), concreteOrderEntity.getSupplierId(), e});
            throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
        finally {
            this.releaseLock(jedis, locked, key, "CONCRETE_ORDER_SYNC");
        }
        return syncFlag;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CommonResponse<String> updatePushBill(ConcreteOrderEntity concreteOrderEntity, String billTypeCode, String url) {
        locked = false;
        jedis = this.jedisPool.getResource();
        key = billTypeCode + "::" + concreteOrderEntity.getId().toString();
        ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)concreteOrderEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
        concreteOrderEntity.setSystemId((String)ejcCloudSystemCode.getData());
        syncReqResp = null;
        supHandleResp = null;
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"CONCRETE_ORDER_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "CONCRETE_ORDER_SYNC");
                var10_10 = CommonResponse.error((String)"\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25!");
                return var10_10;
            }
            paramMap = new HashMap<String, String>();
            paramMap.put("id", concreteOrderEntity.getId().toString());
            paramMap.put("systemId", concreteOrderEntity.getSystemId());
            this.logger.info("\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)concreteOrderEntity.getSupplierId(), (Object)concreteOrderEntity.getId());
            syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(url, RequestMethod.POST, JSONObject.toJSONString(paramMap), concreteOrderEntity.getSupplierId().toString());
            if (!syncReqResp.isSuccess()) ** GOTO lbl34
            supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                var11_13 = CommonResponse.success();
                return var11_13;
            }
            try {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{concreteOrderEntity.getSupplierId(), concreteOrderEntity.getId(), supHandleResp.getMsg()});
                throw new BusinessException(supHandleResp.getMsg());
lbl34:
                // 1 sources

                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{concreteOrderEntity.getSupplierId(), concreteOrderEntity.getId(), syncReqResp.getMsg()});
                throw new BusinessException(syncReqResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error(syncReqResp.getMsg() + "////////" + supHandleResp.getMsg());
                this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)concreteOrderEntity.getId(), (Object)e);
                throw new BusinessException(supHandleResp.getMsg());
            }
        }
        finally {
            this.releaseLock(jedis, locked, key, "CONCRETE_ORDER_SYNC");
        }
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String tenantId, ConcreteOrderEntity orderEntity) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

