package com.ejianc.business.promaterial.contract.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.vo.ContractChangeVO;
import com.ejianc.business.promaterial.contract.vo.ContractMaterialReportVO;
import com.ejianc.business.promaterial.contract.vo.MaterialReportVO;
import com.ejianc.business.promaterial.dataModel.vo.MaterialDataModelVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 主合同实体
 *
 * @author generator
 */
@Mapper
public interface ContractMapper extends BaseCrudMapper<ContractEntity> {
    List<ContractChangeVO> getContractChangeList(@Param("contractIds") List<Long> contractIds);

    List<SettlementVO> getSettlementList(@Param("contractIds") List<Long> contractIds);

    List<MaterialReportVO> quueryMaterialByProject(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper, @Param("projectId") Long projectId);

    List<ContractMaterialReportVO> quueryMaterialByOrg(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<ContractMaterialReportVO> getOrderNum(@Param("contractIds") List<Long> contractIds);

    List<ContractMaterialReportVO> getCheckNum(@Param("contractIds") List<Long> contractIds);

    List<ContractMaterialReportVO> getSettleNum(@Param("contractIds") List<Long> contractIds);

    /**
     * @description: 查询材料数据模型
     * @return: java.util.List<com.ejianc.business.promaterial.dataModel.vo.MaterialDataModelVO>
     * @author songlx
     * @date: 2022/6/17
     */
    List<MaterialDataModelVO> queryMaterialDataModelList(@Param("projectId") Long projectId,
                                                         @Param("contractId") Long contractId,
                                                         @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    /**
     * 根据材料分类id查询合同大类数量
     *
     * @param projectId    项目id
     * @param contractId   合同id
     * @param queryWrapper 查询条件
     * @return 查询结果
     */
    List<MaterialDataModelVO> queryContractByMaterialTypeIdList(@Param("projectId") Long projectId,
                                                                @Param("contractId") Long contractId,
                                                                @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    /**
     * @description: 查询材料数据模型
     * @return: java.util.List<com.ejianc.business.promaterial.dataModel.vo.MaterialDataModelVO>
     * @author songlx
     * @date: 2022/6/17
     */
    List<MaterialDataModelVO> queryListByMaterialId(@Param("projectId") Long projectId,
                                                    @Param("contractId") Long contractId,
                                                    @Param(Constants.WRAPPER) QueryWrapper queryWrapper);
    /**
     * @description: 查询材料数据模型
     * @return: java.util.List<com.ejianc.business.promaterial.dataModel.vo.MaterialDataModelVO>
     * @author songlx
     * @date: 2022/6/17
     */
    List<MaterialDataModelVO> queryListByMaterialTypeId(@Param("projectId") Long projectId,
                                                        @Param("contractId") Long contractId,
                                                        @Param(Constants.WRAPPER) QueryWrapper queryWrapper);
    /**
     * 物资门户查所有物资合同的id
     */
    @Select("SELECT id FROM `ejc-promaterial`.`ejc_promaterial_contract`\n" +
            "where dr = 0 and project_id = #{projectId}\n" +
            "union\n" +
            "SELECT id FROM `ejc-prormat`.`ejc_prormat_contract`\n" +
            "where dr = 0 and project_id = #{projectId}")
    List<Long> queryContractByProjectId(@Param("projectId") Long projectId);

    @Select("select sum(a.num) as tatal from (\n" +
            "SELECT id,if(bill_state in (2,5),1,0) as num FROM `ejc-promaterial`.`ejc_promaterial_contract`\n" +
            "where dr = 0 and project_id = #{projectId}\n" +
            "union\n" +
            "SELECT id,if(bill_state in (2,5),1,0) as num  FROM `ejc-prormat`.`ejc_prormat_contract`\n" +
            "where dr = 0 and project_id = #{projectId}) as a")
    Integer queryBpmNumByProjectId(@Param("projectId") Long projectId);
}
