/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.pricelib.bean.PriceSettlementEntity;
import com.ejianc.business.promaterial.pricelib.enums.OutFlagEnum;
import com.ejianc.business.promaterial.pricelib.mapper.PriceSettlementMapper;
import com.ejianc.business.promaterial.pricelib.service.IPriceSettlementService;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.utils.DateUtils;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="priceSettlementService")
public class PriceSettlementServiceImpl
extends BaseServiceImpl<PriceSettlementMapper, PriceSettlementEntity>
implements IPriceSettlementService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IContractService contractService;

    @Override
    public void savePriceSettleByTiming(Date date) {
        List settlementEntityList;
        QueryParam queryParam = new QueryParam();
        if (date != null) {
            Date qDate = DateUtils.calculationDay(date, -1);
            settlementEntityList = ((PriceSettlementMapper)this.baseMapper).getSettlementListByTime(qDate);
        } else {
            queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            settlementEntityList = this.settlementService.queryList(queryParam, false);
        }
        if (CollectionUtils.isEmpty((Collection)settlementEntityList)) {
            return;
        }
        List<Long> contractIds = settlementEntityList.stream().filter(t -> t.getContractId() != null).map(SettlementEntity::getContractId).collect(Collectors.toList());
        List<ContractEntity> contractListByIds = ((PriceSettlementMapper)this.baseMapper).getContractListByIds(contractIds);
        Map contractEntityMap = contractListByIds.stream().filter(t -> t.getId() != null).collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key2));
        List<Long> settlementIdList = settlementEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<SettlementDetailEntity> detailEntityList = ((PriceSettlementMapper)this.baseMapper).getSettlementDetailListBySettlementId(settlementIdList);
        if (CollectionUtils.isEmpty(detailEntityList)) {
            return;
        }
        List materialTypeIdList = detailEntityList.stream().map(SettlementDetailEntity::getMaterialTypeId).distinct().collect(Collectors.toList());
        CommonResponse materialResponse = this.materialApi.queryCategoryListByIds(materialTypeIdList);
        Map<Object, Object> materialCategoryMap = new HashMap();
        this.logger.info("\u67e5\u8be2\u6750\u6599\u5185\u7801\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)materialResponse));
        if (materialResponse.isSuccess()) {
            List materialCategoryVOList = (List)materialResponse.getData();
            materialCategoryMap = materialCategoryVOList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, MaterialCategoryVO::getInnerCode, (key1, key2) -> key2));
        }
        this.logger.info("\u67e5\u8be2\u6750\u6599\u5185\u7801\u8f6cmap\uff0c\u8f6c\u6362\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(materialCategoryMap));
        List projectIdList = settlementEntityList.stream().map(SettlementEntity::getProjectId).distinct().collect(Collectors.toList());
        CommonResponse projectResponse = this.projectSetApi.getProjectListIds(projectIdList);
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u5730\u5740\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)projectResponse));
        Map<Object, Object> projectAreaMap = new HashMap();
        Map<Object, Object> projectAreaNameMap = new HashMap();
        if (projectResponse.isSuccess()) {
            List projectPoolList = (List)projectResponse.getData();
            projectAreaMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getArea())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            projectAreaNameMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getAreaName())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }
        Map<Long, List<SettlementDetailEntity>> detailMap = detailEntityList.stream().collect(Collectors.groupingBy(SettlementDetailEntity::getSettlementId));
        ArrayList<PriceSettlementEntity> saveEntityList = new ArrayList<PriceSettlementEntity>();
        for (SettlementEntity entity : settlementEntityList) {
            List<SettlementDetailEntity> entityDetailList = detailMap.get(entity.getId());
            if (CollectionUtils.isEmpty(entityDetailList)) continue;
            for (SettlementDetailEntity settlementDetailEntity : entityDetailList) {
                PriceSettlementEntity priceSettlementEntity = (PriceSettlementEntity)((Object)BeanMapper.map((Object)((Object)entity), PriceSettlementEntity.class));
                if (null != entity.getContractId() && contractEntityMap.containsKey(entity.getContractId())) {
                    ContractEntity contractEntity = (ContractEntity)((Object)contractEntityMap.get(entity.getContractId()));
                    priceSettlementEntity.setSettlementPayment(contractEntity.getSettlementPayment());
                    priceSettlementEntity.setPriceFloatType(contractEntity.getPriceFloatType());
                }
                priceSettlementEntity.setArea((String)projectAreaMap.get(entity.getProjectId()));
                priceSettlementEntity.setAreaName((String)projectAreaNameMap.get(entity.getProjectId()));
                priceSettlementEntity.setSourceId(entity.getId());
                priceSettlementEntity.setSourceCode(entity.getBillCode());
                priceSettlementEntity.setSourceDetailId(settlementDetailEntity.getId());
                priceSettlementEntity.setMaterialId(settlementDetailEntity.getMaterialId());
                priceSettlementEntity.setMaterialCode(settlementDetailEntity.getMaterialCode());
                priceSettlementEntity.setMaterialName(settlementDetailEntity.getMaterialName());
                priceSettlementEntity.setMaterialTypeId(settlementDetailEntity.getMaterialTypeId());
                priceSettlementEntity.setMaterialTypeName(settlementDetailEntity.getMaterialTypeName());
                priceSettlementEntity.setInnerCode((String)materialCategoryMap.get(settlementDetailEntity.getMaterialTypeId()));
                priceSettlementEntity.setSpec(settlementDetailEntity.getSpec());
                priceSettlementEntity.setUnitId(settlementDetailEntity.getUnitId());
                priceSettlementEntity.setUnitName(settlementDetailEntity.getUnit());
                priceSettlementEntity.setSettleNum(settlementDetailEntity.getNum());
                priceSettlementEntity.setSettlePrice(settlementDetailEntity.getPrice());
                priceSettlementEntity.setSettleMny(settlementDetailEntity.getMny());
                priceSettlementEntity.setSettleTaxRate(settlementDetailEntity.getTaxRate());
                priceSettlementEntity.setSettleTaxMny(settlementDetailEntity.getTaxMny());
                priceSettlementEntity.setSettleTaxPrice(settlementDetailEntity.getTaxPrice());
                priceSettlementEntity.setMemo(settlementDetailEntity.getMemo());
                priceSettlementEntity.setOutFlag(OutFlagEnum.\u672a\u79fb\u9664.getCode());
                priceSettlementEntity.setId(null);
                priceSettlementEntity.setCreateTime(null);
                priceSettlementEntity.setCreateUserCode(null);
                priceSettlementEntity.setUpdateTime(null);
                priceSettlementEntity.setUpdateUserCode(null);
                priceSettlementEntity.setDr(settlementDetailEntity.getDr());
                saveEntityList.add(priceSettlementEntity);
            }
        }
        if (CollectionUtils.isEmpty(saveEntityList)) {
            return;
        }
        List sourceDetailIdList = saveEntityList.stream().map(PriceSettlementEntity::getSourceDetailId).collect(Collectors.toList());
        QueryParam priceParam = new QueryParam();
        priceParam.getParams().put("sourceDetailId", new Parameter("in", sourceDetailIdList));
        List queryPriceList = super.queryList(priceParam, false);
        if (CollectionUtils.isNotEmpty((Collection)queryPriceList)) {
            Map queryPriceMap = queryPriceList.stream().collect(Collectors.toMap(PriceSettlementEntity::getSourceDetailId, Function.identity(), (key1, key2) -> key2));
            for (PriceSettlementEntity entity : saveEntityList) {
                PriceSettlementEntity queryEntity = (PriceSettlementEntity)((Object)queryPriceMap.get(entity.getSourceDetailId()));
                if (queryEntity == null) continue;
                entity.setId(queryEntity.getId());
                entity.setOutFlag(queryEntity.getOutFlag());
            }
        }
        super.saveOrUpdateBatch(saveEntityList);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        super.remove((Wrapper)wrapper, false);
        List list = saveEntityList.stream().filter(t -> t.getDr() != 0).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            super.removeByIds(list, false);
        }
    }
}

