/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.bean.ContractRelieveEntity;
import com.ejianc.business.promaterial.contract.enums.DraftTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractRelieveService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractRelieveVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="contractRelieve")
public class ContractRelieveBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractRelieveService service;
    @Autowired
    private IContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ContractRelieveEntity entity = (ContractRelieveEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        this.service.saveOrUpdate((Object)entity);
        this.logger.info("\u63d0\u4ea4\u524d\u56de\u8c03\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ContractRelieveEntity contractRelieveEntity = (ContractRelieveEntity)((Object)this.service.selectById(billId));
        if (contractRelieveEntity != null) {
            if (contractRelieveEntity.getDraftType() == 2) {
                contractRelieveEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                contractRelieveEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode());
                contractRelieveEntity.setEffectiveDate(new Date());
                this.service.saveOrUpdate((Object)contractRelieveEntity, false);
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("id", new Parameter("eq", (Object)contractRelieveEntity.getContractId()));
                List contractList = this.contractService.queryList(queryParam);
                ContractEntity contractEntity = (ContractEntity)((Object)contractList.get(0));
                contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode());
                this.contractService.saveOrUpdate((Object)contractEntity, false);
                this.contractService.pushContract((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class));
                String linkUrl = contractEntity.getContractType() == 0 ? this.BaseHost + "ejc-promaterial-frontend/#/contractMaterial/contractRelieve/card?id=" + contractRelieveEntity.getId() : this.BaseHost + "ejc-promaterial-frontend/#/contractConcrete/contractRelieve/card?id=" + contractRelieveEntity.getId();
                if (contractEntity.getPurchaseType().equals("1")) {
                    ExecutionVO executionVO = this.service.targetCost((ContractRelieveVO)BeanMapper.map((Object)((Object)contractRelieveEntity), ContractRelieveVO.class), linkUrl, contractEntity.getContractType());
                    this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                    CommonResponse response = this.executionApi.aggPush(executionVO);
                    if (!response.isSuccess()) {
                        throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                    }
                }
                this.logger.info("\u7ec8\u5ba1\u5df2\u7b7e\u7ae0\u5904\u7406\u5b8c\u6210\uff01");
            } else if (contractRelieveEntity.getDraftType() == 1) {
                contractRelieveEntity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
                this.service.saveOrUpdate((Object)contractRelieveEntity, false);
                this.logger.info("\u7ec8\u5ba1\u4e0a\u4f20\u89e3\u9664\u534f\u8bae\u5904\u7406\u5b8c\u6210\uff0c\u521d\u59cb\u5316\u4e3a\u672a\u7b7e\u7ae0");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5408\u540c\u89e3\u9664\u8fdb\u5165\u5f03\u5ba1\u524d\u4e8b\u4ef6\uff0c\u5408\u540cid\uff1a{}", (Object)billId);
        ContractRelieveEntity entity = (ContractRelieveEntity)((Object)this.service.selectById(billId));
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(entity.getDraftType()) && !statusList.contains(entity.getSignatureStatus())) {
            return CommonResponse.error((String)("\u5408\u540c\u89e3\u9664" + (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(entity.getSignatureStatus()) ? "\u5df2\u751f\u6548" : "\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b") + "\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1!"));
        }
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(entity.getSignatureStatus())) {
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            this.service.saveOrUpdate((Object)entity, false);
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.contractService.pushContract((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class));
        return CommonResponse.success((String)"\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5408\u540c\u89e3\u9664\u8fdb\u5165\u5f03\u5ba1\u540e\u4e8b\u4ef6\uff0c\u5408\u540cid\uff1a{}", (Object)billId);
        ContractRelieveEntity contractRelieveEntity = (ContractRelieveEntity)((Object)this.service.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractRelieveEntity.getContractId()));
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        if (contractEntity.getPurchaseType().equals("1")) {
            ExecutionVO executionVO = this.service.targetCost((ContractRelieveVO)BeanMapper.map((Object)((Object)contractRelieveEntity), ContractRelieveVO.class), "", contractEntity.getContractType());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            totalExecutionVOList.add(executionVO.getTotalVO());
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success((String)"\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray arr = new JSONArray();
        this.logger.info("sign:{}", (Object)sign);
        if ("choseCostUser".equals(sign)) {
            ContractRelieveEntity entity = (ContractRelieveEntity)((Object)this.service.selectById(billId));
            Long projectId = entity.getProjectId();
            JSONObject jsonObject = new JSONObject();
            CommonResponse commonResponse = this.projectPoolApi.queryProjectPoolById(projectId);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5931\u8d25!");
            }
            JSONArray array = (JSONArray)commonResponse.getData();
            List vos = JSONObject.parseArray((String)array.toJSONString(), ProjectPoolSetVO.class);
            this.logger.info("vos:{}", (Object)JSONObject.toJSONString((Object)vos));
            ProjectPoolSetVO vo = (ProjectPoolSetVO)vos.get(0);
            Long costAdapter = vo.getCostAdapter();
            String costAdapterName = vo.getCostAdapterName();
            this.logger.info("userId:{}", (Object)costAdapter);
            this.logger.info("userName:{}", (Object)costAdapterName);
            jsonObject.put("userId", (Object)costAdapter);
            jsonObject.put("userName", (Object)costAdapterName);
            arr.add((Object)jsonObject);
        }
        return CommonResponse.success((Object)arr);
    }
}

