/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.reconciliation.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="reconciliation")
public class ReconciliationBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IReconciliationService service;
    private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/reconciliation/delReconciliation";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
            ReconciliationEntity entity = (ReconciliationEntity)((Object)this.service.selectById(billId));
            Boolean pushFlag = this.service.pushBillToSupCenter(entity, billTypeCode);
            if (!pushFlag.booleanValue()) {
                entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            } else {
                entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            }
            this.service.updateById((Object)entity);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        ReconciliationEntity entity = (ReconciliationEntity)((Object)this.service.selectById(billId));
        List list = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)entity.getContractId())).in((Object)"bill_state", new Object[]{0, 2, 4, 5})).eq((Object)"dr", (Object)0)).ne((Object)"id", (Object)entity.getId()));
        if (list.size() > 0) {
            throw new BusinessException("\u5408\u540c\u4e0b\u5b58\u5728\u4e00\u5f20\u672a\u751f\u6548\u7684\u5bf9\u8d26\u5355");
        }
        if (entity.getSignStatus() == 1) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de");
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse<String> commonResponse = this.service.updatePushBill(entity, billTypeCode, "/ejc-supbusiness-web/openapi/reconciliation/delReconciliation");
            this.logger.info("\u4f9b\u65b9\u7ed3\u679c" + JSONObject.toJSONString(commonResponse));
            if (!commonResponse.isSuccess()) {
                return CommonResponse.error((String)("\u5f03\u5ba1\u63a8\u9001\u4f9b\u65b9\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + commonResponse.getMsg()));
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.service.updateById((Object)entity);
            this.logger.info("\u4f9b\u65b9\u64a4\u56de\u6210\u529f---" + JSONObject.toJSONString((Object)((Object)entity)));
        }
        return CommonResponse.success();
    }
}

