package com.ejianc.business.promaterial.pricelib.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.promaterial.pricelib.vo.*;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.promaterial.pricelib.bean.PriceContractEntity;

import java.util.Date;
import java.util.List;

/**
 * 价格库-合同明细
 *
 * @author generator
 */
public interface IPriceContractService extends IBaseService<PriceContractEntity> {

    /**
     * 定时处理合同价格库明细
     * 如果传入日期为空，则为初始化，处理全部合同（已提交、审批通过）明细
     *
     * @param date 日期
     */
    void savePriceContractByTiming(Date date);

    /**
     * 查询价格库汇总信息(有权限控制)
     *
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<PriceLibVO> queryPriceLibListByTime(QueryParam param);

    /**
     * 查询价格库汇总信息(有权限控制)
     *
     * @param param 查询参数
     * @return 查询结果
     */
    List<PriceLibVO> queryPriceLibListByTimeExcel(QueryParam param);

    /**
     * 根据材料id查询价格库信息
     *
     * @param param 查询参数
     * @return 查询结果
     */
    PriceLibVO queryPriceLibDetail(QueryParam param);

    /**
     * 查询价格库信息（无权限）
     *
     * @param startDate      开始日期
     * @param endDate        结束日期
     * @param materialTypeId 材料分类id
     * @return 查询结果
     */
    List<PriceLibVO> queryPriceLibList(Date startDate, Date endDate, String materialTypeId);

    /**
     * 根据材料id查询对应的价格库合同明细
     *
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<PriceContractVO> queryPriceContractListDetail(QueryParam param);

    /**
     * 根据材料id查询对应的价格库验收明细
     *
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<PriceCheckVO> queryPriceCheckListDetail(QueryParam param);

    /**
     * 根据材料id查询对应的价格库结算明细
     *
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<PriceSettlementVO> queryPriceSettleListDetail(QueryParam param);

    /**
     * 查询合同价格趋势图
     *
     * @param param 查询参数
     * @return 查询结果
     */
    List<PriceTrendVo> queryPriceTrendContractList(QueryParam param);

    /**
     * 查询验收价格趋势图
     *
     * @param param 查询参数
     * @return 查询结果
     */
    List<PriceTrendVo> queryPriceTrendCheckList(QueryParam param);

    /**
     * 查询结算价格趋势图
     *
     * @param param 查询参数
     * @return 查询结果
     */
    List<PriceTrendVo> queryPriceTrendSettleList(QueryParam param);

    /**
     * 移除合同明细
     *
     * @param id 明细id
     */
    void removePriceContractDetail(Long id);

    /**
     * 移除验收明细
     *
     * @param id 明细id
     */
    void removePriceCheckDetail(Long id);

    /**
     * 移除结算明细
     *
     * @param id 明细id
     */
    void removePriceSettleDetail(Long id);
}
