package com.ejianc.business.promaterial.pricelib.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.promaterial.pricelib.vo.PriceGuideDetailVO;
import com.ejianc.business.tender.expert.vo.ExpertVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.promaterial.pricelib.bean.PriceGuideEntity;
import com.ejianc.business.promaterial.pricelib.service.IPriceGuideService;
import com.ejianc.business.promaterial.pricelib.vo.PriceGuideVO;

/**
 * 物资指导价主表
 *
 * @author generator
 */
@Controller
@RequestMapping("priceGuide")
@Api(value = "物资指导价主表", tags = {"物资指导价主表"})
public class PriceGuideController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "GUIDE_CODE";//此处需要根据实际修改

    @Autowired
    private IPriceGuideService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi materialApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PriceGuideVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody PriceGuideVO saveOrUpdateVO) {
        PriceGuideEntity entity = BeanMapper.map(saveOrUpdateVO, PriceGuideEntity.class);
        // parentOrgCode如果是空的，则需要查询赋值
        CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(entity.getOrgId());
        if (orgResponse.isSuccess()) {
            OrgVO orgVO = orgResponse.getData();
            entity.setOrgCode(orgVO.getCode());
            if (orgVO.getOrgType() == 5) {
                entity.setParentOrgId(orgVO.getId());
                entity.setParentOrgName(orgVO.getName());
                entity.setParentOrgCode(orgVO.getCode());
            }
            else {
                entity.setParentOrgId(entity.getOrgId());
                entity.setParentOrgName(entity.getOrgName());
                entity.setParentOrgCode(entity.getOrgCode());
            }
        }
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 查询材料内码
        List<PriceGuideDetailEntity> guideDetailList = entity.getPriceGuideDetailList();
        List<Long> materialTypeIdList = guideDetailList.stream().map(PriceGuideDetailEntity::getMaterialTypeId)
                .distinct().collect(Collectors.toList());
        CommonResponse<List<MaterialCategoryVO>> materialResponse = materialApi
                .queryCategoryListByIds(materialTypeIdList);
        Map<Long, String> materialCategoryMap = new HashMap<>();
        logger.info("查询材料内码，查询结果：{}", JSONObject.toJSONString(materialResponse));
        if (materialResponse.isSuccess()) {
            List<MaterialCategoryVO> materialCategoryVOList = materialResponse.getData();
            materialCategoryMap = materialCategoryVOList.stream()
                    .collect(Collectors.toMap(MaterialCategoryVO::getId, MaterialCategoryVO::getInnerCode,
                            (key1, key2) -> key2));
        }
        //循环list通过map获取内码
        for (PriceGuideDetailEntity detailEntity : guideDetailList) {
            detailEntity.setInnerCode(materialCategoryMap.get(detailEntity.getMaterialTypeId()));
        }
        service.saveOrUpdate(entity, false);
        PriceGuideVO vo = BeanMapper.map(entity, PriceGuideVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PriceGuideVO> queryDetail(@RequestParam Long id) {
        PriceGuideEntity entity = service.selectById(id);
        PriceGuideVO vo = BeanMapper.map(entity, PriceGuideVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PriceGuideVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PriceGuideVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PriceGuideVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PriceGuideVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("theme");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }
        else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            }
            else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PriceGuideEntity> page = service.queryPage(param, false);
        IPage<PriceGuideVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PriceGuideVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("theme");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PriceGuideEntity> list = service.queryList(param);
        List<PriceGuideVO> guideVOS = BeanMapper.mapList(list, PriceGuideVO.class);
        //todo:字段翻译等等
        guideVOS.stream().forEach(item -> {
            item.setFlagName(item.getFlag() == 0 ? "启用" : "禁用");
            item.setBillStateName(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", guideVOS);
        ExcelExport.getInstance().export("PriceGuide-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refPriceGuideData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PriceGuideVO>> refPriceGuideData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PriceGuideEntity> page = service.queryPage(param, false);
        IPage<PriceGuideVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PriceGuideVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
    /**
     * @Description saveOrUpdate 启停用
     */
    @RequestMapping(value = "/startUpdate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PriceGuideVO> startUpdate(@RequestParam Long id, Integer state) {
        PriceGuideEntity priceGuideEntity = service.selectById(id);
        priceGuideEntity.setFlag(state);
        service.saveOrUpdate(priceGuideEntity, false);
        PriceGuideVO vo = BeanMapper.map(priceGuideEntity, PriceGuideVO.class);
        return CommonResponse.success("启用停用状态调整成功！",vo);
    }
    /**
     * @Description saveOrUpdate 复制子表
     */
    @RequestMapping(value = "/copyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PriceGuideDetailVO>> copyDetail(@RequestParam Long id) {
        PriceGuideEntity priceGuideEntity = service.selectById(id);
        List<PriceGuideDetailEntity> detailList = priceGuideEntity.getPriceGuideDetailList();
        //将id设置为空
        detailList.forEach(detail -> {
            detail.setId(IdWorker.getId());
            detail.setRowState("add");
            detail.setBillState(null);
            detail.setVersion(null);
            detail.setCreateTime(null);
            detail.setUpdateTime(null);
            detail.setCreateUserCode(null);
            detail.setUpdateUserCode(null);
        });
        return CommonResponse.success("复制子表成功！",BeanMapper.mapList(detailList, PriceGuideDetailVO.class));
    }
}
