package com.ejianc.business.promaterial.check.mapper;

import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.plan.vo.SourceBliVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 消耗材-验收主表
 * 
 * @author generator
 * 
 */
@Mapper
public interface CheckMapper extends BaseCrudMapper<CheckEntity> {
    List<CheckDetailVO> getDetail(@Param("contractId")Long contractId, @Param("checkId")Long checkId);

    /**
     * 获取验收单、对账单、结算单的的数量
     * @param supplierId
     * @param orgIds
     * @return
     */
    SourceBliVO getSourceBliVO(@Param("supplierId") Long supplierId, @Param("orgIds") List<Long> orgIds,@Param("dateIn") String dateIn);

    SourceBliVO getConcreteSourceBliVO(@Param("supplierId") Long supplierId, @Param("orgIds") List<Long> orgIds,@Param("dateIn") String dateIn);

    List<CheckDetailEntity> getCheckMnyGroupByMaterialType(@Param("checkIds") List<Long> checkIds);
    List<CheckVO> getMaterialDesktopData(@Param("projectId") Long projectId, @Param("createTime") Date createTime);
    List<CheckDetailVO> getCheckMnyTopFiveMaterialId(@Param("projectId") Long projectId, @Param("createTime") Date createTime);

    //查询最新的两个验收单
    List<CheckVO> getNewestCheck(@Param("projectId") Long projectId);

    List<CheckDetailEntity> getCheckMnyGroupByDetail(@Param("sourceIds") List<Long> sourceIds);

    //查询上周的验收单，并预警消息
    List<CheckEntity> getCheckWarnList();
}
