package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;

@Service("masterPlan") 
public class MasterPlanBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IMasterPlanService masterPlanService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		MasterPlanEntity e = masterPlanService.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();

		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		masterPlanService.saveOrUpdate(e, false);

		return CommonResponse.success("总计划审批回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		MasterPlanEntity e = masterPlanService.selectById(billId);

		logger.info("物资总计划单据【billId-{}】,【billTypeCode-{}】执行撤回前校验！", billId, billTypeCode);
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("物资总计划单据【billId-{}】,【billTypeCode-{}】校验被下游单据引用结果：{}", billId, billTypeCode, JSONObject.toJSONString(resp));
		if(!resp.isSuccess()) {
			logger.info("物资总计划单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}", resp.getMsg());
			return CommonResponse.error(resp.getMsg());
		}

		return CommonResponse.success("总计划撤回回调处理成功！");
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		MasterPlanEntity e = masterPlanService.selectById(billId);
		e.setEffectiveDate(new Date());
		if(state == 1) {
			//直审时记录
			UserContext userContext = sessionManager.getUserContext();
			e.setCommitDate(new Date());
			e.setCommitUserCode(userContext.getUserCode());
			e.setCommitUserName(userContext.getUserName());
		}
		masterPlanService.saveOrUpdate(e, false);
		return CommonResponse.success("总计划审批回调处理成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		MasterPlanEntity e = masterPlanService.selectById(billId);
		if(e!=null){
			if(e.getChangeState() == MasterPlanVO.PLAN_CHANGE_STATE_CHANGING){
				return CommonResponse.error("变更中单据无法撤回");
			}
			if(e.getChangeState() == MasterPlanVO.PLAN_CHANGE_STATE_CHANGED){
				return CommonResponse.error("已变更单据无法撤回");
			}
		}
		logger.info("物资总计划单据【billId-{}】,【billTypeCode-{}】执行弃审前校验！", billId, billTypeCode);
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("物资总计划单据【billId-{}】,【billTypeCode-{}】校验被下游单据引用结果：{}", billId, billTypeCode, JSONObject.toJSONString(resp));
		if(!resp.isSuccess()) {
			logger.info("物资总计划单据【billId-{}】,【billTypeCode-{}】执行弃审操作校验结束，未通过校验，原因：{}", resp.getMsg());
			return CommonResponse.error(resp.getMsg());
		}

		return CommonResponse.success("总计划弃审回调处理成功！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
