package com.ejianc.business.promaterial.dataModel.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.dataModel.consts.DataModelEnum;
import com.ejianc.business.promaterial.dataModel.service.MaterialDataModelService;
import com.ejianc.business.promaterial.dataModel.vo.MaterialDataModelVO;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.google.gson.JsonObject;
import io.swagger.annotations.Api;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author songlx
 * @versin 1.0
 * @description: 数据模型-材料执行情况
 * @date 2022/6/16
 */
@RestController
@RequestMapping("materialDataModel")
@Api(value = "数据模型-材料执行情况", tags = {"数据模型-材料执行情况"})
public class MaterialDataModelController implements Serializable {


    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    MaterialDataModelService materialDataModelService;
    @Autowired
    private IDutyApi dutyApi;

    /**
     * @param param
     * @param request
     * @description: 材料情况
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.alibaba.fastjson.JSONObject>>
     * @author songlx
     * @date: 2022/6/16
     */
//    @RequestMapping(value = "/listByProject", method = RequestMethod.POST)
    public CommonResponse<List<MaterialDataModelVO>> getList(@RequestBody JSONObject param, HttpServletRequest request) {
        logger.info("项目材料情况入参 : {}", param);
        Map<String, List<Long>> listMap = processData(param);
        Long projectId = param.getLong("projectId");
        List<Long> materialTypeIds = listMap.get("materialTypeIds");

        List<Long> materialIds = listMap.get("materialIds");
        QueryWrapper<T> queryWrapper = new QueryWrapper();
        queryWrapper.in(CollectionUtils.isNotEmpty(materialIds), "material_id", materialIds);
        if (CollectionUtils.isNotEmpty(materialTypeIds)) {
            queryWrapper.or(wrapper -> wrapper.in("material_type_id", materialTypeIds).isNull("material_id"));
        }
        List<MaterialDataModelVO> materialDataModelVOs=new ArrayList<>();
        if (CollectionUtils.isNotEmpty(materialIds) || CollectionUtils.isNotEmpty(materialTypeIds)){
            materialDataModelVOs = materialDataModelService.queryList(projectId, null, queryWrapper);
            if (CollectionUtils.isNotEmpty(materialDataModelVOs)){
                CommonResponse<Map<Long, BigDecimal>> commonResponse = dutyApi.queryDoc(projectId);
                CommonResponse<Map<Long, BigDecimal>> mapCommonResponse = dutyApi.querySumPreTypeAmount(projectId);
                if (commonResponse.isSuccess()){
                    Map<Long, BigDecimal> map = commonResponse.getData();
                    for (MaterialDataModelVO materialDataModelVO : materialDataModelVOs) {
                        if (materialDataModelVO.getMaterialId()!=null){
                            BigDecimal mbNum = map.get(materialDataModelVO.getMaterialId());
                            if (mbNum==null){
                                mbNum=BigDecimal.ZERO;
                            }
                            materialDataModelVO.setMbNum(mbNum);
                        }else {
                            Map<Long, BigDecimal> materialTypeMap = mapCommonResponse.getData();
                            if (materialTypeMap!=null){
                                BigDecimal mbNum = materialTypeMap.get(materialDataModelVO.getMaterialTypeId());
                                if (mbNum==null){
                                    mbNum=BigDecimal.ZERO;
                                }
                                materialDataModelVO.setMbNum(mbNum);
                            }
                        }
                    }
                }
            }
        }
        materialDataModelVOs = getChildrenData(param,materialDataModelVOs);
        return CommonResponse.success("材料情况入参：" + param, materialDataModelVOs);
    }

    @RequestMapping(value = "/listByProject", method = RequestMethod.POST)
    public CommonResponse<List<MaterialDataModelVO>> getList2(@RequestBody JSONObject param, HttpServletRequest request) {
        return CommonResponse.success("材料情况入参：" + param, materialDataModelService.queryListByProjectId(param));
    }

    @RequestMapping(value = "/listByContract", method = RequestMethod.POST)
    public CommonResponse<List<MaterialDataModelVO>> listByContract2(@RequestBody JSONObject param, HttpServletRequest request) {
        return CommonResponse.success("材料情况入参：" + param, materialDataModelService.queryListByContractId(param));
    }

    @RequestMapping(value = "/listByBatPlan", method = RequestMethod.POST)
    public CommonResponse<List<MaterialDataModelVO>> listByBatPlan(@RequestBody JSONObject param, HttpServletRequest request) {
        return CommonResponse.success("材料情况入参：" + param, materialDataModelService.queryListByBatPlan(param));
    }

    /**
     * @param param
     * @param request
     * @description: 合同材料执行情况
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.alibaba.fastjson.JSONObject>>
     * @author songlx
     * @date: 2022/6/16
     */
//    @RequestMapping(value = "/listByContract", method = RequestMethod.POST)
    public CommonResponse<List<MaterialDataModelVO>> listByContract(@RequestBody JSONObject param, HttpServletRequest request) {
        logger.info("合同材料情况入参 : {}", param);
        Map<String, List<Long>> listMap = processData(param);
        Object bill = param.get("bill");
        JSONObject  content = new JSONObject((HashMap) bill);
        String billTypeCode = (String)param.get("billTypeCode");
        Long contractId=null;
        if (DataModelEnum.物资采购合同.getCode().equals(billTypeCode) || DataModelEnum.混凝土采购合同.getCode().equals(billTypeCode)){
            contractId = content.getLong("id");
        }else {
            if (content.get("contractId")!=null){
                JSONObject  contract = new JSONObject((HashMap) content.get("contractId"));
                contractId = contract.getLong("id");
            }
        }

        List<Long> materialTypeIds = listMap.get("materialTypeIds");
        List<Long> materialIds = listMap.get("materialIds");
        QueryWrapper<T> queryWrapper = new QueryWrapper();
        queryWrapper.in(CollectionUtils.isNotEmpty(materialIds), "material_id", materialIds);
        if (CollectionUtils.isNotEmpty(materialTypeIds)) {
            queryWrapper.or(wrapper -> wrapper.in("material_type_id", materialTypeIds).isNull("material_id"));
        }
        List<MaterialDataModelVO> materialDataModelVOs=new ArrayList<>();
        if (contractId!=null){
            if (CollectionUtils.isNotEmpty(materialIds) || CollectionUtils.isNotEmpty(materialTypeIds)){
                materialDataModelVOs = materialDataModelService.queryList(null, contractId, queryWrapper);
            }
        }
        materialDataModelVOs = getChildrenData(param,materialDataModelVOs);
        return CommonResponse.success("材料情况入参：" + param, materialDataModelVOs);
    }

    public static Map<String, List<Long>> processData(JSONObject param){
        Map<String, List<Long>> map = new HashMap<>();
        String materialTypeId="materialTypeId";
        List<Long> materialIds=new ArrayList<>();
        List<Long> materialTypeIds=new ArrayList<>();
        String billTypeCode = (String)param.get("billTypeCode");
        String subTableName = DataModelEnum.getByCode(billTypeCode).getName();
        Object bill = param.get("bill");
        JSONObject  content = new JSONObject((HashMap) bill);
        if (content.get(subTableName)!=null){
            JSONArray jsonArray = content.getJSONArray(subTableName);
            if (jsonArray!=null){
                if (DataModelEnum.消耗材总计划.getCode().equals(billTypeCode) || DataModelEnum.混凝土总计划.getCode().equals(billTypeCode) || DataModelEnum.消耗材总计划变更.getCode().equals(billTypeCode) || DataModelEnum.混凝土总计划变更.getCode().equals(billTypeCode) ){
                    materialTypeId="materialCategoryId";
                }
                for (Object o : jsonArray) {
                    JSONObject  subContent = new JSONObject((HashMap) o);
                    if (subContent.get("materialId")!=null){
                        String materialId = (String)subContent.get("materialId");
                        materialIds.add( Long.parseLong(materialId));
                    }else {
                        String materialCategoryId = (String)subContent.get(materialTypeId);
                        materialTypeIds.add( Long.parseLong(materialCategoryId));
                    }
                }
            }
        }
        map.put("materialTypeIds",materialTypeIds);
        map.put("materialIds",materialIds);
        return map;
    }

    public static List<MaterialDataModelVO> getChildrenData(JSONObject param,List<MaterialDataModelVO> materialDataModelVOs){
        List<MaterialDataModelVO> list=new ArrayList<>();
        Long projectId = param.getLong("projectId");
        String materialTypeId="materialTypeId";
        String materialTypeName="materialTypeName";
        String unit="unit";
        String billTypeCode = (String)param.get("billTypeCode");
        String subTableName = DataModelEnum.getByCode(billTypeCode).getName();
        Object bill = param.get("bill");
        JSONObject  content = new JSONObject((HashMap) bill);
        Map<Long, MaterialDataModelVO> materialMap =
                materialDataModelVOs.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.toMap(MaterialDataModelVO::getMaterialId, Function.identity(),
                        (key1, key2) -> key2));
        Map<Long, MaterialDataModelVO> materialTypeMap =
                materialDataModelVOs.stream().filter(s -> s.getMaterialId() == null).collect(Collectors.toMap(MaterialDataModelVO::getMaterialTypeId, Function.identity(),
                        (key1, key2) -> key2));
        if (content.get(subTableName)!=null){
            JSONArray jsonArray = content.getJSONArray(subTableName);
            if (jsonArray!=null){
                if (DataModelEnum.消耗材总计划.getCode().equals(billTypeCode) || DataModelEnum.混凝土总计划.getCode().equals(billTypeCode) || DataModelEnum.消耗材总计划变更.getCode().equals(billTypeCode) || DataModelEnum.混凝土总计划变更.getCode().equals(billTypeCode) ){
                    materialTypeName="materialCategoryName";
                    materialTypeId="materialCategoryId";
                }
                if (DataModelEnum.物资采购合同.getCode().equals(billTypeCode) || DataModelEnum.混凝土采购合同.getCode().equals(billTypeCode) || DataModelEnum.物资采购合同变更.getCode().equals(billTypeCode) || DataModelEnum.混凝土变更合同.getCode().equals(billTypeCode)){
                    unit="unitName";
                }
                for (Object o : jsonArray) {
                    JSONObject  subContent = new JSONObject((HashMap) o);
                    MaterialDataModelVO materialDataModelVO = new MaterialDataModelVO();
                    long materialType = Long.parseLong(subContent.get(materialTypeId).toString());
                    long materialId = Long.parseLong(subContent.get("materialId")!=null ? subContent.get("materialId").toString() : Long.toString(0));
                    if (materialMap.containsKey(materialId)){
                        materialDataModelVO = materialMap.get(materialId);
                    }
                    if (materialTypeMap.containsKey(materialType)){
                        materialDataModelVO = materialTypeMap.get(materialType);
                    }
                    if (!materialTypeMap.containsKey(materialType) && !materialMap.containsKey(materialId)){
                        materialDataModelVO.setProjectId(projectId);
                        materialDataModelVO.setProjectName(content.get("projectName")!=null ? content.get("projectName").toString() : "");
                        materialDataModelVO.setMaterialTypeId(materialType);
                        materialDataModelVO.setMaterialTypeName(subContent.get(materialTypeName).toString());
                        materialDataModelVO.setMaterialName(subContent.get("materialName")!=null ? subContent.get("materialName").toString() : "");
                        if (subContent.get("materialId")!=null){
                            materialDataModelVO.setMaterialId(Long.parseLong(subContent.get("materialId").toString()));
                        }
                        materialDataModelVO.setSpec(subContent.get("spec")!=null ? subContent.get("spec").toString() : "");
                        String unitName = subContent.get(unit)!=null ? subContent.get(unit).toString() : "";
                        materialDataModelVO.setUnitName(unitName);
                        materialDataModelVO.setContractNum(BigDecimal.ZERO);
                        materialDataModelVO.setMbNum(BigDecimal.ZERO);
                        materialDataModelVO.setPlanNum(BigDecimal.ZERO);
                        materialDataModelVO.setContractMny(BigDecimal.ZERO);
                        materialDataModelVO.setContractTaxMny(BigDecimal.ZERO);
                        materialDataModelVO.setOrderNum(BigDecimal.ZERO);
                        materialDataModelVO.setCheckNum(BigDecimal.ZERO);
                        materialDataModelVO.setCheckTaxMny(BigDecimal.ZERO);
                        materialDataModelVO.setCheckMny(BigDecimal.ZERO);
                        materialDataModelVO.setSettlementNum(BigDecimal.ZERO);
                        materialDataModelVO.setSettlementTaxMny(BigDecimal.ZERO);
                        materialDataModelVO.setSettlementMny(BigDecimal.ZERO);
                        materialDataModelVO.setAccountNum(BigDecimal.ZERO);
                    }
                    list.add(materialDataModelVO);
                }
            }
        }
        return list;
    }

}
