package com.ejianc.business.promaterial.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.enums.*;
import com.ejianc.business.promaterial.order.service.IOrderDetailService;
import com.ejianc.business.promaterial.order.vo.*;
import com.ejianc.business.promaterial.plan.bean.PlanDetailEntity;
import com.ejianc.business.promaterial.plan.service.IPlanDetailService;
import com.ejianc.business.promaterial.plan.utils.TreeNodeBUtil;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.SupplierProVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.order.mapper.OrderMapper;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.service.IOrderService;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料订单主表
 * 
 * @author generator
 * 
 */
@Service("orderService")
public class OrderServiceImpl extends BaseServiceImpl<OrderMapper, OrderEntity> implements IOrderService {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "XHC_ORDER";//此处需要根据实际修改
    @Autowired
    private IOrderService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Value("${common.env.base-host}")
    private String baseHost;

    private final String OPERATE = "MATERIAL_ORDER_SYNC";

    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialOrder/saveOrUpdate";

    private final String UPDATE_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialOrder/updateOrderCloseFlag";

    /*
     * 新增（修改）保存
     * */
    @Override
    public CommonResponse<OrderVO> saveOrUpdate(OrderVO saveOrUpdateVO) {
        OrderEntity entity = BeanMapper.map(saveOrUpdateVO, OrderEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //校验供应商
        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("获取供应商信息失败！");
        }
        Boolean flag = supplierResp.getData();
        if(!flag){
            return CommonResponse.error("该供应商未开通协同权限，无法新增订单。 请先到供应商库—生成协同账号再进行订单操作。");
        }

        List<OrderDetailEntity> orderDetailList = entity.getOrderDetailList();
        ArrayList<OrderDetailEntity> delOrderDetailList = new ArrayList<>();//删除子表父级
        ArrayList<OrderDetailEntity> addOrderDetailList = new ArrayList<>();//新增子表父级
        ArrayList<OrderDetailEntity> updateOrderDetailList = new ArrayList<>();//修改子表父级
        if (entity.getId() == null || entity.getId() == 0) {
            if (CollectionUtils.isNotEmpty(orderDetailList)) {
                for (OrderDetailEntity detail : orderDetailList) {
                    detail.setLeafFlag(false);
                    if (detail.getSourceType().equals(SourceTypeEnum.需用计划.getCode())) {//是否是需用计划
                        addOrderDetailList.add(detail);
                    }
                }
            }
        } else {
            if (CollectionUtils.isNotEmpty(orderDetailList)) {
                for (OrderDetailEntity detail : orderDetailList) {
                    detail.setLeafFlag(false);
                    if (detail.getSourceType().equals(SourceTypeEnum.需用计划.getCode())) {//是否是需用计划
                        if (detail.getId() != null) {
                            if ("del".equals(detail.getRowState())) {//删除
                                delOrderDetailList.add(detail);
                            } else {//修改
                                OrderDetailEntity byId = orderDetailService.getById(detail.getId());
                                BigDecimal orderNumsSum = detail.getOrderNumsSum()==null?BigDecimal.ZERO:detail.getOrderNumsSum();
                                BigDecimal byNumsSum = byId.getOrderNumsSum()==null?BigDecimal.ZERO:byId.getOrderNumsSum();
                                if (orderNumsSum.compareTo(byNumsSum)!=0) {//量有变化
                                    updateOrderDetailList.add(detail);
                                }
                            }
                        } else {//新增
                            addOrderDetailList.add(detail);
                        }
                    }
                }
            }
        }
        entity.setOrderFlag(0);
        super.saveOrUpdate(entity, false);
        if (CollectionUtils.isNotEmpty(delOrderDetailList)) {
            this.delOrderDetail(delOrderDetailList, entity.getId());//删除
        }
        if (CollectionUtils.isNotEmpty(addOrderDetailList)) {
            this.addOrderDetail(addOrderDetailList, entity.getProjectId(), entity.getId());//新增
        }
        if (CollectionUtils.isNotEmpty(updateOrderDetailList)) {
            this.updateOrderDetail(updateOrderDetailList, entity.getProjectId(), entity.getId());//修改
        }
//        //为子表tid赋值
//        LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
//        lambda.eq(OrderDetailEntity::getOrderId, entity.getId());
//        List<OrderDetailEntity> list = orderDetailService.list(lambda);
//        if(CollectionUtils.isNotEmpty(list)){
//            for (OrderDetailEntity orderDetailEntity : list) {
//                orderDetailEntity.setTid(orderDetailEntity.getId());
//            }
//            orderDetailService.saveOrUpdateBatch(list);
//        }
        OrderVO vo = BeanMapper.map(entity, OrderVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
/*
* 查询详情
* */
    @Override
    public CommonResponse<OrderVO> queryDetail(Long id) {
        OrderEntity entity = service.selectById(id);
        OrderVO orderVO = BeanMapper.map(entity, OrderVO.class);
        List<OrderDetailVO> orderDetailVOS = new ArrayList<>();
        List<OrderDetailVO> orderDetailList = orderVO.getOrderDetailList();
        if(CollectionUtils.isNotEmpty(orderDetailList)){
            orderDetailList.forEach(vo -> {
                if (vo.getLeafFlag() == null || !vo.getLeafFlag()) {
                    BigDecimal surplusNumsSum = planDetailService.getSurplusNumsSum(orderVO.getProjectId(), vo.getMaterialId());
                    surplusNumsSum = surplusNumsSum==null?BigDecimal.ZERO:surplusNumsSum;
                    vo.setNewSurplusNumsSum(surplusNumsSum);//最新计划剩余
                    orderDetailVOS.add(vo);
                }
            });
            if(CollectionUtils.isNotEmpty(orderDetailVOS)){
                Map<Long, List<OrderDetailVO>> map = orderDetailList.stream().filter(t -> t.getParentId() != null && t.getLeafFlag() != null && t.getLeafFlag()).collect(Collectors.groupingBy(OrderDetailVO::getParentId));
                for (OrderDetailVO orderDetailVO : orderDetailVOS) {
                    List<OrderDetailVO> orderDetailVOS1 = map.get(orderDetailVO.getMaterialId());
                    if(orderDetailVO.getSourceType()==0 && CollectionUtils.isNotEmpty(orderDetailVOS1)){
                        orderDetailVO.setOrderDetailVOS(orderDetailVOS1);
                    }
                }
            }
        }
        orderVO.setOrderDetailList(orderDetailVOS);
//        OrderVO vo = BeanMapper.map(entity, OrderVO.class);
        return CommonResponse.success("查询详情数据成功！", orderVO);
    }
/*
* 删除
* */
    @Override
    public CommonResponse<String> delete(List<OrderVO> vos) {
        List<Long> ids = vos.stream().map(OrderVO::getId).collect(Collectors.toList());
        List<OrderEntity> orderList = (List<OrderEntity>) service.listByIds(ids);
        if (CollectionUtils.isNotEmpty(orderList)) {
            for (OrderEntity orderEntity : orderList) {
                LambdaQueryWrapper<OrderDetailEntity> lambda = new LambdaQueryWrapper<>();
                lambda.eq(OrderDetailEntity::getOrderId, orderEntity.getId());
                List<OrderDetailEntity> list = orderDetailService.list(lambda);//查询子表
                List<OrderDetailEntity> orderDetailEntities = new ArrayList<>();//需用父级
                if (CollectionUtils.isNotEmpty(list)) {
                    for (OrderDetailEntity orderDetailEntity : list) {//筛选父级
                        if ((orderDetailEntity.getLeafFlag() == null || !orderDetailEntity.getLeafFlag()) && orderDetailEntity.getSourceType().equals(SourceTypeEnum.需用计划.getCode())) {
                            orderDetailEntities.add(orderDetailEntity);
                        }
                    }
                }
                delOrderDetail(orderDetailEntities, orderEntity.getId());
            }
        }
        service.removeByIds(ids, true);
        return CommonResponse.success("删除成功！");
    }

    /*
    * 保存校验
    * */
    @Override
    public Map<String, Object> savaHintFlag(OrderVO orderVO) {
        Map<String, Object> stringObjectMap = new HashMap<>();
        String hint = "";
        Boolean hintFlag = true;
        LambdaQueryWrapper<ContractDetailEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractDetailEntity::getContractId, orderVO.getContractId());
        lambda.ne(ContractDetailEntity::getChangeType, ChangeTypeEnum.中止项.toString());
        List<ContractDetailEntity> list3 = contractDetailService.list(lambda);
        //合同明细转为map
        Map<Long, ContractDetailEntity> detailVOMap = list3.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, item -> item, (v1, v2) -> v2));
        if (CollectionUtils.isNotEmpty(orderVO.getOrderDetailList())) {
            //分别查询出合同和计划
            ArrayList<OrderDetailVO> contractOrderDetail = new ArrayList<>();//合同明细
            for (OrderDetailVO orderDetailVO : orderVO.getOrderDetailList()) {
                if (orderDetailVO.getSourceType().equals(SourceTypeEnum.需用计划.getCode()) && !"del".equals(orderDetailVO.getRowState())) {
                    if (!detailVOMap.containsKey(orderDetailVO.getMaterialId())) {//比较是否在合同明细
                        if(hint.equals("")){
                            hint = orderDetailVO.getDetailIndex();
                        }else {
                            hint = hint + "、"+ orderDetailVO.getDetailIndex() ;
                        }
                    }
                }
            }
        }
        if (!hint.equals("")) {
            hintFlag = false;
        }
        stringObjectMap.put("hintFlag", hintFlag);
        stringObjectMap.put("hint", "第"+hint + "行材料不在合同清单内，是否继续保存？");
        return stringObjectMap;
    }


    //删除回显
    public void delOrderDetail(List<OrderDetailEntity> delOrderDetailList, Long orderId) {
        ArrayList<PlanDetailEntity> planDetailList = new ArrayList<>();
        ArrayList<OrderDetailEntity> orderDetailList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(delOrderDetailList)) {
            for (OrderDetailEntity delOrderDetail : delOrderDetailList) {//遍历父级
                LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
                lambda.eq(OrderDetailEntity::getParentId, delOrderDetail.getTid());//根据父级tid
                lambda.eq(OrderDetailEntity::getOrderId, orderId);
                List<OrderDetailEntity> list = orderDetailService.list(lambda);//查询子级
                if (CollectionUtils.isNotEmpty(list)) {
                    for (OrderDetailEntity orderDetail : list) {//遍历子级进行计划分摊
                        PlanDetailEntity entity = planDetailService.getById(orderDetail.getSourceDetailId());
                        BigDecimal nums = entity.getNums() == null ? BigDecimal.ZERO : entity.getNums();// 数量
                        BigDecimal occupyNums = entity.getOccupyNums() == null ? BigDecimal.ZERO : entity.getOccupyNums();// 占用数量
                        BigDecimal orderNums = orderDetail.getOrderNumsSum() == null ? BigDecimal.ZERO : orderDetail.getOrderNumsSum();//订单量
                        entity.setOccupyNums(occupyNums.subtract(orderNums));
                        entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                        planDetailList.add(entity);
                        orderDetailList.add(orderDetail);
                    }
                }
            }
            logger.info("删除修改计划-----"+JSONObject.toJSONString(planDetailList));
            if(CollectionUtils.isNotEmpty(planDetailList)){
                planDetailService.updateBatchById(planDetailList);
            }
            logger.info("删除修改订单-----"+JSONObject.toJSONString(orderDetailList));
            if(CollectionUtils.isNotEmpty(orderDetailList)){
                orderDetailService.removeByIds(orderDetailList.stream().map(OrderDetailEntity::getId).collect(Collectors.toList()), true);
            }
        }
    }

    //新增回显
    public void addOrderDetail(List<OrderDetailEntity> addOrderDetailList, Long projectId, Long orderId) {
        List<OrderDetailEntity> orderDetail = new ArrayList<>();
        List<PlanDetailEntity> planDetail = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(addOrderDetailList)) {
            for (OrderDetailEntity addOrderDetail : addOrderDetailList) {//遍历父级
                List<OrderDetailVO> orderDetailVOS = planDetailService.queryMaterialDetail(projectId, addOrderDetail.getMaterialId());//库存大于0的计划明细
                BigDecimal orderNumsSum = addOrderDetail.getOrderNumsSum() == null ? BigDecimal.ZERO : addOrderDetail.getOrderNumsSum();//父级订单量
                if (CollectionUtils.isNotEmpty(orderDetailVOS)) {
                    for (int i = 0; i < orderDetailVOS.size(); i++) {
                        orderDetailVOS.get(i).setLeafFlag(true);
                        orderDetailVOS.get(i).setOrderId(orderId);
                        orderDetailVOS.get(i).setParentId(addOrderDetail.getTid());
                        if (orderNumsSum.compareTo(BigDecimal.ZERO) > 0) {//总订单>0  明细订单= 计划明细剩余
                            if(addOrderDetail.getConstruction()==null){
                                addOrderDetail.setConstruction(orderDetailVOS.get(i).getConstruction());
                            }else {
                                addOrderDetail.setConstruction(addOrderDetail.getConstruction()+"、"+ orderDetailVOS.get(i).getConstruction());
                            }
                            //查询计划明细
                            PlanDetailEntity entity = planDetailService.getById(orderDetailVOS.get(i).getSourceDetailId());
                            BigDecimal nums = entity.getNums() == null ? BigDecimal.ZERO : entity.getNums();// 计划需用数量
                            BigDecimal occupyNums = entity.getOccupyNums() == null ? BigDecimal.ZERO : entity.getOccupyNums();// 计划占用数量
                            BigDecimal surplusNums = entity.getSurplusNums() == null ? BigDecimal.ZERO : entity.getSurplusNums();// 计划剩余
                            if (orderNumsSum.compareTo(surplusNums) < 0) {//总订单量小于剩余量 取总订单量
                                orderDetailVOS.get(i).setOrderNumsSum(orderNumsSum);
                            } else {
                                orderDetailVOS.get(i).setOrderNumsSum(surplusNums);
                            }
                            BigDecimal orderNums = orderDetailVOS.get(i).getOrderNumsSum() == null ? BigDecimal.ZERO : orderDetailVOS.get(i).getOrderNumsSum();
                            if (surplusNums.compareTo(orderNums) < 0) {
                                throw new BusinessException("【订单数量】不能超过计划剩余量，该材料明细实际剩余量为【" + surplusNums + "】!");
                            }
                            entity.setOccupyNums(occupyNums.add(orderNums));
                            entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                            orderDetailVOS.get(i).setSurplusNumsSum(entity.getSurplusNums());//重新记录计划剩余
                            orderNumsSum = orderNumsSum.subtract(orderNums);
                            orderDetail.add(BeanMapper.map(orderDetailVOS.get(i), OrderDetailEntity.class));
                            planDetail.add(entity);
                        }
                    }
                }
                orderDetail.add(addOrderDetail);
            }
            logger.info("新增修改计划-----"+JSONObject.toJSONString(planDetail));
            if (CollectionUtils.isNotEmpty(planDetail)){
                planDetailService.updateBatchById(planDetail);
            }
            logger.info("新增/修改订单-----"+JSONObject.toJSONString(orderDetail));
            if(CollectionUtils.isNotEmpty(orderDetail)){
                orderDetailService.saveOrUpdateBatch(orderDetail);
            }
        }
    }

    //修改回显
    public void updateOrderDetail(List<OrderDetailEntity> updateOrderDetailList, Long projectId, Long orderId) {
        if (CollectionUtils.isNotEmpty(updateOrderDetailList)) {
//            ArrayList<OrderDetailEntity> addOrder = new ArrayList<>();
//            ArrayList<OrderDetailEntity> delOrder = new ArrayList<>();
//            LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
//            lambda.eq(OrderDetailEntity::getLeafFlag, false);
//            lambda.eq(OrderDetailEntity::getOrderId, orderId);
//            List<OrderDetailEntity> list = orderDetailService.list(lambda);//子级库的父级
//            Map<Long, OrderDetailEntity> detailEntityMap = list.stream().filter(t -> t.getId() != null).collect(Collectors.toMap(OrderDetailEntity::getId, item -> item, (v1, v2) -> v2));
//            for (OrderDetailEntity updateOrderDetail: updateOrderDetailList){
//                if(detailEntityMap.containsKey(updateOrderDetail.getId())){
//                    if(updateOrderDetail)
//
//                    delOrder.add(detailEntityMap.get(updateOrderDetail.getId()));
//                }
//                addOrder.add(detailEntityMap.get(updateOrderDetail.getId()));
//            }
            this.delOrderDetail(updateOrderDetailList, orderId);
            this.addOrderDetail(updateOrderDetailList, projectId, orderId);
        }
    }
/*
* 接受
* @param orderVO - 供方推送的订单vo
* */
    @Override
    public CommonResponse<OrderVO> updateReceived(SupOrderVO orderVO) {
        logger.info("---接收开始---",JSONObject.toJSONString(orderVO));
        OrderEntity orderEntity = super.selectById(orderVO.getId());
        if (null != orderEntity && null != orderEntity.getReceiveState() && orderEntity.getReceiveState() > 0 && 4 != orderVO.getReceiveState()) {
            return CommonResponse.error("该订单已被操作,请刷新后重试");
        }

        // TO DO 消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        List<String> sender = new ArrayList<>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        logger.info("发送信息给发布人:>----------" + sender + baseHost);
        String formurl = baseHost + "ejc-promaterial-mobile/#/purchaseOrder/card?id=" + orderEntity.getId();
        String subject = "";
        String content = "";
        //全部接收
        if (1 == orderVO.getReceiveState()) {
            logger.info("---全部接受开始---");
            orderEntity.setReceiveState(1);//全部接收
            orderEntity.setDeliverState(0);//待发货
            subject = "您的订单【" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + orderEntity.getSupplierName() + "】全部接收。";
            content = "您的订单【" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + orderEntity.getSupplierName() + "】全部接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            //拆分接收数量
            logger.info("---拆分接收数量---");
            OrderDetailBack(orderVO.getMaterialOrderDetailList(), 1);
            orderEntity.getOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(vo.getOrderNumsSum());//接收数量
                vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
            });
        } else if (2 == orderVO.getReceiveState()) {
            logger.info("---部分接受开始---");
            //部分接收
            orderEntity.setReceiveState(2);//部分接收
            orderEntity.setDeliverState(0);//待发货
            subject = "您的订单【" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + orderEntity.getSupplierName() + "】部分接收。";
            content = "您的订单【" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + orderEntity.getSupplierName() + "】部分接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orderVO.getMaterialOrderDetailList())) {
                //拆分接收数量
                //拆分接收数量
                logger.info("---拆分接收数量---");
                OrderDetailBack(orderVO.getMaterialOrderDetailList(), 1);
                Map<Long, BigDecimal> map = orderVO.getMaterialOrderDetailList().stream().collect(Collectors.toMap(SupOrderDetailVO::getId, SupOrderDetailVO::getReceiveNumsSum));
                logger.debug("map------" + map);
                orderEntity.getOrderDetailList().forEach(vo -> {
                    vo.setReceiveNumsSum(map.get(vo.getId()));
                    logger.debug("ReceiveNumsSum------" + vo.getReceiveNumsSum());
                    vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                });
            }
        } else if (3 == orderVO.getReceiveState()) {
            logger.info("---不予接受开始---");
            //已拒绝
            orderEntity.setReceiveState(3);//拒绝
            orderEntity.setReceiveReason(orderVO.getReceiveReason());
            subject = "您的订单【" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + orderEntity.getSupplierName() + "】拒绝接收。";
            content = "您的订单【" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + orderEntity.getSupplierName() + "】拒绝接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            //拆分接收数量
            logger.info("---拆分接收数量---");
            OrderDetailBack(orderVO.getMaterialOrderDetailList(), 1);
            orderEntity.getOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(BigDecimal.ZERO);//接收数量
                vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
            });
        }
        this.sendMsg(messageType, sender, "notice", subject, content, String.valueOf(orderEntity.getTenantId()), orderEntity);
        logger.debug("-----主键" + orderEntity.getId());
        super.saveOrUpdate(orderEntity, false);
        return CommonResponse.success("操作成功");
    }


/*
接收回显计划方法
算法
--@param detailList 供方推送子表
*/
    //1-全部接收，2-部分接收，3-全部拒绝
    public void OrderDetailBack(List<SupOrderDetailVO> detailList,int type){
        List<OrderDetailEntity> entityList = new ArrayList<>();
        List<PlanDetailEntity> planDetailList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(vo -> {
                OrderDetailEntity orderDetailEntity = orderDetailService.getById(vo.getId());//取当前行的tid
                //查询订单数量>接收数量的明细  根据主键正序排
                LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
                lambda.eq(OrderDetailEntity::getParentId,orderDetailEntity.getTid());
                lambda.eq(OrderDetailEntity::getOrderId,orderDetailEntity.getOrderId());
                lambda.eq(OrderDetailEntity::getLeafFlag,true);
                lambda.orderByAsc(OrderDetailEntity::getId);
                List<OrderDetailEntity> details  = orderDetailService.list(lambda);
                if(CollectionUtils.isNotEmpty(details)){
                    BigDecimal receiveNumsSum = vo.getReceiveNumsSum()==null?BigDecimal.ZERO:vo.getReceiveNumsSum();//汇总的接收数量
                    //forEach  不能这样用    xx = xx.subtract(xx);
                    for(int i=0;i<details.size();i++){
                        BigDecimal orderNumsSum = details.get(i).getOrderNumsSum()==null?BigDecimal.ZERO:details.get(i).getOrderNumsSum();//订单量
                        if(receiveNumsSum.compareTo(BigDecimal.ZERO)>0){
                            if(receiveNumsSum.compareTo(orderNumsSum)>=0){
                                //接收数量  大于该行  剩余可接收数量，则直接将该行  接收数量=订单数量即可
                                details.get(i).setReceiveNumsSum(orderNumsSum);
                                receiveNumsSum = receiveNumsSum.subtract(orderNumsSum);
                            }else{
                                //接收数量  小于该行  剩余可接收数量，则直接将该行  接收数量=原来订单数量+行汇总后的剩余接收数量
                                details.get(i).setReceiveNumsSum(receiveNumsSum);
                                //此时需要回写计划订单明细对应的占用金额
                                PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getSourceDetailId());
                                BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
                                BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();

                                planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum).add(receiveNumsSum));//占用量
                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
                                receiveNumsSum = receiveNumsSum.subtract(receiveNumsSum);
                                planDetailList.add(planDetailEntity);
                            }
                            entityList.add(details.get(i));//后续批量更新
                        }else {
                            PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getSourceDetailId());
                            BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
                            BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();

                            planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum));//占用量
                            planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
                            planDetailList.add(planDetailEntity);
                        }
                    }
                    //批量更新订单明细
                    if(CollectionUtils.isNotEmpty(entityList)){
                        orderDetailService.updateBatchById(entityList);
                    }
                    //批量更新计划明细
                    if(CollectionUtils.isNotEmpty(planDetailList)){
                        planDetailService.updateBatchById(planDetailList);
                    }
                }
            });
        }
    }
/*
* 供方修改送货状态
* */
    @Override
    public CommonResponse<String> updateDeliver(Long orderId,Integer deliverState) {
        logger.info("订单id:-{},修改发货状态开始!",orderId);
        OrderEntity byId = super.getById(orderId);
        byId.setDeliverState(deliverState);
        super.saveOrUpdate(byId);
        logger.info("订单id:-{},修改发货状态为:-{}成功!",orderId,deliverState);
        return  CommonResponse.success("订单id:"+orderId+"修改发货状态为："+deliverState+"成功!");
    }
/*
* 获取最新的计划剩余数量
* */
    @Override
    public BigDecimal getSurplusNumsSum(Long orderDetailId,Long projectId, Long materialId) {
        BigDecimal surplusNumsSum = planDetailService.getSurplusNumsSum(projectId, materialId);
        if(orderDetailId!=null){
            OrderDetailEntity orderDetailEntity = orderDetailService.selectById(orderDetailId);
            BigDecimal orderNumsSum=orderDetailEntity.getOrderNumsSum()==null?BigDecimal.ZERO:orderDetailEntity.getOrderNumsSum();
            surplusNumsSum = orderNumsSum.add(surplusNumsSum);
        }
        return surplusNumsSum;
    }
    /*
* 关闭查询验收-对比-回显计划
* */
    @Override
    public CommonResponse<String> close(Long orderId){
        OrderEntity orderEntity = super.selectById(orderId);
        CommonResponse<String> res = updatePushBill(orderEntity,"BT220223000000006",UPDATE_BILL_SERVER_URL);
//            orderEntity.setOrderFlag(1);
            orderEntity.setOrderFlag(OrderFlagEnum.已关闭.getCode());//修改状态为关闭
            /*查询子表父级*/
            LambdaQueryWrapper<OrderDetailEntity> ordLambda = new LambdaQueryWrapper();
            ordLambda.eq(OrderDetailEntity::getOrderId, orderId);
            ordLambda.eq(OrderDetailEntity::getLeafFlag, false);
            List<OrderDetailEntity> list1 = orderDetailService.list(ordLambda);//查询父级
            /*查询该订单的验收所有子表*/
            List<CheckDetailVO> list = baseMapper.getCheckDetail(orderId);
//            LambdaQueryWrapper<CheckDetailEntity> cheLambda = new LambdaQueryWrapper();
//            cheLambda.eq(CheckDetailEntity::getOrderId, orderId);
//            List<CheckDetailEntity> list = checkDetailService.list(cheLambda);//查询验收
            /*----*/
            List<OrderDetailEntity> orderDetailList = new ArrayList<OrderDetailEntity>();//订单明细
            List<PlanDetailEntity> planDetailList = new ArrayList<PlanDetailEntity>();//计划明细
            Map<Long, CheckDetailVO> map = list.stream().filter(t -> t.getOrderDetailId() != null).collect(Collectors.toMap(CheckDetailVO::getOrderDetailId, item -> item, (v1, v2) -> v2));
            /*遍历订单子表父级*/
            for (OrderDetailEntity orderDetail : list1) {
                /*该父级是否被验收*/
                if(map.containsKey(orderDetail.getId())) {
                    CheckDetailVO checkDetail = map.get(orderDetail.getId());
                    BigDecimal checkNum = checkDetail.getCheckNum() == null ? BigDecimal.ZERO : checkDetail.getCheckNum();//验收总量
                    orderDetail.setCheckNumsSum(checkNum);//父级验收等于验收父级验收
                    /*是否是需用计划*/
                    if(orderDetail.getSourceType().equals(SourceTypeEnum.需用计划.getCode())){//是否需用计划
                        /*查询该订单子表子级*/
                        LambdaQueryWrapper<OrderDetailEntity> lambda = new LambdaQueryWrapper();
                        lambda.eq(OrderDetailEntity::getParentId, orderDetail.getTid());
                        lambda.orderByDesc(OrderDetailEntity::getPlanDate);
                        lambda.eq(OrderDetailEntity::getOrderId, orderDetail.getOrderId());
                        lambda.eq(OrderDetailEntity::getLeafFlag, true);
                        List<OrderDetailEntity> list2 = orderDetailService.list(lambda);//查询子级
                        /*遍历子级，根据接受回显计划*/
                        for (OrderDetailEntity detailEntity : list2) {
                            BigDecimal receiveNumsSum = detailEntity.getReceiveNumsSum()==null?BigDecimal.ZERO :detailEntity.getReceiveNumsSum();//子级接受
                            if(checkNum.compareTo(BigDecimal.ZERO)>0){//总验收>0 分摊子级
                                if(checkNum.compareTo(receiveNumsSum)>=0){//验收大于等于接受，验收等于接受
                                    detailEntity.setCheckNumsSum(receiveNumsSum);
                                    checkNum = checkNum.subtract(receiveNumsSum);
                                }else {
                                    detailEntity.setCheckNumsSum(checkNum);//小于验收等于验收  回显计划
                                    BigDecimal subtract = receiveNumsSum.subtract(checkNum);//接受-验收  差值
                                    PlanDetailEntity planDetailEntity = planDetailService.selectById(detailEntity.getSourceDetailId());
                                    BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();//占用数量
                                    BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();
                                    planDetailEntity.setOccupyNums(occupyNums.subtract(subtract));//占用量 = 减去差值
                                    planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
                                    planDetailList.add(planDetailEntity);
                                }
                            }else {//如果还有为分摊完的子级 回显计划
                                detailEntity.setCheckNumsSum(BigDecimal.ZERO);
                                PlanDetailEntity planDetailEntity = planDetailService.selectById(detailEntity.getSourceDetailId());
                                BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();//占用数量
                                BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();
                                planDetailEntity.setOccupyNums(occupyNums.subtract(receiveNumsSum));//占用量 = 减去接受
                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
                                planDetailList.add(planDetailEntity);
                            }
                            orderDetailList.add(detailEntity);
                        }
                    }
                }else {
                    orderDetail.setCheckNumsSum(BigDecimal.ZERO);//父级验收等于0
                    if(orderDetail.getSourceType().equals(SourceTypeEnum.需用计划.getCode())){
                        /*查询该订单子表子级*/
                        LambdaQueryWrapper<OrderDetailEntity> lambda = new LambdaQueryWrapper();
                        lambda.eq(OrderDetailEntity::getParentId, orderDetail.getTid());
                        lambda.eq(OrderDetailEntity::getLeafFlag, true);
                        lambda.eq(OrderDetailEntity::getOrderId, orderDetail.getOrderId());
                        lambda.orderByDesc(OrderDetailEntity::getPlanDate);
                        List<OrderDetailEntity> list2 = orderDetailService.list(lambda);
                        /*遍历子级，根据接受回显计划*/
                        for (OrderDetailEntity detailEntity : list2) {
                            BigDecimal receiveNumsSum = detailEntity.getReceiveNumsSum()==null?BigDecimal.ZERO:detailEntity.getReceiveNumsSum();//接受量
                            PlanDetailEntity planDetailEntity = planDetailService.selectById(detailEntity.getSourceDetailId());
                            BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();//占用数量
                            BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();
                            planDetailEntity.setOccupyNums(occupyNums.subtract(receiveNumsSum));//占用量
                            planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
                            detailEntity.setCheckNumsSum(BigDecimal.ZERO);
                            planDetailList.add(planDetailEntity);
                            orderDetailList.add(detailEntity);
                        }
                    }
                }
                orderDetailList.add(orderDetail);
            }
            if(CollectionUtils.isNotEmpty(orderDetailList)){//批量修改订单明细
                orderDetailService.saveOrUpdateBatch(orderDetailList);
            }
            if(CollectionUtils.isNotEmpty(planDetailList)){//批量修改计划明细
                planDetailService.saveOrUpdateBatch(planDetailList);
            }
//            super.saveOrUpdate(orderEntity);
            super.updateById(orderEntity);
            return CommonResponse.success("关闭成功");
    }
/*
* 提交推送供方
 */
    @Override
    public boolean pushBillToSupCenter(OrderEntity orderEntity, String billTypeCode) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + orderEntity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送计量单据-{}失败，获取当前系统编码失败,{}", orderEntity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        orderEntity.setSystemId(ejcCloudSystemCode.getData());

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            SupOrderVO supOrderVO = BeanMapper.map(orderEntity, SupOrderVO.class);
            List<SupOrderDetailVO> supOrderDetailVOS = BeanMapper.mapList(orderEntity.getOrderDetailList(), SupOrderDetailVO.class);
            supOrderVO.setMaterialOrderDetailList(supOrderDetailVOS);
            paramMap.put("order", JSONObject.toJSONString(supOrderVO));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(orderEntity.getId(), "BT220223000000006", "material-order-attaches", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                //当前单据携带有附件信息
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送计量单据参数-{}", orderEntity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        orderEntity.getSupplierId().toString(),
                        files);
                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
//                if (syncReqResp.isSuccess()) {
//                    JSONObject jsonObject = JSONObject.parseObject(syncReqResp.getData());
//                    // 如果返回的结果包含code
//                    if(StringUtils.isNotEmpty(syncReqResp.getData())&& jsonObject.containsKey("code")){
//                        CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
//                        if (billPushResp.isSuccess()) {
//                            syncFlag = true;
//                        } else {
//                            logger.error("供方id-{}处理推送订单单据id-{}失败, {}", orderEntity.getSupplierId(), orderEntity.getId(), billPushResp.getMsg());
//                            throw new BusinessException(billPushResp.getMsg());
//                        }
//                    }else {
//                        throw new BusinessException();
//                    }
//
//                } else {
//                    logger.error("发送请求推送订单单据id-{}给供方id-{}失败, {}", orderEntity.getId(), orderEntity.getSupplierId(), syncReqResp.getMsg());
//                    throw new BusinessException(syncReqResp.getMsg());
//                }
            } else {
                logger.error("获取订单单据id-{}对应附件信息失败, {}", orderEntity.getId(), fileResp.getMsg());
                throw new BusinessException(fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送订单单据id-{}给供方id-{} 异常，", orderEntity.getId(), orderEntity.getSupplierId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }
    /*
    * 撤回推送供方
    *  */
    @Override
    public CommonResponse<String> updatePushBill(OrderEntity orderEntity, String billTypeCode,String url) {
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + orderEntity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", orderEntity.getId(), ejcCloudSystemCode.getMsg());
            return CommonResponse.error("推送供方异常!");
        }
        //设置当前系统ID
        orderEntity.setSystemId(ejcCloudSystemCode.getData());

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return CommonResponse.error("单据作废失败，单据锁获取失败!");
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("id", orderEntity.getId().toString());
            paramMap.put("systemId", orderEntity.getSystemId());
            logger.info("单据id-{}弃审，通知供方-{}单据作废!", orderEntity.getSupplierId(), orderEntity.getId());

            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(url,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    orderEntity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    return supHandleResp;
                } else {
                    logger.error("供方-{}处理作废单据id-{}作废失败, {}", orderEntity.getSupplierId(), orderEntity.getId(), supHandleResp.getMsg());
                    throw new BusinessException(supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", orderEntity.getSupplierId(), orderEntity.getId(), syncReqResp.getMsg());
                throw new BusinessException(syncReqResp.getMsg());
            }

        }
        catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", orderEntity.getId(), e);
            throw e;
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }
    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String tenantId,OrderEntity orderEntity) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());


//        if (messageType.contains("wjy")) {
//            JSONObject wjyMsgParams  = new JSONObject();
//            wjyMsgParams.put("appid", appid);
//            wjyMsgParams.put("from", "供方平台");
//            wjyMsgParams.put("msg", subject);
//            wjyMsgParams.put("url", wjyPath+"cscec5b-wzxt-mobile/#/orderIndex/orderDetails?id="+orderEntity.getId()+"&userid={userid}");
//            parameter.setWjyMsgParams(wjyMsgParams);
//        }

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }
}
