/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.check.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.mapper.CheckMapper;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.impl.CheckBpmServiceImpl;
import com.ejianc.business.promaterial.check.service.impl.CheckServiceImpl;
import com.ejianc.business.promaterial.check.service.impl.ConcreteCheckBpmServiceImpl;
import com.ejianc.business.promaterial.check.vo.CheckDesktopDTO;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.check.vo.SupplierPushCheckDetailVO;
import com.ejianc.business.promaterial.check.vo.SupplierPushCheckVO;
import com.ejianc.business.promaterial.contract.vo.MaterialMnyVO;
import com.ejianc.business.promaterial.contract.vo.ReferenceDetailVO;
import com.ejianc.business.promaterial.contract.vo.ReferenceMapVO;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"check"})
@Api(value="\u6d88\u8017\u6750-\u9a8c\u6536\u4e3b\u8868", tags={"\u6d88\u8017\u6750-\u9a8c\u6536\u4e3b\u8868"})
public class CheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "XHC-CHECK-CODE";
    private static final String BILL_TYPE = "BT220215000000006";
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/check/card";
    @Autowired
    private ICheckService service;
    @Autowired
    private CheckServiceImpl serviceimpl;
    @Autowired
    private CheckBpmServiceImpl checkBpmService;
    @Autowired
    private ConcreteCheckBpmServiceImpl concreteCheckBpmService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/materialCheck/saveCheck";
    @Autowired
    ICommonBusinessService check;
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private CheckMapper checkMapper;

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> test(@RequestParam Long id) {
        CommonResponse<String> stringCommonResponse = this.concreteCheckBpmService.afterApprovalProcessor(id, null, null);
        return stringCommonResponse;
    }

    @ApiOperation(value="\u540c\u6b65\u76ee\u6807\u6210\u672c\u63a5\u53e3")
    @RequestMapping(value={"/syncCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncCost(@RequestParam Long id) {
        CheckEntity checkEntity = this.service.syncCost(id);
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody CheckVO saveOrUpdateVO) {
        ArrayList<Long> usedIds = new ArrayList<Long>();
        ArrayList<Long> unuseIds = new ArrayList<Long>();
        List detailList = saveOrUpdateVO.getCheckDetailList();
        if (ListUtil.isNotEmpty((List)detailList)) {
            detailList.forEach(sub -> {
                if (null != sub.getSourceMainId()) {
                    if ("del".equals(sub.getRowState())) {
                        unuseIds.add(sub.getSourceMainId());
                    } else {
                        usedIds.add(sub.getSourceMainId());
                    }
                }
            });
        }
        CheckVO vo = this.service.saveOrUpdates(saveOrUpdateVO, false);
        this.serviceimpl.updSmartStore(usedIds, unuseIds);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6d88\u8017\u6750-\u66f4\u65b0\u5408\u540c\u548c\u7269\u8d44\u660e\u7ec6\u8fd4\u56de\u7a0e\u7387\u548c\u5355\u4ef7")
    @RequestMapping(value={"/getRateAndPrice"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> getRateAndPrice(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody CheckVO saveOrUpdateVO) {
        CheckVO vo = this.service.getRateAndPrice(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6df7\u51dd\u571f-\u81ea\u5236\u5408\u540c\u9a8c\u6536\u903b\u8f91-\u66f4\u65b0\u5408\u540c\u548c\u7269\u8d44\u660e\u7ec6\u8fd4\u56de\u7a0e\u7387\u548c\u5355\u4ef7")
    @RequestMapping(value={"/hntgetRateAndPrice"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> hntgetRateAndPrice(@RequestParam Long sourceDetailId) {
        CheckVO vo = this.service.hntgetRateAndPrice(sourceDetailId);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6df7\u51dd\u571f-\u57fa\u4e8e\u8ba2\u5355\u9a8c\u6536\u903b\u8f91-\u66f4\u65b0\u5408\u540c\u548c\u7269\u8d44\u660e\u7ec6\u8fd4\u56de\u7a0e\u7387\u548c\u5355\u4ef7")
    @RequestMapping(value={"/hntOrderRateAndPrice"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> hntOrderRateAndPrice(@RequestParam Long sourceDetailId) {
        CheckVO vo = this.service.hntOrderRateAndPrice(sourceDetailId);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(@RequestParam Long id) {
        CheckEntity entity = (CheckEntity)((Object)this.service.selectById(id));
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryUnapprove"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryUnapprove(@RequestParam Long id) {
        CommonResponse stringCommonResponse = this.check.afterAbstainingProcessor(id, null, null);
        this.logger.error("---\u5f03\u5ba1\u7ed3\u679c" + stringCommonResponse);
        return stringCommonResponse;
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryApprove"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryApprove(@RequestParam Long id) {
        CommonResponse stringCommonResponse = this.check.afterApprovalProcessor(id, null, null);
        this.logger.error("---\u5ba1\u6279\u7ed3\u679c" + stringCommonResponse);
        return stringCommonResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u534f\u540c\u94fe\u63a5")
    @RequestMapping(value={"/getBillShareLink"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        CheckEntity entity = (CheckEntity)((Object)this.service.selectById(id));
        CommonResponse supplierResp = this.proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546\u4e3b\u952e-{}\u67e5\u8be2\u5931\u8d25\uff0c{}", (Object)entity.getSupplierId(), (Object)supplierResp.getMsg());
            return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Boolean flag = (Boolean)supplierResp.getData();
        if (!flag.booleanValue()) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u672a\u5f00\u901a\u534f\u540c\u6743\u9650\uff0c\u65e0\u6cd5\u534f\u540c\u9a8c\u6536\u3002 \u8bf7\u5148\u5230\u4f9b\u5e94\u5546\u5e93\u2014\u751f\u6210\u534f\u540c\u8d26\u53f7\u518d\u8fdb\u884c\u8ba2\u5355\u64cd\u4f5c\u3002");
        }
        if (BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode(BILL_TYPE);
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)BILL_TYPE, (Object)cooperateResp.getMsg());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            SupplierPushCheckVO supplierPushCheckVO = (SupplierPushCheckVO)BeanMapper.map((Object)((Object)entity), SupplierPushCheckVO.class);
            supplierPushCheckVO.setSourceId(entity.getId());
            List checkDetailList = supplierPushCheckVO.getCheckDetailList();
            for (SupplierPushCheckDetailVO supplierPushCheckDetailVO : checkDetailList) {
                supplierPushCheckDetailVO.setSourceId(entity.getId());
                supplierPushCheckDetailVO.setSourcedetailId(supplierPushCheckDetailVO.getId());
                supplierPushCheckDetailVO.setId(null);
            }
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                return CommonResponse.error((String)("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg()));
            }
            supplierPushCheckVO.setSystemId((String)ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString((Object)supplierPushCheckVO);
            boolean pushResult = this.service.pushBillToSupCenter(dataInfo, entity.getSupplierId(), entity.getId(), BILL_TYPE, (CooperateVO)cooperateResp.getData(), PUSH_SAVE_URL);
            if (!pushResult) {
                this.logger.error("\u5355\u636e-{}\u63a8\u9001\u7ed9\u4f9b\u5e94\u5546supplierId-{}\u5931\u8d25\uff01", (Object)id, (Object)entity.getSupplierId());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, BILL_TYPE, entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/proMaterial/check/card", null);
    }

    @PostMapping(value={"/supSignSync"})
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        this.service.deletes(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6839\u636e\u660e\u7ec6\u4fe1\u606f\u586b\u5145\u6570\u636e,\u8fd4\u56de")
    @RequestMapping(value={"/getDetailListData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> getDetailListData(@RequestBody CheckVO checkVO) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)this.service.getDetailListData(checkVO));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/deletssse"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> deletesss(@RequestParam Long billId) {
        this.checkBpmService.afterApprovalProcessor(billId, null, "BILL_TYPE");
        return null;
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("checkerName");
        fuzzyFields.add("checkDate");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("hasContract")) {
            String hasContract = ((Parameter)param.getParams().get("hasContract")).getValue().toString();
            if (hasContract.equals("1")) {
                param.getParams().put("contractId1", new Parameter("sql", (Object)"contract_id is not null"));
            }
            if (hasContract.equals("2")) {
                param.getParams().put("contractId1", new Parameter("sql", (Object)"contract_id is  null"));
            }
            param.getParams().remove("hasContract");
        }
        List orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> pushCost(@RequestBody CheckVO checkVO) {
        return this.service.pushCost(checkVO);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("checkerName");
        fuzzyFields.add("checkDate");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("hasContract")) {
            String hasContract = ((Parameter)param.getParams().get("hasContract")).getValue().toString();
            if (hasContract.equals("1")) {
                param.getParams().put("contractId1", new Parameter("sql", (Object)"contract_id is not null"));
            }
            if (hasContract.equals("2")) {
                param.getParams().put("contractId1", new Parameter("sql", (Object)"contract_id is  null"));
            }
            param.getParams().remove("hasContract");
        }
        List orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List listVo = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            listVo = BeanMapper.mapList((Iterable)list, CheckVO.class);
            listVo.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (vo.getStoreType() != null) {
                    vo.setStoreTypeName(vo.getStoreType() == 0 ? "\u6536\u6599\u5165\u5e93" : "\u76f4\u5165\u76f4\u51fa");
                }
                if (vo.getSourceType() != null) {
                    vo.setSourceTypeName(vo.getSourceType() == 0 ? "\u81ea\u5236\u9a8c\u6536" : "\u8ba2\u5355\u9a8c\u6536");
                }
                if (vo.getAttrFlag() != null) {
                    vo.setAttrFlagName(vo.getAttrFlag() == 1 ? "\u81ea\u8d2d\u6750" : "\u7532\u4f9b\u6750");
                }
                if (vo.getRecordFlag() != null) {
                    vo.setRecordFlagName(vo.getRecordFlag() == 0 ? "\u5426" : "\u662f");
                }
                if (vo.getSignStatus() != null) {
                    vo.setSignStatusName(vo.getSignStatus() == 0 ? "\u672a\u7b7e\u5b57" : "\u5df2\u7b7e\u5b57");
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", listVo);
        ExcelExport.getInstance().export("checkExport.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refCheckData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody CheckVO checkVO) {
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a7\u5236\u6210\u529f\uff01", (Object)this.service.targetCostCtrl(checkVO));
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a7\u5236\u6210\u529f\uff01", (Object)this.service.viewTargetCostCtrlInfo(id));
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody CheckVO checkVO) {
        ParamsCheckVO paramsCheckVO = this.service.checkParams(checkVO, null);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"/queryDetailWeigh"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> queryDetailWeigh(@RequestBody CheckVO vo) {
        CheckVO checkVO = this.service.queryDetailWeigh(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)checkVO);
    }

    @RequestMapping(value={"/queryMaterialMnyOfCheck"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialMnyVO>> queryMaterialMnyOfCheck(@RequestParam(value="orgId", required=false) Long orgId) {
        return this.service.queryMaterialMnyOfCheck(orgId);
    }

    @GetMapping(value={"/getReferenceMap"})
    @ResponseBody
    public CommonResponse<List<ReferenceMapVO>> getReferenceMap(@RequestParam String type, @RequestParam Long id) {
        Map<String, String> queryParam = this.getQueryDataParam(id.toString());
        CommonResponse dataResp = this.mdApi.queryDataList(queryParam);
        if (!dataResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5408\u540cid-{}\u83b7\u53d6\u5f15\u7528\u5355\u636e\u4fe1\u606f\u5217\u8868\u5931\u8d25{}", (Object)id, (Object)dataResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5f15\u7528\u7ed3\u7b97\u5355\u7684\u5355\u636e\u4fe1\u606f\u5217\u8868\u5931\u8d25\uff01");
        }
        List<ReferenceMapVO> resp = this.getReferenceMapData((Map)dataResp.getData());
        return CommonResponse.success(resp);
    }

    private Map<String, String> getQueryDataParam(String id) {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        StringBuilder sp = new StringBuilder();
        sp = new StringBuilder();
        sp.append("SELECT  id, create_user_code, create_time, bill_code, org_name,bill_state,reconciliation_tax_mny as mny  FROM `ejc_promaterial_reconciliation`\nwhere id in (select DISTINCT reconciliation_id from ejc_promaterial_reconciliation_detail where source_id =").append(id).append("  and dr = 0) and dr = 0 ");
        queryParam.put("BT220310000000001", sp.toString());
        sp = new StringBuilder();
        sp.append("SELECT  id, create_user_code, create_time, bill_code, org_name,bill_state,settlement_tax_mny as mny  FROM `ejc_promaterial_settlement`\nwhere id in (select DISTINCT settlement_id from ejc_promaterial_settlement_detail where source_id = ").append(id).append("  and dr = 0) and dr = 0 ");
        queryParam.put("BT220309000000003", sp.toString());
        sp = new StringBuilder();
        sp.append("select id, create_user_code, create_time, project_name AS bill_code, parent_org_name,bill_state,cost_mny as mny  from ejc_procost_share ").append(" where id in (select DISTINCT share_id from ejc_procost_share_detail where source_id = ").append(id).append(" and dr = 0) and dr = 0");
        queryParam.put("BT220316000000002", sp.toString());
        sp = new StringBuilder();
        sp.append("select id, create_user_code, create_time, bill_code, parent_org_name,bill_state,payment_contract_flag,apply_mny as mny  from ejc_payment_apply ").append("where id in (select DISTINCT pay_id from ejc_payment_apply_detail where source_id = ").append(id).append(" and dr =0 ) and dr = 0");
        queryParam.put("BT220223000000003", sp.toString());
        return queryParam;
    }

    private List<ReferenceMapVO> getReferenceMapData(Map<String, List<JSONObject>> data) {
        ArrayList<ReferenceMapVO> resp = new ArrayList<ReferenceMapVO>();
        ReferenceMapVO tmp = null;
        ReferenceDetailVO tmpDetail = null;
        List<JSONObject> dataList = null;
        HashSet<String> userCodes = new HashSet<String>();
        for (String billType : data.keySet()) {
            dataList = data.get(billType);
            if (!CollectionUtils.isNotEmpty(dataList)) continue;
            String billName = "";
            String billUrl = "";
            switch (billType) {
                case "BT220215000000006": {
                    billName = "\u9a8c\u6536\u5355";
                    billUrl = "ejc-promaterial-frontend/#/check/card?id=";
                    break;
                }
                case "BT220310000000001": {
                    billName = "\u5bf9\u8d26\u5355";
                    billUrl = "ejc-promaterial-frontend/#/reconciliation/card?id=";
                    break;
                }
                case "BT220309000000003": {
                    billName = "\u91c7\u8d2d\u7ed3\u7b97\u5355";
                    billUrl = "ejc-promaterial-frontend/#/settlementList/settlementCard?id=";
                    break;
                }
                case "BT220316000000002": {
                    billName = "\u6210\u672c\u5f52\u96c6\u5355";
                    billUrl = "ejc-share-frontend/#/costShare/card?id=";
                    break;
                }
                case "BT220223000000003": {
                    billName = "\u6709\u5408\u540c\u4ed8\u6b3e\u7533\u8bf7";
                    billUrl = "ejc-profinance-frontend/#/paymentList/contractCard?id=";
                }
            }
            tmp = new ReferenceMapVO();
            tmp.setId(billType);
            tmp.setModuleName(billName);
            tmp.setReferenceNum(Integer.valueOf(dataList.size()));
            BigDecimal sumMny = new BigDecimal(0);
            for (JSONObject dataRow : dataList) {
                tmpDetail = new ReferenceDetailVO();
                tmpDetail.setId(dataRow.getString("id"));
                tmpDetail.setBillCode(dataRow.getString("bill_code"));
                tmpDetail.setBillState(BillStateEnum.getEnumByStateCode((Integer)dataRow.getInteger("bill_state")).getDescription());
                tmpDetail.setCreateTime(dataRow.getDate("create_time"));
                tmpDetail.setEmployeeName(dataRow.getString("create_user_code"));
                tmpDetail.setModuleName(tmp.getModuleName());
                tmpDetail.setOrgName(dataRow.getString("org_name"));
                tmpDetail.setMny(dataRow.getBigDecimal("mny"));
                tmpDetail.setDetailPcUrl(this.BaseHost + billUrl + tmpDetail.getId());
                tmp.getDetailList().add(tmpDetail);
                if (StringUtils.isNotBlank((CharSequence)tmpDetail.getEmployeeName())) {
                    userCodes.add(tmpDetail.getEmployeeName());
                }
                if (tmpDetail.getMny() == null) continue;
                sumMny = sumMny.add(dataRow.getBigDecimal("mny"));
            }
            tmp.setSumMny(sumMny);
            resp.add(tmp);
        }
        if (CollectionUtils.isNotEmpty(userCodes)) {
            CommonResponse userResp = this.userApi.queryUserByUserCodes(userCodes.toArray(new String[userCodes.size()]));
            if (!userResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7528\u6237\u7f16\u7801\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)userResp.getMsg());
            } else {
                Map<String, UserVO> userMap = ((List)userResp.getData()).stream().collect(Collectors.toMap(item -> item.getUserCode(), item -> item));
                resp.stream().forEach(item -> item.getDetailList().stream().forEach(detail -> {
                    if (userMap.containsKey(detail.getEmployeeName())) {
                        detail.setEmployeeName(((UserVO)userMap.get(detail.getEmployeeName())).getUserName());
                    }
                }));
            }
        }
        return resp;
    }

    @GetMapping(value={"/getMaterialDesktopData"})
    @ResponseBody
    public CommonResponse<List<CheckDesktopDTO>> getMaterialDesktopData(@RequestParam Long projectId) {
        CheckDesktopDTO checkDesktopDTO;
        Date date = new Date();
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(2, -1);
        List<CheckVO> materialDataMonth = this.checkMapper.getMaterialDesktopData(projectId, instance.getTime());
        instance.set(2, 0);
        instance.set(5, 1);
        List<CheckVO> materialDataYear = this.checkMapper.getMaterialDesktopData(projectId, instance.getTime());
        instance.set(1, 2000);
        List<CheckVO> materialDataAll = this.checkMapper.getMaterialDesktopData(projectId, instance.getTime());
        ArrayList<CheckDesktopDTO> checkDesktopDTOS = new ArrayList<CheckDesktopDTO>();
        if (CollectionUtils.isNotEmpty(materialDataMonth)) {
            checkDesktopDTO = new CheckDesktopDTO();
            checkDesktopDTO.setType("\u8fd1\u4e00\u4e2a\u6708");
            for (CheckVO checkVO : materialDataMonth) {
                switch (checkVO.getCheckType()) {
                    case "contract": {
                        checkDesktopDTO.setContract(checkVO.getCheckAllMny());
                        break;
                    }
                    case "change": {
                        checkDesktopDTO.setChange(checkVO.getCheckAllMny());
                        break;
                    }
                    case "check": {
                        checkDesktopDTO.setCheck(checkVO.getCheckAllMny());
                        break;
                    }
                    case "finance": {
                        checkDesktopDTO.setFinance(checkVO.getCheckAllMny());
                        break;
                    }
                    case "setlle": {
                        checkDesktopDTO.setSettle(checkVO.getCheckAllMny());
                        break;
                    }
                    case "store": {
                        checkDesktopDTO.setStore(checkVO.getCheckAllMny());
                    }
                }
            }
            checkDesktopDTO.setFinanceRate(checkDesktopDTO.getFinance().divide(checkDesktopDTO.getSettle(), 4, 4));
            checkDesktopDTOS.add(checkDesktopDTO);
        }
        if (CollectionUtils.isNotEmpty(materialDataYear)) {
            checkDesktopDTO = new CheckDesktopDTO();
            checkDesktopDTO.setType("\u672c\u5e74");
            for (CheckVO checkVO : materialDataYear) {
                switch (checkVO.getCheckType()) {
                    case "contract": {
                        checkDesktopDTO.setContract(checkVO.getCheckAllMny());
                        break;
                    }
                    case "change": {
                        checkDesktopDTO.setChange(checkVO.getCheckAllMny());
                        break;
                    }
                    case "check": {
                        checkDesktopDTO.setCheck(checkVO.getCheckAllMny());
                        break;
                    }
                    case "finance": {
                        checkDesktopDTO.setFinance(checkVO.getCheckAllMny());
                        break;
                    }
                    case "setlle": {
                        checkDesktopDTO.setSettle(checkVO.getCheckAllMny());
                        break;
                    }
                    case "store": {
                        checkDesktopDTO.setStore(checkVO.getCheckAllMny());
                    }
                }
            }
            checkDesktopDTO.setFinanceRate(checkDesktopDTO.getFinance().divide(checkDesktopDTO.getSettle(), 4, 4));
            checkDesktopDTOS.add(checkDesktopDTO);
        }
        if (CollectionUtils.isNotEmpty(materialDataAll)) {
            checkDesktopDTO = new CheckDesktopDTO();
            checkDesktopDTO.setType("\u7d2f\u8ba1");
            for (CheckVO checkVO : materialDataAll) {
                switch (checkVO.getCheckType()) {
                    case "contract": {
                        checkDesktopDTO.setContract(checkVO.getCheckAllMny());
                        break;
                    }
                    case "change": {
                        checkDesktopDTO.setChange(checkVO.getCheckAllMny());
                        break;
                    }
                    case "check": {
                        checkDesktopDTO.setCheck(checkVO.getCheckAllMny());
                        break;
                    }
                    case "finance": {
                        checkDesktopDTO.setFinance(checkVO.getCheckAllMny());
                        break;
                    }
                    case "setlle": {
                        checkDesktopDTO.setSettle(checkVO.getCheckAllMny());
                        break;
                    }
                    case "store": {
                        checkDesktopDTO.setStore(checkVO.getCheckAllMny());
                    }
                }
            }
            checkDesktopDTO.setFinanceRate(checkDesktopDTO.getFinance().divide(checkDesktopDTO.getSettle(), 4, 4));
            checkDesktopDTOS.add(checkDesktopDTO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", checkDesktopDTOS);
    }

    @GetMapping(value={"/getCheckMnyTopFiveMaterialId"})
    @ResponseBody
    public CommonResponse<List<CheckDetailVO>> getCheckMnyTopFiveMaterialId(@RequestParam Long projectId, @RequestParam String dateType) {
        Date date = new Date();
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        if ("last30Days".equals(dateType)) {
            instance.add(5, -30);
        } else if ("thisYear".equals(dateType)) {
            instance.set(2, 0);
            instance.set(5, 1);
        }
        List<CheckDetailVO> checkMnyTopFiveMaterialId = this.checkMapper.getCheckMnyTopFiveMaterialId(projectId, instance.getTime());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", checkMnyTopFiveMaterialId);
    }

    @PostMapping(value={"/exportStaffDetail"})
    @ResponseBody
    public void exportStaffDetail(HttpServletRequest request, HttpServletResponse response, Long projectId) {
        try {
            this.service.exportStaffDetail(request, response, projectId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

