package com.ejianc.business.proother.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * 分包变更付款阶段
 */
public class ChangePaymentVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 通用变更类型：0-新增项
     */
    public static final Integer CHANGE_TYPE_ADD = 0;
    /**
     * 通用变更类型：1-删除项
     */
    public static final Integer CHANGE_TYPE_DEL = 1;
    /**
     * 通用变更类型：2-内容便更
     */
    public static final Integer CHANGE_TYPE_CONTENT_CHANGE = 2;

    /**
     * 付款阶段名称
     */
    private String paymentName;

    /**
     * 付款阶段比例(%)
     */
    private BigDecimal paymentScale;

    /**
     * 备注
     */
    private String mark;

    /**
     * 变更主键
     */
    private Long changeId;

    /**
     * 来源子表主键
     */
    private Long srcTblId;

    /**
     * 所属合同Id
     */
    private Long contractId;

    /**
     * 对比清单使用字段——原名称
     *
     */
    private String beforePaymentName;

    /**
     * 对比清单使用字段——原比例
     */
    private BigDecimal beforePaymentScale;

    /**
     * 对比清单使用字段——变更类型：0-新增项，1-删除项，2-条款内容便更
     */
    private Integer changeType;


    /**
     * 对比清单使用字段——变更类型：新增项，删除项，条款内容便更
     */
    private String changeTypeName;

    public BigDecimal getBeforePaymentScale() {
        return beforePaymentScale;
    }

    public void setBeforePaymentScale(BigDecimal beforePaymentScale) {
        this.beforePaymentScale = beforePaymentScale;
    }

    public String getBeforePaymentName() {
        return beforePaymentName;
    }

    public void setBeforePaymentName(String beforePaymentName) {
        this.beforePaymentName = beforePaymentName;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public String getPaymentName() {
        return paymentName;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }

    public BigDecimal getPaymentScale() {
        return paymentScale;
    }

    public void setPaymentScale(BigDecimal paymentScale) {
        this.paymentScale = paymentScale;
    }

    public String getMark() {
        return mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getSrcTblId() {
        return srcTblId;
    }

    public void setSrcTblId(Long srcTblId) {
        this.srcTblId = srcTblId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getChangeTypeName() {
        return changeTypeName;
    }

    public void setChangeTypeName(String changeTypeName) {
        this.changeTypeName = changeTypeName;
    }
}
