package com.ejianc.business.proother.vo;


import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 分包变更
 * 
 * @author generator
 * 
 */
public class ChangeCompareVO {
    private static final long serialVersionUID = 1L;


    /**
     * 合同名称
     */
    private String contractName;


    /**
     * 甲方名称
     */
    private String firstPartyName;


    /**
     * 签订日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;


    /**
     * 签约地点
     */
    private String signPlace;


    /**
     * 工程地点
     */
    private String projectAddress;



    /**
     * 资质名称
     */
    private String qualifyName;



    /**
     * 资质证书编号
     */
    private String qualifyCertifyNo;

    /**
     * 资质证书发证机关
     */
    private String qualifyLicenceIssuingAuthority;


    /**
     * 资质证书授予日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qualifyGrantDate;




    /**
     * 资质证书有效期至
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qualifyValidTillDate;


    /**
     * 安全生成许可证编号
     */
    private String safetyProductionLicenseNo;



    /**
     * 安全生产许可证授予日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date safetyCertifyGrantDate;



    /**
     * 安全许可证有效期至
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date safetyCertifyValidTillDate;



    /**
     * 开工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectStartDate;




    /**
     * 计划竣工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedFinishDate;


    /**
     * 合同工期:合同工期=计划竣工日期-开工日期+1
     */
    private Integer contractDaysLimit;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 经办人电话
     */
    private String employeePhone;

    /**
     * 乙方经办人
     */
    private String supplierEmployee;

    /**
     * 乙方经办人电话
     */
    private String supplierEmployeePhone;


    /**
     * 甲方项目经理名称
     */
    private String firstPartyProjectManagerName;


    /**
     * 甲方项目经理联系电话
     */
    private String firstPartyProjectManagerLink;


    /**
     * 甲方项目经理职务
     */
    private String firstPartyProjectManagerPost;



    /**
     * 乙方项目经理名称
     */
    private String supplierProjectManagerName;



    /**
     * 乙方项目经理联系电话
     */
    private String supplierProjectManagerLink;



    /**
     * 乙方项目经理职务
     */
    private String supplierProjectManagerPost;



    /**
     * 乙方项目经理身份证号
     */
    private String supplierProjectManagerIdCard;

    /**
     * 合同金额（含税）
     */
    private BigDecimal contractTaxMny;

    /**
     * 合同金额（无税）
     */
    private BigDecimal contractMny;

    /**
     * 合同税额
     */
    private BigDecimal contractTax;

    /**
     * 分包金额（含税）
     */
    private BigDecimal subContractTaxMny;

    /**
     * 分包金额（无税）
     */
    private BigDecimal subContractMny;

    /**
     * 分包税额
     */
    private BigDecimal subContractTax;

    /**
     * 其他金额（含税）
     */
    private BigDecimal otherCostTaxMny;

    /**
     * 其他金额（无税）
     */
    private BigDecimal otherCostMny;

    /**
     * 其他税额
     */
    private BigDecimal otherCostTax;


    /**
     * 分包合同明细实体
     */
    private List<ChangeDetailVO> detailList = new ArrayList<>();
    /**
     * 分包合同条款实体
     */
    private List<ChangeClauseVO> clauseList = new ArrayList<>();
    /**
     * 分包合同其他费用实体
     */
    private List<ChangeOtherCostVO> otherCostList = new ArrayList<>();
    /**
     * 付款阶段
     */
    private List<ChangePaymentVO> paymentList = new ArrayList<>();


    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public String getQualifyName() {
        return qualifyName;
    }

    public void setQualifyName(String qualifyName) {
        this.qualifyName = qualifyName;
    }

    public String getQualifyCertifyNo() {
        return qualifyCertifyNo;
    }

    public void setQualifyCertifyNo(String qualifyCertifyNo) {
        this.qualifyCertifyNo = qualifyCertifyNo;
    }

    public String getQualifyLicenceIssuingAuthority() {
        return qualifyLicenceIssuingAuthority;
    }

    public void setQualifyLicenceIssuingAuthority(String qualifyLicenceIssuingAuthority) {
        this.qualifyLicenceIssuingAuthority = qualifyLicenceIssuingAuthority;
    }

    public Date getQualifyGrantDate() {
        return qualifyGrantDate;
    }

    public void setQualifyGrantDate(Date qualifyGrantDate) {
        this.qualifyGrantDate = qualifyGrantDate;
    }

    public Date getQualifyValidTillDate() {
        return qualifyValidTillDate;
    }

    public void setQualifyValidTillDate(Date qualifyValidTillDate) {
        this.qualifyValidTillDate = qualifyValidTillDate;
    }

    public String getSafetyProductionLicenseNo() {
        return safetyProductionLicenseNo;
    }

    public void setSafetyProductionLicenseNo(String safetyProductionLicenseNo) {
        this.safetyProductionLicenseNo = safetyProductionLicenseNo;
    }

    public Date getSafetyCertifyGrantDate() {
        return safetyCertifyGrantDate;
    }

    public void setSafetyCertifyGrantDate(Date safetyCertifyGrantDate) {
        this.safetyCertifyGrantDate = safetyCertifyGrantDate;
    }

    public Date getSafetyCertifyValidTillDate() {
        return safetyCertifyValidTillDate;
    }

    public void setSafetyCertifyValidTillDate(Date safetyCertifyValidTillDate) {
        this.safetyCertifyValidTillDate = safetyCertifyValidTillDate;
    }

    public Date getProjectStartDate() {
        return projectStartDate;
    }

    public void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }

    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }

    public Integer getContractDaysLimit() {
        return contractDaysLimit;
    }

    public void setContractDaysLimit(Integer contractDaysLimit) {
        this.contractDaysLimit = contractDaysLimit;
    }

    public String getFirstPartyProjectManagerName() {
        return firstPartyProjectManagerName;
    }

    public void setFirstPartyProjectManagerName(String firstPartyProjectManagerName) {
        this.firstPartyProjectManagerName = firstPartyProjectManagerName;
    }

    public String getFirstPartyProjectManagerLink() {
        return firstPartyProjectManagerLink;
    }

    public void setFirstPartyProjectManagerLink(String firstPartyProjectManagerLink) {
        this.firstPartyProjectManagerLink = firstPartyProjectManagerLink;
    }

    public String getFirstPartyProjectManagerPost() {
        return firstPartyProjectManagerPost;
    }

    public void setFirstPartyProjectManagerPost(String firstPartyProjectManagerPost) {
        this.firstPartyProjectManagerPost = firstPartyProjectManagerPost;
    }

    public String getSupplierProjectManagerName() {
        return supplierProjectManagerName;
    }

    public void setSupplierProjectManagerName(String supplierProjectManagerName) {
        this.supplierProjectManagerName = supplierProjectManagerName;
    }

    public String getSupplierProjectManagerLink() {
        return supplierProjectManagerLink;
    }

    public void setSupplierProjectManagerLink(String supplierProjectManagerLink) {
        this.supplierProjectManagerLink = supplierProjectManagerLink;
    }

    public String getSupplierProjectManagerPost() {
        return supplierProjectManagerPost;
    }

    public void setSupplierProjectManagerPost(String supplierProjectManagerPost) {
        this.supplierProjectManagerPost = supplierProjectManagerPost;
    }

    public String getSupplierProjectManagerIdCard() {
        return supplierProjectManagerIdCard;
    }

    public void setSupplierProjectManagerIdCard(String supplierProjectManagerIdCard) {
        this.supplierProjectManagerIdCard = supplierProjectManagerIdCard;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public BigDecimal getSubContractTaxMny() {
        return subContractTaxMny;
    }

    public void setSubContractTaxMny(BigDecimal subContractTaxMny) {
        this.subContractTaxMny = subContractTaxMny;
    }

    public BigDecimal getSubContractMny() {
        return subContractMny;
    }

    public void setSubContractMny(BigDecimal subContractMny) {
        this.subContractMny = subContractMny;
    }

    public BigDecimal getSubContractTax() {
        return subContractTax;
    }

    public void setSubContractTax(BigDecimal subContractTax) {
        this.subContractTax = subContractTax;
    }

    public BigDecimal getOtherCostTaxMny() {
        return otherCostTaxMny;
    }

    public void setOtherCostTaxMny(BigDecimal otherCostTaxMny) {
        this.otherCostTaxMny = otherCostTaxMny;
    }

    public BigDecimal getOtherCostMny() {
        return otherCostMny;
    }

    public void setOtherCostMny(BigDecimal otherCostMny) {
        this.otherCostMny = otherCostMny;
    }

    public BigDecimal getOtherCostTax() {
        return otherCostTax;
    }

    public void setOtherCostTax(BigDecimal otherCostTax) {
        this.otherCostTax = otherCostTax;
    }

    public List<ChangeDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ChangeDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<ChangeClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ChangeClauseVO> clauseList) {
        this.clauseList = clauseList;
    }

    public List<ChangeOtherCostVO> getOtherCostList() {
        return otherCostList;
    }

    public void setOtherCostList(List<ChangeOtherCostVO> otherCostList) {
        this.otherCostList = otherCostList;
    }

    public List<ChangePaymentVO> getPaymentList() {
        return paymentList;
    }

    public void setPaymentList(List<ChangePaymentVO> paymentList) {
        this.paymentList = paymentList;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }

    public String getSupplierEmployee() {
        return supplierEmployee;
    }

    public void setSupplierEmployee(String supplierEmployee) {
        this.supplierEmployee = supplierEmployee;
    }

    public String getSupplierEmployeePhone() {
        return supplierEmployeePhone;
    }

    public void setSupplierEmployeePhone(String supplierEmployeePhone) {
        this.supplierEmployeePhone = supplierEmployeePhone;
    }
}
