package com.ejianc.business.settle.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 签章状态
 */
public enum SignStatusEnum {

    /**
     * 签章状态：1、待签章
     */
    待签章(1, "待签章"),
    /**
     * 签章状态：2、待乙方签章；
     */
    待乙方签章(2, "待乙方签章"),
    /**
     * 签章状态：3、待甲方签章；
     */
    待甲方签章(3, "待甲方签章"),
    /**
     * 签章状态：4、已签章；
     */
    已签章(4, "已签章"),

    /**
     * 签章状态：5、已退回；
     */
    已退回(5, "已退回"),
    /**
     * 签章状态：6、已撤回；
     */
    已撤回(6, "已撤回"),
    /**
     * 签章状态：7、已过期；
     */
    已过期(7, "已过期"),
    /**
     * 签章状态：8、其他；
     */
    其他(8, "其他");


    private static Map<Integer, SignStatusEnum> enumMap = new HashMap<>();

    static {
        enumMap = EnumSet.allOf(SignStatusEnum.class).stream().collect(Collectors.toMap(SignStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    private final Integer code;
    private final String description;

    SignStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public static SignStatusEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }
}
