package com.ejianc.business.proother.contract.vo;


import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 分包合同
 * 
 * @author generator
 * 
 */
public class ContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;


    /**
     * 合同类型：主合同
     */
    public static final Integer CONTRACT_TYPE_MAIN_CONTRACT = 0;
    /**
     * 合同类型：补充协议
     */
    public static final Integer CONTRACT_TYPE_SUPPLEMENT = 1;

    /**
     * 定标结果Id
     */
    private Long targetResultId;

    /**
     * 定标结果名称
     */
    private String targetResultName;

    /**
     * 项目Id
     */
    @ConvertField
    private Long projectId;

    /**
     * 项目名称
     */
    @ConvertField
    private String projectName;

    /**
     * 合同编码
     */
    @ConvertField(targetField = "contractCode")
    private String billCode;

    /**
     * 合同名称
     */
    @ConvertField
    private String contractName;

    /**
     * 合同类别Id
     */
    @ConvertField(targetField = "categoryId")
    private Long contractCategoryId;

    /**
     * 合同类别名称
     */
    @ConvertField(targetField = "categoryName")
    private String contractCategoryName;

    /**
     * 甲方Id
     */
    @ConvertField(targetField = "partyaId")
    private Long firstPartyId;

    /**
     * 甲方名称
     */
    @ConvertField(targetField = "partyaName")
    private String firstPartyName;

    /**
     * 供应商Id
     */
    @ConvertField(targetField = "partybId")
    private Long supplierId;

    /**
     * 供应商名称
     */
    @ConvertField(targetField = "partybName")
    private String supplierName;

    /**
     * 签订日期
     */
    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 签约地点
     */
    @ConvertField
    private String signPlace;

    /**
     * 甲方经办人部门 名称
     */
    @ConvertField
    private String departmentName;
    /**
     * 甲方经办人部门
     */
    @ConvertField
    private Long departmentId;


    /**
     * 签章状态：1-待签章,2-待乙方签章,3-待甲方签章,4-已签章（已完成）,5-已退回（已拒签）,6-已撤回,7-已过期,8-其他已签章；  单据新增后默认为待签章
     */
    private String signatureStatus;

    /**
     * 合同履约状态：1、未签订；2、履约中；3、已终止；4、已作废；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已终止】
     */
    @ConvertField
    private String performanceStatus;

    /**
     * 经办人Id
     */
    @ConvertField
    private Long employeeId;

    /**
     * 经办人名称
     */
    @ConvertField
    private String employeeName;

    /**
     * 经办人电话
     */
    @ConvertField
    private String employeePhone;

    /**
     * 乙方经办人
     */
    private String supplierEmployee;

    /**
     * 乙方经办人电话
     */
    private String supplierEmployeePhone;

    /**
     * 工程地点
     */
    private String projectAddress;

    /**
     * 合同税率
     */
    @ConvertField
    private BigDecimal taxRate;

    /**
     * 质量标准Id
     */
    private Long qualityStandardId;

    /**
     * 质量标准名称
     */
    private String qualityStandardName;

    /**
     * 项目计税方式名称:简易计税、一般计税
     */
    @ConvertField(targetField = "taxCalcTypeName")
    private String projectTaxCalcType;

    /**
     * 计价方式：1-可调单价、2-固定总价、3-成本加酬金；
     */
    @ConvertField
    private String pricingType;

    /**
     * 起草方式：1、线上起草，2、上传合同，3、线下签订
     */
    private String draftType;

    /**
     * 合同附件路径
     */
    private String contractFilePath;

    /**
     * 合同附件Id
     */
    private Long contractFileId;

    /**
     * 水印合同附件Id
     */
    private Long watermarkContractFileId;

    /**
     * 合同模板Id
     */
    private Long contractTemplateId;

    /**
     * 合同模板名称
     */
    private String contractTemplateName;

    /**
     * 合同附件版本Id
     */
    private Long contractFileVersionId;

    /**
     * 合同附件版本
     */
    private Long contractFileVersion;

    /**
     * 资质id
     */
    private Long qualifyId;

    /**
     * 资质名称
     */
    private String qualifyName;

    /**
     * 资质证书编号
     */
    private String qualifyCertifyNo;

    /**
     * 资质证书发证机关
     */
    private String qualifyLicenceIssuingAuthority;

    /**
     * 资质证书授予日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qualifyGrantDate;

    /**
     * 资质证书有效期至
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qualifyValidTillDate;

    /**
     * 安全生成许可证编号
     */
    private String safetyProductionLicenseNo;

    /**
     * 安全生产许可证授予日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date safetyCertifyGrantDate;

    /**
     * 安全许可证有效期至
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date safetyCertifyValidTillDate;

    /**
     * 开工日期
     */
    @ConvertField(targetField = "contractStartDate")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectStartDate;

    /**
     * 计划竣工日期
     */
    @ConvertField(targetField = "contractFinishDate")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedFinishDate;

    /**
     * 合同工期:合同工期=计划竣工日期-开工日期+1
     */
    @ConvertField(targetField = "contractDaysLimit")
    private Integer contractDaysLimit;

    /**
     * 甲方项目经理Id
     */
    private Long firstPartyProjectManagerId;

    /**
     * 甲方项目经理名称
     */
    private String firstPartyProjectManagerName;

    /**
     * 甲方项目经理联系电话
     */
    private String firstPartyProjectManagerLink;

    /**
     * 甲方项目经理职务
     */
    private String firstPartyProjectManagerPost;

    /**
     * 乙方项目经理Id
     */
    @ConvertField
    private Long supplierProjectManagerId;

    /**
     * 乙方项目经理名称
     */
    @ConvertField
    private String supplierProjectManagerName;

    /**
     * 乙方项目经理联系电话
     */
    @ConvertField
    private String supplierProjectManagerLink;

    /**
     * 乙方项目经理职务
     */
    private String supplierProjectManagerPost;

    /**
     * 乙方项目经理身份证号
     */
    private String supplierProjectManagerIdCard;

    /**
     * 合同金额（含税）
     */
    @ConvertField
    private BigDecimal contractTaxMny;

    /**
     * 合同金额（无税）
     */
    @ConvertField
    private BigDecimal contractMny;

    /**
     * 合同税额
     */
    @ConvertField
    private BigDecimal contractTax;

    /**
     * 分包金额（含税）
     */
    private BigDecimal subContractTaxMny;

    /**
     * 分包金额（无税）
     */
    private BigDecimal subContractMny;

    /**
     * 分包税额
     */
    private BigDecimal subContractTax;

    /**
     * 其他金额（含税）
     */
    private BigDecimal otherCostTaxMny;

    /**
     * 其他金额（无税）
     */
    private BigDecimal otherCostMny;

    /**
     * 其他税额
     */
    private BigDecimal otherCostTax;

    /**
     * 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    private Integer billState;

    /**
     * 提交日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate;

    /**
     * 提交人名称
     */
    private String commitUserName;

    /**
     * 提交人账号
     */
    private String commitUserCode;

    /**
     * 生效日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate;

    /**
     * 项目部Id
     */
    @ConvertField
    private Long orgId;

    /**
     * 项目部名称
     */
    @ConvertField
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @ConvertField
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @ConvertField
    private String parentOrgName;

    /**
     * 项目部上级组织编码
     */
    @ConvertField
    private String parentOrgCode;

    /**
     * 合同高亮附件路径
     */
    private String contractFileHighlightPath;

    /**
     * 合同高亮附件Id
     */
    private Long contractFileHighlightId;

    /**
     * 初始版本金额
     */
    @ConvertField
    private BigDecimal baseMny;

    /**
     * 初始版本(含税)金额
     */
    @ConvertField
    private BigDecimal baseTaxMny;

    /**
     * 变更前金额
     */
    private BigDecimal beforeChangeMny;

    /**
     * 变更前金额（含税）
     */
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更中金额
     */
    private BigDecimal changingMny;

    /**
     * 变更中金额（含税）
     */
    private BigDecimal changingTaxMny;

    /**
     * 变更单号
     */
    private String changeCode;

    /**
     * 变更版本
     */
    private Integer changeVersion;

    /**
     * 变更主键
     */
    private Long changeId;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更 4-审批通过)
     */
    @ConvertField
    private Integer changeStatus;

    /**
     * 是否补充协议(1:是，0：否)
     */
    @ConvertField
    private Integer supplementFlag;

    /**
     * 主合同Id
     */
    @ConvertField
    private Long mainContractId;

    /**
     * 主合同编码
     */
    @ConvertField
    private String mainContractCode;

    /**
     * 主合同名称
     */
    @ConvertField
    private String mainContractName;

    /**
     * 补充协议描述
     */
    private String supplementDescribe;

    /**
     * 主合同创建日期（用于补充协议排列）
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mainContractCreateDate ;

    /**
     * 变更日期（用于合同列表页展示）
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate ;


    /**
     * 补充协议集合（不入库）
     */
    private List<ContractVO> supplementList;

    /**
     * 是否能新增补充协议（不入库）
     */
    private Boolean editFlag;


    /**
     * 补充协议次数（不入库）
     */
    private Integer supplementNum;

    /**
     * 累计补充金额（不入库）
     */
    private BigDecimal allSupplementMny;

    /**
     * 补充金额比例（不入库）
     */
    private BigDecimal supplementMnyRate;


    /**
     * 累计变更次数（不入库）
     */
    private Integer changeNum;

    /**
     * 累计变更金额（不入库）
     */
    private BigDecimal allChangeMny;

    /**
     * 累计变更金额比例（不入库）
     */
    private BigDecimal changeMnyRate;

    /**
     * 变更集合（不入库）
     */
    private List<ChangeVO> changeList;

    /**
     * 单据状态名称（不入库） ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    private String billStateName;


    /**
     * 变更合同签章状态（用于合同列表页展示）
     */
    private Integer changeContractSignatureStatus ;

    /**
     * 变更起草方式：1-上传附件，2-线下签订，3-线下签订
     */
    private String changeDraftType;

    /**
     * 变更附件id
     */
    private String changeFileId;

    /**
     * 变更合同名称
     */
    private String changeContractName;

    /**
     * 分包合同明细实体
     */
    private List<ContractDetailVO> detailList = new ArrayList<>();

    /**
     * 分包合同付款阶段实体
     */
    @ConvertField(targetField = "contractSubPaymentNodeList", targetFieldType = ConvertField.TargetType.CLASS)
    private List<ContractPaymentVO> paymentList = new ArrayList<>();

    /**
     * 分包合同条款实体
     */
    private List<ContractClauseVO> clauseList = new ArrayList<>();

    /**
     * 分包合同其他费用实体
     */
    private List<ContractOtherCostVO> otherCostList = new ArrayList<>();

    /**
     * 完成签章附件Id
     */
    private Long signedFileId;

    /**
     * 合同类型：分包合同-0，专业合同-1
     */
    private Integer contractType;

    /**
     * 合同新增方式：参照定标结果新增-0，直接新增-1
     */
    private Integer addType;

    /**
     * 项目编码
     */
    @ConvertField
    private String projectCode;

    /**
     * 项目部编码
     */
    @ConvertField
    private String orgCode;

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    private String billPushFlag;

    @ConvertField(targetField = "sourceId,contractId,id")
    private Long id;

    @ConvertField
    private Integer dr;

    /**
     * 发票类型Id
     */
    private Long invoiceTypeId;

    /**
     * 发票类型名称
     */
    private String invoiceTypeName;

    /**
     * 线上起草，审批中修改的合同是否已重新进行合同编辑
     */
    private Boolean contractFileSyncFlag = true;

    /**
     * 合同甲方客户类型
     */
    @ConvertField(targetField = "belongUnitId")
    private Long belongUnitId; //所属组织id
    @ConvertField(targetField = "belongUnitName")
    private String belongUnitName; // 所属组织
    private Integer filingStatus;//是否归档 1：是；0：否 2：归档中
    private Integer filingRef;//是否被归档引用0：否

    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public Long getBelongUnitId() {
        return belongUnitId;
    }

    public void setBelongUnitId(Long belongUnitId) {
        this.belongUnitId = belongUnitId;
    }

    public String getBelongUnitName() {
        return belongUnitName;
    }

    public void setBelongUnitName(String belongUnitName) {
        this.belongUnitName = belongUnitName;
    }
    public Boolean getContractFileSyncFlag() {
        return contractFileSyncFlag;
    }

    public void setContractFileSyncFlag(Boolean contractFileSyncFlag) {
        this.contractFileSyncFlag = contractFileSyncFlag;
    }

    public Long getInvoiceTypeId() {
        return invoiceTypeId;
    }

    @ReferDeserialTransfer
    public void setInvoiceTypeId(Long invoiceTypeId) {
        this.invoiceTypeId = invoiceTypeId;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getDr() {
        return dr;
    }

    @Override
    public void setDr(Integer dr) {
        this.dr = dr;
    }

    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }

    public Long getTargetResultId() {
        return targetResultId;
    }

    @ReferDeserialTransfer
    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }

    public String getTargetResultName() {
        return targetResultName;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }

    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getBillCode() {
        return billCode;
    }



    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    @ReferDeserialTransfer
    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Long getFirstPartyId() {
        return firstPartyId;
    }
    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }

    public String getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(String signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }

    public String getSupplierEmployee() {
        return supplierEmployee;
    }

    public void setSupplierEmployee(String supplierEmployee) {
        this.supplierEmployee = supplierEmployee;
    }

    public String getSupplierEmployeePhone() {
        return supplierEmployeePhone;
    }

    public void setSupplierEmployeePhone(String supplierEmployeePhone) {
        this.supplierEmployeePhone = supplierEmployeePhone;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getQualityStandardId() {
        return qualityStandardId;
    }

    @ReferDeserialTransfer
    public void setQualityStandardId(Long qualityStandardId) {
        this.qualityStandardId = qualityStandardId;
    }

    public String getQualityStandardName() {
        return qualityStandardName;
    }

    public void setQualityStandardName(String qualityStandardName) {
        this.qualityStandardName = qualityStandardName;
    }



    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }

    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getWatermarkContractFileId() {
        return watermarkContractFileId;
    }

    public void setWatermarkContractFileId(Long watermarkContractFileId) {
        this.watermarkContractFileId = watermarkContractFileId;
    }

    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }

    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }

    public Long getContractFileVersionId() {
        return contractFileVersionId;
    }

    public void setContractFileVersionId(Long contractFileVersionId) {
        this.contractFileVersionId = contractFileVersionId;
    }

    public Long getContractFileVersion() {
        return contractFileVersion;
    }

    public void setContractFileVersion(Long contractFileVersion) {
        this.contractFileVersion = contractFileVersion;
    }

    public Long getQualifyId() {
        return qualifyId;
    }
    @ReferDeserialTransfer
    public void setQualifyId(Long qualifyId) {
        this.qualifyId = qualifyId;
    }

    public String getProjectTaxCalcType() {
        return projectTaxCalcType;
    }

    public void setProjectTaxCalcType(String projectTaxCalcType) {
        this.projectTaxCalcType = projectTaxCalcType;
    }

    public String getQualifyName() {
        return qualifyName;
    }

    public void setQualifyName(String qualifyName) {
        this.qualifyName = qualifyName;
    }

    public String getQualifyCertifyNo() {
        return qualifyCertifyNo;
    }

    public void setQualifyCertifyNo(String qualifyCertifyNo) {
        this.qualifyCertifyNo = qualifyCertifyNo;
    }

    public String getQualifyLicenceIssuingAuthority() {
        return qualifyLicenceIssuingAuthority;
    }

    public void setQualifyLicenceIssuingAuthority(String qualifyLicenceIssuingAuthority) {
        this.qualifyLicenceIssuingAuthority = qualifyLicenceIssuingAuthority;
    }

    public Date getQualifyGrantDate() {
        return qualifyGrantDate;
    }

    public void setQualifyGrantDate(Date qualifyGrantDate) {
        this.qualifyGrantDate = qualifyGrantDate;
    }

    public Date getQualifyValidTillDate() {
        return qualifyValidTillDate;
    }

    public void setQualifyValidTillDate(Date qualifyValidTillDate) {
        this.qualifyValidTillDate = qualifyValidTillDate;
    }

    public String getSafetyProductionLicenseNo() {
        return safetyProductionLicenseNo;
    }

    public void setSafetyProductionLicenseNo(String safetyProductionLicenseNo) {
        this.safetyProductionLicenseNo = safetyProductionLicenseNo;
    }

    public Date getSafetyCertifyGrantDate() {
        return safetyCertifyGrantDate;
    }

    public void setSafetyCertifyGrantDate(Date safetyCertifyGrantDate) {
        this.safetyCertifyGrantDate = safetyCertifyGrantDate;
    }

    public Date getSafetyCertifyValidTillDate() {
        return safetyCertifyValidTillDate;
    }

    public void setSafetyCertifyValidTillDate(Date safetyCertifyValidTillDate) {
        this.safetyCertifyValidTillDate = safetyCertifyValidTillDate;
    }

    public Date getProjectStartDate() {
        return projectStartDate;
    }

    public void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }

    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }

    public Integer getContractDaysLimit() {
        return contractDaysLimit;
    }

    public void setContractDaysLimit(Integer contractDaysLimit) {
        this.contractDaysLimit = contractDaysLimit;
    }

    public Long getFirstPartyProjectManagerId() {
        return firstPartyProjectManagerId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyProjectManagerId(Long firstPartyProjectManagerId) {
        this.firstPartyProjectManagerId = firstPartyProjectManagerId;
    }

    public String getFirstPartyProjectManagerName() {
        return firstPartyProjectManagerName;
    }

    public void setFirstPartyProjectManagerName(String firstPartyProjectManagerName) {
        this.firstPartyProjectManagerName = firstPartyProjectManagerName;
    }

    public String getFirstPartyProjectManagerLink() {
        return firstPartyProjectManagerLink;
    }

    public void setFirstPartyProjectManagerLink(String firstPartyProjectManagerLink) {
        this.firstPartyProjectManagerLink = firstPartyProjectManagerLink;
    }

    public String getFirstPartyProjectManagerPost() {
        return firstPartyProjectManagerPost;
    }

    public void setFirstPartyProjectManagerPost(String firstPartyProjectManagerPost) {
        this.firstPartyProjectManagerPost = firstPartyProjectManagerPost;
    }

    public Long getSupplierProjectManagerId() {
        return supplierProjectManagerId;
    }

    @ReferDeserialTransfer
    public void setSupplierProjectManagerId(Long supplierProjectManagerId) {
        this.supplierProjectManagerId = supplierProjectManagerId;
    }

    public String getSupplierProjectManagerName() {
        return supplierProjectManagerName;
    }

    public void setSupplierProjectManagerName(String supplierProjectManagerName) {
        this.supplierProjectManagerName = supplierProjectManagerName;
    }

    public String getSupplierProjectManagerLink() {
        return supplierProjectManagerLink;
    }

    public void setSupplierProjectManagerLink(String supplierProjectManagerLink) {
        this.supplierProjectManagerLink = supplierProjectManagerLink;
    }

    public String getSupplierProjectManagerPost() {
        return supplierProjectManagerPost;
    }

    public void setSupplierProjectManagerPost(String supplierProjectManagerPost) {
        this.supplierProjectManagerPost = supplierProjectManagerPost;
    }

    public String getSupplierProjectManagerIdCard() {
        return supplierProjectManagerIdCard;
    }

    public void setSupplierProjectManagerIdCard(String supplierProjectManagerIdCard) {
        this.supplierProjectManagerIdCard = supplierProjectManagerIdCard;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public BigDecimal getSubContractTaxMny() {
        return subContractTaxMny;
    }

    public void setSubContractTaxMny(BigDecimal subContractTaxMny) {
        this.subContractTaxMny = subContractTaxMny;
    }

    public BigDecimal getSubContractMny() {
        return subContractMny;
    }

    public void setSubContractMny(BigDecimal subContractMny) {
        this.subContractMny = subContractMny;
    }

    public BigDecimal getSubContractTax() {
        return subContractTax;
    }

    public void setSubContractTax(BigDecimal subContractTax) {
        this.subContractTax = subContractTax;
    }

    public BigDecimal getOtherCostTaxMny() {
        return otherCostTaxMny;
    }

    public void setOtherCostTaxMny(BigDecimal otherCostTaxMny) {
        this.otherCostTaxMny = otherCostTaxMny;
    }

    public BigDecimal getOtherCostMny() {
        return otherCostMny;
    }

    public void setOtherCostMny(BigDecimal otherCostMny) {
        this.otherCostMny = otherCostMny;
    }

    public BigDecimal getOtherCostTax() {
        return otherCostTax;
    }

    public void setOtherCostTax(BigDecimal otherCostTax) {
        this.otherCostTax = otherCostTax;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }

    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public List<ContractDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ContractDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<ContractPaymentVO> getPaymentList() {
        return paymentList;
    }

    public void setPaymentList(List<ContractPaymentVO> paymentList) {
        this.paymentList = paymentList;
    }

    public List<ContractClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ContractClauseVO> clauseList) {
        this.clauseList = clauseList;
    }

    public List<ContractOtherCostVO> getOtherCostList() {
        return otherCostList;
    }

    public void setOtherCostList(List<ContractOtherCostVO> otherCostList) {
        this.otherCostList = otherCostList;
    }

    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }

    public List<ContractVO> getSupplementList() {
        return supplementList;
    }

    public void setSupplementList(List<ContractVO> supplementList) {
        this.supplementList = supplementList;
    }

    public Boolean getEditFlag() {
        return editFlag;
    }

    public void setEditFlag(Boolean editFlag) {
        this.editFlag = editFlag;
    }

    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }

    public Integer getSupplementNum() {
        return supplementNum;
    }

    public void setSupplementNum(Integer supplementNum) {
        this.supplementNum = supplementNum;
    }

    public BigDecimal getAllSupplementMny() {
        return allSupplementMny;
    }

    public void setAllSupplementMny(BigDecimal allSupplementMny) {
        this.allSupplementMny = allSupplementMny;
    }

    public BigDecimal getSupplementMnyRate() {
        return supplementMnyRate;
    }

    public void setSupplementMnyRate(BigDecimal supplementMnyRate) {
        this.supplementMnyRate = supplementMnyRate;
    }

    public Integer getChangeNum() {
        return changeNum;
    }

    public void setChangeNum(Integer changeNum) {
        this.changeNum = changeNum;
    }

    public BigDecimal getAllChangeMny() {
        return allChangeMny;
    }

    public void setAllChangeMny(BigDecimal allChangeMny) {
        this.allChangeMny = allChangeMny;
    }

    public BigDecimal getChangeMnyRate() {
        return changeMnyRate;
    }

    public void setChangeMnyRate(BigDecimal changeMnyRate) {
        this.changeMnyRate = changeMnyRate;
    }

    public List<ChangeVO> getChangeList() {
        return changeList;
    }

    public void setChangeList(List<ChangeVO> changeList) {
        this.changeList = changeList;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public Integer getChangeContractSignatureStatus() {
        return changeContractSignatureStatus;
    }

    public void setChangeContractSignatureStatus(Integer changeContractSignatureStatus) {
        this.changeContractSignatureStatus = changeContractSignatureStatus;
    }

    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getChangeFileId() {
        return changeFileId;
    }

    public void setChangeFileId(String changeFileId) {
        this.changeFileId = changeFileId;
    }

    public String getChangeContractName() {
        return changeContractName;
    }

    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
}
