package com.ejianc.business.proother.contract.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * 分包合同付款阶段
 */
public class ContractPaymentVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 付款阶段名称
     */
    @ConvertField(targetField = "paymentNodeName")
    private String paymentName;

    /**
     * 付款阶段比例(%)
     */
    @ConvertField(targetField = "totalActualPayRecTax")
    private BigDecimal paymentScale;

    /**
     * 备注
     */
    @ConvertField(targetField = "memo")
    private String mark;

    /**
     * 所属合同Id
     */
    private Long contractId;

    /**
     * 变更主键
     */
    private Long changeId;

    /**
     * 变更子表主键
     */
    private Long changeBid;

    @ConvertField(targetField = "sourceId,id")
    private Long id;

    @ConvertField
    private Integer dr;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getDr() {
        return dr;
    }

    @Override
    public void setDr(Integer dr) {
        this.dr = dr;
    }

    public String getPaymentName() {
        return paymentName;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }

    public BigDecimal getPaymentScale() {
        return paymentScale;
    }

    public void setPaymentScale(BigDecimal paymentScale) {
        this.paymentScale = paymentScale;
    }

    public String getMark() {
        return mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
}
