package com.ejianc.business.proother.settle.vo;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 合同结算记录
 *
 * @author CJ
 * @Description:
 * @date 2022/2/17 16:52
 */
public class SettleRecordVO extends BaseVO {
    private static final long serialVersionUID = 2718875112397717352L;

    private boolean canAddNewSettleFlag;

    /**
     * 合同Id
     */
    private Long contractId;

    /**
     * 结算类型：0-过程，1-完工，2-节点
     */
    private Integer settleType;

    /**
     * 合同履约状态：1、未签订；2、履约中；3、已终止；4、已作废；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已终止】
     */
    private String performanceStatus;

    /**
     * 合同金额含税
     */
    private BigDecimal contractTaxMny;

    /**
     * 合同金额不含税
     */
    private BigDecimal contractMny;

    /**
     * 累计过程结算金额
     */
    private BigDecimal totalProcessSettleMny;

    /**
     * 结算比例
     */
    private BigDecimal settleRatio;

    /**
     * 累计节点结算金额
     */
    private BigDecimal totalNodeSettleMny;

    /**
     * 结算差额：累计节点结算金额-累计过程结算金额
     */
    private BigDecimal settleBalanceMny;

    /**
     * 合同结算金额
     */
    private BigDecimal contractSettleMny;

    /**
     * 阶段记录
     */
    List<com.ejianc.business.proother.settle.vo.SettleVO> settleList = new ArrayList<>();

    /**
     * 累计结算金额
     */
    private BigDecimal totalSettleMny;

    public BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    public void setTotalSettleMny(BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getTotalProcessSettleMny() {
        return totalProcessSettleMny;
    }

    public void setTotalProcessSettleMny(BigDecimal totalProcessSettleMny) {
        this.totalProcessSettleMny = totalProcessSettleMny;
    }

    public BigDecimal getTotalNodeSettleMny() {
        return totalNodeSettleMny;
    }

    public void setTotalNodeSettleMny(BigDecimal totalNodeSettleMny) {
        this.totalNodeSettleMny = totalNodeSettleMny;
    }

    public BigDecimal getSettleBalanceMny() {
        return settleBalanceMny;
    }

    public void setSettleBalanceMny(BigDecimal settleBalanceMny) {
        this.settleBalanceMny = settleBalanceMny;
    }

    public BigDecimal getContractSettleMny() {
        return contractSettleMny;
    }

    public void setContractSettleMny(BigDecimal contractSettleMny) {
        this.contractSettleMny = contractSettleMny;
    }

    public List<com.ejianc.business.proother.settle.vo.SettleVO> getSettleList() {
        return settleList;
    }

    public void setSettleList(List<SettleVO> settleList) {
        this.settleList = settleList;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public BigDecimal getSettleRatio() {
        return settleRatio;
    }

    public void setSettleRatio(BigDecimal settleRatio) {
        this.settleRatio = settleRatio;
    }

    public boolean isCanAddNewSettleFlag() {
        return canAddNewSettleFlag;
    }

    public void setCanAddNewSettleFlag(boolean canAddNewSettleFlag) {
        this.canAddNewSettleFlag = canAddNewSettleFlag;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
}
