/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.proother.bean.ContractDetailEntity;
import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.service.IContractDetailService;
import com.ejianc.business.proother.service.IContractOtherCostService;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.proother.utils.TreeNodeBUtil;
import com.ejianc.business.proother.vo.ContractDetailVO;
import com.ejianc.business.proother.vo.ContractOtherCostVO;
import com.ejianc.business.proother.vo.ContractPaymentVO;
import com.ejianc.business.proother.vo.ContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"contract"})
public class ContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractService service;
    @Autowired
    private IContractDetailService detailService;
    @Autowired
    private IContractOtherCostService otherCostService;
    private final String LABORSUB_Bill_CODE = "BT211108000000002";
    private final String PROSUB_Bill_CODE = "BT220216000000003";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        ContractVO vo = this.service.insertOrUpdate(saveorUpdateVO, authority);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/getContractFileMgrInfo"})
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value="contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(contractId));
        CommonResponse categoryResp = this.templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if (!categoryResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5408\u540c\u7c7b\u522bI\u7684-{}\u67e5\u8be2\u5bf9\u5e94\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)contractEntity.getContractCategoryId(), (Object)categoryResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25");
        }
        TemplateCategoryVO category = (TemplateCategoryVO)categoryResp.getData();
        resp.put("contactId", (Object)contractEntity.getId());
        if (null != contractEntity.getContractType() && contractEntity.getContractType().equals(0)) {
            resp.put("contractBillTypeCode", (Object)"BT211108000000002");
        } else {
            resp.put("contractBillTypeCode", (Object)"BT220216000000003");
        }
        resp.put("contractCategoryId", (Object)category.getId());
        resp.put("boBillType", (Object)category.getBillTypeCode());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        ContractVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        return this.service.deleteByIds(vos);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap beans = new HashMap();
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.pageList(param);
        List contractVOList = new ArrayList();
        if (null != commonResponse.getData() && null != (contractVOList = (List)((JSONObject)commonResponse.getData()).get((Object)"records")) && contractVOList.size() > 0) {
            contractVOList.forEach(c -> {
                if (StringUtils.isBlank((CharSequence)c.getPerformanceStatus())) {
                    c.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getDescription());
                } else {
                    c.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode(c.getPerformanceStatus()).getDescription());
                }
                if (StringUtils.isBlank((CharSequence)c.getSignatureStatus())) {
                    c.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getDescription());
                } else {
                    c.setSignatureStatus(SignatureStatusEnum.getEnumByCode(c.getSignatureStatus()).getDescription());
                }
                c.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription());
            });
        }
        beans.put("records", contractVOList);
        ExcelExport.getInstance().export("contract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage pageData = this.service.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @ResponseBody
    @RequestMapping(value={"/prosubContractRef"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> prosubContractRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        if (null == condition || StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("orgId") && null == conditionMap.get("projectId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u9879\u76eeid \u6216 \u7ec4\u7ec7id\u4e3a\u7a7a\uff01");
        }
        if (null != conditionMap.get("orgId") && null == conditionMap.get("orgType")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        if (null != conditionMap.get("categoryId")) {
            CommonResponse categoryVOResp = this.templateCategoryApi.querySelfAndChildById(Long.valueOf(conditionMap.get("categoryId").toString()));
            if (!categoryVOResp.isSuccess()) {
                return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List categoryIds = ((List)categoryVOResp.getData()).stream().map(item -> item.getId()).collect(Collectors.toList());
            switch (categoryIds.size()) {
                case 0: {
                    JSONObject page = new JSONObject();
                    page.put("records", new ArrayList());
                    page.put("total", (Object)0);
                    page.put("current", (Object)queryParam.getPageIndex());
                    page.put("size", (Object)queryParam.getPageSize());
                    page.put("pages", (Object)0);
                    return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u6570\u636e\u6210\u529f\uff01", (Object)page);
                }
                case 1: {
                    queryParam.getParams().put("contractCategoryId", new Parameter("eq", categoryIds.get(0)));
                    break;
                }
                default: {
                    queryParam.getParams().put("contractCategoryId", new Parameter("in", categoryIds));
                }
            }
        }
        if (null != conditionMap.get("projectId")) {
            Long projectId = Long.parseLong(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        } else {
            Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                queryParam.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        queryParam.getParams().put("performance_status", new Parameter("eq", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode()));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != queryParam.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", queryParam.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        queryParam.setOrderMap(orderMap);
        this.logger.info("\u5206\u5305\u5408\u540c\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u6761\u4ef6---------->" + JSONObject.toJSONString((Object)queryParam.getParams()));
        IPage pageData = this.service.queryPage(queryParam, false);
        this.logger.info("\u5206\u5305\u5408\u540c\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u7ed3\u679c\u6761\u6570---------->" + pageData.getRecords().size());
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @ResponseBody
    @RequestMapping(value={"/proOtherContractDetailRef"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> proOtherContractDetailRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        if (null == condition || StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("contractId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
        }
        queryParam.getParams().put("contract_id", new Parameter("eq", conditionMap.get("contractId")));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("detail_price", new Parameter("ne", null));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time", "desc");
        queryParam.setOrderMap(orderMap);
        this.logger.info("\u5206\u5305\u5408\u540c\u660e\u7ec6\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u6761\u4ef6---------->" + JSONObject.toJSONString((Object)queryParam.getParams()));
        IPage pageData = this.detailService.queryPage(queryParam, false);
        this.logger.info("\u5206\u5305\u5408\u540c\u660e\u7ec6\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u7ed3\u679c\u6761\u6570---------->" + pageData.getRecords().size());
        JSONObject page = new JSONObject();
        List records = BeanMapper.mapList((Iterable)pageData.getRecords(), JSONObject.class);
        ArrayList detailIds = new ArrayList();
        HashMap detailHasParentMap = new HashMap();
        records.stream().forEach(item -> {
            detailIds.add(item.getLong("id"));
            if (null != item.get((Object)"parentId")) {
                if (null == detailHasParentMap.get(item.getLong("parentId"))) {
                    detailHasParentMap.put(item.getLong("parentId"), new ArrayList());
                }
                ((List)detailHasParentMap.get(item.getLong("parentId"))).add(item);
            }
        });
        if (!detailHasParentMap.isEmpty()) {
            List parents = (List)this.detailService.listByIds(new ArrayList(detailHasParentMap.keySet()));
            for (ContractDetailEntity parent : parents) {
                ((List)detailHasParentMap.get(parent.getId())).forEach(child -> child.put("pTag", (Object)(parent.getDetailCode() + "-" + parent.getDetailName())));
            }
        }
        page.put("records", (Object)records);
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u660e\u7ec6\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @ResponseBody
    @RequestMapping(value={"/contractDetailRef"}, method={RequestMethod.GET})
    public CommonResponse<List<ContractDetailVO>> contractDetailRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        List contractDetailList;
        List resList = new ArrayList();
        if (null == condition || StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("contractId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById((Serializable)conditionMap.get("contractId")));
        if (null != contractEntity && CollectionUtils.isNotEmpty(contractEntity.getDetailList()) && CollectionUtils.isNotEmpty((Collection)(contractDetailList = BeanMapper.mapList(contractEntity.getDetailList(), ContractDetailVO.class)))) {
            for (ContractDetailVO detail : contractDetailList) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            resList = TreeNodeBUtil.buildTree((List)contractDetailList);
        }
        this.logger.info("\u8fd4\u56de\u5408\u540c\u660e\u7ec6\u6570\u636e\u6210\u529f\uff1a", (Object)JSONObject.toJSONString(resList));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", resList);
    }

    @ResponseBody
    @RequestMapping(value={"/queryPayment"}, method={RequestMethod.GET})
    public CommonResponse<List<ContractPaymentVO>> queryPayment(@RequestParam(value="contractId") String contractId) {
        List contractPayments = new ArrayList();
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById((Serializable)((Object)contractId)));
        if (null != contractEntity && CollectionUtils.isNotEmpty(contractEntity.getDetailList())) {
            contractPayments = BeanMapper.mapList(contractEntity.getPaymentList(), ContractPaymentVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", contractPayments);
    }

    @ResponseBody
    @RequestMapping(value={"/contractPaymentRef"}, method={RequestMethod.GET})
    public CommonResponse<List<ContractPaymentVO>> contractPaymentRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        List contractPayments = new ArrayList();
        if (null == condition || StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("contractId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById((Serializable)conditionMap.get("contractId")));
        if (null != contractEntity && CollectionUtils.isNotEmpty(contractEntity.getDetailList())) {
            contractPayments = BeanMapper.mapList(contractEntity.getPaymentList(), ContractPaymentVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", contractPayments);
    }

    @RequestMapping(value={"/querySupplementRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> querySupplementRecord(Long id) {
        ContractVO vo = this.service.querySupplementRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateSupplement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateSupplement(@RequestBody ContractVO supplement) {
        if (supplement.getMainContractId() == null) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e3b\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        ContractVO vo = this.service.saveOrUpdateSupplement(supplement);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> addConvertByConId(Long contractId) {
        ContractVO vo = this.service.addConvertByConId(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addSupplementFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = this.service.addSupplementFlag(id);
        if (flag.booleanValue()) {
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff0c\u8be5\u5408\u540c\u53ef\u4ee5\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u80fd\u65b0\u589e\uff01");
    }

    @RequestMapping(value={"/signatureProcess"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(id));
        if (contractEntity != null) {
            contractEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
            contractEntity.setEffectiveDate(new Date());
            this.service.saveOrUpdate((Object)contractEntity);
        }
        return CommonResponse.success();
    }

    @ResponseBody
    @RequestMapping(value={"/prosubContractOtherCostRef"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> prosubContractOtherCostRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        if (null == condition || StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("contractId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
        }
        queryParam.getParams().put("contract_id", new Parameter("eq", conditionMap.get("contractId")));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time", "desc");
        queryParam.setOrderMap(orderMap);
        this.logger.info("\u5206\u5305\u5408\u540c\u5176\u4ed6\u8d39\u7528\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u6761\u4ef6---------->" + JSONObject.toJSONString((Object)queryParam.getParams()));
        IPage pageData = this.otherCostService.queryPage(queryParam, false);
        this.logger.info("\u5206\u5305\u5408\u540c\u5176\u4ed6\u8d39\u7528\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u7ed3\u679c\u6761\u6570---------->" + pageData.getRecords().size());
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractOtherCostVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u5176\u4ed6\u8d39\u7528\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @PostMapping(value={"/testPushContract"})
    @ResponseBody
    public CommonResponse<ContractPoolVO> testPushContract(@RequestBody ContractVO contractVO) {
        ContractEntity contract = (ContractEntity)((Object)this.service.selectById(contractVO.getId()));
        boolean pushContractResult = this.service.pushContract((ContractVO)BeanMapper.map((Object)((Object)contract), ContractVO.class));
        if (pushContractResult) {
            return CommonResponse.success((String)"\u5408\u540c\u6570\u636e\u63a8\u9001\u5408\u540c\u6c60\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)"\u5408\u540c\u6570\u636e\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01");
    }

    @PostMapping(value={"/deleteContractFile"})
    @ResponseBody
    public CommonResponse<Integer> deleteContractFile(@RequestBody ContractVO contractVO) {
        Integer contractVersion = this.service.deleteContractFileById(contractVO.getId());
        if (null != contractVersion && contractVersion.equals(-1)) {
            return CommonResponse.error((String)"\u5408\u540c\u5220\u9664\u5408\u540c\u9644\u4ef6\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u5408\u540c\u5220\u9664\u5408\u540c\u9644\u4ef6\u6210\u529f\uff01", (Object)contractVersion);
    }
}

