/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proother.bean.ContractClauseEntity;
import com.ejianc.business.proother.bean.ContractDetailEntity;
import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.bean.ContractOtherCostEntity;
import com.ejianc.business.proother.bean.ContractPaymentEntity;
import com.ejianc.business.proother.enums.ChangeStatusEnum;
import com.ejianc.business.proother.enums.DraftTypeEnum;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.mapper.ContractMapper;
import com.ejianc.business.proother.service.IContractDetailService;
import com.ejianc.business.proother.service.IContractOtherCostService;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.proother.utils.TreeNodeBUtil;
import com.ejianc.business.proother.vo.ContractDetailVO;
import com.ejianc.business.proother.vo.ContractVO;
import com.ejianc.business.tender.api.ITenderSubApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="contractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    @Autowired
    private IContractDetailService detailService;
    @Autowired
    private IContractOtherCostService otherCostService;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "OTH_CON";
    @Autowired
    private IContractService service;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ITenderSubApi tenderApi;
    int unOccupyState = 0;
    int occupyState = 1;
    @Value(value="${common.env.base-host}")
    private String BaseHost;

    @Override
    public ContractVO insertOrUpdate(ContractVO contractVO, String authority) {
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVO, ContractEntity.class));
        if (entity.getId() == null) {
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if (!billCode.isSuccess()) {
                    this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCode.getMsg());
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                entity.setBillCode((String)billCode.getData());
            } else if (this.checkSameBillCode((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class)).booleanValue()) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            entity.setSupplementFlag(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setMainContractCreateDate(new Date());
            this.tenderApi.updateById(entity.getTargetResultId(), Integer.valueOf(this.occupyState));
        } else {
            ContractEntity oldContractEntity = (ContractEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (null != entity.getTargetResultId() && !entity.getTargetResultId().equals(oldContractEntity.getTargetResultId())) {
                this.tenderApi.updateById(oldContractEntity.getTargetResultId(), Integer.valueOf(this.unOccupyState));
                this.tenderApi.updateById(entity.getTargetResultId(), Integer.valueOf(this.occupyState));
            }
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                entity.setBillCode(oldContractEntity.getBillCode());
            } else if (this.checkSameBillCode((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class)).booleanValue()) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
        entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
        entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
        entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
        entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
        entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
        entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
        entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
        entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                ContractEntity contract = (ContractEntity)((Object)this.service.getById(entity.getId()));
                if (contract != null && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                    this.delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            } else if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                this.delContractFile(entity.getContractFileId(), authority);
                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }
        this.resetPid(entity.getDetailList());
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public Boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.BaseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ContractVO> vos) {
        vos.forEach(contractVO -> {
            ContractEntity contractEntity = (ContractEntity)((Object)((Object)super.getById((Serializable)contractVO.getId())));
            if (null != contractEntity.getTargetResultId()) {
                CommonResponse tender = this.tenderApi.updateById(contractEntity.getTargetResultId(), Integer.valueOf(this.unOccupyState));
                this.logger.info("\u5b9a\u6807\u7ed3\u679c\u5360\u7528\u72b6\u6001\u4fee\u6539\u4e3a\u672a\u5360\u7528\u72b6\u6001\u4fe1\u606f\uff1a" + tender.getMsg());
            }
        });
        this.service.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public boolean pushContract(ContractVO vo) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            data.setSourceType(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return false;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);
        this.logger.info("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\uff01", (Object)id);
        CommonResponse delDataResp = this.contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }
        this.logger.error("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\u5931\u8d25, {}\uff01", (Object)id, (Object)delDataResp.getMsg());
        return false;
    }

    @Override
    public Integer deleteContractFileById(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(id));
        contractEntity.setContractFileId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileHighlightId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileVersion(null);
        contractEntity.setContractFileVersionId(null);
        Boolean deleteContractFileResult = this.service.saveOrUpdate((Object)contractEntity, false);
        if (!deleteContractFileResult.booleanValue()) {
            return -1;
        }
        return contractEntity.getVersion();
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id, orderMap));
        ContractVO contractVO = (ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class);
        if (CollectionUtils.isNotEmpty((Collection)contractVO.getDetailList())) {
            for (ContractDetailVO detail : contractVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            contractVO.setDetailList(TreeNodeBUtil.buildTree((List)contractVO.getDetailList()));
        }
        return contractVO;
    }

    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        ContractVO contractVO = new ContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_contract_id", (Object)id);
        query.eq((Object)"performance_status", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        query.orderByDesc((Object)"create_time");
        List supplementEntities = super.list((Wrapper)query);
        contractVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, ContractVO.class));
        contractVO.setSupplementNum(Integer.valueOf(supplementEntities.size()));
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            for (ContractEntity c : supplementEntities) {
                if (c.getContractTaxMny() == null) continue;
                allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? allSupplementAmt.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(contractEntity.getPerformanceStatus()) && !PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus())) {
            contractVO.setEditFlag(this.addSupplementFlag(id));
        } else {
            contractVO.setEditFlag(Boolean.valueOf(false));
        }
        return contractVO;
    }

    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO contractVO) {
        ContractEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)contractVO.getBillCode()) && this.checkSameBillCode(contractVO).booleanValue()) {
            throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        ContractEntity mainContract = (ContractEntity)((Object)this.service.selectById(contractVO.getMainContractId()));
        if (null == mainContract) {
            throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("main_contract_id", new Parameter("eq", (Object)contractVO.getMainContractId()));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billStateList));
        List supplementList = this.service.queryList(param, false);
        if (StringUtils.isBlank((CharSequence)contractVO.getBillCode())) {
            String supplementNum = "";
            supplementNum = supplementList.size() < 9 ? supplementNum + "0" + (supplementList.size() + 1) : supplementNum + (supplementList.size() + 1);
            contractVO.setBillCode(mainContract.getBillCode() + "2" + supplementNum);
        }
        if (contractVO.getId() == null) {
            supplementList.stream().forEach(e -> {
                if (!e.getSignatureStatus().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) || !e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
                }
            });
            entity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)mainContract), ContractEntity.class));
            this.clearBaseFields(entity);
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setBillCode(contractVO.getBillCode());
            entity.setContractName(contractVO.getContractName());
            entity.setSignDate(contractVO.getSignDate());
            entity.setEmployeeId(contractVO.getEmployeeId());
            entity.setEmployeeName(contractVO.getEmployeeName());
            entity.setEmployeePhone(contractVO.getEmployeePhone());
            entity.setSupplierEmployee(contractVO.getSupplierEmployee());
            entity.setSupplierEmployeePhone(contractVO.getSupplierEmployeePhone());
            entity.setPerformanceStatus(contractVO.getPerformanceStatus());
            entity.setDraftType(contractVO.getDraftType());
            entity.setContractFilePath(contractVO.getContractFilePath());
            entity.setContractFileId(contractVO.getContractFileId());
            entity.setContractTemplateId(contractVO.getContractTemplateId());
            entity.setContractTemplateName(contractVO.getContractTemplateName());
            entity.setContractFileVersionId(contractVO.getContractFileVersionId());
            entity.setContractFileVersion(contractVO.getContractFileVersion());
            entity.setSupplementDescribe(contractVO.getSupplementDescribe());
            entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
            entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
            entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
            entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
            entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
            entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
            entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
            entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
            entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
            entity.setDetailList(BeanMapper.mapList((Iterable)contractVO.getDetailList(), ContractDetailEntity.class));
            entity.setOtherCostList(BeanMapper.mapList((Iterable)contractVO.getOtherCostList(), ContractOtherCostEntity.class));
            entity.setClauseList(BeanMapper.mapList((Iterable)contractVO.getClauseList(), ContractClauseEntity.class));
            entity.setPaymentList(BeanMapper.mapList((Iterable)contractVO.getPaymentList(), ContractPaymentEntity.class));
            entity.setChangingMny(null);
            entity.setChangeCode(null);
            entity.setChangeVersion(null);
            entity.setChangeId(null);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
            entity.setMainContractId(contractVO.getMainContractId());
            entity.setMainContractCode(contractVO.getMainContractCode());
            entity.setMainContractName(contractVO.getMainContractName());
        } else {
            entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVO, ContractEntity.class));
        }
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setAttachIds(contractVO.getAttachIds());
        this.resetPid(entity.getDetailList());
        this.service.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    private Boolean checkSameBillCode(ContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)contractVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    private void resetPid(List<ContractDetailEntity> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ContractDetailEntity cdEntity : detailList) {
                if (cdEntity.getId() == null) {
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (ContractDetailEntity cdEntity : detailList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
        }
    }

    private void clearBaseFields(ContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserName(null);
        entity.setEffectiveDate(null);
    }

    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        ContractVO supplementVO = new ContractVO();
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setFirstPartyId(contractVO.getFirstPartyId());
        supplementVO.setFirstPartyName(contractVO.getFirstPartyName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "\u8865\u5145\u534f\u8bae");
        return supplementVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getMainContractId, (Object)id);
        lambda.eq(ContractEntity::getSupplementFlag, (Object)ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ContractEntity::getSignatureStatus, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }
}

