package com.ejianc.business.contract.relieve.service.impl;

import com.ejianc.business.contract.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.contract.relieve.mapper.ContractRelieveMapper;
import com.ejianc.business.contract.relieve.service.IContractRelieveService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 合同解除实体
 *
 * @author generator
 */
@Service("contractRelieveService")
public class ContractRelieveServiceImpl extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity> implements IContractRelieveService {

    @Autowired
    private IContractRelieveService service;

    /**
     * 根据合同编号查询是否可以新增合同解除单据
     *
     * @param contractId 合同id
     * @return Boolean 是否可以新增
     */
    @Override
    public Boolean isCanRelieve(Long contractId) {
        // 添加校验
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        List<ContractRelieveEntity> list = service.queryList(param);
        return list.isEmpty();
    }
}
